---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 38
  claims_with_evidence: 37
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: ライティング（2D/3D）

## 1. 概要

本レポートは「9-ライティング.md」機能設計書の記述内容について、ソースコードに基づく根拠を提示する。

## 2. 主張と根拠の対応

### 2.1 クラス構造に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 1 | Light3DはVisualInstance3Dを継承 | `class Light3D : public VisualInstance3D` | light_3d.h 35行目 |
| 2 | DirectionalLight3DはLight3Dを継承 | `class DirectionalLight3D : public Light3D` | light_3d.h 162行目 |
| 3 | OmniLight3DはLight3Dを継承 | `class OmniLight3D : public Light3D` | light_3d.h 203行目 |
| 4 | SpotLight3DはLight3Dを継承 | `class SpotLight3D : public Light3D` | light_3d.h 230行目 |
| 5 | light RIDがある | `RID light;` | light_3d.h 95行目 |
| 6 | param配列がある | `real_t param[PARAM_MAX] = {}` | light_3d.h 72行目 |
| 7 | bake_modeがある | `BakeMode bake_mode = BAKE_DYNAMIC` | light_3d.h 85行目 |

### 2.2 Param列挙型に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 8 | PARAM_ENERGYがある | `PARAM_ENERGY = RS::LIGHT_PARAM_ENERGY` | light_3d.h 40行目 |
| 9 | PARAM_RANGEがある | `PARAM_RANGE = RS::LIGHT_PARAM_RANGE` | light_3d.h 44行目 |
| 10 | PARAM_SPOT_ANGLEがある | `PARAM_SPOT_ANGLE = RS::LIGHT_PARAM_SPOT_ANGLE` | light_3d.h 47行目 |
| 11 | PARAM_INTENSITYがある | `PARAM_INTENSITY = RS::LIGHT_PARAM_INTENSITY` | light_3d.h 60行目 |
| 12 | PARAM_MAXがある | `PARAM_MAX = RS::LIGHT_PARAM_MAX` | light_3d.h 61行目 |

### 2.3 BakeMode列挙型に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 13 | BAKE_DISABLED/STATIC/DYNAMICがある | enum定義 | light_3d.h 64-68行目 |

### 2.4 コンストラクタに関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 14 | LIGHT_DIRECTIONALでdirectional_light_createを呼び出す | `light = RS::directional_light_create()` | light_3d.cpp 454行目 |
| 15 | LIGHT_OMNIでomni_light_createを呼び出す | `light = RS::omni_light_create()` | light_3d.cpp 457行目 |
| 16 | LIGHT_SPOTでspot_light_createを呼び出す | `light = RS::spot_light_create()` | light_3d.cpp 460行目 |
| 17 | instance_set_baseでlight RIDを設定 | `RS::instance_set_base(get_instance(), light)` | light_3d.cpp 466行目 |
| 18 | デフォルトでPARAM_INTENSITY = 1000.0 | `set_param(PARAM_INTENSITY, 1000.0)` | light_3d.cpp 495行目 |
| 19 | デフォルトでtemperature = 6500.0 | `set_temperature(6500.0)` | light_3d.cpp 496行目 |

### 2.5 set_param()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 20 | param配列に値を保存 | `param[p_param] = p_value` | light_3d.cpp 37行目 |
| 21 | RS::light_set_paramを呼び出す | `RS::light_set_param(light, RS::LightParam(p_param), p_value)` | light_3d.cpp 39行目 |
| 22 | SPOT_ANGLE/RANGEでupdate_gizmosを呼び出す | `if (p_param == PARAM_SPOT_ANGLE || p_param == PARAM_RANGE) update_gizmos()` | light_3d.cpp 41-42行目 |

### 2.6 set_shadow()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 23 | RS::light_set_shadowを呼び出す | `RS::light_set_shadow(light, p_enable)` | light_3d.cpp 57行目 |
| 24 | update_configuration_warningsを呼び出す | `update_configuration_warnings()` | light_3d.cpp 59行目 |

### 2.7 set_color()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 25 | 物理単位使用時にsrgb_to_linearを適用 | `Color combined = color.srgb_to_linear()` | light_3d.cpp 125行目 |
| 26 | correlated_colorと乗算 | `combined *= correlated_color.srgb_to_linear()` | light_3d.cpp 126行目 |
| 27 | linear_to_srgbで変換して設定 | `RS::light_set_color(light, combined.linear_to_srgb())` | light_3d.cpp 127行目 |

### 2.8 _color_from_temperature()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 28 | CIE 1960のu,v座標を計算 | u, v計算式 | light_3d.cpp 234-237行目 |
| 29 | xyY空間に変換 | x, y計算 | light_3d.cpp 240-242行目 |
| 30 | XYZ空間に変換 | xyz計算 | light_3d.cpp 245-246行目 |
| 31 | XYZからsRGBに変換 | 変換行列の適用 | light_3d.cpp 249-251行目 |

### 2.9 get_aabb()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 32 | DIRECTIONALは(-1,-1,-1)〜(2,2,2) | `return AABB(Vector3(-1, -1, -1), Vector3(2, 2, 2))` | light_3d.cpp 159行目 |
| 33 | OMNIはPARAM_RANGEベース | `return AABB(Vector3(-1, -1, -1) * param[PARAM_RANGE], ...)` | light_3d.cpp 162行目 |
| 34 | SPOTはコーン形状を考慮 | コーン計算 | light_3d.cpp 164-174行目 |

### 2.10 距離フェードに関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 35 | light_set_distance_fadeを呼び出す | `RS::light_set_distance_fade(light, distance_fade_enabled, ...)` | light_3d.cpp 77行目 |
| 36 | distance_fade_begin/shadow/lengthパラメータがある | メンバ変数宣言 | light_3d.h 79-81行目 |

### 2.11 派生クラスに関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 37 | DirectionalLight3DにShadowMode列挙型がある | enum定義 | light_3d.h 166-170行目 |
| 38 | OmniLight3DにShadowMode列挙型がある | enum定義 | light_3d.h 208-211行目 |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | GDScriptでの使用例の構文 | GDScript実装はC++コードからは直接確認不可（ただし一般的な使用法として妥当） |

## 4. 信頼度評価

### 4.1 評価基準

- 全38主張中37主張にソースコード根拠あり
- 根拠なし1件はGDScript構文例（設計書として許容範囲）
- 全ての重要な技術的主張は行番号付きで検証済み

### 4.2 最終信頼度

**信頼度: 97%**

## 5. 検証に使用したソースファイル

| ファイル | 確認行数 | 検証項目数 |
|----------|----------|------------|
| scene/3d/light_3d.cpp | 1-500 | 22 |
| scene/3d/light_3d.h | 1-241 | 16 |

## 6. 特記事項

### 6.1 コード品質の観察

1. **パラメータ配列**: param[PARAM_MAX]で全パラメータを一元管理
2. **物理ベース単位**: use_physical_light_units設定で分岐
3. **色温度変換**: CIE 1960 → xyY → XYZ → sRGBの正確な変換パイプライン

### 6.2 設計パターンの確認

- ファクトリパターン: 光源タイプに応じたRenderingServer関数の呼び分け
- テンプレートメソッドパターン: Light3Dを基底とした派生クラス
- プロパティパターン: param配列による汎用パラメータ管理
