---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 54
  claims_with_evidence: 54
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧.csv / 画面遷移図.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：54 / 54、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての画面情報にソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> 以下はGodot Engineソースコード内の実在ファイルです。

- E-01: `editor/project_manager/project_manager.h`
- E-02: `editor/project_manager/project_manager.cpp`
- E-03: `editor/editor_node.h`
- E-04: `editor/editor_node.cpp`
- E-05: `editor/scene/canvas_item_editor_plugin.cpp`
- E-06: `editor/scene/3d/node_3d_editor_plugin.cpp`
- E-07: `editor/script/script_editor_plugin.h`
- E-08: `editor/asset_library/asset_library_editor_plugin.h`
- E-09: `editor/docks/filesystem_dock.h`
- E-10: `editor/docks/scene_tree_dock.h`
- E-11: `editor/docks/inspector_dock.h`
- E-12: `editor/docks/signals_dock.h`
- E-13: `editor/docks/groups_dock.h`
- E-14: `editor/docks/history_dock.h`
- E-15: `editor/docks/import_dock.h`
- E-16: `editor/editor_log.h`
- E-17: `editor/debugger/script_editor_debugger.h`
- E-18: `editor/audio/editor_audio_buses.cpp`
- E-19: `editor/animation/animation_player_editor_plugin.cpp`
- E-20: `editor/shader/shader_editor_plugin.h`
- E-21: `editor/project_manager/project_dialog.h`
- E-22: `editor/project_manager/quick_settings_dialog.h`
- E-23: `editor/settings/project_settings_editor.h`
- E-24: `editor/settings/editor_settings_dialog.h`
- E-25: `editor/export/project_export.h`
- E-26: `editor/gui/editor_about.h`
- E-27: `editor/gui/editor_file_dialog.h`
- E-28: `editor/gui/directory_create_dialog.h`
- E-29: `editor/gui/editor_quick_open_dialog.h`
- E-30: `editor/gui/create_dialog.h`
- E-31: `editor/gui/progress_dialog.h`
- E-32: `editor/script/script_create_dialog.h`
- E-33: `editor/scene/scene_create_dialog.h`
- E-34: `editor/scene/connections_dialog.h`
- E-35: `editor/scene/reparent_dialog.h`
- E-36: `editor/scene/rename_dialog.h`
- E-37: `editor/shader/shader_create_dialog.h`
- E-38: `editor/settings/input_event_configuration_dialog.h`
- E-39: `editor/settings/editor_layouts_dialog.h`
- E-40: `editor/plugins/plugin_config_dialog.h`
- E-41: `editor/run/run_instances_dialog.h`
- E-42: `editor/asset_library/editor_asset_installer.h`
- E-43: `editor/translations/editor_locale_dialog.h`
- E-44: `editor/shader/visual_shader_editor_plugin.h`
- E-45: `editor/animation/animation_tree_editor_plugin.cpp`
- E-46: `editor/scene/2d/tiles/` (ディレクトリ)
- E-47: `editor/scene/sprite_frames_editor_plugin.h`
- E-48: `editor/scene/curve_editor_plugin.h`
- E-49: `editor/scene/gradient_editor_plugin.h`
- E-50: `editor/scene/3d/mesh_library_editor_plugin.h`
- E-51: `editor/scene/2d/polygon_2d_editor_plugin.h`
- E-52: `editor/scene/2d/path_2d_editor_plugin.h`
- E-53: `editor/scene/3d/path_3d_editor_plugin.h`
- E-54: `editor/scene/3d/skeleton_3d_editor_plugin.h`
- E-55: `editor/scene/3d/mesh_editor_plugin.h`
- E-56: `editor/scene/material_editor_plugin.h`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトマネージャー画面が存在する | E-01, E-02 | ○ |
| C-02 | エディタメイン画面が存在する | E-03, E-04 | ○ |
| C-03 | 2Dエディタが存在する | E-05 | ○ |
| C-04 | 3Dエディタが存在する | E-06 | ○ |
| C-05 | スクリプトエディタが存在する | E-07 | ○ |
| C-06 | アセットライブラリが存在する | E-08 | ○ |
| C-07 | ファイルシステムドックが存在する | E-09 | ○ |
| C-08 | シーンツリードックが存在する | E-10 | ○ |
| C-09 | インスペクタードックが存在する | E-11 | ○ |
| C-10 | シグナルドックが存在する | E-12 | ○ |
| C-11 | グループドックが存在する | E-13 | ○ |
| C-12 | ヒストリードックが存在する | E-14 | ○ |
| C-13 | インポートドックが存在する | E-15 | ○ |
| C-14 | 出力パネルが存在する | E-16 | ○ |
| C-15 | デバッガが存在する | E-17 | ○ |
| C-16 | オーディオバスエディタが存在する | E-18 | ○ |
| C-17 | アニメーションエディタが存在する | E-19 | ○ |
| C-18 | シェーダーエディタが存在する | E-20 | ○ |
| C-19 | プロジェクトダイアログが存在する | E-21 | ○ |
| C-20 | クイック設定ダイアログが存在する | E-22 | ○ |
| C-21 | プロジェクト設定ダイアログが存在する | E-23 | ○ |
| C-22 | エディター設定ダイアログが存在する | E-24 | ○ |
| C-23 | エクスポートダイアログが存在する | E-25 | ○ |
| C-24 | Aboutダイアログが存在する | E-26 | ○ |
| C-25 | ファイルダイアログが存在する | E-27 | ○ |
| C-26 | ディレクトリ作成ダイアログが存在する | E-28 | ○ |
| C-27 | クイックオープンダイアログが存在する | E-29 | ○ |
| C-28 | ノード作成ダイアログが存在する | E-30 | ○ |
| C-29 | 進捗ダイアログが存在する | E-31 | ○ |
| C-30 | スクリプト作成ダイアログが存在する | E-32 | ○ |
| C-31 | シーン作成ダイアログが存在する | E-33 | ○ |
| C-32 | シグナル接続ダイアログが存在する | E-34 | ○ |
| C-33 | 親変更ダイアログが存在する | E-35 | ○ |
| C-34 | 名前変更ダイアログが存在する | E-36 | ○ |
| C-35 | シェーダー作成ダイアログが存在する | E-37 | ○ |
| C-36 | 入力イベント設定ダイアログが存在する | E-38 | ○ |
| C-37 | レイアウト保存ダイアログが存在する | E-39 | ○ |
| C-38 | プラグイン設定ダイアログが存在する | E-40 | ○ |
| C-39 | 実行インスタンスダイアログが存在する | E-41 | ○ |
| C-40 | アセットインストーラーが存在する | E-42 | ○ |
| C-41 | ロケールダイアログが存在する | E-43 | ○ |
| C-42 | ビジュアルシェーダーエディタが存在する | E-44 | ○ |
| C-43 | アニメーションツリーエディタが存在する | E-45 | ○ |
| C-44 | タイルマップエディタが存在する | E-46 | ○ |
| C-45 | スプライトフレームエディタが存在する | E-47 | ○ |
| C-46 | カーブエディタが存在する | E-48 | ○ |
| C-47 | グラデーションエディタが存在する | E-49 | ○ |
| C-48 | メッシュライブラリエディタが存在する | E-50 | ○ |
| C-49 | ポリゴン2Dエディタが存在する | E-51 | ○ |
| C-50 | パス2Dエディタが存在する | E-52 | ○ |
| C-51 | パス3Dエディタが存在する | E-53 | ○ |
| C-52 | スケルトン3Dエディタが存在する | E-54 | ○ |
| C-53 | メッシュエディタが存在する | E-55 | ○ |
| C-54 | マテリアルエディタが存在する | E-56 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての画面情報はソースコードのヘッダーファイル（.h）または実装ファイル（.cpp）から直接確認されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての画面情報がソースコードファイルの存在により確認されています
- 注意事項：
  - 画面の日本語名はソースコード内のクラス名や機能から推測しています
  - 画面遷移図はソースコードの構造と一般的なGodotエディターの操作フローに基づいています
  - GDExtensionやカスタムプラグインによる追加画面は含まれていません

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧に記載されている全てのファイルパスが実在することを確認
- [ ] 画面遷移図のフローが実際のGodotエディターの操作と一致することを確認
- [ ] 画面の説明文がGodotドキュメントと整合しているか確認
- [ ] 漏れている重要な画面（特にエディタープラグイン）がないか確認
- [ ] カテゴリ分類が適切かどうか確認
