# Godot Engine エディター画面遷移図

## 概要

Godot Engineのエディターは、プロジェクトマネージャーとメインエディターの2つの主要な画面から構成されています。本ドキュメントでは、これらの画面間の遷移関係をMermaid形式で図示します。

## 全体画面遷移図

```mermaid
flowchart TB
    subgraph Launch["起動"]
        PM[プロジェクトマネージャー]
    end

    subgraph MainEditor["メインエディター"]
        EN[エディタメイン画面]
        E2D[2Dエディタ]
        E3D[3Dエディタ]
        SE[スクリプトエディタ]
        AL[アセットライブラリ]
    end

    subgraph Docks["ドック"]
        FSD[ファイルシステムドック]
        STD[シーンツリードック]
        ID[インスペクタードック]
        SigD[シグナルドック]
        GD[グループドック]
        HD[ヒストリードック]
        IMD[インポートドック]
    end

    subgraph BottomPanel["ボトムパネル"]
        OUT[出力パネル]
        DBG[デバッガ]
        AB[オーディオバス]
        ANI[アニメーションエディタ]
        SHE[シェーダーエディタ]
    end

    PM -->|プロジェクト選択/作成| EN
    EN -->|プロジェクト終了| PM

    EN <-->|タブ切り替え| E2D
    EN <-->|タブ切り替え| E3D
    EN <-->|タブ切り替え| SE
    EN <-->|タブ切り替え| AL

    EN --- FSD
    EN --- STD
    EN --- ID
    EN --- SigD
    EN --- GD
    EN --- HD
    EN --- IMD

    EN --- OUT
    EN --- DBG
    EN --- AB
    EN --- ANI
    EN --- SHE
```

## プロジェクトマネージャー画面遷移

```mermaid
flowchart TB
    PM[プロジェクトマネージャー]

    subgraph PMDialogs["ダイアログ"]
        PD[プロジェクトダイアログ]
        QSD[クイック設定ダイアログ]
        ABT[Aboutダイアログ]
        ASL[アセットライブラリ]
    end

    PM -->|新規作成/インポート| PD
    PM -->|設定| QSD
    PM -->|About| ABT
    PM -->|Asset Library| ASL

    PD -->|完了/キャンセル| PM
    QSD -->|閉じる| PM
    ABT -->|閉じる| PM
    ASL -->|閉じる| PM
```

## メインエディター ダイアログ遷移

```mermaid
flowchart TB
    EN[エディタメイン画面]

    subgraph ProjectDialogs["プロジェクト関連"]
        PS[プロジェクト設定]
        EX[エクスポートダイアログ]
    end

    subgraph EditorDialogs["エディター関連"]
        ES[エディター設定]
        ABT[Aboutダイアログ]
        LD[レイアウトダイアログ]
    end

    subgraph FileDialogs["ファイル関連"]
        FD[ファイルダイアログ]
        QO[クイックオープンダイアログ]
        DCD[ディレクトリ作成ダイアログ]
    end

    subgraph CreateDialogs["作成関連"]
        CD[ノード作成ダイアログ]
        SCD[スクリプト作成ダイアログ]
        ScCD[シーン作成ダイアログ]
        ShCD[シェーダー作成ダイアログ]
    end

    EN -->|Project > Project Settings| PS
    EN -->|Project > Export| EX
    EN -->|Editor > Editor Settings| ES
    EN -->|Help > About| ABT
    EN -->|Editor > Editor Layout| LD
    EN -->|Scene > Open Scene| FD
    EN -->|Ctrl+P| QO
    EN -->|ファイルシステムで新規フォルダ| DCD
    EN -->|シーンツリーでAdd Node| CD
    EN -->|ファイルシステムで新規スクリプト| SCD
    EN -->|Scene > New Scene| ScCD
    EN -->|ファイルシステムで新規シェーダー| ShCD

    PS -->|閉じる| EN
    EX -->|閉じる| EN
    ES -->|閉じる| EN
    ABT -->|閉じる| EN
    LD -->|閉じる| EN
    FD -->|選択/キャンセル| EN
    QO -->|選択/キャンセル| EN
    DCD -->|作成/キャンセル| EN
    CD -->|作成/キャンセル| EN
    SCD -->|作成/キャンセル| EN
    ScCD -->|作成/キャンセル| EN
    ShCD -->|作成/キャンセル| EN
```

## シーンツリー操作画面遷移

```mermaid
flowchart TB
    STD[シーンツリードック]

    subgraph SceneDialogs["シーン関連ダイアログ"]
        CD[ノード作成ダイアログ]
        CND[シグナル接続ダイアログ]
        RPD[親変更ダイアログ]
        RND[名前変更ダイアログ]
    end

    STD -->|Add Node| CD
    STD -->|Connect Signal| CND
    STD -->|Reparent| RPD
    STD -->|Batch Rename| RND

    CD -->|作成/キャンセル| STD
    CND -->|接続/キャンセル| STD
    RPD -->|変更/キャンセル| STD
    RND -->|適用/キャンセル| STD
```

## インスペクタードック画面遷移

```mermaid
flowchart TB
    ID[インスペクタードック]

    subgraph InspectorDialogs["インスペクター関連"]
        NRD[新規リソースダイアログ]
        LRD[リソース読込ダイアログ]
    end

    ID -->|New Resource| NRD
    ID -->|Load Resource| LRD

    NRD -->|作成/キャンセル| ID
    LRD -->|選択/キャンセル| ID
```

## エディタープラグイン画面遷移

```mermaid
flowchart TB
    EN[エディタメイン画面]

    subgraph Plugins2D["2Dエディタープラグイン"]
        P2DE[ポリゴン2Dエディタ]
        PT2E[パス2Dエディタ]
        TLE[タイルマップエディタ]
        SFE[スプライトフレームエディタ]
    end

    subgraph Plugins3D["3Dエディタープラグイン"]
        PT3E[パス3Dエディタ]
        SK3E[スケルトン3Dエディタ]
        MSE[メッシュエディタ]
        MLE[メッシュライブラリエディタ]
    end

    subgraph PluginsShader["シェーダー関連"]
        VSE[ビジュアルシェーダーエディタ]
        TSE[テキストシェーダーエディタ]
    end

    subgraph PluginsAnim["アニメーション関連"]
        ATE[アニメーションツリーエディタ]
        APE[アニメーションプレイヤーエディタ]
    end

    subgraph PluginsRes["リソース関連"]
        CE[カーブエディタ]
        GE[グラデーションエディタ]
        ME[マテリアルエディタ]
    end

    EN -->|Polygon2D選択| P2DE
    EN -->|Path2D選択| PT2E
    EN -->|TileMap選択| TLE
    EN -->|AnimatedSprite選択| SFE
    EN -->|Path3D選択| PT3E
    EN -->|Skeleton3D選択| SK3E
    EN -->|Mesh選択| MSE
    EN -->|MeshLibrary選択| MLE
    EN -->|VisualShader選択| VSE
    EN -->|Shader選択| TSE
    EN -->|AnimationTree選択| ATE
    EN -->|AnimationPlayer選択| APE
    EN -->|Curve選択| CE
    EN -->|Gradient選択| GE
    EN -->|Material選択| ME
```

## デバッガ画面遷移

```mermaid
flowchart TB
    DBG[デバッガ]

    subgraph DebugTabs["デバッグタブ"]
        ERR[エラータブ]
        PROF[プロファイラータブ]
        VPROF[ビジュアルプロファイラー]
        MON[モニタータブ]
        MISC[その他タブ]
    end

    DBG <-->|タブ切り替え| ERR
    DBG <-->|タブ切り替え| PROF
    DBG <-->|タブ切り替え| VPROF
    DBG <-->|タブ切り替え| MON
    DBG <-->|タブ切り替え| MISC
```

## 設定画面遷移

```mermaid
flowchart TB
    subgraph ProjectSettings["プロジェクト設定タブ"]
        PSG[一般設定]
        PSIM[Input Map]
        PSL[ローカライゼーション]
        PSA[Autoload]
        PSSG[シェーダーグローバル]
        PSGR[グループ設定]
        PSPL[プラグイン]
    end

    PS[プロジェクト設定ダイアログ]
    PS <-->|タブ切り替え| PSG
    PS <-->|タブ切り替え| PSIM
    PS <-->|タブ切り替え| PSL
    PS <-->|タブ切り替え| PSA
    PS <-->|タブ切り替え| PSSG
    PS <-->|タブ切り替え| PSGR
    PS <-->|タブ切り替え| PSPL

    PSIM -->|イベント追加| IED[入力イベント設定ダイアログ]
    IED -->|設定完了| PSIM
```

## 備考

- 実線矢印（-->）は画面遷移を表します
- 双方向矢印（<-->）は相互に切り替え可能な画面を表します
- 破線（---）は常時表示されるドック/パネルとの関係を表します
- ダイアログは親画面から開かれ、閉じると親画面に戻ります
- エディタープラグインはノード/リソースの選択により自動的に表示されます
