---
generated_at: 2026-01-23 16:30:00
metrics:
  claims_total: 107
  claims_with_evidence: 98
  claims_without_evidence: 9
confidence_derived: 0.92
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：98 / 107、根拠なし：9
- 優先レビュー（高）
  1. **ポリゴン2Dエディタ - スケルトン/ボーン連携**：ボーンウェイト設定機能の詳細が要確認
  2. **パス2D/3Dエディタ - ナビゲーション連携**：パスフォローとナビゲーションの関連性が間接的
  3. **アセットインストーラー - ZIP圧縮**：内部実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（54画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（80機能）
- E-03: `editor/project_manager/project_manager.cpp` - プロジェクトマネージャー実装
- E-04: `editor/editor_node.cpp` - エディタメイン画面実装
- E-05: `editor/docks/filesystem_dock.cpp` - ファイルシステムドック実装
- E-06: `editor/docks/scene_tree_dock.cpp` - シーンツリードック実装
- E-07: `editor/docks/inspector_dock.cpp` - インスペクタードック実装
- E-08: `editor/docks/signals_dock.cpp` - シグナルドック実装
- E-09: `editor/script/script_editor_plugin.cpp` - スクリプトエディタ実装
- E-10: `editor/animation/animation_player_editor_plugin.cpp` - アニメーションエディタ実装
- E-11: `editor/shader/visual_shader_editor_plugin.cpp` - ビジュアルシェーダーエディタ実装
- E-12: `editor/settings/project_settings_editor.cpp` - プロジェクト設定エディタ実装
- E-13: `editor/export/project_export.cpp` - エクスポートダイアログ実装
- E-14: `editor/asset_library/asset_library_editor_plugin.cpp` - アセットライブラリ実装
- E-15: `editor/debugger/script_editor_debugger.cpp` - デバッガ実装
- E-16: `editor/audio/editor_audio_buses.cpp` - オーディオバス実装
- E-17: `editor/scene/canvas_item_editor_plugin.cpp` - 2Dエディタ実装
- E-18: `editor/scene/3d/node_3d_editor_plugin.cpp` - 3Dエディタ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトマネージャー → プロジェクト設定（主機能） | E-01, E-02, E-03 | ○ |
| C-02 | プロジェクトマネージャー → リソース管理（補助機能） | E-03 | ○ |
| C-03 | プロジェクトマネージャー → テーマシステム（補助機能） | E-03 | ○ |
| C-04 | エディタメイン画面 → シーンツリー管理（主機能） | E-04, E-06 | ○ |
| C-05 | エディタメイン画面 → ノードシステム（主機能） | E-04 | ○ |
| C-06 | エディタメイン画面 → リソース管理（主機能） | E-04 | ○ |
| C-07 | エディタメイン画面 → シーンエディタ（主機能） | E-04 | ○ |
| C-08 | 2Dエディタ → 2Dレンダリング（主機能） | E-17 | ○ |
| C-09 | 2Dエディタ → カメラシステム（主機能） | E-17 | ○ |
| C-10 | 2Dエディタ → 2D物理シミュレーション（補助機能） | E-17 | ○ |
| C-11 | 3Dエディタ → 3Dレンダリング（主機能） | E-18 | ○ |
| C-12 | 3Dエディタ → ライティング（補助機能） | E-18 | ○ |
| C-13 | スクリプトエディタ → GDScript（主機能） | E-09 | ○ |
| C-14 | スクリプトエディタ → C#サポート（主機能） | E-09 | ○ |
| C-15 | アセットライブラリ → HTTPリクエスト（API連携） | E-14 | ○ |
| C-16 | ファイルシステムドック → リソース管理（主機能） | E-05 | ○ |
| C-17 | シーンツリードック → シーンツリー管理（主機能） | E-06 | ○ |
| C-18 | インスペクタードック → インスペクター（主機能） | E-07 | ○ |
| C-19 | シグナルドック → 信号システム（主機能） | E-08 | ○ |
| C-20 | デバッガ → デバッガー（主機能） | E-15 | ○ |
| C-21 | オーディオバス → オーディオバス（主機能） | E-16 | ○ |
| C-22 | アニメーションエディタ → AnimationPlayer（主機能） | E-10 | ○ |
| C-23 | ビジュアルシェーダーエディタ → シェーダー（主機能） | E-11 | ○ |
| C-24 | プロジェクト設定 → 入力マッピング（主機能） | E-12 | ○ |
| C-25 | エクスポートダイアログ → プラットフォーム対応（主機能） | E-13 | ○ |
| C-26 | ポリゴン2Dエディタ → スケルトン/ボーン（補助機能） | **根拠不足** | △ |
| C-27 | パス2Dエディタ → 2Dナビゲーション（補助機能） | **根拠不足** | △ |
| C-28 | パス3Dエディタ → 3Dナビゲーション（補助機能） | **根拠不足** | △ |
| C-29 | アセットインストーラー → ZIP圧縮（補助機能） | **根拠不足** | △ |
| C-30 | タイルマップエディタ → タイルマップシステム（主機能） | E-01, E-02 | ○ |
| C-31 | アニメーションツリーエディタ → AnimationTree（主機能） | E-01, E-02 | ○ |
| C-32 | カーブエディタ → Tween（主機能） | **根拠弱** | △ |
| C-33 | グラデーションエディタ → 2Dレンダリング（主機能） | **根拠弱** | △ |
| C-34 | メッシュライブラリエディタ → メッシュライブラリ（主機能） | E-01, E-02 | ○ |
| C-35 | スケルトン3Dエディタ → IK（補助機能） | **根拠弱** | △ |
| C-36 | 名前変更ダイアログ → ノードシステム（主機能） | E-01, E-02 | ○ |
| C-37 | 入力イベント設定ダイアログ → 入力マッピング（主機能） | E-01, E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- **ポリゴン2Dエディタのボーンウェイト設定**：polygon_2d_editor_plugin.cppの詳細実装を確認する必要がある
  - 候補：editor/scene/2d/polygon_2d_editor_plugin.cpp / scene/2d/polygon_2d.cpp
- **パスエディタとナビゲーションの連携**：PathとNavigationの直接的な連携コードが見つからなかった
  - 候補：editor/scene/2d/path_2d_editor_plugin.cpp / scene/2d/navigation/
- **アセットインストーラーのZIP処理**：内部でのZIP解凍処理の実装詳細
  - 候補：editor/asset_library/editor_asset_installer.cpp / modules/zip/
- **カーブエディタとTweenの関係**：CurveリソースはTweenだけでなくアニメーション全般で使用される
  - 候補：editor/scene/curve_editor_plugin.cpp / scene/resources/curve.cpp
- **スケルトン3DエディタとIKの連携**：IK設定機能の詳細確認が必要
  - 候補：editor/scene/3d/skeleton_3d_editor_plugin.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主機能のマッピング（画面一覧・機能一覧から直接導出可能なもの）
- 1: 中リスク - 補助機能・遷移先機能のマッピング（コード解析から推測したもの）
- 2: 高リスク - 間接的な関連性が推測されるもの（C-26〜C-37の一部）

全体として、主要な画面と機能のマッピングはソースコードのinclude文とクラス依存関係から確認できており、信頼度は高い。ただし、一部のエディタープラグイン間の補助的な連携については、詳細なコードレビューによる確認を推奨する。

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧（54画面）と機能一覧（80機能）の全組み合わせをカバーしているか確認
- [ ] 「主機能」として分類されたマッピングが適切か確認
- [ ] 「遷移先機能」の分類が画面遷移フローと整合しているか確認
- [ ] 「API連携」の分類が非同期処理を正しく反映しているか確認
- [ ] △マークの項目（9件）について、実際のコードを確認して妥当性を検証
- [ ] 未マッピングの画面・機能ペアがないか確認（特に新規追加されたプラグイン）
