# 画面設計書 1-プロジェクトマネージャー

## 概要

本ドキュメントは、Godot Engine起動時に表示されるプロジェクトマネージャー画面の設計仕様を記載する。

### 本画面の処理概要

プロジェクトマネージャーは、Godot Engineの起動直後に表示される最初の画面であり、ユーザーがプロジェクトを管理するための中央集約的なインターフェースを提供する。

**業務上の目的・背景**：ゲーム開発者やクリエイターが複数のGodotプロジェクトを効率的に管理するため、プロジェクトの一覧表示、新規作成、インポート、削除、実行といった基本操作を一箇所で行えるようにする。これにより、プロジェクト間の切り替えやプロジェクトの整理が容易になり、開発ワークフローの効率化を実現する。

**画面へのアクセス方法**：Godot Engineを起動すると自動的にこの画面が表示される。また、エディタメイン画面から「Project > Quit to Project List」を選択することでも遷移可能。

**主要な操作・処理内容**：
1. プロジェクト一覧の表示と検索・フィルタリング
2. 新規プロジェクトの作成（テンプレート選択、ディレクトリ指定）
3. 既存プロジェクトのインポート（ZIPファイルまたはディレクトリから）
4. プロジェクトのスキャン（指定ディレクトリ配下のプロジェクト自動検出）
5. プロジェクトの編集（エディタメイン画面への遷移）
6. プロジェクトの実行（ゲームの直接起動）
7. プロジェクトの名前変更・複製・削除
8. プロジェクトタグの管理（分類・整理用）
9. Asset Libraryへのアクセス
10. クイック設定（言語・テーマ変更）

**画面遷移**：この画面からエディタメイン画面に遷移する（プロジェクト選択時）。また、プロジェクトダイアログ、クイック設定ダイアログ、Aboutダイアログ、Asset Libraryへの遷移が可能。

**権限による表示制御**：特になし。全ユーザーが同一の機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | プロジェクト設定 | 主機能 | プロジェクトの作成・設定読み込み・保存処理 |
| 3 | リソース管理 | 補助機能 | プロジェクトファイル・アセットの読み込み |
| 29 | テーマシステム | 補助機能 | プロジェクトマネージャーのUIテーマ適用 |

## 画面種別

一覧 / 管理

## URL/ルーティング

デスクトップアプリケーションのため、URL/ルーティングの概念なし。起動時のデフォルト画面として表示される。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 検索ボックス | 入力 | String | - | プロジェクト名での絞り込み検索 |
| ソートオプション | 入力 | Enum | - | プロジェクトの並び順（名前順、更新日時順など） |
| プロジェクト一覧 | 出力 | List | - | 登録済みプロジェクトの一覧表示 |
| タグフィルター | 入力 | List | - | 選択したタグでのフィルタリング |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| プロジェクト名 | String | プロジェクトの表示名 |
| プロジェクトパス | String | プロジェクトのファイルシステムパス |
| プロジェクトアイコン | Texture2D | プロジェクトのサムネイル画像 |
| Godotバージョン | String | 作成時のGodotバージョン |
| 最終更新日時 | DateTime | プロジェクトの最終編集日時 |
| タグ | List[String] | 割り当てられたタグ一覧 |
| ステータス | Enum | プロジェクトの状態（正常/欠落/要変換） |

## イベント仕様

### 1-新規作成ボタン押下

「New」ボタン押下時、ProjectDialogがMODE_NEWモードで開き、新規プロジェクト作成フローが開始される。プロジェクト名、保存先ディレクトリ、レンダラー選択などを入力後、project.godotファイルが生成される。

### 2-インポートボタン押下

「Import」ボタン押下時、ProjectDialogがMODE_IMPORTモードで開き、ファイルダイアログが表示される。既存のproject.godotファイルを選択することで、プロジェクトをリストに追加する。

### 3-スキャンボタン押下

「Scan」ボタン押下時、EditorFileDialogが開き、ディレクトリを選択する。選択されたディレクトリ配下を再帰的に検索し、project.godotファイルを持つプロジェクトを自動検出してリストに追加する。

### 4-編集ボタン押下

「Edit」ボタン押下時、選択されたプロジェクトのバージョン互換性チェックを行い、問題なければOS::create_instance()でエディタプロセスを起動する。バージョン不一致の場合は変換確認ダイアログを表示。

### 5-実行ボタン押下

「Run」ボタン押下時、選択されたプロジェクトのメインシーンが設定されているか確認し、設定済みであればゲームプロセスを起動する。未設定の場合はエラーメッセージを表示。

### 6-削除ボタン押下

「Remove」ボタン押下時、確認ダイアログを表示し、承認後にプロジェクトをリストから削除する（ファイルシステムからは削除しない）。

### 7-検索入力

検索ボックスへの入力時、リアルタイムでプロジェクト一覧をフィルタリングし、入力文字列を含むプロジェクトのみを表示する。Enterキー押下でフィルタされた最初のプロジェクトを編集モードで開く。

### 8-タグ管理ボタン押下

「Manage Tags」ボタン押下時、タグ管理ダイアログを開き、選択されたプロジェクトにタグを追加・削除できる。タグはproject.godotのapplication/config/tagsに保存される。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はファイルシステムベースで動作するため、データベースは使用しない。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | project.godot | CREATE | 新規プロジェクト設定ファイル作成 |
| インポート | editor_settings-4.tres | UPDATE | プロジェクトパスをリストに追加 |
| 削除 | editor_settings-4.tres | UPDATE | プロジェクトパスをリストから削除 |
| タグ変更 | project.godot | UPDATE | タグ設定の更新 |
| 名前変更 | project.godot | UPDATE | プロジェクト名の更新 |

### ファイル別更新項目詳細

#### project.godot

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|-----|-----------------|------|
| CREATE/UPDATE | config/name | ユーザー入力値 | プロジェクト名 |
| UPDATE | config/tags | タグ配列 | プロジェクト分類用タグ |
| CREATE | config_version | GODOT4_CONFIG_VERSION (5) | 設定ファイルバージョン |

#### editor_settings-4.tres

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|-----|-----------------|------|
| UPDATE | project_manager/project_list | プロジェクトパス配列 | 登録プロジェクト一覧 |
| UPDATE | project_manager/sorting_order | ソート順序 | デフォルトソート設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | エラー | Can't run project: Project has no main scene defined. | メインシーン未設定でRun実行時 |
| MSG002 | エラー | Can't run project: Assets need to be imported first. | 初回インポート未実行でRun実行時 |
| MSG003 | エラー | Can't open project at '%s'. | project.godotが見つからない場合 |
| MSG004 | 確認 | Remove this project from the list? | 削除操作時 |
| MSG005 | 確認 | Are you sure to run %d projects at once? | 複数プロジェクト同時実行時 |
| MSG006 | 情報 | You don't have any projects yet. | プロジェクトが0件の場合 |
| MSG007 | 警告 | The selected project was generated by Godot 3.x | Godot 3プロジェクト検出時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトファイル欠落 | プロジェクト項目に「Missing」ステータスを表示し、編集・実行ボタンを無効化 |
| バージョン不一致 | 変換確認ダイアログを表示し、ユーザーの選択に従って変換または中止 |
| ディスク容量不足 | エラーダイアログを表示し、処理を中止 |
| 権限不足 | エラーダイアログを表示し、処理を中止 |

## 備考

- プロジェクト一覧はeditor_settings-4.tresに永続化される
- ウィンドウの最小サイズは720x450ピクセル（EDSCALE適用後）
- デフォルトウィンドウサイズは1152x800ピクセル
- リカバリーモードでのプロジェクト起動に対応（ツールスクリプト、プラグイン、GDExtensionを無効化）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プロジェクトマネージャーで扱われるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_manager.h | `editor/project_manager/project_manager.h` | ProjectManagerクラスの構造、メンバ変数、MainViewTab enum |
| 1-2 | project_list.h | `editor/project_manager/project_list.h` | ProjectList::Item構造体（プロジェクト情報を保持） |

**読解のコツ**: C++のヘッダファイルでクラス構造を把握してから、実装を読む。enumやstructの定義が重要。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | project_manager.cpp | `editor/project_manager/project_manager.cpp` | コンストラクタでUI構築、_notification()でイベント処理 |

**主要処理フロー**:
1. **行84-140**: _notification()でENTER_TREE、READY、VISIBILITY_CHANGEDなどの通知処理
2. **行309-332**: _add_main_view()でプロジェクトビューとAsset Libraryビューを追加
3. **行354-380**: _select_main_view()でビュー切り替え処理

#### Step 3: プロジェクト一覧管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | project_list.cpp | `editor/project_manager/project_list.cpp` | プロジェクトのロード、表示、ソート処理 |
| 3-2 | project_dialog.cpp | `editor/project_manager/project_dialog.cpp` | プロジェクト作成・インポートダイアログ |

**主要処理フロー**:
- **project_manager.cpp 行500-551**: _run_project_confirm()でプロジェクト実行
- **project_manager.cpp 行553-602**: _open_selected_projects()でエディタ起動

#### Step 4: UIコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | quick_settings_dialog.cpp | `editor/project_manager/quick_settings_dialog.cpp` | クイック設定ダイアログ |
| 4-2 | project_tag.cpp | `editor/project_manager/project_tag.cpp` | タグUIコンポーネント |

### プログラム呼び出し階層図

```
ProjectManager (singleton)
    │
    ├─ ProjectList (project_list)
    │      ├─ ProjectList::Item (各プロジェクトデータ)
    │      └─ ProjectTag (タグ表示)
    │
    ├─ ProjectDialog (project_dialog)
    │      └─ EditorFileDialog (ファイル選択)
    │
    ├─ QuickSettingsDialog (quick_settings_dialog)
    │
    ├─ EditorAssetLibrary (asset_library)
    │
    └─ EditorAbout (about_dialog)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザー操作 ──────────▶ ProjectManager ──────────▶ UI更新
(ボタン押下等)            │
                         ├──▶ ProjectList ──────────▶ プロジェクト一覧
                         │     │
project.godot ◀──────────┼─────┘
(読み込み/保存)          │
                         ├──▶ OS::create_instance()──▶ エディタ起動
                         │
editor_settings-4.tres ◀─┴──▶ EditorSettings ──────▶ 設定永続化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| project_manager.cpp | `editor/project_manager/project_manager.cpp` | ソース | メイン画面実装 |
| project_manager.h | `editor/project_manager/project_manager.h` | ヘッダ | クラス定義 |
| project_list.cpp | `editor/project_manager/project_list.cpp` | ソース | プロジェクト一覧管理 |
| project_dialog.cpp | `editor/project_manager/project_dialog.cpp` | ソース | 作成/インポートダイアログ |
| quick_settings_dialog.cpp | `editor/project_manager/quick_settings_dialog.cpp` | ソース | 設定ダイアログ |
| project_tag.cpp | `editor/project_manager/project_tag.cpp` | ソース | タグコンポーネント |
| engine_update_label.cpp | `editor/project_manager/engine_update_label.cpp` | ソース | エンジン更新通知 |
| editor_settings.cpp | `editor/settings/editor_settings.cpp` | ソース | 設定永続化 |
