# 画面設計書 10-シグナルドック

## 概要

本ドキュメントは、Godot Engineにおける選択中ノードのシグナル接続管理ドック画面の設計仕様を記載する。

### 本画面の処理概要

シグナルドックは、現在選択されているノードが持つシグナル（イベント）の一覧と、それらの接続（コネクション）を表示・管理するためのドックパネルである。

**業務上の目的・背景**：Godotのシグナル/スロット機構を視覚的に管理できるようにする。ノードが発信するシグナルと、それを受信するメソッド（スロット）の接続関係を一覧表示し、接続の作成・編集・削除を行う。

**画面へのアクセス方法**：エディタメイン画面の右側ドック（インスペクターの隣タブ）。「Node > Signals」タブで表示。ショートカットキーで開くことも可能。

**主要な操作・処理内容**：
1. シグナル一覧の表示（クラス別にグループ化）
2. シグナル接続の作成
3. シグナル接続の編集
4. シグナル接続の削除
5. シグナル接続先メソッドへのジャンプ
6. シグナル名のコピー
7. シグナルのドキュメント表示
8. 全接続の一括削除

**画面遷移**：ドックとして表示。接続ダブルクリックでスクリプトエディタのメソッドにジャンプ。

**権限による表示制御**：リソース編集時は接続作成が無効化される。継承された接続は編集・削除不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 信号システム（シグナル） | 主機能 | シグナル一覧・接続管理 |
| 2 | ノードシステム | 連携機能 | 選択ノードのシグナル表示 |
| 47 | スクリプトエディタ | 遷移先機能 | 接続先メソッドへのジャンプ |

## 画面種別

ドック / ツリービュー

## URL/ルーティング

該当なし

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 選択オブジェクト | 入力 | Object | - | 選択中のノード/リソース |
| 検索キーワード | 入力 | String | - | シグナル名フィルター |
| シグナル一覧 | 出力 | Array | - | オブジェクトのシグナル |
| 接続一覧 | 出力 | Array | - | 各シグナルの接続 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| シグナルツリー | Tree | シグナル・接続の階層表示 |
| 検索バー | LineEdit | シグナル検索入力 |
| 接続ボタン | Button | Connect.../Disconnect |
| クラス項目 | TreeItem | シグナルのグループ化 |
| シグナル項目 | TreeItem | シグナル名と引数 |
| 接続項目 | TreeItem | 接続先ノード・メソッド |

## イベント仕様

### 1-シグナル選択

ツリー上でシグナルをクリック。接続ボタンが「Connect...」に変更され、接続ダイアログを開ける状態になる。

### 2-接続選択

ツリー上で接続をクリック。接続ボタンが「Disconnect」に変更され、接続を削除できる状態になる。

### 3-シグナルダブルクリック

シグナルをダブルクリックで接続ダイアログを表示。新規接続を作成。

### 4-接続ダブルクリック

接続をダブルクリックでスクリプトエディタにジャンプ。接続先メソッドを表示。

### 5-右クリックメニュー（シグナル）

シグナル項目を右クリック。メニュー項目：Connect、Disconnect All、Copy Name、Open Documentation。

### 6-右クリックメニュー（接続）

接続項目を右クリック。メニュー項目：Edit、Go to Method、Disconnect。

### 7-接続ダイアログ

接続作成時にConnectDialogを表示。ターゲットノード選択、メソッド名入力、オプション設定（Deferred、One Shot、Append Source）、バインド引数設定。

## データベース更新仕様

本画面はシーンの接続情報を更新（シーン保存時にファイル反映）。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| 接続作成 | Connection | CREATE | シグナル接続追加 |
| 接続削除 | Connection | DELETE | シグナル接続削除 |
| 接続編集 | Connection | UPDATE | 接続設定変更 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | Cannot connect signal | 接続失敗時 |
| MSG002 | エラー | Method in target node must be specified. | メソッド名未入力時 |
| MSG003 | エラー | Method name must be a valid identifier. | 無効なメソッド名時 |
| MSG004 | エラー | Target method not found. | メソッドが存在しない時 |
| MSG005 | 確認 | Are you sure you want to remove all connections...? | 全削除確認時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| リソース編集中 | 接続作成を無効化 |
| 継承された接続 | 編集・削除を無効化 |
| スクリプトなしノード | コールバック生成不可の警告表示 |

## 備考

- SignalsDockクラスがラッパー、ConnectionsDockが実装
- ConnectDialogで詳細な接続設定
- Undo/Redo対応（接続作成・削除）
- 接続フラグ：CONNECT_DEFERRED、CONNECT_ONE_SHOT、CONNECT_APPEND_SOURCE_OBJECT

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | signals_dock.h | `editor/docks/signals_dock.h` | SignalsDockクラス（ラッパー） |
| 1-2 | signals_dock.cpp | `editor/docks/signals_dock.cpp` | ConnectionsDockを内包 |

**読解のコツ**: SignalsDockはConnectionsDockの薄いラッパー。実装はConnectionsDockを参照。

#### Step 2: 実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | connections_dialog.h | `editor/scene/connections_dialog.h` | ConnectionData構造体、ConnectDialogクラス |
| 2-2 | connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | ConnectionsDockクラスの実装 |

**主要処理フロー**:
1. **行966-968**: _filter_changed()でシグナルフィルタリング
2. **行974-1080**: _make_or_edit_connection()で接続作成/編集
3. **行1085-1104**: _connect()で接続作成（UndoRedo対応）
4. **行1109-1124**: _disconnect()で接続削除（UndoRedo対応）
5. **行1130-1157**: _disconnect_all()で全接続削除
6. **行1178-1189**: _tree_item_activated()でダブルクリック処理
7. **行1210-1233**: _open_connection_dialog()で接続ダイアログ表示
8. **行1261-1283**: _go_to_method()でメソッドへジャンプ

### プログラム呼び出し階層図

```
SignalsDock (EditorDock)
    |
    +-- ConnectionsDock (実装)
            |
            +-- ConnectionsDockTree (ツリー表示)
            |
            +-- ConnectDialog (接続ダイアログ)
            |       |
            |       +-- SceneTreeEditor (ターゲット選択)
            |       +-- EditorInspector (バインド引数)
            |
            +-- PopupMenu (右クリックメニュー)
                    +-- signal_menu
                    +-- slot_menu
                    +-- class_menu
```

### データフロー図

```
[入力]                      [処理]                           [出力]

選択ノード --------------> SignalsDock ----------------> シグナル一覧
                               |
                               +-> ConnectionsDock
                                       |
シグナル選択 -----------> _open_connection_dialog() --> ConnectDialog
                                       |
接続確定 ----------------> _make_or_edit_connection()
                                       |
                                       +-> _connect() --------> シーン更新
                                       |
                                       +-> EditorUndoRedoManager
                                               (Undo/Redo記録)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| signals_dock.cpp | `editor/docks/signals_dock.cpp` | ソース | シグナルドック（ラッパー） |
| signals_dock.h | `editor/docks/signals_dock.h` | ヘッダ | SignalsDockクラス定義 |
| connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | ソース | ConnectionsDock, ConnectDialog実装 |
| connections_dialog.h | `editor/scene/connections_dialog.h` | ヘッダ | クラス定義、ConnectionData構造体 |
| scene_tree_editor.cpp | `editor/scene/scene_tree_editor.cpp` | ソース | ターゲットノード選択ツリー |
