# 画面設計書 13-インポートドック

## 概要

本ドキュメントは、Godot Engineエディタにおけるインポートドック（Import Dock）の画面設計書である。インポートドックは、プロジェクトにインポートされたリソースファイル（画像、音声、3Dモデル等）のインポート設定を編集・再インポートするためのドックパネルである。

### 本画面の処理概要

インポートドックは、ファイルシステムドックで選択されたリソースファイルのインポート設定を表示・編集する機能を提供する。リソースの種類に応じたインポーターを選択し、各種インポートオプションを設定した後、再インポートを実行できる。複数ファイルの一括編集にも対応している。

**業務上の目的・背景**：Godot Engineでは、外部から取り込んだリソース（テクスチャ、オーディオ、3Dモデル等）をエンジン内部形式に変換してプロジェクトにインポートする。本画面は、インポート時の圧縮設定、ミップマップ生成、フィルタ設定などを細かく調整し、プラットフォームやパフォーマンス要件に合わせた最適なリソース変換を行うために必要である。

**画面へのアクセス方法**：ファイルシステムドックでリソースファイルを選択すると自動的にインポートドックに設定が表示される。エディタメニューから「View > Docks > Import」を選択、または、ショートカットキー（ED_SHORTCUTで定義された「docks/open_import」）を使用してアクセスする。デフォルトでは左上のドックスロット（DOCK_SLOT_LEFT_UR）に配置される。

**主要な操作・処理内容**：
1. インポート設定の表示: 選択したリソースの現在のインポート設定をEditorInspectorで表示
2. インポーターの変更: 「Import As」ドロップダウンでインポーターを切り替え
3. プリセットの適用: 「Preset」メニューから定義済み設定を適用
4. インポート設定の編集: 各オプション項目をEditorInspectorで編集
5. 再インポートの実行: 「Reimport」ボタンで設定を反映してリソースを再インポート
6. 複数ファイルの一括編集: 複数選択時にチェックボックスで変更項目を選択
7. デフォルト設定の保存/読み込み: プリセットメニューからデフォルト設定を管理
8. 高度なオプション: 「Advanced...」ボタンでインポーター固有の詳細設定画面を表示

**画面遷移**：ファイルシステムドックからリソース選択で更新される。高度なオプションボタンで各インポーター固有のダイアログ画面に遷移可能。

**権限による表示制御**：特になし。すべてのユーザーが全機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ファイルシステムドック | 遷移元機能 | リソースファイル選択時に設定を表示 |
| - | ResourceFormatImporter | 主機能 | インポーター取得・インポート処理 |
| - | EditorFileSystem | 補助機能 | ファイルシステム管理・再インポート実行 |
| - | ProjectSettings | API連携 | デフォルトインポート設定の保存 |
| - | EditorInspector | UI連携 | インポートオプションの編集UI |

## 画面種別

詳細 / 編集（ドックパネル）

## URL/ルーティング

エディタ内部ドック（URLなし）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| リソースパス | 入力 | String / Vector<String> | 必須 | 編集対象のリソースファイルパス |
| インポーター名 | 入力 | String | 必須 | 選択されたインポーター |
| インポートオプション | 入力 | HashMap<StringName, Variant> | - | 各インポートオプションの設定値 |
| プリセットインデックス | 入力 | int | - | 適用するプリセット |

## 表示項目

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|----------|----------|------|
| ファイル名 | String | Label | 選択中のファイル名（複数時は件数） |
| Import As | OptionButton | ドロップダウン | 利用可能なインポーター一覧 |
| Preset | MenuButton | ボタン+ポップアップ | プリセットメニュー |
| インポートオプション | EditorInspector | プロパティ一覧 | インポート設定の編集UI |
| Reimport | Button | ボタン | 再インポート実行 |
| Advanced... | Button | ボタン | 高度なオプション（条件付き表示） |

## イベント仕様

### 1-リソース選択（set_edit_path / set_edit_multiple_paths）

ファイルシステムドックでリソースを選択すると、インポート設定が読み込まれる。

- **処理フロー**:
  1. `.import`ファイルを読み込み（ConfigFile）
  2. インポーター名を取得し、対応するResourceImporterを取得
  3. 利用可能なインポーター一覧を取得し、「Import As」ドロップダウンを更新
  4. インポートオプションを読み込み、EditorInspectorに設定
  5. プリセットメニューを更新

### 2-インポーター変更（_importer_selected）

「Import As」ドロップダウンでインポーターを変更すると、オプションが更新される。

- **処理フロー**:
  1. 選択されたインポーター名を取得
  2. 「keep」の場合: インポーターをクリア、エクスポート時そのまま出力
  3. 「skip」の場合: インポーターをクリア、エクスポート対象外
  4. その他: 対応するインポーターを設定し、オプションを更新

### 3-プリセット選択（_preset_selected）

「Preset」メニューからプリセットを選択すると、設定が適用される。

- **処理フロー**:
  1. **通常プリセット**: インポーターの`get_import_options()`でデフォルト値を取得し適用
  2. **Set as Default**: 現在の設定をProjectSettingsに保存
  3. **Load Default**: ProjectSettingsから設定を読み込み適用
  4. **Clear Default**: ProjectSettingsからデフォルト設定を削除

### 4-再インポート実行（_reimport_pressed / _reimport）

「Reimport」ボタンをクリックすると、設定を保存して再インポートを実行する。

- **処理フロー**:
  1. インポーターの変更チェック（警告ダイアログ表示）
  2. `.import`ファイルに設定を保存
  3. `EditorFileSystem::reimport_files()`で再インポート実行
  4. `filesystem_changed`シグナルを発行
  5. ダーティフラグをクリア

### 5-高度なオプション（_advanced_options）

「Advanced...」ボタンをクリックすると、インポーター固有の詳細設定画面を表示する。

- **処理フロー**:
  1. `params->importer->show_advanced_options(path)`を呼び出し
  2. インポーター固有のダイアログが表示される

### 6-プロパティ編集（_property_edited）

EditorInspectorでプロパティを編集すると、ダーティフラグが設定される。

- **処理フロー**:
  1. `_set_dirty(true)`でダーティ状態に設定
  2. 「Reimport」ボタンに`(*)`マーカーを追加
  3. 警告カラーでボタンを強調表示

### 7-プロパティチェック状態変更（_property_toggled）

複数ファイル編集時、チェックボックスのオン/オフで変更対象を指定する。

- **処理フロー**:
  1. チェック時: `params->checked`に追加
  2. チェック解除時: `params->checked`から削除
  3. 再インポート時にチェックされた項目のみ更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 再インポート | {リソース}.import | UPDATE | インポート設定の保存 |
| 再インポート | {リソース} | UPDATE | リソースの再変換 |
| デフォルト設定保存 | project.godot | UPDATE | importer_defaults/{インポーター名}に設定保存 |
| デフォルト設定削除 | project.godot | DELETE | importer_defaults/{インポーター名}を削除 |

### テーブル別更新項目詳細

#### .importファイル（ConfigFile形式）

| 操作 | 項目（セクション/キー） | 更新値・取得条件 | 備考 |
|-----|------------------------|-----------------|------|
| UPDATE | remap/importer | インポーター名 | 使用するインポーターの識別子 |
| UPDATE | remap/group_file | グループファイルパス | アトラス等のグループ設定 |
| UPDATE | params/{オプション名} | 各オプションの値 | インポートオプション |

#### ProjectSettings（project.godot）

| 操作 | 項目（キー） | 更新値・取得条件 | 備考 |
|-----|-------------|-----------------|------|
| UPDATE | importer_defaults/{インポーター名} | Dictionary | デフォルトインポート設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 案内 | Select a resource file in the filesystem or in the inspector to adjust import settings. | リソース未選択時 |
| - | ラベル | {ファイル名} | 単一ファイル選択時 |
| - | ラベル | {n} Files | 複数ファイル選択時 |
| - | ボタン | Reimport (*) | 未保存の変更がある場合 |
| - | ツールチップ | You have pending changes that haven't been applied yet. Click Reimport to apply changes... | 未保存変更時 |
| - | 警告 | The imported resource is currently loaded. All instances will be replaced and undo history will be cleared. | インポーター変更時 |
| - | 警告 | WARNING: Assets exist that use this resource. They may stop loading properly after changing type. | 依存リソース存在時 |
| - | メニュー | Keep File (exported as is) | エクスポート時そのまま出力 |
| - | メニュー | Skip File (not exported) | エクスポート対象外 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| リソース未選択 | 「Select a resource file...」メッセージを表示し、コンテンツを非表示 |
| .importファイル読み込みエラー | clear()を呼び出して初期状態に戻す |
| インポーターが見つからない | clear()を呼び出して初期状態に戻す |
| インポーター変更時の警告 | ConfirmationDialogで確認後に処理続行 |

## 備考

- 複数ファイル編集時は、最も頻度の高い設定値がデフォルトとして表示される
- 「Advanced...」ボタンは、インポーターが`has_advanced_options()`を実装し、単一ファイル選択時のみ表示
- インポーター変更時は、既存のリソースインスタンスが自動的に新しいリソースに置き換えられる
- EditorInspectorの`set_use_doc_hints(true)`により、XMLクラスリファレンスからツールチップが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インポート設定を管理するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | import_dock.cpp | `editor/docks/import_dock.cpp` | ImportDockParametersクラス（44-97行目）の構造を確認 |
| 1-2 | import_dock.h | `editor/docks/import_dock.h` | ImportDockクラスのメンバ変数を確認 |
| 1-3 | resource_importer.h | `core/io/resource_importer.h` | ResourceImporter::ImportOption構造体を確認 |

**読解のコツ**: `ImportDockParameters`はObjectを継承し、`_get`/`_set`/`_get_property_list`でEditorInspectorと連携する。`checking`フラグは複数ファイル編集時のチェックボックス表示を制御する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | import_dock.cpp | `editor/docks/import_dock.cpp` | コンストラクタ（745-836行目）でUIの初期化を確認 |

**主要処理フロー**:
1. **745-750行目**: ドック設定（名前、アイコン、ショートカット、デフォルトスロット）
2. **760-774行目**: ファイル名ラベル、Import Asドロップダウン、Presetメニューの作成
3. **787-794行目**: EditorInspectorの作成と設定
4. **798-812行目**: ReimportボタンとAdvancedボタンの作成
5. **825-835行目**: ImportDockParametersの生成と案内メッセージの作成

#### Step 3: リソース設定読み込み処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | import_dock.cpp | `editor/docks/import_dock.cpp` | `set_edit_path()`（101-158行目）の単一ファイル読み込み |
| 3-2 | import_dock.cpp | `editor/docks/import_dock.cpp` | `set_edit_multiple_paths()`（226-357行目）の複数ファイル読み込み |
| 3-3 | import_dock.cpp | `editor/docks/import_dock.cpp` | `_update_options()`（173-224行目）のオプション設定 |

**主要処理フロー**:
- **104行目**: `.import`ファイルをConfigFileとして読み込み
- **110-120行目**: インポーター名を取得し、keep/skip/通常を判定
- **128-146行目**: 利用可能なインポーター一覧を取得してドロップダウンに設定
- **173-224行目**: インポートオプションを読み込みパラメータに設定

#### Step 4: 再インポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | import_dock.cpp | `editor/docks/import_dock.cpp` | `_reimport_attempt()`（540-579行目）の事前チェック |
| 4-2 | import_dock.cpp | `editor/docks/import_dock.cpp` | `_reimport()`（633-692行目）の実際のインポート処理 |
| 4-3 | import_dock.cpp | `editor/docks/import_dock.cpp` | `_reimport_and_cleanup()`（581-625行目）のクリーンアップ処理 |

**主要処理フロー**:
- **553-569行目**: インポーター変更時の警告チェック
- **634-686行目**: `.import`ファイルへの設定書き込み
- **688行目**: `EditorFileSystem::reimport_files()`で再インポート実行

#### Step 5: プリセット管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | import_dock.cpp | `editor/docks/import_dock.cpp` | `_preset_selected()`（430-491行目）のプリセット処理 |
| 5-2 | import_dock.cpp | `editor/docks/import_dock.cpp` | `_update_preset_menu()`（374-399行目）のメニュー更新 |

**主要処理フロー**:
- **435-452行目**: ITEM_SET_AS_DEFAULT - ProjectSettingsに設定保存
- **453-468行目**: ITEM_LOAD_DEFAULT - ProjectSettingsから設定読み込み
- **469-473行目**: ITEM_CLEAR_DEFAULT - ProjectSettingsから設定削除

### プログラム呼び出し階層図

```
ImportDock（エントリーポイント）
    │
    ├─ set_edit_path() / set_edit_multiple_paths()
    │      ├─ ConfigFile::load()（.importファイル読み込み）
    │      ├─ ResourceFormatImporter::get_importer_by_name()
    │      ├─ _update_options()
    │      │      ├─ ResourceImporter::get_import_options()
    │      │      └─ params->update()（EditorInspector更新）
    │      └─ _update_preset_menu()
    │
    ├─ _importer_selected()
    │      └─ _update_options()
    │
    ├─ _preset_selected()
    │      ├─ ITEM_SET_AS_DEFAULT → ProjectSettings::set()
    │      ├─ ITEM_LOAD_DEFAULT → params->values更新
    │      └─ ITEM_CLEAR_DEFAULT → ProjectSettings::set(Variant())
    │
    └─ _reimport_pressed()
           └─ _reimport_attempt()
                  ├─ _reimport()
                  │      ├─ ConfigFile::save()
                  │      └─ EditorFileSystem::reimport_files()
                  │
                  └─ _reimport_and_cleanup()（インポーター変更時）
                         ├─ EditorUndoRedoManager::clear_history()
                         └─ EditorNode::replace_resources_in_scenes()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

FileSystemDock
└─ リソース選択 ───────▶ set_edit_path() ───────────▶ EditorInspector表示
                               │
                               ▼
                        ConfigFile読み込み
                        (.import ファイル)
                               │
                               ▼
                        _update_options() ──────────▶ params更新
                               │
                               ▼
                        ResourceImporter
                        └─ get_import_options()

ユーザー操作
├─ Reimport ────────────▶ _reimport() ──────────────▶ .importファイル保存
│                              │                      リソース再変換
│                              ▼
│                        EditorFileSystem
│                        └─ reimport_files()
│
└─ Preset選択 ──────────▶ _preset_selected() ───────▶ ProjectSettings更新
                               │                      params更新
                               ▼
                        ProjectSettings
                        └─ importer_defaults/...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| import_dock.cpp | `editor/docks/import_dock.cpp` | ソース | ドックパネルの実装 |
| import_dock.h | `editor/docks/import_dock.h` | ヘッダ | ドックパネルのクラス定義 |
| editor_dock.h | `editor/docks/editor_dock.h` | ヘッダ | ドック基底クラス |
| resource_importer.h | `core/io/resource_importer.h` | ヘッダ | インポーター基底クラス |
| resource_format_importer.h | `core/io/resource_format_importer.h` | ヘッダ | インポーター管理 |
| editor_inspector.h | `editor/inspector/editor_inspector.h` | ヘッダ | プロパティ編集UI |
| editor_file_system.h | `editor/file_system/editor_file_system.h` | ヘッダ | ファイルシステム管理 |
| config_file.h | `core/io/config_file.h` | ヘッダ | .importファイル読み書き |
| project_settings.h | `core/config/project_settings.h` | ヘッダ | プロジェクト設定 |
