# 画面設計書: アニメーションエディタ

## 1. 画面概要

| 項目 | 内容 |
|------|------|
| 画面ID | 17 |
| 画面名 | アニメーションエディタ（AnimationPlayerEditor） |
| 概要 | AnimationPlayerおよびAnimationTree用のアニメーション再生・編集インターフェース。タイムライン、トラック編集、オニオンスキニング機能を提供 |
| 主要機能 | アニメーション再生/停止、タイムラインシーク、トラック編集、オニオンスキニング、ブレンド設定、アニメーションライブラリ管理 |

## 2. UI構成

### 2.1 全体レイアウト

```
+-----------------------------------------------------------------------------------+
| AnimationPlayerEditor (EditorDock)                                                |
| +-------------------------------------------------------------------------------+ |
| | VBoxContainer (main_vbox_container)                                           | |
| | +-------------------------------------------------------------------------+   | |
| | | HBoxContainer (hb) - ツールバー                                          |   | |
| | | [BWEnd][BW][Stop][Play][PlayEnd] [frame] | [scale] [Animation][List][auto]  | |
| | | | [track_menu] | [onion][onion_opt] | [pin]                              |   | |
| | +-------------------------------------------------------------------------+   | |
| | +-------------------------------------------------------------------------+   | |
| | | AnimationTrackEditor (track_editor)                                     |   | |
| | | [タイムライン・トラック編集エリア]                                        |   | |
| | +-------------------------------------------------------------------------+   | |
| +-------------------------------------------------------------------------------+ |
+-----------------------------------------------------------------------------------+
```

### 2.2 ツールバー詳細

```
+-----------------------------------------------------------------------------------+
| HBoxContainer (hb)                                                                |
| +-----------------------+-----+-----+                                             |
| | HBoxContainer         | Sep | Sep |                                             |
| | (playback_container)  |     |     |                                             |
| | [BWEnd][BW][Stop]     |     |     |                                             |
| | [Play][PlayEnd]       |     |     |                                             |
| +-----------------------+-----+-----+                                             |
| +-------+-----+---------+----------+-------+-------+-----+-------+-------+-----+  |
| |SpinBox|Sep  |MenuBtn  |OptionBtn |Button |Sep    |Btn  |MenuBtn|Sep    |Button| |
| |(frame)|    |(tool_   |(animation|(auto- |       |(oni-|(onion_|       |(pin) | |
| |       |    | anim)   |)         |play)  |       |on)  |skin)  |       |      | |
| +-------+-----+---------+----------+-------+-------+-----+-------+-------+-----+  |
+-----------------------------------------------------------------------------------+
```

## 3. コンポーネント詳細

### 3.1 クラス構造

```
AnimationPlayerEditor : EditorDock
├── GDCLASS(AnimationPlayerEditor, EditorDock)
├── friend AnimationPlayerEditorPlugin
├── singleton パターン
└── ドック名: "Animation", アイコン: "Animation"

AnimationPlayerEditorPlugin : EditorPlugin
└── AnimationPlayer/AnimationTree/AnimationMixerを編集

EditorInspectorPluginAnimationTrackKeyEdit : EditorInspectorPlugin
└── アニメーションキー編集用インスペクタプラグイン

AnimationTrackKeyEditEditorPlugin : EditorPlugin
└── トラックキー編集プラグイン
```

### 3.2 再生コントロールコンポーネント

| コンポーネント名 | 型 | 説明 |
|------------------|-----|------|
| play_bw_from | Button | 現在位置から逆再生 |
| play_bw | Button | 末尾から逆再生 |
| stop | Button | 停止/一時停止 |
| play | Button | 先頭から再生 |
| play_from | Button | 現在位置から再生 |
| frame | SpinBox | 再生位置（秒） |
| scale | LineEdit | 再生速度スケール |

### 3.3 アニメーション管理コンポーネント

| コンポーネント名 | 型 | 説明 |
|------------------|-----|------|
| tool_anim | MenuButton | アニメーションツールメニュー |
| animation | OptionButton | アニメーション選択 |
| autoplay | Button | 自動再生設定（トグル） |
| pin | Button | AnimationPlayerピン留め（トグル） |
| library_editor | AnimationLibraryEditor | ライブラリ管理ダイアログ |

### 3.4 オニオンスキニングコンポーネント

| コンポーネント名 | 型 | 説明 |
|------------------|-----|------|
| onion_toggle | Button | オニオンスキニング有効/無効（トグル） |
| onion_skinning | MenuButton | オニオンスキニングオプションメニュー |

### 3.5 トラック編集コンポーネント

| コンポーネント名 | 型 | 説明 |
|------------------|-----|------|
| track_editor | AnimationTrackEditor | タイムライン・トラック編集 |

## 4. データ構造

### 4.1 ツールメニュー列挙型

```cpp
enum {
    TOOL_NEW_ANIM,        // 新規アニメーション
    TOOL_ANIM_LIBRARY,    // ライブラリ管理
    TOOL_DUPLICATE_ANIM,  // アニメーション複製
    TOOL_RENAME_ANIM,     // アニメーション名変更
    TOOL_EDIT_TRANSITIONS,// トランジション編集
    TOOL_REMOVE_ANIM,     // アニメーション削除
    TOOL_EDIT_RESOURCE    // リソース編集
};
```

### 4.2 オニオンスキニングメニュー列挙型

```cpp
enum {
    ONION_SKINNING_ENABLE,            // 有効化
    ONION_SKINNING_PAST,              // 過去フレーム表示
    ONION_SKINNING_FUTURE,            // 未来フレーム表示
    ONION_SKINNING_1_STEP,            // 1ステップ
    ONION_SKINNING_2_STEPS,           // 2ステップ
    ONION_SKINNING_3_STEPS,           // 3ステップ
    ONION_SKINNING_DIFFERENCES_ONLY,  // 差分のみ
    ONION_SKINNING_FORCE_WHITE_MODULATE, // 白モジュレート強制
    ONION_SKINNING_INCLUDE_GIZMOS,    // ギズモ含む(3D)
};
```

### 4.3 オニオンスキニング構造体

```cpp
struct {
    // Settings
    bool enabled = false;
    bool past = true;
    bool future = false;
    uint32_t steps = 1;
    bool differences_only = false;
    bool force_white_modulate = false;
    bool include_gizmos = false;

    // Rendering
    int64_t last_frame = 0;
    int can_overlay = 0;
    Size2 capture_size;
    LocalVector<RID> captures;
    LocalVector<bool> captures_valid;
    struct {
        RID canvas;
        RID canvas_item;
        Ref<ShaderMaterial> material;
        Ref<Shader> shader;
    } capture;

    // Cross-call state
    struct {
        double anim_player_position;
        Ref<AnimatedValuesBackup> anim_values_backup;
        Rect2 screen_rect;
        Dictionary canvas_edit_state;
        Dictionary spatial_edit_state;
    } temp;
} onion;
```

### 4.4 BlendEditor構造体

```cpp
struct BlendEditor {
    AcceptDialog *dialog = nullptr;
    Tree *tree = nullptr;
    OptionButton *next = nullptr;
} blend_editor;
```

## 5. 処理フロー

### 5.1 再生フロー（_play_pressed）

```
_play_pressed()
    ↓
current = _get_current()
    ↓
if current == player->get_assigned_animation():
    player->stop()  // 自己ブレンド防止
    ↓
_validate_tracks(player->get_animation(current))
    ↓
markers = track_editor->get_selected_section()
    ↓
if markers.size() == 2:
    player->play_section_with_markers(...)
else:
    player->play(current)
    ↓
stop->set_button_icon(pause_icon)
```

### 5.2 停止/一時停止フロー（_stop_pressed）

```
_stop_pressed()
    ↓
if player->is_playing():
    player->pause()
else:
    player->stop()
    player->set_assigned_animation(current)
    frame->set_value(0)
    track_editor->set_anim_pos(0)
    ↓
stop->set_button_icon(stop_icon)
```

### 5.3 シーク処理フロー

```
_seek_value_changed(p_value, p_timeline_only)
    ↓
pos = CLAMP(anim->get_length() * (p_value / frame->get_max()), 0, length)
    ↓
if track_editor->is_snap_timeline_enabled():
    pos = Math::snapped(pos, _get_editor_step())
    ↓
if !p_timeline_only:
    player->seek_internal(pos, true, true, false)
    ↓
track_editor->set_anim_pos(pos)
```

### 5.4 オニオンスキニング描画フロー

```
_prepare_onion_layers_1()
    ↓
[フレーム変更検出]
    ↓
_prepare_onion_layers_2_prolog()
    ├── 2D/3Dエディタ状態保存
    ├── ビューポート設定調整
    └── バックアップ作成
    ↓
_prepare_onion_layers_2_step_prepare(step_offset, capture_idx)
    ├── player->seek_internal(pos, ...)
    └── _prepare_onion_layers_2_step_capture()
    ↓
_prepare_onion_layers_2_epilog()
    ├── ビューポート復元
    ├── アニメーション状態復元
    └── エディタ状態復元
    ↓
forward_force_draw_over_viewport()
    └── キャプチャ画像をオーバーレイ描画
```

## 6. イベント処理

### 6.1 シグナル定義

| シグナル名 | パラメータ | 説明 |
|------------|------------|------|
| animation_selected | String name | アニメーション選択時 |

### 6.2 AnimationPlayer連携

```cpp
// edit()内で接続
player->connect("animation_list_changed", &_animation_libraries_updated);
player->connect("animation_finished", &_animation_finished);
player->connect("current_animation_changed", &_current_animation_changed);
```

### 6.3 ショートカットキー処理

```cpp
void shortcut_input(const Ref<InputEvent> &p_ev) {
    // "animation_editor/stop_animation"
    // "animation_editor/play_animation"
    // "animation_editor/play_animation_from_start"
    // "animation_editor/play_animation_backwards"
    // "animation_editor/play_animation_from_end"
}
```

## 7. 状態管理

### 7.1 プレーヤー状態

| 変数名 | 型 | 説明 |
|--------|-----|------|
| player | AnimationPlayer* | 編集対象プレーヤー |
| original_node | AnimationMixer* | 元ノード（ピン用） |
| is_dummy | bool | ダミープレーヤーフラグ |
| updating | bool | 更新中フラグ |
| finishing | bool | アニメーション終了中フラグ |
| last_active | bool | 前フレームの再生状態 |
| timeline_position | float | タイムライン位置 |

### 7.2 アイコン管理

| 変数名 | 型 | 説明 |
|--------|-----|------|
| stop_icon | Ref<Texture2D> | 停止アイコン |
| pause_icon | Ref<Texture2D> | 一時停止アイコン |
| autoplay_icon | Ref<Texture2D> | 自動再生アイコン |
| reset_icon | Ref<Texture2D> | リセットアイコン |
| autoplay_reset_icon | Ref<ImageTexture> | 自動再生+リセット合成アイコン |

## 8. ダイアログ

### 8.1 名前ダイアログ（name_dialog）

```cpp
ConfirmationDialog *name_dialog;
LineEdit *name;           // 新しい名前入力
OptionButton *library;    // ライブラリ選択
Label *name_title;        // タイトルラベル
int name_dialog_op;       // 操作種別(TOOL_NEW_ANIM/TOOL_DUPLICATE_ANIM等)
```

### 8.2 ブレンドエディタダイアログ

```cpp
struct BlendEditor {
    AcceptDialog *dialog;  // ダイアログ
    Tree *tree;            // ブレンド時間ツリー（2カラム）
    OptionButton *next;    // 次アニメーション選択
} blend_editor;
```

### 8.3 その他ダイアログ

| ダイアログ名 | 型 | 説明 |
|-------------|-----|------|
| delete_dialog | ConfirmationDialog | 削除確認 |
| error_dialog | AcceptDialog | エラー表示 |
| file | EditorFileDialog | ファイル選択 |

## 9. EditorDock設定

```cpp
// コンストラクタ内
set_name(TTRC("Animation"));
set_icon_name("Animation");
set_dock_shortcut(ED_SHORTCUT_AND_COMMAND(
    "bottom_panels/toggle_animation_bottom_panel",
    TTRC("Toggle Animation Dock"),
    KeyModifierMask::ALT | Key::N
));
set_default_slot(EditorDock::DOCK_SLOT_BOTTOM);
set_available_layouts(
    EditorDock::DOCK_LAYOUT_HORIZONTAL |
    EditorDock::DOCK_LAYOUT_FLOATING
);
```

## 10. コードリーディングガイド

### 10.1 データ構造の把握

1. **onion構造体** (animation_player_editor_plugin.h:143-179)
   - オニオンスキニングの設定・レンダリング状態管理
   - captures: 各ステップのビューポートRID配列

2. **BlendEditor構造体** (animation_player_editor_plugin.h:125-130)
   - ブレンド時間編集ダイアログのUI参照

3. **ツールメニュー列挙型** (animation_player_editor_plugin.h:58-66)
   - TOOL_NEW_ANIM〜TOOL_EDIT_RESOURCE

### 10.2 エントリーポイント

1. **edit(AnimationMixer*, AnimationPlayer*, bool)** (animation_player_editor_plugin.cpp:1237-1304)
   - 編集対象ノードの設定
   - シグナル接続・切断
   - track_editor/library_editor設定

2. **AnimationPlayerEditorPlugin::edit(Object*)** (未掲載)
   - EditorPluginからの呼び出しエントリ

### 10.3 処理層の読み解き

```
ユーザー操作
    ↓
AnimationPlayerEditor (UI制御)
    ↓
AnimationPlayer (再生制御)
    ↓
AnimationTrackEditor (トラック編集)
    ↓
Animation (リソース)
```

### 10.4 プログラム呼び出し階層図

```
AnimationPlayerEditor
├── 再生制御
│   ├── _play_pressed() → player->play()
│   ├── _play_from_pressed() → player->seek_internal() → player->play()
│   ├── _play_bw_pressed() → player->play_backwards()
│   ├── _play_bw_from_pressed() → player->seek_internal() → player->play_backwards()
│   └── _stop_pressed() → player->pause() / player->stop()
├── アニメーション管理
│   ├── _animation_tool_menu(TOOL_NEW_ANIM) → _animation_new()
│   ├── _animation_tool_menu(TOOL_DUPLICATE_ANIM) → _animation_duplicate()
│   ├── _animation_tool_menu(TOOL_RENAME_ANIM) → _animation_rename()
│   ├── _animation_tool_menu(TOOL_REMOVE_ANIM) → _animation_remove()
│   └── _animation_tool_menu(TOOL_ANIM_LIBRARY) → library_editor->show_dialog()
├── シーク処理
│   ├── _seek_value_changed() → player->seek_internal()
│   └── _animation_key_editor_seek() → frame->set_value()
├── オニオンスキニング
│   ├── _start_onion_skinning() → connect("process_frame")
│   ├── _prepare_onion_layers_1() → _prepare_onion_layers_2_prolog()
│   └── forward_force_draw_over_viewport() → オーバーレイ描画
└── トラック編集連携
    └── track_editor->set_animation() / set_root() / set_anim_pos()
```

### 10.5 データフロー図

```
[AnimationPlayer/AnimationTree/AnimationMixer]
       ↓ edit()
[AnimationPlayerEditor]
       ├── player->get_animation() → [Animation]
       ├── animation (OptionButton) ← player->get_animation_list()
       ├── track_editor → AnimationTrackEditor
       └── onion → オニオンスキニングレンダリング
              ↓
[forward_force_draw_over_viewport]
       ↓
[2D/3Dビューポートオーバーレイ]
```

### 10.6 関連ファイル一覧

| ファイルパス | 役割 |
|-------------|------|
| editor/animation/animation_player_editor_plugin.h | クラス定義・メンバ宣言 |
| editor/animation/animation_player_editor_plugin.cpp | 実装・UIコンストラクタ |
| editor/animation/animation_track_editor.h/cpp | トラック編集エディタ |
| editor/animation/animation_library_editor.h/cpp | ライブラリ管理ダイアログ |
| scene/animation/animation_player.h/cpp | AnimationPlayerクラス |
| scene/animation/animation_tree.h/cpp | AnimationTreeクラス |
| scene/animation/animation_mixer.h/cpp | AnimationMixer基底クラス |
| scene/resources/animation.h/cpp | Animationリソース |

## 11. 補足情報

### 11.1 キーボードショートカット

| 機能 | 設定キー |
|------|---------|
| 停止 | animation_editor/stop_animation |
| 再生 | animation_editor/play_animation |
| 先頭から再生 | animation_editor/play_animation_from_start |
| 逆再生 | animation_editor/play_animation_backwards |
| 末尾から逆再生 | animation_editor/play_animation_from_end |
| ドック表示切替 | Alt+N |

### 11.2 ツールメニュー項目

| メニュー項目 | ショートカット設定 |
|-------------|-------------------|
| New... | animation_player_editor/new_animation |
| Manage Animations... | animation_player_editor/animation_libraries |
| Duplicate... | animation_player_editor/duplicate_animation |
| Rename... | animation_player_editor/rename_animation |
| Edit Transitions... | animation_player_editor/edit_transitions |
| Open in Inspector | animation_player_editor/open_animation_in_inspector |
| Remove | animation_player_editor/remove_animation |

### 11.3 オニオンスキニング設定

| 設定 | エディタ設定キー |
|------|----------------|
| 過去色 | editors/animation/onion_layers_past_color |
| 未来色 | editors/animation/onion_layers_future_color |
