# 画面設計書 2-エディタメイン画面

## 概要

本ドキュメントは、Godot Engineでプロジェクト編集時に表示されるメインエディター画面の設計仕様を記載する。

### 本画面の処理概要

エディタメイン画面は、Godotプロジェクトの編集作業を行うための中央ハブとなる画面である。2Dエディタ、3Dエディタ、スクリプトエディタ、Asset Libraryといった各種編集モードを切り替えながら、シーンの構築、ノードの配置、スクリプトの編集を統合的に行える。

**業務上の目的・背景**：ゲーム開発において、シーン編集、スクリプティング、アセット管理といった多様なタスクをシームレスに切り替えながら作業できる統合開発環境を提供する。これにより、開発者は複数のツール間を移動することなく、一つのアプリケーション内で完結した開発ワークフローを実現できる。

**画面へのアクセス方法**：プロジェクトマネージャーでプロジェクトを選択し「Edit」ボタンを押すか、プロジェクトをダブルクリックすることでこの画面に遷移する。

**主要な操作・処理内容**：
1. 2D/3D/Script/AssetLibの各エディタモード切り替え
2. シーンのオープン・保存・作成・クローズ
3. ノードの選択・編集（インスペクター経由）
4. ドック（FileSystem、SceneTree、Inspector等）の表示・非表示・配置変更
5. ボトムパネル（出力、デバッガ、アニメーション等）の表示切り替え
6. プロジェクト実行・デバッグ
7. プロジェクト設定・エディター設定の編集
8. エクスポート設定とビルド

**画面遷移**：プロジェクトマネージャーから遷移してくる。「Project > Quit to Project List」でプロジェクトマネージャーに戻る。各種ダイアログ（プロジェクト設定、エディター設定、エクスポート等）への遷移が可能。

**権限による表示制御**：特になし。ただし、エディター機能プロファイルにより一部機能を制限可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | シーンツリー管理 | 主機能 | 編集中シーンの階層構造管理 |
| 2 | ノードシステム | 主機能 | ノードの作成・編集・削除の基盤処理 |
| 3 | リソース管理 | 主機能 | シーン・リソースの読み込み・保存 |
| 4 | プロジェクト設定 | API連携 | プロジェクト設定値の参照・更新 |
| 45 | シーンエディタ | 主機能 | 2D/3Dシーンの視覚的編集のメイン処理 |

## 画面種別

メイン画面 / 統合開発環境

## URL/ルーティング

デスクトップアプリケーションのため、URL/ルーティングの概念なし。プロジェクト選択後に起動されるメインウィンドウ。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 編集中シーン | 入出力 | PackedScene | - | 現在編集中のシーンデータ |
| 選択ノード | 入力 | Node | - | インスペクターで編集するノード |
| プロジェクト設定 | 入出力 | Dictionary | - | project.godotの設定値 |
| エディターレイアウト | 入力 | ConfigFile | - | ドック配置・ウィンドウ状態 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タイトルバー | String | プロジェクト名・編集中シーン名・未保存マーク |
| メインエディタタブ | Enum | 2D/3D/Script/AssetLib/Game |
| シーンタブ | List[String] | 開いているシーンのタブ一覧 |
| ドックパネル | Control | 各種ドック（FileSystem、SceneTree等） |
| ボトムパネル | Control | 出力、デバッガ等のパネル |
| ツールバー | Control | シーン操作、実行ボタン等 |

## イベント仕様

### 1-シーンオープン

「Scene > Open Scene」またはCtrl+Oでファイルダイアログを開き、.tscnまたは.scnファイルを選択。ResourceLoader::loadでシーンを読み込み、新しいタブとして追加。

### 2-シーン保存

「Scene > Save Scene」またはCtrl+Sで現在のシーンを保存。初回保存時は保存先ダイアログを表示。ResourceSaver::saveでディスクに書き込み。

### 3-エディタモード切り替え

メインエディタタブ（2D/3D/Script/AssetLib）をクリックするか、F1-F4キーで各エディタに切り替え。editor_main_screen->select()が呼ばれる。

### 4-ノード選択

シーンツリードックでノードをクリック、または2D/3Dビューポートでオブジェクトをクリック。選択ノードがインスペクターに反映され、プロパティ編集が可能になる。

### 5-プロジェクト実行

「Play」ボタン（F5）押下でエディター実行バーからゲームを起動。EditorRunクラスがサブプロセスとしてゲームを実行し、デバッガと接続。

### 6-プロジェクト停止

「Stop」ボタン（F8）押下で実行中のゲームプロセスを終了。デバッグ接続も切断。

### 7-Undo/Redo

「Edit > Undo」（Ctrl+Z）でEditorUndoRedoManagerから直前の操作を取り消し。「Edit > Redo」（Ctrl+Shift+Z）で取り消しを再実行。

### 8-クイックオープン

Ctrl+Pでクイックオープンダイアログを表示。ファジー検索でシーン・スクリプト・リソースを素早く開く。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はファイルシステムベースで動作する。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| シーン保存 | *.tscn/*.scn | UPDATE/CREATE | シーンデータの保存 |
| リソース保存 | *.tres/*.res | UPDATE/CREATE | リソースデータの保存 |
| プロジェクト設定変更 | project.godot | UPDATE | 設定値の更新 |
| レイアウト保存 | editor_layout.cfg | UPDATE | ドック配置の保存 |

### ファイル別更新項目詳細

#### *.tscn (テキストシーン)

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|-----|-----------------|------|
| UPDATE | ノード構造 | シーンツリー状態 | テキスト形式で保存 |
| UPDATE | プロパティ値 | インスペクター編集値 | 各ノードのプロパティ |
| UPDATE | シグナル接続 | 接続情報 | connections配列 |

#### editor_layout.cfg

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|-----|-----------------|------|
| UPDATE | dock_hsplit_* | スプリッタ位置 | ドック幅 |
| UPDATE | dock_select | 選択中ドック | 各スロットの選択状態 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 確認 | Save changes to '%s' before closing? | 未保存シーンのクローズ時 |
| MSG002 | エラー | Can't open scene file '%s'. | シーンファイル読み込み失敗時 |
| MSG003 | 警告 | This operation can't be undone. | 取り消し不可操作実行時 |
| MSG004 | 情報 | Scene '%s' was successfully saved. | シーン保存成功時（トースト） |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| シーンファイル破損 | エラーダイアログ表示、シーンタブ作成せず |
| リソース読み込み失敗 | 警告表示、プレースホルダーリソースで代替 |
| ディスク書き込み失敗 | エラーダイアログ表示、別名保存を提案 |
| プラグインクラッシュ | エラーログ出力、プラグイン無効化 |

## 備考

- EditorNodeクラスがシングルトンとしてエディター全体を統括
- 各ドックはEditorDockManagerで管理される
- レイアウトは`.godot/editor/editor_layout.cfg`に保存される
- 最大4つのビューポート分割表示に対応（3Dエディタ）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_node.h | `editor/editor_node.h` | EditorNodeクラス構造、メンバ変数 |
| 1-2 | editor_data.h | `editor/editor_data.h` | EditorData（編集データ管理） |
| 1-3 | editor_main_screen.h | `editor/editor_main_screen.h` | メインエディタ画面管理 |

**読解のコツ**: EditorNodeが中心となり、EditorDataで編集状態、EditorMainScreenで画面切り替えを管理。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_node.cpp | `editor/editor_node.cpp` | コンストラクタでUI構築、_notification()でイベント処理 |

**主要処理フロー**:
1. **行350-360**: _version_control_menu_option() バージョン管理メニュー
2. **行361-377**: _update_title() ウィンドウタイトル更新
3. **行402-438**: shortcut_input() ショートカットキー処理

#### Step 3: 各エディタモードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | canvas_item_editor_plugin.cpp | `editor/scene/canvas_item_editor_plugin.cpp` | 2Dエディタ |
| 3-2 | node_3d_editor_plugin.cpp | `editor/scene/3d/node_3d_editor_plugin.cpp` | 3Dエディタ |
| 3-3 | script_editor_plugin.cpp | `editor/script/script_editor_plugin.cpp` | スクリプトエディタ |

#### Step 4: ドック管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | editor_dock_manager.cpp | `editor/docks/editor_dock_manager.cpp` | ドックの配置・表示管理 |
| 4-2 | scene_tree_dock.cpp | `editor/docks/scene_tree_dock.cpp` | シーンツリードック |
| 4-3 | inspector_dock.cpp | `editor/docks/inspector_dock.cpp` | インスペクタードック |

### プログラム呼び出し階層図

```
EditorNode (singleton)
    │
    ├─ EditorMainScreen
    │      ├─ CanvasItemEditor (2D)
    │      ├─ Node3DEditor (3D)
    │      ├─ ScriptEditor (Script)
    │      └─ AssetLibraryEditor (AssetLib)
    │
    ├─ EditorDockManager
    │      ├─ SceneTreeDock
    │      ├─ InspectorDock
    │      ├─ FileSystemDock
    │      ├─ SignalsDock
    │      ├─ GroupsDock
    │      └─ HistoryDock
    │
    ├─ EditorBottomPanel
    │      ├─ EditorLog (出力)
    │      ├─ ScriptEditorDebugger (デバッガ)
    │      ├─ AudioBusesEditor (オーディオ)
    │      └─ AnimationPlayerEditor (アニメーション)
    │
    ├─ EditorRunBar
    │      └─ EditorRun (ゲーム実行)
    │
    └─ EditorData
           └─ EditorSelection (選択管理)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

*.tscn ─────────────────▶ ResourceLoader ─────────────▶ PackedScene
                           │
                           ▼
ユーザー操作 ──────────▶ EditorNode ────────────────▶ UI更新
                           │
                           ├──▶ EditorMainScreen ─────▶ ビューポート描画
                           │
                           ├──▶ EditorData ───────────▶ 編集状態管理
                           │
                           └──▶ EditorUndoRedoManager ▶ Undo履歴

                                      │
                                      ▼
                              ResourceSaver ──────────▶ *.tscn (保存)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_node.cpp | `editor/editor_node.cpp` | ソース | メインエディター実装 |
| editor_node.h | `editor/editor_node.h` | ヘッダ | クラス定義 |
| editor_main_screen.cpp | `editor/editor_main_screen.cpp` | ソース | メイン画面管理 |
| editor_data.cpp | `editor/editor_data.cpp` | ソース | 編集データ管理 |
| editor_dock_manager.cpp | `editor/docks/editor_dock_manager.cpp` | ソース | ドック管理 |
| editor_run_bar.cpp | `editor/run/editor_run_bar.cpp` | ソース | 実行バー |
| editor_undo_redo_manager.cpp | `editor/editor_undo_redo_manager.cpp` | ソース | Undo/Redo管理 |
| editor_selection.cpp | `editor/editor_selection.cpp` | ソース | 選択管理 |
