# 画面設計書 21-プロジェクト設定

## 概要

本ドキュメントは、Godot Engineエディターのプロジェクト設定ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

プロジェクト設定ダイアログは、現在開いているプロジェクト固有の設定を編集・管理するための中央集約型設定画面である。project.godotファイルに保存される各種設定を視覚的に編集できる。

**業務上の目的・背景**：ゲーム開発において、プロジェクト固有の設定（入力マッピング、Autoload、ローカライゼーション、シェーダーグローバル変数など）を一元管理する必要がある。この画面により、開発者はコードを書かずにプロジェクトの動作を制御でき、チーム開発においても設定の共有・管理が容易になる。

**画面へのアクセス方法**：メインメニューの「Project > Project Settings」から起動する。ショートカットキーでのアクセスも可能。

**主要な操作・処理内容**：
1. 一般設定（General）タブでプロジェクト全般の設定を編集
2. Input Mapタブで入力アクションとキーバインドを設定
3. Localizationタブで多言語対応の設定を管理
4. Globalsタブ内のAutoloadでシングルトンスクリプトを設定
5. Shader Globalsタブでシェーダーグローバル変数を定義
6. Groupsタブでノードグループを管理
7. Pluginsタブでエディタープラグインの有効/無効を切り替え
8. Import Defaultsタブでリソースのデフォルトインポート設定を管理
9. カスタムプロパティの追加・削除

**画面遷移**：エディターメイン画面から「Project > Project Settings」メニューで開く。閉じるボタンまたはOKボタンで親画面に戻る。Input Map設定時には入力イベント設定ダイアログに遷移可能。

**権限による表示制御**：エディター機能であり、プロジェクトを開いている状態でのみアクセス可能。EditorFeatureProfileによる機能制限がある場合は一部設定が非表示になる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | プロジェクト設定 | 主機能 | project.godot設定の編集・保存 |
| 26 | 入力マッピング | 主機能 | Input Map（アクション・キーバインド）設定 |
| 72 | 国際化（i18n） | 補助機能 | Localization設定・翻訳ファイル管理 |

## 画面種別

設定編集ダイアログ（タブ型マルチセクション）

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `ProjectSettingsEditor` が画面を管理する。

## 入出力項目

### 一般設定タブ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 検索フィルター | 文字列 | - | 設定項目をフィルタリング |
| Advanced Settings | ブール値 | - | 詳細設定の表示/非表示 |
| プロパティ名 | 文字列 | カスタムプロパティ追加時 | 新規プロパティの名前 |
| プロパティ型 | 列挙 | カスタムプロパティ追加時 | プロパティのVariant型 |
| Feature | 列挙 | - | プラットフォーム/機能別オーバーライド |

### Input Mapタブ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| アクション名 | 文字列 | 新規追加時 | 入力アクションの名前 |
| デッドゾーン | 浮動小数点 | - | アナログ入力のデッドゾーン値 |
| 入力イベント | InputEvent | - | キー/ボタン/軸などの入力イベント |

## 表示項目

### タブ構成

| タブ名 | 説明 |
|--------|------|
| General | 全般設定のセクション化されたインスペクター |
| Input Map | 入力アクション一覧とイベント設定 |
| Localization | 翻訳ファイル・ロケール設定 |
| Globals | Autoload/Shader Globals/Groups のサブタブ |
| Plugins | エディタープラグインの管理 |
| Import Defaults | インポートデフォルト設定 |

## イベント仕様

### 1-設定値変更

設定値が変更されると `queue_save()` が呼び出され、1.5秒後に自動保存される。即座に保存はされず、連続編集時のファイルI/Oを最適化している。

### 2-入力アクション追加

「input/」プレフィックス付きでProjectSettingsに新しいアクションが追加される。UndoRedoManagerによる操作履歴管理が行われる。

### 3-入力アクション削除

選択されたアクションがProjectSettingsから削除される。Undo/Redo対応。

### 4-カスタムプロパティ追加

指定した名前・型でProjectSettingsに新規プロパティを追加する。名前が「/」を含まない場合は「global/」プレフィックスが自動付与される。

### 5-エディター再起動要求

一部の設定変更は即座に反映されないため、再起動バナーが表示される。「Save & Restart」ボタンで保存と再起動が実行される。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はファイルベースの設定管理であり、データベースは使用しない。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | project.godot | UPDATE | ProjectSettings::save()で保存 |
| Autoload変更 | project.godot | UPDATE | autoload/プレフィックスのプロパティ更新 |
| Input Map変更 | project.godot | UPDATE | input/プレフィックスのプロパティ更新 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | Changed settings will be applied to the editor after restarting. | 再起動が必要な設定変更時 |
| エラー | An action with this name already exists. | 重複するアクション名追加時 |
| 成功 | (自動保存のため明示的なメッセージなし) | 設定保存成功時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 無効なプロパティ名 | Addボタンが無効化され追加不可 |
| ビルトイン設定の削除試行 | Deleteボタンが無効化 |
| 設定保存失敗 | エラーログ出力（通常発生しない） |

## 備考

- ダイアログ位置・サイズはEditorSettingsのプロジェクトメタデータに保存され、次回起動時に復元される
- Feature Overrideにより、プラットフォーム別の設定値を管理可能
- EditorSettingのオーバーライド機能により、プロジェクト固有のエディター設定も管理可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクト設定のデータ構造はProjectSettingsシングルトンで管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_settings.h | `core/config/project_settings.h` | ProjectSettingsクラスの構造、プロパティ管理方法 |
| 1-2 | input_map.h | `core/input/input_map.h` | 入力マッピングのデータ構造、DEFAULT_DEADZONE定数 |

**読解のコツ**: ProjectSettingsはDictionaryベースでプロパティを管理。`get_setting()` / `set_setting()` がコアAPI。

#### Step 2: エントリーポイントを理解する

ProjectSettingsEditorクラスがダイアログの主要実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | project_settings_editor.h | `editor/settings/project_settings_editor.h` | クラス構造、メンバー変数の役割 |
| 2-2 | project_settings_editor.cpp | `editor/settings/project_settings_editor.cpp` | コンストラクタでのUI構築、イベントハンドラ |

**主要処理フロー**:
1. **行51-75**: `popup_project_settings()` - ダイアログ表示、各エディターの更新
2. **行120-127**: `_setting_edited()` - 設定変更時の保存キュー登録
3. **行164-185**: `_add_setting()` - カスタムプロパティ追加処理
4. **行442-462**: `_action_added()` - 入力アクション追加処理

#### Step 3: タブ別エディターを理解する

各タブは専用のエディタークラスで実装されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | action_map_editor.h | `editor/settings/action_map_editor.h` | Input Mapタブの実装 |
| 3-2 | localization_editor.h | `editor/translations/localization_editor.h` | Localizationタブの実装 |
| 3-3 | editor_autoload_settings.h | `editor/settings/editor_autoload_settings.h` | Autoloadタブの実装 |
| 3-4 | shader_globals_editor.h | `editor/shader/shader_globals_editor.h` | Shader Globalsタブの実装 |
| 3-5 | group_settings_editor.h | `editor/scene/group_settings_editor.h` | Groupsタブの実装 |
| 3-6 | editor_plugin_settings.h | `editor/plugins/editor_plugin_settings.h` | Pluginsタブの実装 |

### プログラム呼び出し階層図

```
EditorNode (メニュー操作)
    │
    ├─ ProjectSettingsEditor::popup_project_settings()
    │      ├─ _add_feature_overrides()
    │      ├─ general_settings_inspector->update_category_list()
    │      ├─ localization_editor->update_translations()
    │      ├─ autoload_settings->update_autoload()
    │      ├─ group_settings->update_groups()
    │      └─ plugin_settings->update_plugins()
    │
    └─ 設定変更イベント
           ├─ _setting_edited()
           │      └─ queue_save() → Timer → _save()
           │                              └─ ProjectSettings::save()
           └─ _action_added() / _action_edited() / _action_removed()
                  └─ EditorUndoRedoManager::commit_action()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー設定変更 ───▶ ProjectSettingsEditor      ───▶ project.godot
                          │
                          ├─ SectionedInspector
                          │     └─ PropertyEditor
                          │
                          ├─ ActionMapEditor
                          │     └─ InputEventConfigurationDialog
                          │
                          └─ Timer (1.5秒遅延)
                                └─ ProjectSettings::save()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| project_settings_editor.cpp | `editor/settings/project_settings_editor.cpp` | ソース | メインダイアログ実装 |
| project_settings_editor.h | `editor/settings/project_settings_editor.h` | ヘッダー | クラス定義 |
| project_settings.cpp | `core/config/project_settings.cpp` | ソース | 設定データ管理 |
| action_map_editor.cpp | `editor/settings/action_map_editor.cpp` | ソース | Input Mapエディター |
| localization_editor.cpp | `editor/translations/localization_editor.cpp` | ソース | ローカライゼーションエディター |
| editor_autoload_settings.cpp | `editor/settings/editor_autoload_settings.cpp` | ソース | Autoloadエディター |
| editor_sectioned_inspector.cpp | `editor/inspector/editor_sectioned_inspector.cpp` | ソース | セクション分けされたインスペクター |
| input_event_configuration_dialog.cpp | `editor/settings/input_event_configuration_dialog.cpp` | ソース | 入力イベント設定ダイアログ |
