# 画面設計書 22-エディター設定

## 概要

本ドキュメントは、Godot Engineエディターのエディター設定ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

エディター設定ダイアログは、Godotエディター自体の動作・外観・キーボードショートカットを設定する画面である。設定はユーザーごとに保存され、すべてのプロジェクトで共有される。

**業務上の目的・背景**：開発者個人の作業環境をカスタマイズするために、エディターの動作設定やショートカットキーを調整する必要がある。この設定はプロジェクト間で共通であり、開発者が快適に作業できる環境を構築するための重要な機能である。

**画面へのアクセス方法**：メインメニューの「Editor > Editor Settings」から起動する。

**主要な操作・処理内容**：
1. 一般（General）タブでエディター全般の設定を編集
2. ショートカット（Shortcuts）タブでキーボードショートカットを設定
3. 設定の検索・フィルタリング
4. Advanced Settingsの表示切り替え
5. ショートカットの追加・編集・削除・リセット
6. ドラッグ&ドロップによるショートカットの並び替え

**画面遷移**：エディターメイン画面から「Editor > Editor Settings」メニューで開く。ショートカット編集時にはInputEventConfigurationDialogに遷移する。

**権限による表示制御**：エディター機能であり、エディターが起動している状態で常にアクセス可能。Project Managerからも限定的にアクセス可能（is_in_project_managerフラグ）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | エディター設定 | 主機能 | エディター設定の編集・保存 |
| 27 | ショートカット設定 | 主機能 | キーボードショートカットのカスタマイズ |

## 画面種別

設定編集ダイアログ（タブ型2セクション）

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `EditorSettingsDialog` が画面を管理する。

## 入出力項目

### 一般タブ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 検索フィルター | 文字列 | - | 設定項目をフィルタリング |
| Advanced Settings | ブール値 | - | 詳細設定の表示/非表示 |
| 各設定プロパティ | 可変 | - | エディター設定値 |

### ショートカットタブ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 検索フィルター | 文字列 | - | ショートカット項目をフィルタリング |
| 入力イベント | InputEvent | ショートカット編集時 | キー/ボタンの入力イベント |

## 表示項目

### タブ構成

| タブ名 | 説明 |
|--------|------|
| General | エディター設定のセクション化されたインスペクター |
| Shortcuts | ショートカット設定のツリー表示 |

### ショートカットツリー構造

| 項目 | 説明 |
|------|------|
| カテゴリ | 機能領域（3D Editor、Script Editorなど） |
| アクション名 | ショートカットのラベル |
| 入力イベント | バインドされたキー/ボタン |
| ボタン | 追加/編集/削除/リセット |

## イベント仕様

### 1-設定値変更

設定値が変更されると即座にEditorSettings::save()が呼び出され保存される。

### 2-ショートカット追加

選択されたアクションに新しい入力イベントを追加する。InputEventConfigurationDialogで入力イベントを設定。

### 3-ショートカット編集

既存のショートカットを編集する。InputEventConfigurationDialogで新しい入力イベントを設定。

### 4-ショートカット削除

選択されたショートカットを削除する。

### 5-ショートカットリセット

変更されたショートカットをデフォルト値にリセットする。

### 6-エディター再起動

一部の設定変更は再起動が必要。バナー表示後「Save & Restart」ボタンで再起動。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はファイルベースの設定管理であり、データベースは使用しない。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | editor_settings-4.cfg | UPDATE | EditorSettings::save() |
| ショートカット変更 | editor_settings-4.cfg | UPDATE | shortcuts セクション |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | The editor must be restarted... | 再起動必要な設定変更時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 重複ショートカット | 競合するショートカットがある場合、警告を表示しつつ設定可能 |

## 備考

- プロジェクト固有のオーバーライドはProjectSettingsで管理
- ショートカットはドラッグ&ドロップで優先順位を変更可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エディター設定はEditorSettingsシングルトンで管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_settings.h | `editor/settings/editor_settings.h` | EditorSettingsクラス定義 |
| 1-2 | editor_settings.cpp | `editor/settings/editor_settings.cpp` | 設定の保存・読み込み処理 |

**読解のコツ**: EditorSettingsはProjectSettingsと同様にDictionaryベースだが、ユーザーディレクトリに保存される点が異なる。

#### Step 2: エントリーポイントを理解する

EditorSettingsDialogクラスがダイアログの主要実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_settings_dialog.h | `editor/settings/editor_settings_dialog.h` | クラス構造、メンバー変数 |
| 2-2 | editor_settings_dialog.cpp | `editor/settings/editor_settings_dialog.cpp` | UI構築、イベントハンドラ |

**主要処理フロー**:
1. **行74-89**: `popup_edit_settings()` - ダイアログ表示
2. **行156-189**: `_update_shortcuts()` - ショートカットツリー構築
3. **行246-300**: `_shortcut_button_pressed()` - ショートカットボタン操作
4. **行302-350**: `_event_config_confirmed()` - 入力イベント確定処理

#### Step 3: ショートカット編集機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | input_event_configuration_dialog.h | `editor/settings/input_event_configuration_dialog.h` | 入力イベント設定ダイアログ |
| 3-2 | editor_event_search_bar.h | `editor/settings/editor_event_search_bar.h` | イベント検索バー |

### プログラム呼び出し階層図

```
EditorNode (メニュー操作)
    │
    ├─ EditorSettingsDialog::popup_edit_settings()
    │      ├─ _update_shortcuts()
    │      │      └─ _create_shortcut_treeitem()
    │      └─ inspector->update_category_list()
    │
    └─ 設定変更イベント
           ├─ _settings_changed()
           │      └─ _settings_save()
           │             └─ EditorSettings::save()
           │
           └─ _shortcut_button_pressed()
                  ├─ SHORTCUT_ADD → shortcut_editor->popup()
                  ├─ SHORTCUT_EDIT → shortcut_editor->popup()
                  ├─ SHORTCUT_ERASE → _update_shortcut_events()
                  └─ SHORTCUT_REVERT → _update_shortcut_events()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー設定変更 ───▶ EditorSettingsDialog       ───▶ editor_settings-4.cfg
                          │
                          ├─ SectionedInspector (General)
                          │     └─ EditorSettingsPropertyWrapper
                          │
                          └─ Tree (Shortcuts)
                                └─ InputEventConfigurationDialog
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_settings_dialog.cpp | `editor/settings/editor_settings_dialog.cpp` | ソース | メインダイアログ実装 |
| editor_settings_dialog.h | `editor/settings/editor_settings_dialog.h` | ヘッダー | クラス定義 |
| editor_settings.cpp | `editor/settings/editor_settings.cpp` | ソース | 設定データ管理 |
| input_event_configuration_dialog.cpp | `editor/settings/input_event_configuration_dialog.cpp` | ソース | 入力イベント設定 |
| editor_sectioned_inspector.cpp | `editor/inspector/editor_sectioned_inspector.cpp` | ソース | セクション化インスペクター |
