# 画面設計書 23-エクスポートダイアログ

## 概要

本ドキュメントは、Godot Engineエディターのエクスポートダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

エクスポートダイアログは、プロジェクトを各種プラットフォーム（Windows、macOS、Linux、Android、iOS、Web等）向けにビルド・エクスポートするための設定と実行を行う画面である。

**業務上の目的・背景**：ゲーム開発の最終段階として、開発したプロジェクトを配布可能な形式にパッケージングする必要がある。この画面により、複数のターゲットプラットフォーム向けのビルド設定を管理し、実際のエクスポート処理を実行できる。

**画面へのアクセス方法**：メインメニューの「Project > Export」から起動する。

**主要な操作・処理内容**：
1. エクスポートプリセットの追加・編集・削除・複製
2. プラットフォーム固有の設定（アイコン、パーミッション、署名等）
3. リソースフィルタリング設定（エクスポート対象ファイルの指定）
4. 機能タグによるエクスポート内容の制御
5. スクリプトの暗号化設定
6. プロジェクトのエクスポート実行
7. PCKファイルのみのエクスポート
8. ZIPアーカイブとしてのエクスポート

**画面遷移**：エディターメイン画面から「Project > Export」メニューで開く。エクスポート実行時にファイル保存ダイアログに遷移する。

**権限による表示制御**：エディター機能であり、プロジェクトを開いている状態でのみアクセス可能。対応するエクスポートテンプレートがインストールされていないプラットフォームは警告表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | プロジェクトエクスポート | 主機能 | エクスポートプリセット管理・エクスポート実行 |
| 61 | エクスポートテンプレート管理 | 補助機能 | テンプレートのダウンロード・インストール |

## 画面種別

エクスポート設定・実行ダイアログ

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `ProjectExportDialog` が画面を管理する。

## 入出力項目

### エクスポートプリセット設定

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| プリセット名 | 文字列 | Y | エクスポート設定の識別名 |
| プラットフォーム | 列挙 | Y | ターゲットプラットフォーム |
| Runnable | ブール値 | - | ワンクリック実行の対象にするか |
| Export Mode | 列挙 | - | すべてのリソース/カスタム/カスタム除外 |
| Dedicate Server | ブール値 | - | 専用サーバービルドか |

### リソースフィルタリング

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| Export Filter | 文字列 | - | エクスポート対象ファイルパターン |
| Exclude Filter | 文字列 | - | エクスポート除外ファイルパターン |
| Feature Tags | 文字列配列 | - | 有効にする機能タグ |

### 暗号化設定

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| Encrypt PCK | ブール値 | - | PCKファイルを暗号化するか |
| Encryption Key | 文字列 | 暗号化時Y | 256ビットAES暗号化キー |
| Encrypt Scripts | ブール値 | - | スクリプトのみ暗号化するか |

## 表示項目

### 画面レイアウト

| 領域 | 説明 |
|------|------|
| プリセット一覧 | 左側パネル、エクスポートプリセットのリスト |
| プリセット設定 | 右側パネル、選択プリセットの詳細設定 |
| リソースタブ | エクスポート対象リソースの設定 |
| オプションタブ | プラットフォーム固有オプション |
| ボタン領域 | エクスポート/PCKエクスポート/ZIPエクスポートボタン |

## イベント仕様

### 1-プリセット追加

「Add...」ボタンでプラットフォーム選択ダイアログを表示し、新しいエクスポートプリセットを作成する。

### 2-プリセット削除

選択されたプリセットを削除する。確認ダイアログ表示後に削除実行。

### 3-プリセット複製

選択されたプリセットをコピーして新しいプリセットを作成する。

### 4-エクスポート実行

「Export Project...」ボタンでファイル保存ダイアログを表示し、選択されたパスにプロジェクトをエクスポートする。

### 5-PCKエクスポート

「Export PCK/ZIP...」ボタンでPCKファイルまたはZIPアーカイブとしてエクスポートする。

### 6-エクスポートテンプレート管理

テンプレートがない場合に「Manage Export Templates」リンクでテンプレート管理画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はファイルベースの設定管理であり、データベースは使用しない。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プリセット変更 | export_presets.cfg | UPDATE | EditorExport::save_presets() |
| エクスポート実行 | 指定パス | CREATE | ビルド成果物出力 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 警告 | No export template found... | テンプレート未インストール時 |
| エラー | Invalid export path... | 無効なエクスポートパス指定時 |
| 情報 | Export successful. | エクスポート成功時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| テンプレート未インストール | 警告表示、エクスポート不可 |
| 書き込み権限なし | エラーダイアログ表示 |
| ディスク容量不足 | エラーダイアログ表示 |

## 備考

- エクスポートプリセットは export_presets.cfg に保存される
- ワンクリック実行（F5相当）の対象プリセットは Runnable フラグで設定
- デバッグエクスポートとリリースエクスポートで異なる設定が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_export.h | `editor/export/editor_export.h` | EditorExportクラス、EditorExportPreset |
| 1-2 | editor_export_platform.h | `editor/export/editor_export_platform.h` | プラットフォーム抽象基底クラス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | project_export.cpp | `editor/export/project_export.cpp` | UI構築、イベントハンドラ |

### プログラム呼び出し階層図

```
EditorNode (メニュー操作)
    │
    ├─ ProjectExportDialog::popup_export()
    │      ├─ _update_presets()
    │      └─ _update_export_all()
    │
    └─ エクスポート操作
           ├─ _export_project() / _export_project_to_path()
           │      └─ EditorExportPlatform::export_project()
           │
           └─ _export_pck_zip()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| project_export.cpp | `editor/export/project_export.cpp` | ソース | メインダイアログ実装 |
| editor_export.cpp | `editor/export/editor_export.cpp` | ソース | エクスポート管理 |
| editor_export_platform.cpp | `editor/export/editor_export_platform.cpp` | ソース | プラットフォーム基底 |
