# 画面設計書 24-Aboutダイアログ

## 概要

本ドキュメントは、Godot Engineエディターの「About」ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

Aboutダイアログは、Godot Engineのバージョン情報、開発者クレジット、ライセンス情報、サードパーティライセンスを表示する情報表示画面である。

**業務上の目的・背景**：オープンソースソフトウェアとして、エンジンの開発者、貢献者、寄付者への謝辞を表示し、使用しているライセンス情報を明示する必要がある。この画面はユーザーがエンジンの詳細情報を確認するための窓口となる。

**画面へのアクセス方法**：メインメニューの「Help > About Godot」から起動する。

**主要な操作・処理内容**：
1. Godotエンジンのバージョン情報表示
2. 著者（Authors）タブで開発者・貢献者の一覧表示
3. 寄付者（Donors）タブでスポンサー・メンバーの一覧表示
4. ライセンス（License）タブでMITライセンス本文表示
5. サードパーティライセンス（Third-party Licenses）タブで依存ライブラリのライセンス表示
6. 開発者名をダブルクリックしてウェブサイトを開く
7. 隠しイースターエッグ（クレジットロール）

**画面遷移**：エディターメイン画面から「Help > About Godot」メニューで開く。OKボタンまたは画面外クリックで閉じる。

**権限による表示制御**：常にアクセス可能。Project Managerからもアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 情報表示 | 主機能 | バージョン・クレジット・ライセンス情報表示 |

## 画面種別

情報表示ダイアログ（タブ型4セクション）

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `EditorAbout` が画面を管理する。

## 入出力項目

本画面は情報表示専用であり、ユーザー入力項目はない。

## 表示項目

### ヘッダー領域

| 項目 | 説明 |
|------|------|
| ロゴ | Godotエンジンロゴ画像 |
| バージョン情報 | バージョン番号、ビルド情報 |
| 著作権表示 | Godot Engine contributors / Juan Linietsky, Ariel Manzur |

### タブ構成

| タブ名 | 説明 |
|--------|------|
| Authors | プロジェクト創設者、リード開発者、プロジェクトマネージャー、開発者の一覧 |
| Donors | パトロン、スポンサー（プラチナ/ゴールド/シルバー）、メンバーの一覧 |
| License | Godot Engine MITライセンス本文 |
| Third-party Licenses | 使用しているサードパーティライブラリとそのライセンス |

### Authorsタブの構成

| セクション | 説明 |
|-----------|------|
| Project Founders | Juan Linietsky, Ariel Manzur |
| Lead Developer | 現在のリード開発者 |
| Project Manager | プロジェクトマネージャー |
| Developers | 主要開発者一覧 |

### Donorsタブの構成

| セクション | 説明 |
|-----------|------|
| Patrons | パトロン支援者 |
| Platinum Sponsors | プラチナスポンサー |
| Gold Sponsors | ゴールドスポンサー |
| Silver Sponsors | シルバースポンサー |
| Diamond Members | ダイアモンドメンバー |
| Titanium Members | チタニウムメンバー |
| Platinum Members | プラチナメンバー |
| Gold Members | ゴールドメンバー |

## イベント仕様

### 1-ライセンスツリー選択

Third-party Licensesタブでコンポーネントを選択すると、対応するライセンス本文が右側に表示される。

### 2-名前ダブルクリック

DonorsタブでURLが関連付けられた名前をダブルクリックすると、ブラウザでそのウェブサイトを開く。

### 3-イースターエッグ起動

特定の条件でProject Managerの名前をクリックすると、クレジットロールアニメーション（CreditsRoll）が再生される。ゲームが実行中の場合は起動しない。

## データベース更新仕様

本画面は情報表示専用であり、データの更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | No distractions for this, close that game first. | ゲーム実行中にイースターエッグを起動しようとした場合 |

## 例外処理

本画面では特別な例外処理は行わない。

## 備考

- 著者・寄付者データは authors.gen.h / donors.gen.h から自動生成される
- ライセンステキストは license.gen.h から読み込まれる
- ダイアログタイトルは「Thanks from the Godot community!」

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

著者・寄付者・ライセンスデータは自動生成ヘッダーファイルから取得される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | authors.gen.h | `core/authors.gen.h` | 著者データ配列 |
| 1-2 | donors.gen.h | `core/donors.gen.h` | 寄付者データ配列 |
| 1-3 | license.gen.h | `core/license.gen.h` | ライセンステキスト、サードパーティ情報 |

#### Step 2: エントリーポイントを理解する

EditorAboutクラスがダイアログの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_about.h | `editor/gui/editor_about.h` | クラス定義 |
| 2-2 | editor_about.cpp | `editor/gui/editor_about.cpp` | コンストラクタでのUI構築 |

**主要処理フロー**:
1. **行209-380**: コンストラクタ - UI構築、タブ作成
2. **行53-99**: `_notification()` - テーマ変更時のアイコン更新
3. **行102-106**: `_license_tree_selected()` - ライセンスツリー選択時のテキスト表示
4. **行117-137**: `_item_activated()` - 名前ダブルクリック時のURL開くまたはイースターエッグ
5. **行143-207**: `_create_section()` - セクション（著者/寄付者リスト）の作成

#### Step 3: イースターエッグを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | credits_roll.h | `editor/gui/credits_roll.h` | クレジットロールクラス |
| 3-2 | credits_roll.cpp | `editor/gui/credits_roll.cpp` | アニメーション実装 |

### プログラム呼び出し階層図

```
EditorNode / ProjectManager (メニュー操作)
    │
    └─ EditorAbout::popup()
           │
           ├─ コンストラクタで構築済みUI表示
           │
           ├─ _license_tree_selected()
           │      └─ _tpl_text->set_text(metadata)
           │
           └─ _item_activated()
                  ├─ OS::shell_open(website_url)
                  └─ CreditsRoll::roll_credits() [イースターエッグ]
```

### データフロー図

```
[データソース]               [処理]                    [出力]

authors.gen.h ───▶ EditorAbout コンストラクタ ───▶ Authors タブ ItemList
donors.gen.h  ───▶ _create_section()          ───▶ Donors タブ ItemList
license.gen.h ───▶ RichTextLabel              ───▶ License タブ
COPYRIGHT_INFO ──▶ Tree + RichTextLabel       ───▶ Third-party Licenses タブ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_about.cpp | `editor/gui/editor_about.cpp` | ソース | メインダイアログ実装 |
| editor_about.h | `editor/gui/editor_about.h` | ヘッダー | クラス定義 |
| credits_roll.cpp | `editor/gui/credits_roll.cpp` | ソース | イースターエッグ |
| editor_version_button.cpp | `editor/gui/editor_version_button.cpp` | ソース | バージョン表示ボタン |
| authors.gen.h | `core/authors.gen.h` | 生成ヘッダー | 著者データ |
| donors.gen.h | `core/donors.gen.h` | 生成ヘッダー | 寄付者データ |
| license.gen.h | `core/license.gen.h` | 生成ヘッダー | ライセンステキスト |
