# 画面設計書 25-ファイルダイアログ

## 概要

本ドキュメントは、Godot Engineエディターのファイルダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

ファイルダイアログは、プロジェクト内またはファイルシステム内のファイル・フォルダを選択・保存するための汎用ダイアログである。エディター内の様々な操作でファイルやフォルダの選択が必要な場合に使用される。

**業務上の目的・背景**：ゲーム開発において、リソースファイル（画像、音声、スクリプト等）の選択、シーンの保存、スクリプトの読み込みなど、ファイル操作が頻繁に発生する。この画面により、プロジェクトリソースへの統一されたアクセス方法を提供する。

**画面へのアクセス方法**：エディター内の様々な操作（ファイルを開く、名前を付けて保存、リソース選択など）から起動される。

**主要な操作・処理内容**：
1. ファイル・フォルダの一覧表示（リスト表示/サムネイル表示）
2. ファイル・フォルダの選択（単一選択/複数選択）
3. ファイル名の入力（保存モード時）
4. ディレクトリのナビゲーション（パンくずリスト、上へ移動）
5. お気に入りフォルダの管理
6. 最近使用したフォルダへのアクセス
7. 隠しファイルの表示切り替え
8. 新規フォルダの作成
9. ファイルタイプによるフィルタリング

**画面遷移**：呼び出し元の画面から開き、ファイル選択またはキャンセルで呼び出し元に戻る。

**権限による表示制御**：アクセスモード（リソース/ユーザーデータ/ファイルシステム）によって表示されるディレクトリ範囲が制限される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 64 | ファイル選択 | 主機能 | ファイル/フォルダの選択・ナビゲーション |

## 画面種別

ファイル選択ダイアログ

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `EditorFileDialog`（`FileDialog` 継承）が画面を管理する。

## 入出力項目

### ナビゲーション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| パスエディット | 文字列 | - | 現在のパスを直接入力 |
| ファイル名 | 文字列 | 保存モード時Y | 保存するファイル名 |

### フィルタリング

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| フィルターパターン | 文字列 | - | ファイルタイプフィルター（例：*.tscn, *.gd） |
| 表示モード | 列挙 | - | リスト/サムネイル |
| 隠しファイル表示 | ブール値 | - | 隠しファイルの表示有無 |

## 表示項目

### 画面レイアウト

| 領域 | 説明 |
|------|------|
| ツールバー | 前へ/次へ/上へボタン、パス入力、表示切替、新規フォルダ |
| サイドパネル | お気に入り、最近使用したフォルダ |
| メインパネル | ファイル・フォルダ一覧（ItemList） |
| 下部 | ファイル名入力、フィルター選択、OK/キャンセルボタン |

### ファイルモード

| モード | 説明 |
|--------|------|
| FILE_MODE_OPEN_FILE | 単一ファイル選択 |
| FILE_MODE_OPEN_FILES | 複数ファイル選択 |
| FILE_MODE_OPEN_DIR | フォルダ選択 |
| FILE_MODE_OPEN_ANY | ファイルまたはフォルダ選択 |
| FILE_MODE_SAVE_FILE | ファイル保存 |

### アクセスモード

| モード | 説明 |
|--------|------|
| ACCESS_RESOURCES | res:// プロジェクトリソースのみ |
| ACCESS_USERDATA | user:// ユーザーデータのみ |
| ACCESS_FILESYSTEM | ファイルシステム全体 |

## イベント仕様

### 1-ファイル選択

ファイルをダブルクリックまたは選択後OKボタンで `file_selected` シグナル発行。

### 2-複数ファイル選択

複数ファイル選択モードで選択確定時に `files_selected` シグナル発行。

### 3-フォルダ選択

フォルダ選択モードで選択確定時に `dir_selected` シグナル発行。

### 4-フォルダ移動

フォルダをダブルクリックでそのフォルダに移動。`dir_access->change_dir()` 呼び出し。

### 5-新規フォルダ作成

ツールバーの新規フォルダボタンで DirectoryCreateDialog を表示。作成後にリストを更新。

### 6-お気に入り追加/削除

現在のフォルダをお気に入りに追加または削除。EditorSettingsの favorites に保存。

### 7-ファイル削除

コンテキストメニューからファイル/フォルダを削除。DependencyRemoveDialog で依存関係チェック後に削除。

## データベース更新仕様

本画面自体はデータ永続化を行わない。選択結果はシグナル経由で呼び出し元に返される。

### 設定保存

| 操作 | 対象 | 概要 |
|------|------|------|
| お気に入り変更 | EditorSettings | favorites配列を更新 |
| 最近使用フォルダ変更 | EditorSettings | recent_dirs配列を更新 |
| 表示モード変更 | EditorSettings | filesystem/file_dialog/display_mode |
| 隠しファイル表示変更 | EditorSettings | filesystem/file_dialog/show_hidden_files |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 警告 | File exists, overwrite? | 上書き保存時（overwrite_warning_enabled時） |
| エラー | Invalid path. | 無効なパス入力時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 無効なパス | エラー表示、操作キャンセル |
| 権限エラー | エラー表示 |
| ディレクトリ存在しない | 上位ディレクトリにフォールバック |

## 備考

- ネイティブファイルダイアログ使用オプションあり（OS統合）
- サンドボックス環境ではネイティブダイアログが強制される場合あり
- Android環境ではURIを返すため制限あり
- フォルダの色はFileSystemDockと同期

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基底クラスを理解する

EditorFileDialogは FileDialog を継承している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | file_dialog.h | `scene/gui/dialogs/file_dialog.h` | FileDialogクラス定義、FileMode/Access列挙 |
| 1-2 | file_dialog.cpp | `scene/gui/dialogs/file_dialog.cpp` | 基本的なファイルダイアログ実装 |

#### Step 2: エディター拡張を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_file_dialog.h | `editor/gui/editor_file_dialog.h` | EditorFileDialogクラス定義 |
| 2-2 | editor_file_dialog.cpp | `editor/gui/editor_file_dialog.cpp` | エディター固有の拡張実装 |

**主要処理フロー**:
1. **行40-64**: `_item_menu_id_pressed()` - コンテキストメニュー処理、依存関係削除対応
2. **行66-73**: `_should_use_native_popup()` - ネイティブダイアログ使用判定
3. **行75-81**: `_should_hide_file()` - ファイル非表示判定
4. **行83-85**: `_get_folder_color()` - フォルダ色取得（FileSystemDock連携）
5. **行131-173**: `_notification()` - 設定変更時の処理

### プログラム呼び出し階層図

```
呼び出し元（EditorNode, ScriptCreateDialog等）
    │
    └─ EditorFileDialog::popup_file_dialog()
           │
           ├─ FileDialog::popup_file_dialog() [基底クラス]
           │      ├─ _update_file_list()
           │      └─ _update_dir()
           │
           └─ ユーザー操作
                  ├─ _item_selected() / _item_activated()
                  │      └─ file_selected / files_selected / dir_selected シグナル
                  │
                  ├─ _make_dir()
                  │      └─ DirectoryCreateDialog
                  │
                  └─ _item_menu_id_pressed()
                         └─ DependencyRemoveDialog（削除時）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイルシステム ───▶ DirAccess              ───▶ ItemList 表示
                           │
                           ├─ _update_file_list()
                           ├─ _update_dir()
                           └─ EditorFileSystem::_should_skip_directory()

EditorSettings ─────▶ お気に入り/最近使用 ───▶ サイドパネル表示

ユーザー選択 ───────▶ シグナル発行        ───▶ 呼び出し元への結果返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_file_dialog.cpp | `editor/gui/editor_file_dialog.cpp` | ソース | エディターファイルダイアログ |
| editor_file_dialog.h | `editor/gui/editor_file_dialog.h` | ヘッダー | クラス定義 |
| file_dialog.cpp | `scene/gui/dialogs/file_dialog.cpp` | ソース | 基底ファイルダイアログ |
| file_dialog.h | `scene/gui/dialogs/file_dialog.h` | ヘッダー | 基底クラス定義 |
| dependency_editor.cpp | `editor/file_system/dependency_editor.cpp` | ソース | 依存関係削除ダイアログ |
| directory_create_dialog.cpp | `editor/gui/directory_create_dialog.cpp` | ソース | フォルダ作成ダイアログ |
| filesystem_dock.cpp | `editor/docks/filesystem_dock.cpp` | ソース | フォルダ色取得 |
