# 画面設計書 26-ディレクトリ作成ダイアログ

## 概要

本ドキュメントは、Godot Engineエディターのディレクトリ作成ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

ディレクトリ作成ダイアログは、プロジェクト内に新しいフォルダまたはファイルを作成するためのシンプルな入力ダイアログである。フォルダ作成モードとファイル作成モードの2つのモードを持つ。

**業務上の目的・背景**：ゲーム開発において、リソースを整理するためにフォルダを作成したり、新しいファイルを特定の場所に作成したりする必要がある。この画面により、ユーザーは名前を入力するだけで適切なバリデーション付きでフォルダ/ファイルを作成できる。

**画面へのアクセス方法**：
- FileSystemドックの右クリックメニュー「New Folder...」
- EditorFileDialogの新規フォルダボタン
- その他のファイル作成が必要な場面

**主要な操作・処理内容**：
1. 新規フォルダ/ファイル名の入力
2. 名前のバリデーション（無効文字、既存名チェック）
3. サブフォルダのサポート（スラッシュで階層作成）
4. フォルダ/ファイルの作成実行

**画面遷移**：呼び出し元（FileSystemドック、EditorFileDialogなど）から開き、作成またはキャンセルで呼び出し元に戻る。

**権限による表示制御**：なし。呼び出し元が適切なアクセス権を持っている前提。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | フォルダ作成 | 主機能 | 新規フォルダの作成 |

## 画面種別

入力確認ダイアログ

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `DirectoryCreateDialog` が画面を管理する。

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 名前 | 文字列 | Y | 作成するフォルダ/ファイルの名前 |

## 表示項目

| 項目 | 説明 |
|------|------|
| ベースパスラベル | 作成先の親ディレクトリパス |
| 名前入力欄 | フォルダ/ファイル名の入力フィールド |
| バリデーションメッセージ | 入力値の検証結果 |
| OKボタン | 作成実行（有効な入力時のみ有効） |
| キャンセルボタン | ダイアログを閉じる |

## イベント仕様

### 1-名前入力変更

入力値が変更されるたびにバリデーションが実行される。

バリデーション内容：
- 空文字チェック
- 無効文字チェック（`\ : * | > .`で終わる、空白で終わる）
- ドットで始まるチェック
- 既存ファイル/フォルダの存在チェック

### 2-OK押下

バリデーション成功時に `accept_callback` が呼び出され、作成先パス（base_dir + 入力名）が返される。

### 3-スラッシュ入力

名前にスラッシュが含まれる場合、サブフォルダが再帰的に作成されることを通知メッセージで表示。

## データベース更新仕様

本画面自体はフォルダ/ファイルを直接作成せず、コールバック経由で呼び出し元に処理を委譲する。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | Name cannot be empty. | 名前が空の場合 |
| エラー | File name can't end with /. | ファイルモードでスラッシュ終端 |
| エラー | Folder name cannot be empty. | フォルダモードでパート空 |
| エラー | File name cannot be empty. | ファイルモードでパート空 |
| エラー | Folder name contains invalid characters. | 無効文字を含む |
| エラー | File name contains invalid characters. | 無効文字を含む |
| エラー | Folder name begins with a dot. | ドットで始まる |
| エラー | File name begins with a dot. | ドットで始まる |
| エラー | File with that name already exists. | 同名ファイル存在 |
| エラー | Folder with that name already exists. | 同名フォルダ存在 |
| 情報 | Folder name is valid. | フォルダ名有効（デフォルト） |
| 情報 | File name is valid. | ファイル名有効 |
| 情報 | Using slashes in folder names will create subfolders recursively. | スラッシュ含むフォルダ名 |
| 情報 | Using slashes in path will create the file in subfolder... | スラッシュ含むファイルパス |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 無効な入力 | OKボタンが無効化され、エラーメッセージ表示 |

## 備考

- MODE_DIRECTORY と MODE_FILE の2つのモードがある
- バリデーションはEditorValidationPanelを使用
- ダイアログ最小幅は480px

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

DirectoryCreateDialogは ConfirmationDialog を継承したシンプルなダイアログ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | directory_create_dialog.h | `editor/gui/directory_create_dialog.h` | クラス定義、MODE_DIRECTORY/MODE_FILE |
| 1-2 | directory_create_dialog.cpp | `editor/gui/directory_create_dialog.cpp` | 全実装（186行） |

**主要処理フロー**:
1. **行41-47**: `_sanitize_input()` - 入力値のサニタイズ
2. **行49-96**: `_validate_path()` - パスバリデーション
3. **行98-115**: `_on_dir_path_changed()` - 入力変更時の処理
4. **行117-126**: `ok_pressed()` - OK押下時の処理
5. **行133-151**: `config()` - ダイアログの設定
6. **行153-185**: コンストラクタ - UI構築

### プログラム呼び出し階層図

```
呼び出し元（FileSystemDock, EditorFileDialog等）
    │
    └─ DirectoryCreateDialog::config()
           │
           ├─ set_title()
           ├─ base_dir設定
           ├─ accept_callback設定
           └─ validation_panel->update()
                  │
                  └─ _on_dir_path_changed()
                         └─ _validate_path()

ユーザー入力
    │
    └─ text_changed シグナル
           └─ validation_panel->update()
                  └─ _on_dir_path_changed()
                         └─ _validate_path()

OK押下
    │
    └─ ok_pressed()
           ├─ _validate_path() [最終確認]
           ├─ accept_callback.call(full_path)
           └─ hide()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー入力 ──────▶ _sanitize_input()        ───▶ サニタイズ済み名前
                         │
                         └─▶ _validate_path()
                                │
                                ├─ 空チェック
                                ├─ 無効文字チェック
                                ├─ ドット開始チェック
                                └─ 既存チェック (DirAccess)

バリデーション結果 ──▶ EditorValidationPanel   ───▶ メッセージ表示
                                               ───▶ OKボタン有効/無効

OK押下 ──────────────▶ accept_callback.call() ───▶ 呼び出し元へパス返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| directory_create_dialog.cpp | `editor/gui/directory_create_dialog.cpp` | ソース | メイン実装 |
| directory_create_dialog.h | `editor/gui/directory_create_dialog.h` | ヘッダー | クラス定義 |
| editor_validation_panel.cpp | `editor/gui/editor_validation_panel.cpp` | ソース | バリデーションUI |
| filesystem_dock.cpp | `editor/docks/filesystem_dock.cpp` | ソース | 呼び出し元 |
| editor_file_dialog.cpp | `editor/gui/editor_file_dialog.cpp` | ソース | 呼び出し元 |
