# 画面設計書 27-クイックオープンダイアログ

## 概要

本ドキュメントは、Godot Engineエディターのクイックオープンダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

クイックオープンダイアログは、プロジェクト内のリソース（シーン、スクリプト、テクスチャなど）をファジー検索で素早く選択するための高速ナビゲーションダイアログである。

**業務上の目的・背景**：大規模なプロジェクトでは数百〜数千のファイルが存在し、ファイルダイアログでの手動ナビゲーションは時間がかかる。この画面により、キーボード入力だけでプロジェクト内のリソースを素早く検索・選択できる。

**画面へのアクセス方法**：
- Ctrl+P（macOSではCmd+P）ショートカット
- インスペクターのリソースプロパティからクイックオープン

**主要な操作・処理内容**：
1. ファジー検索によるファイル名検索
2. 検索結果のリスト/グリッド表示
3. 検索結果からのファイル選択
4. 最近使用したファイルの履歴表示
5. インスタントプレビュー機能（プロパティ編集時）
6. ファイルのFileSystemDock/ファイルマネージャーでの表示

**画面遷移**：呼び出し元から開き、ファイル選択またはキャンセルで呼び出し元に戻る。

**権限による表示制御**：addonsフォルダ内のファイルは「Addons」トグルで表示/非表示を切り替え可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | クイックオープン | 主機能 | ファジー検索によるリソース選択 |

## 画面種別

検索・選択ダイアログ

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `EditorQuickOpenDialog` が画面を管理する。

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 検索クエリ | 文字列 | - | ファジー検索キーワード |

## 表示項目

### 画面レイアウト

| 領域 | 説明 |
|------|------|
| 検索バー | 検索キーワード入力欄 |
| 結果リスト/グリッド | 検索結果の表示（サムネイル、ファイル名、パス） |
| 選択パス表示 | 選択中ファイルのフルパス |
| ボトムバー | Instant Preview/Fuzzy Search/Addons/表示モード切替 |

### 検索結果表示モード

| モード | 説明 |
|--------|------|
| リスト表示 | ファイル名とパスを縦一列で表示 |
| グリッド表示 | サムネイルを格子状に表示 |

### ボトムバーコントロール

| 項目 | 説明 |
|------|------|
| Instant Preview | 選択したリソースを即座にプレビュー |
| Fuzzy Search | あいまい検索の有効/無効 |
| Addons | addonsフォルダのファイルを含める |
| 表示モード切替 | リスト/グリッド表示の切り替え |

## イベント仕様

### 1-検索クエリ変更

入力テキストが変更されると即座にファジー検索が実行され、結果がリアルタイム更新される。

### 2-結果選択

上下キーまたはマウスで結果を選択。`selection_changed` シグナルで選択変更を通知。

### 3-ダブルクリック/Enter

選択を確定し、`item_selected_callback` を呼び出してファイルパスを返却。

### 4-コンテキストメニュー

右クリックでコンテキストメニューを表示：
- Show in FileSystem: FileSystemDockでファイルを表示
- Show in File Manager: OSのファイルマネージャーで表示

### 5-インスタントプレビュー

プロパティ編集モードで有効な場合、選択変更時にリソースを即座に読み込んでプロパティに反映。再帰参照はエラー表示。

## データベース更新仕様

### 履歴保存

| 操作 | 対象ファイル | 概要 |
|------|-------------|------|
| ファイル選択 | quick_open_dialog_cache.cfg | 選択履歴をタイプ別に保存 |

履歴は ConfigFile 形式で `selected_history` セクションに保存される。各タイプごとに最大 MAX_HISTORY_SIZE 件まで保存。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | No files found for this type | 対象タイプのファイルが存在しない |
| 情報 | No results found | 検索結果が0件 |
| 情報 | (recently opened) | 履歴からの表示時にパスに付加 |
| エラー | Recursion detected, Instant Preview failed. | リソースの再帰参照検出時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 検索結果なし | 「No results found」メッセージ表示 |
| 再帰参照検出 | エラートースト表示、プレビュー中止 |
| 無効なコールバック | エラーメッセージ、Instant Preview無効化の提案 |

## 備考

- 表示モードはリソースタイプに応じて自動選択（テクスチャ等はグリッド推奨）
- 検索ハイライト機能で一致箇所を視覚的に表示
- UIDベースでの履歴保存によりファイル移動に対応
- 最大結果数はEditorSettings `filesystem/quick_open_dialog/max_results` で設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

EditorQuickOpenDialogとそのコンテナクラスの関係を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_quick_open_dialog.h | `editor/gui/editor_quick_open_dialog.h` | クラス構造、各種設定 |
| 1-2 | editor_quick_open_dialog.cpp | `editor/gui/editor_quick_open_dialog.cpp` | 全実装（1310行） |

**クラス構成**:
- `EditorQuickOpenDialog`: メインダイアログ
- `QuickOpenResultContainer`: 結果表示コンテナ
- `QuickOpenResultItem`: 結果アイテム
- `QuickOpenResultListItem`: リスト表示用アイテム
- `QuickOpenResultGridItem`: グリッド表示用アイテム
- `HighlightedLabel`: ハイライト付きラベル

**主要処理フロー**:
1. **行105-138**: EditorQuickOpenDialogコンストラクタ - UI構築
2. **行152-163**: `popup_dialog()` - ダイアログ表示
3. **行191-198**: `ok_pressed()` - 選択確定処理
4. **行232-278**: `preview_property()` / `update_property()` - インスタントプレビュー
5. **行304-417**: QuickOpenResultContainerコンストラクタ - 結果コンテナ構築
6. **行448-536**: `init()` - 検索初期化、履歴読み込み
7. **行600-603**: `set_query_and_update()` - 検索クエリ設定
8. **行642-697**: `update_results()` / `_score_and_sort_candidates()` - 検索実行

#### Step 2: ファジー検索を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fuzzy_search.h | `core/string/fuzzy_search.h` | FuzzySearch クラス |
| 2-2 | fuzzy_search.cpp | `core/string/fuzzy_search.cpp` | ファジー検索アルゴリズム |

### プログラム呼び出し階層図

```
呼び出し元（EditorNode, EditorProperty等）
    │
    └─ EditorQuickOpenDialog::popup_dialog()
           │
           ├─ QuickOpenResultContainer::init()
           │      ├─ _ensure_result_vector_capacity()
           │      ├─ _find_filepaths_in_folder() [ファイル収集]
           │      ├─ 履歴読み込み (history_file)
           │      └─ _create_initial_results()
           │
           └─ 検索入力
                  └─ _search_box_text_changed()
                         └─ set_query_and_update()
                                ├─ _update_fuzzy_search_results() [FuzzySearch]
                                └─ _update_result_items()

選択確定
    │
    └─ ok_pressed()
           ├─ save_selected_item() [履歴保存]
           ├─ update_property() [コールバック呼び出し]
           └─ hide()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

EditorFileSystem ───▶ _find_filepaths_in_folder()  ───▶ filepaths配列
                           │
                           └─▶ FuzzySearch::search_all()
                                   │
                                   └─▶ search_results配列

検索クエリ ─────────▶ _score_and_sort_candidates() ───▶ candidates配列
                                                   ───▶ QuickOpenResultItem表示

選択結果 ──────────▶ item_selected_callback.call() ───▶ 呼び出し元へパス返却

履歴 ─────────────▶ history_file (ConfigFile)     ───▶ quick_open_dialog_cache.cfg
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_quick_open_dialog.cpp | `editor/gui/editor_quick_open_dialog.cpp` | ソース | メイン実装 |
| editor_quick_open_dialog.h | `editor/gui/editor_quick_open_dialog.h` | ヘッダー | クラス定義 |
| fuzzy_search.cpp | `core/string/fuzzy_search.cpp` | ソース | ファジー検索アルゴリズム |
| editor_file_system.cpp | `editor/file_system/editor_file_system.cpp` | ソース | ファイル情報取得 |
| editor_resource_preview.cpp | `editor/inspector/editor_resource_preview.cpp` | ソース | サムネイル取得 |
| filesystem_dock.cpp | `editor/docks/filesystem_dock.cpp` | ソース | ファイルシステム表示連携 |
