# 画面設計書 28-ノード作成ダイアログ

## 概要

本ドキュメントは、Godot Engineエディターのノード作成ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

ノード作成ダイアログは、シーンツリーに新しいノードを追加する際に使用する、ノードタイプ選択ダイアログである。すべてのビルトインノードタイプ、グローバルスクリプトクラス、カスタムタイプを検索・選択できる。

**業務上の目的・背景**：Godotでは様々なタイプのノードを組み合わせてシーンを構築する。この画面により、開発者は必要なノードタイプを素早く検索し、シーンに追加できる。

**画面へのアクセス方法**：
- シーンドックの「+」ボタン
- Ctrl+A（macOSではCmd+A）ショートカット
- シーンドックの右クリックメニュー「Add Child Node」

**主要な操作・処理内容**：
1. ノードタイプのツリー表示（継承階層に基づく）
2. 検索フィルターによるノードタイプの絞り込み
3. お気に入りノードの管理
4. 最近使用したノードの履歴表示
5. ノードタイプの選択・作成
6. タイプの置換モード（既存ノードのタイプ変更）

**画面遷移**：シーンドックなどから開き、ノード選択またはキャンセルで呼び出し元に戻る。スクリプトボタンでグローバルクラスのスクリプトを開く。

**権限による表示制御**：EditorFeatureProfileによる機能制限がある場合は一部ノードタイプが非表示になる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ノード作成 | 主機能 | ノードタイプ選択・作成 |
| 20 | ノード置換 | 補助機能 | 既存ノードのタイプ変更 |

## 画面種別

タイプ選択ダイアログ

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `CreateDialog` が画面を管理する。

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 検索キーワード | 文字列 | - | ノードタイプ検索キーワード |

## 表示項目

### 画面レイアウト

| 領域 | 説明 |
|------|------|
| 検索バー | 検索キーワード入力欄、お気に入りボタン |
| お気に入りリスト | お気に入りに登録されたノードタイプ |
| 最近使用リスト | 最近使用したノードタイプ |
| ノードツリー | 継承階層に基づくノードタイプツリー |
| ヘルプビット | 選択中ノードタイプの説明 |

### ノードタイプの表示

| 項目 | 説明 |
|------|------|
| アイコン | ノードタイプのアイコン |
| 名前 | ノードタイプ名（クラス名） |
| 非推奨バッジ | 非推奨マーク（@deprecated）がある場合 |
| 実験的バッジ | 実験的マーク（@experimental）がある場合 |
| スクリプトボタン | グローバルクラスの場合、スクリプトを開くボタン |

## イベント仕様

### 1-検索クエリ変更

検索キーワードが変更されると `_update_search()` でツリーが再構築される。サブシーケンス検索（例: "spr" → "Sprite2D"）に対応。

### 2-ノードタイプ選択

ツリーでノードタイプを選択すると、ヘルプビットに説明が表示される。ダブルクリックまたはCreateボタンで確定。

### 3-お気に入り登録/解除

選択中のノードタイプをお気に入りに追加/削除。EditorSettingsに保存される。

### 4-スクリプトボタン押下

グローバルスクリプトクラスの場合、スクリプトをエディターで開く。ダイアログは閉じる。

### 5-選択確定

`_confirmed()` が呼び出され、選択されたタイプ名を通知。抽象クラスやvirtualクラスは選択不可（グレーアウト）。

## データベース更新仕様

### 設定保存

| 操作 | 対象 | 概要 |
|------|------|------|
| お気に入り変更 | EditorSettings favorites | create_dialog/ プレフィックスで保存 |
| 最近使用変更 | EditorSettings recents | create_dialog/ プレフィックスで保存 |
| ダイアログ位置 | EditorSettings project_metadata | dialog_bounds/create_new_node |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | This class is marked as deprecated. | 非推奨クラス選択時（ツールチップ） |
| 情報 | This class is marked as experimental. | 実験的クラス選択時（ツールチップ） |
| 情報 | No results for "xxx". | 検索結果なし |
| 情報 | Matches the "xxx" keyword. | キーワード検索でマッチした場合 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| インスタンス化不可クラス | グレーアウト表示、選択不可 |
| 検索結果なし | メッセージ表示、Createボタン無効 |

## 備考

- ダイアログ位置・サイズは保存され次回起動時に復元
- base_typeによりルートノードタイプを制限可能
- preferred_search_result_type で検索結果の優先順位を設定可能
- Editor系ノードはノード追加時は非表示（通常開発では不要）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

CreateDialogは ConfirmationDialog を継承。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | create_dialog.h | `editor/gui/create_dialog.h` | クラス定義、TypeInfo構造体 |
| 1-2 | create_dialog.cpp | `editor/gui/create_dialog.cpp` | 全実装 |

**主要処理フロー**:
1. **行41-77**: `popup_create()` - ダイアログ表示、初期化
2. **行83-132**: `_fill_type_list()` - 全タイプリスト構築
3. **行160-233**: `_should_hide_type()` - タイプ非表示判定
4. **行235-293**: `_update_search()` - 検索実行・ツリー構築
5. **行295-351**: `_add_type()` - タイプをツリーに追加
6. **行353-444**: `_configure_search_option_item()` - ツリーアイテム設定
7. **行447-490**: `_score_type()` - 検索スコア計算

#### Step 2: タイプ判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | class_db.cpp | `core/object/class_db.cpp` | クラス継承判定 |
| 2-2 | script_server.cpp | `core/object/script_server.cpp` | グローバルクラス判定 |

### プログラム呼び出し階層図

```
呼び出し元（SceneTreeDock等）
    │
    └─ CreateDialog::popup_create()
           │
           ├─ _fill_type_list()
           │      ├─ ClassDB::get_class_list()
           │      ├─ ScriptServer::get_global_class_list()
           │      └─ EditorNode::get_editor_data().get_custom_types()
           │
           ├─ _load_favorites_and_history()
           ├─ _update_search()
           │      ├─ _score_type() [各タイプのスコア計算]
           │      ├─ _add_type() [継承階層でツリー構築]
           │      │      └─ _configure_search_option_item()
           │      └─ select_type() [ベストマッチ選択]
           │
           └─ popup() [表示]

選択確定
    │
    └─ _confirmed()
           ├─ _save_and_update_favorite_list()
           └─ emit_signal("selected")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ClassDB ────────────▶ _fill_type_list()          ───▶ type_info_list
ScriptServer ───────▶
EditorData::custom_types

検索クエリ ──────────▶ _update_search()           ───▶ search_options Tree
                           │
                           ├─ _score_type()
                           └─ _add_type()

選択結果 ───────────▶ emit_signal("selected")    ───▶ 呼び出し元へタイプ名

EditorSettings ─────▶ favorites/recents         ───▶ お気に入り/履歴リスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| create_dialog.cpp | `editor/gui/create_dialog.cpp` | ソース | メイン実装 |
| create_dialog.h | `editor/gui/create_dialog.h` | ヘッダー | クラス定義 |
| scene_tree_dock.cpp | `editor/scene/scene_tree_dock.cpp` | ソース | 呼び出し元 |
| class_db.cpp | `core/object/class_db.cpp` | ソース | クラス情報取得 |
| script_server.cpp | `core/object/script_server.cpp` | ソース | グローバルクラス情報 |
| editor_help.cpp | `editor/help/editor_help.cpp` | ソース | ヘルプビット表示 |
