# 画面設計書 29-進捗ダイアログ

## 概要

本ドキュメントは、Godot Engineエディターの進捗ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

進捗ダイアログは、時間のかかる処理（インポート、ビルド、スキャンなど）の進行状況を表示し、ユーザーに処理の進捗をフィードバックするモーダルダイアログである。

**業務上の目的・背景**：エディターでは、リソースのインポート、プロジェクトのスキャン、エクスポートなど、時間のかかる処理が発生する。この画面により、ユーザーは処理の進行状況を把握でき、必要に応じてキャンセルすることができる。

**画面へのアクセス方法**：
- 時間のかかる処理が開始されると自動的に表示される
- プログラムから `ProgressDialog::add_task()` を呼び出して表示

**主要な操作・処理内容**：
1. タスクの進捗表示（プログレスバー）
2. タスクのステータスメッセージ表示
3. キャンセル可能なタスクの中止

**画面遷移**：処理中に自動表示され、処理完了またはキャンセルで自動的に閉じる。

**権限による表示制御**：なし。システムダイアログとして常に最前面に表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 進捗表示 | 主機能 | 処理進捗のユーザーフィードバック |

## 画面種別

進捗表示ダイアログ（モーダル）

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `ProgressDialog` が画面を管理する。シングルトンパターンで実装。

## 入出力項目

本画面は出力専用であり、ユーザー入力は「Cancel」ボタンのみ。

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| Cancelボタン | - | - | キャンセル可能なタスクの中止（p_can_cancel=true時） |

## 表示項目

### 画面レイアウト

| 領域 | 説明 |
|------|------|
| タスクラベル | タスクの説明ラベル |
| プログレスバー | 進捗を示すバー（PopupProgressBarバリエーション） |
| ステータスラベル | 現在の処理状態メッセージ |
| Cancelボタン | キャンセルボタン（キャンセル可能時のみ表示） |

### 複数タスク対応

複数のタスクが同時に実行される場合、各タスクが VBoxContainer 内に縦に並べて表示される。

## イベント仕様

### 1-タスク追加

`add_task()` が呼び出されると、新しいタスク表示が追加され、ダイアログが表示される。
- ダイアログはZ-indexが最大値に設定され、常に最前面に表示
- 他のウィンドウは PROCESS_MODE_DISABLED に設定され操作不可に

### 2-タスク進捗更新

`task_step()` が呼び出されると、プログレスバーとステータスメッセージが更新される。
- 200ms以内の連続更新は無視される（パフォーマンス最適化）
- `p_force_redraw=true` で強制更新可能
- 戻り値でキャンセル状態を返す

### 3-タスク終了

`end_task()` が呼び出されると、タスク表示が削除される。
- すべてのタスクが終了するとダイアログが非表示になる
- 他のウィンドウの操作制限が解除される

### 4-キャンセル

「Cancel」ボタンが押されると `canceled` フラグがtrueになり、次回 `task_step()` の戻り値で通知される。

## データベース更新仕様

本画面はデータの永続化を行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | Do not use progress dialog (task) while flushing the message queue or using call_deferred()! | メッセージキューフラッシュ中に呼び出された場合 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 重複タスク追加 | ERR_FAIL_COND_MSG で警告出力 |
| 存在しないタスク更新 | ERR_FAIL_COND で警告出力 |
| メッセージキュー処理中 | 警告出力、処理中止 |

## 備考

- シングルトンパターン（`ProgressDialog::singleton`）
- Z-indexは `RS::CANVAS_ITEM_Z_MAX` で最前面保証
- `host_windows` で管理対象ウィンドウを追跡
- バックグラウンド進捗は `BackgroundProgress` クラスで別途表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

ProgressDialogと BackgroundProgress の2つのクラスが存在。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | progress_dialog.h | `editor/gui/progress_dialog.h` | クラス定義、Task構造体 |
| 1-2 | progress_dialog.cpp | `editor/gui/progress_dialog.cpp` | 全実装（315行） |

**主要処理フロー**:
1. **行42-65**: BackgroundProgress::_add_task() - バックグラウンドタスク追加
2. **行79-90**: BackgroundProgress::_task_step() - バックグラウンドタスク更新
3. **行92-100**: BackgroundProgress::_end_task() - バックグラウンドタスク終了
4. **行132-145**: ProgressDialog::_notification() - テーマ変更対応
5. **行155-178**: ProgressDialog::_popup() - ダイアログ表示
6. **行193-227**: ProgressDialog::add_task() - タスク追加
7. **行229-250**: ProgressDialog::task_step() - タスク更新
8. **行252-271**: ProgressDialog::end_task() - タスク終了
9. **行285-310**: ProgressDialog コンストラクタ - UI構築

### プログラム呼び出し階層図

```
呼び出し元（EditorNode, EditorFileSystem等）
    │
    ├─ ProgressDialog::add_task()
    │      ├─ Task構造体作成
    │      │      ├─ VBoxContainer (vb)
    │      │      ├─ ProgressBar (progress)
    │      │      └─ Label (state)
    │      ├─ _popup()
    │      │      ├─ EditorNode::set_process_input(true) [入力無効化]
    │      │      ├─ 他ウィンドウ PROCESS_MODE_DISABLED
    │      │      └─ show()
    │      └─ _update_ui()
    │
    ├─ ProgressDialog::task_step() [繰り返し呼び出し]
    │      ├─ 200ms以内はスキップ
    │      ├─ progress->set_value()
    │      ├─ state->set_text()
    │      └─ _update_ui()
    │      │
    │      └─ return canceled [キャンセル状態]
    │
    └─ ProgressDialog::end_task()
           ├─ memdelete(t.vb)
           ├─ tasks.erase()
           └─ tasks.is_empty() ? hide() : _popup()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

add_task() ─────────────▶ Task構造体作成           ───▶ ダイアログ表示
(task, label, steps)          │
                              └─▶ ProgressBar/Label追加

task_step() ────────────▶ progress->set_value()   ───▶ プログレスバー更新
(task, state, step)           │
                              └─▶ state->set_text()  ───▶ ステータス更新

end_task() ─────────────▶ Task削除                ───▶ ダイアログ非表示（全終了時）

Cancelボタン ───────────▶ canceled = true         ───▶ task_step()の戻り値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| progress_dialog.cpp | `editor/gui/progress_dialog.cpp` | ソース | メイン実装 |
| progress_dialog.h | `editor/gui/progress_dialog.h` | ヘッダー | クラス定義 |
| editor_node.cpp | `editor/editor_node.cpp` | ソース | 呼び出し元、host_windows管理 |
| editor_file_system.cpp | `editor/file_system/editor_file_system.cpp` | ソース | 呼び出し元（スキャン処理） |
| main.cpp | `main/main.cpp` | ソース | Main::iteration()呼び出し |
