# 画面設計書 3-2Dエディタ

## 概要

本ドキュメントは、Godot Engineにおける2Dシーン編集用エディタ画面の設計仕様を記載する。

### 本画面の処理概要

2Dエディタは、Canvas Item（2Dノード）を視覚的に配置・編集するためのエディタ画面である。スプライト、UI要素、2D物理オブジェクトなどをドラッグ&ドロップで配置し、変形ツールで位置・回転・スケールを調整できる。

**業務上の目的・背景**：2Dゲームやアプリケーションのビジュアルデザインを直感的に行えるようにする。プログラミング知識がなくても、UIやゲームシーンのレイアウトを視覚的に構築でき、プロトタイピングから本番開発まで幅広く活用できる。

**画面へのアクセス方法**：エディタメイン画面上部の「2D」タブをクリック、またはF1キーを押す。2Dノード（Node2D、Control派生クラス）を選択すると自動的に2Dエディタに切り替わる。

**主要な操作・処理内容**：
1. 2Dビューポートでのノード選択・移動・回転・スケール
2. グリッドスナップ・ピクセルスナップ
3. ルーラー表示とガイドライン設定
4. 複数選択とグループ操作
5. ズーム・パン（ビューポートのナビゲーション）
6. アンカー・マージン編集（Controlノード）
7. コリジョンシェイプの編集プレビュー
8. アニメーションプレビュー

**画面遷移**：エディタメイン画面内のタブとして表示。3D/Script/AssetLibタブと相互切り替え可能。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | 2Dレンダリング | 主機能 | 2Dノード・スプライトの描画プレビュー |
| 8 | カメラシステム（2D/3D） | 主機能 | 2Dビューポートのカメラ制御 |
| 14 | 2D物理シミュレーション | 補助機能 | 2D物理ノードのプレビュー・デバッグ表示 |
| 16 | 衝突検出 | 補助機能 | コリジョンシェイプの編集・プレビュー |
| 45 | シーンエディタ | 主機能 | CanvasItemの配置・変形操作 |

## 画面種別

編集 / ビューポート

## URL/ルーティング

該当なし（デスクトップアプリケーション内のタブ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 選択ノード | 入力 | CanvasItem[] | - | 編集対象の2Dノード |
| ズームレベル | 入力 | float | - | ビューポートの拡大率 |
| グリッド設定 | 入力 | Vector2 | - | グリッドステップ |
| スナップ設定 | 入力 | bool | - | スナップの有効/無効 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ビューポート | SubViewport | 2Dシーンの描画領域 |
| グリッド | Line2D | グリッド線表示 |
| ルーラー | Control | X/Y軸の目盛り |
| 選択枠 | Control | 選択ノードの境界表示 |
| ギズモ | Control | 移動・回転・スケールハンドル |
| ツールバー | HBoxContainer | 編集ツール選択 |

## イベント仕様

### 1-ノード選択

ビューポート上でノードをクリック。_get_canvas_item_at_pos()で座標からノードを特定し、EditorSelectionに追加。Shiftキーで複数選択、Ctrl+クリックでトグル選択。

### 2-ノード移動

選択ノードをドラッグ。マウス移動量にスナップ処理を適用し、CanvasItem::set_position()で位置更新。Undo用にEditorUndoRedoManagerに操作を記録。

### 3-ノード回転

回転ハンドルをドラッグ。中心点からの角度を計算し、CanvasItem::set_rotation()で更新。Shiftキーで15度単位スナップ。

### 4-ノードスケール

スケールハンドルをドラッグ。中心または角からの距離比率でスケール値を計算。Shiftキーで比率維持。

### 5-ズーム

マウスホイールまたはZoomWidgetでズーム変更。zoom変数を更新し、ビューポートのtransformを再計算。

### 6-パン（スクロール）

中クリック+ドラッグ、またはスペース+ドラッグでビューポートをスクロール。ViewPannerクラスが処理。

### 7-スナップ設定変更

ツールバーのスナップボタンまたはSnap Dialogでグリッドステップ、回転ステップ、スケールステップを設定。

## データベース更新仕様

本画面は直接ファイルを更新しない（シーン保存時に反映）。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| ノード変形 | EditorData | UPDATE | 編集中シーンのノードプロパティ更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 警告 | Children of a container get their position and size determined only by their parent. | コンテナ子ノード移動時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ロック済みノード選択 | 選択不可、移動操作を無視 |
| 非表示ノード選択 | ツールバー設定により選択可否を制御 |

## 備考

- CanvasItemEditorクラスがメインの実装
- DRAG_THRESHOLD = 8 * EDSCALEでドラッグ判定
- スケールハンドル距離は25ピクセル

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | canvas_item_editor_plugin.h | `editor/scene/canvas_item_editor_plugin.h` | CanvasItemEditorクラス構造、ツールenum |

**読解のコツ**: Tool enum（TOOL_SELECT、TOOL_MOVE等）とDragType enumが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | canvas_item_editor_plugin.cpp | `editor/scene/canvas_item_editor_plugin.cpp` | gui_input()でマウス/キー入力処理 |

**主要処理フロー**:
1. **行270-285**: _is_node_movable()でノード移動可否判定
2. **行287-298**: _snap_if_closer_float()でスナップ計算
3. **行77-268**: SnapDialogクラスでスナップ設定UI

### プログラム呼び出し階層図

```
CanvasItemEditor
    │
    ├─ ViewPanner (パン操作)
    │
    ├─ EditorZoomWidget (ズーム操作)
    │
    ├─ SnapDialog (スナップ設定)
    │
    └─ EditorSelection (選択管理)
           └─ CanvasItem選択リスト
```

### データフロー図

```
[入力]                    [処理]                           [出力]

マウス/キー入力 ─────▶ CanvasItemEditor ─────────▶ ビューポート描画
                         │
                         ├──▶ _get_canvas_item_at_pos() ▶ ノード選択
                         │
                         ├──▶ _snap_*() ─────────────────▶ 座標スナップ
                         │
                         └──▶ EditorUndoRedoManager ────▶ 操作履歴

```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| canvas_item_editor_plugin.cpp | `editor/scene/canvas_item_editor_plugin.cpp` | ソース | 2Dエディタ実装 |
| canvas_item_editor_plugin.h | `editor/scene/canvas_item_editor_plugin.h` | ヘッダ | クラス定義 |
| editor_zoom_widget.cpp | `editor/gui/editor_zoom_widget.cpp` | ソース | ズームUI |
| view_panner.cpp | `scene/gui/view_panner.cpp` | ソース | パン操作 |
