# 画面設計書 30-スクリプト作成ダイアログ

## 概要

本ドキュメントは、Godot Engineエディターのスクリプト作成ダイアログ画面の設計仕様を定義する。

### 本画面の処理概要

スクリプト作成ダイアログは、新しいスクリプトファイルを作成したり、既存のスクリプトを読み込んだりするためのダイアログである。言語選択、テンプレート選択、継承クラス設定、保存先パス設定などを行う。

**業務上の目的・背景**：Godotでは、ノードにスクリプトをアタッチして動作をプログラムする。この画面により、開発者は適切な言語とテンプレートを選択し、継承階層を設定した上でスクリプトを作成できる。

**画面へのアクセス方法**：
- インスペクターのノードに対して「Attach Script」
- シーンドックの右クリックメニュー「Attach Script」
- FileSystemドックで新規スクリプト作成
- スクリプトドックの「+」ボタン

**主要な操作・処理内容**：
1. スクリプト言語の選択（GDScript、C#など）
2. 継承クラスの指定（クラス名またはスクリプトパス）
3. テンプレートの選択（Node、Empty、カスタムテンプレート）
4. 保存パスの指定
5. ビルトインスクリプトオプション（シーン内蔵）
6. 新規スクリプトの作成
7. 既存スクリプトの読み込み

**画面遷移**：呼び出し元から開き、スクリプト作成/読み込みまたはキャンセルで呼び出し元に戻る。継承クラス参照ではCreateDialogやEditorFileDialogを使用。

**権限による表示制御**：なし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | スクリプト作成 | 主機能 | 新規スクリプトの作成 |
| 23 | スクリプト読み込み | 補助機能 | 既存スクリプトのアタッチ |

## 画面種別

入力・選択ダイアログ

## URL/ルーティング

エディター内ダイアログのため、URLルーティングは適用されない。C++クラス `ScriptCreateDialog` が画面を管理する。

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| Language | 列挙 | Y | スクリプト言語（GDScript、C#など） |
| Inherits | 文字列 | Y | 継承するクラス名またはスクリプトパス |
| Template | 列挙 | - | 使用するテンプレート |
| Built-in Script | ブール値 | - | シーンに内蔵するか |
| Name | 文字列 | Built-in時Y | ビルトインスクリプトの名前 |
| Path | 文字列 | Built-in以外Y | スクリプトファイルのパス |

## 表示項目

### 画面レイアウト

| 領域 | 説明 |
|------|------|
| 言語選択 | OptionButton - 利用可能な言語一覧 |
| 継承設定 | LineEdit + 参照ボタン（フォルダ/クラスリスト） |
| テンプレート選択 | OptionButton - テンプレート一覧 |
| テンプレートトグル | CheckButton - テンプレート使用の有無 |
| ビルトインチェック | CheckBox - シーン内蔵オプション |
| ビルトイン名 | LineEdit - ビルトイン時の名前 |
| パス入力 | LineEdit + 参照ボタン - ファイルパス |
| バリデーションパネル | 入力検証結果の表示 |

## イベント仕様

### 1-言語変更

言語が変更されると、拡張子の自動変換、テンプレート一覧の更新が行われる。一部言語はビルトインスクリプトをサポートしない。

### 2-継承クラス変更

入力または参照選択で継承クラスを設定。クラス名の有効性を検証。

### 3-テンプレート変更

テンプレートが変更されると、最後に使用したテンプレート情報が保存される（プロジェクト辞書またはエディター辞書）。

### 4-パス変更

パスが変更されると、バリデーション（存在チェック、拡張子チェック、ディレクトリチェック）が実行される。

### 5-作成/読み込み

- 新規作成モード: テンプレートからスクリプトを生成し保存
- 読み込みモード: 既存スクリプトを読み込み
- `script_created` シグナルで作成/読み込みしたスクリプトを通知

### 6-ビルトインスクリプト

「Built-in Script」チェック時は、シーンファイル内にスクリプトを埋め込む（外部ファイルを作成しない）。

## データベース更新仕様

### ファイル操作

| 操作 | 対象 | 概要 |
|------|------|------|
| スクリプト作成 | 指定パス | ResourceSaver::save() |
| テンプレート履歴 | EditorSettings / project_metadata | 最後に使用したテンプレート保存 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | Path is empty. | パスが空 |
| エラー | Filename is empty. | ファイル名が空 |
| エラー | Filename is invalid. | 無効なファイル名 |
| エラー | Name begins with a dot. | ドットで始まる |
| エラー | Path is not local. | res://で始まらない |
| エラー | Base path is invalid. | 存在しないディレクトリ |
| エラー | A directory with the same name exists. | 同名ディレクトリ存在 |
| エラー | File does not exist. | 読み込み時にファイルなし |
| エラー | Invalid extension. | 無効な拡張子 |
| エラー | Extension doesn't match chosen language. | 言語と拡張子の不一致 |
| エラー | Error - Could not create script in filesystem. | ファイル作成失敗 |
| エラー | Error loading script from %s | スクリプト読み込み失敗 |
| 情報 | Template: xxx | 選択中のテンプレート情報 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 無効なパス | バリデーションエラー表示、OKボタン無効 |
| 無効な継承クラス | バリデーションエラー表示、OKボタン無効 |
| ファイル保存失敗 | アラートダイアログ表示 |

## 備考

- 言語ごとにアイコンが表示される
- テンプレートはプロジェクトディレクトリ（script_templates/）とエディターディレクトリから読み込み
- ファイル名のケーシングは言語の推奨設定に従って自動変換
- `_script_setup_use_script_templates` でテンプレート使用の有無を記憶

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

ScriptCreateDialogは ConfirmationDialog を継承。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script_create_dialog.h | `editor/script/script_create_dialog.h` | クラス定義 |
| 1-2 | script_create_dialog.cpp | `editor/script/script_create_dialog.cpp` | 全実装 |

**主要処理フロー**:
1. **行113-159**: `_notification()` - 初期化、テーマ変更
2. **行195-212**: `config()` - ダイアログ設定
3. **行218-231**: `_validate_parent()` - 継承クラス検証
4. **行233-309**: `_validate_path()` - パス検証
5. **行349-363**: `ok_pressed()` - 作成/読み込み確定
6. **行365-398**: `_create_new()` - 新規スクリプト作成
7. **行400-411**: `_load_exist()` - 既存スクリプト読み込み
8. **行413-431**: `_language_changed()` - 言語変更処理
9. **行450-475**: `_browse_path()` - パス参照ダイアログ

#### Step 2: テンプレート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script_language.h | `core/object/script_language.h` | ScriptTemplate構造体 |
| 2-2 | gdscript.cpp | `modules/gdscript/gdscript.cpp` | GDScript::make_template() |

### プログラム呼び出し階層図

```
呼び出し元（SceneTreeDock, FileSystemDock等）
    │
    └─ ScriptCreateDialog::config()
           │
           ├─ parent_name->set_text()
           ├─ file_path->set_text()
           ├─ _language_changed()
           │      ├─ _adjust_file_path() [拡張子変換]
           │      └─ _parent_name_changed()
           │
           └─ validation_panel->update()

UI操作
    │
    ├─ _language_changed() → テンプレート更新
    ├─ _template_changed() → 履歴保存
    ├─ _path_changed() → バリデーション
    └─ _built_in_pressed() → ビルトイン切り替え

ok_pressed()
    │
    ├─ is_new_script_created = true ?
    │      └─ _create_new()
    │             ├─ ScriptServer::make_template()
    │             ├─ ResourceSaver::save() [外部ファイル]
    │             └─ scr->reload() [ビルトイン]
    │
    └─ else
           └─ _load_exist()
                  └─ ResourceLoader::load()

emit_signal("script_created", scr)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

言語選択 ──────────────▶ ScriptServer::get_language()  ───▶ テンプレート一覧
                               │
                               └─▶ _adjust_file_path()  ───▶ 拡張子変換

継承クラス入力 ────────▶ _validate_parent()             ───▶ 検証結果

パス入力 ──────────────▶ _validate_path()               ───▶ 検証結果
                               │
                               └─▶ DirAccess確認

テンプレート選択 ──────▶ _get_current_template()        ───▶ テンプレート内容
                               │
                               └─▶ 履歴保存 (EditorSettings)

作成実行 ──────────────▶ _create_new()                  ───▶ スクリプトファイル
                               │
                               ├─ ScriptLanguage::make_template()
                               └─ ResourceSaver::save()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script_create_dialog.cpp | `editor/script/script_create_dialog.cpp` | ソース | メイン実装 |
| script_create_dialog.h | `editor/script/script_create_dialog.h` | ヘッダー | クラス定義 |
| create_dialog.cpp | `editor/gui/create_dialog.cpp` | ソース | 継承クラス選択 |
| editor_file_dialog.cpp | `editor/gui/editor_file_dialog.cpp` | ソース | パス/継承スクリプト参照 |
| editor_validation_panel.cpp | `editor/gui/editor_validation_panel.cpp` | ソース | バリデーション表示 |
| script_language.h | `core/object/script_language.h` | ヘッダー | ScriptTemplate定義 |
| gdscript.cpp | `modules/gdscript/gdscript.cpp` | ソース | GDScriptテンプレート |
