# 画面設計書 31-シーン作成ダイアログ

## 概要

本ドキュメントは、Godot Engineエディタにおけるシーン作成ダイアログ（SceneCreateDialog）の画面設計を記述する。このダイアログは新規シーンの作成時に使用され、シーンのルートノードタイプ、シーン名、ルートノード名を設定できる。

### 本画面の処理概要

このダイアログ画面では、ユーザーが新規シーンを作成する際に必要な各種設定を行うことができる。ConfirmationDialogを継承したモーダルダイアログとして実装されており、シーンの基本構成を対話的に決定する。

**業務上の目的・背景**：ゲーム開発において、シーンはゲームの各場面（レベル、メニュー、キャラクターなど）を構成する基本単位である。新しいシーンを作成する際、開発者は適切なルートノードタイプを選択し、意味のある名前を付ける必要がある。このダイアログは、2Dシーン、3Dシーン、ユーザーインターフェース、カスタムノードなど、用途に応じた適切なルートノードの選択を支援し、プロジェクト内での一貫した命名規則の適用を促進する。

**画面へのアクセス方法**：メインメニューの「シーン」→「新規シーン」を選択するか、ファイルシステムドックで右クリックして「新規」→「シーン」を選択することでアクセスする。

**主要な操作・処理内容**：
1. ルートノードタイプの選択（2Dシーン / 3Dシーン / ユーザーインターフェース / その他）
2. 「その他」選択時のカスタムノードタイプ選択
3. シーン名の入力（拡張子選択を含む）
4. ルートノード名の入力（オプション）
5. 入力値のリアルタイム検証
6. シーン作成の確定

**画面遷移**：
- 遷移元：メインエディタ画面、ファイルシステムドック
- 遷移先（確定時）：新規作成したシーンがエディタに表示される
- 遷移先（キャンセル時）：元の画面に戻る

**権限による表示制御**：EditorFeatureProfileにより3Dシーンオプションの表示/非表示が制御される。3D機能が無効化されている場合、3Dシーンオプションは非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F-001 | シーン管理 | 主機能 | 新規シーンの作成・保存 |
| F-002 | ノード選択ダイアログ | 補助機能 | カスタムルートノードタイプの選択 |
| F-003 | ファイルシステム | 遷移先機能 | 作成したシーンファイルの保存 |

## 画面種別

登録（新規作成ダイアログ）

## URL/ルーティング

該当なし（デスクトップアプリケーションのモーダルダイアログ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| ルートタイプ | 入力 | RootType (enum) | 必須 | ROOT_2D_SCENE / ROOT_3D_SCENE / ROOT_USER_INTERFACE / ROOT_OTHER |
| カスタムノードタイプ | 入力 | String | 条件付き必須 | ルートタイプがROOT_OTHERの場合に必要 |
| シーン名 | 入力 | String | 必須 | ファイル名として有効な文字列 |
| シーン拡張子 | 入力 | String | 必須 | .tscn / .scn など |
| ルートノード名 | 入力 | String | オプション | 空の場合はシーン名から自動導出 |
| シーンパス | 出力 | String | - | 作成されるシーンの完全パス |
| ルートノード | 出力 | Node* | - | 作成されるルートノードインスタンス |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Root Type | ラジオボタン群 | 2D Scene / 3D Scene / User Interface / Other |
| 2D Sceneアイコン | アイコン | Node2Dアイコン |
| 3D Sceneアイコン | アイコン | Node3Dアイコン |
| User Interfaceアイコン | アイコン | Controlアイコン |
| Otherアイコン | アイコン | 選択したノードタイプのアイコン |
| カスタムタイプ表示 | 読み取り専用テキスト | 選択したカスタムノードタイプ名 |
| ノード選択ボタン | ボタン | ClassListアイコン |
| Scene Name | テキスト入力 + ドロップダウン | シーン名入力と拡張子選択 |
| Root Name | テキスト入力 | ルートノード名入力（プレースホルダー付き） |
| 検証パネル | ラベル | シーン名・ルートノード名の検証結果 |

## イベント仕様

### 1-ルートタイプ選択

ラジオボタンで2D Scene / 3D Scene / User Interface / Otherのいずれかを選択する。選択が変更されると、validation_panel->update()が呼び出され、入力値の再検証が行われる。Otherを選択した場合、カスタムノードタイプ表示とノード選択ボタンが有効になる。

### 2-ノードタイプ選択ボタン押下

select_node_buttonをクリックすると、browse_types()メソッドが呼び出される。CreateDialogがポップアップ表示され、利用可能なノードタイプの一覧から選択できる。選択が確定すると、on_type_picked()が呼び出され、other_type_displayに選択したタイプ名が表示される。

### 3-シーン名入力

scene_name_editにテキストを入力すると、リアルタイムでupdate_dialog()が呼び出される。以下の検証が行われる：
- シーン名が空でないこと
- 有効なファイル名であること
- ドットで始まっていないこと
- 同名のファイルが存在しないこと

### 4-シーン名確定（Enter押下）

scene_name_editでEnterキーを押すと、accept_create()が呼び出される。OKボタンが無効でなければ、ダイアログが閉じられ、confirmedシグナルが発行される。

### 5-ルートノード名入力

root_name_editにテキストを入力すると、update_dialog()が呼び出される。空の場合はシーン名から自動導出される。ノード名として無効な文字が含まれる場合は警告メッセージが表示される。

### 6-OKボタン押下

検証に成功していればダイアログが閉じられ、create_scene_root()により選択されたタイプのルートノードが作成される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| シーン作成確定 | ファイルシステム | CREATE | 新規シーンファイル（.tscn/.scn）を作成 |

### テーブル別更新項目詳細

#### ファイルシステム（シーンファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE | ファイルパス | directory + scene_name | 指定ディレクトリに作成 |
| CREATE | ルートノード | create_scene_root()の戻り値 | 選択したタイプのノード |
| CREATE | ルートノード名 | root_name | 入力値またはシーン名から導出 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_ID_PATH | 成功 | Scene name is valid. | シーン名が有効な場合 |
| MSG_ID_PATH | エラー | Scene name is empty. | シーン名が空の場合 |
| MSG_ID_PATH | エラー | File name invalid. | ファイル名として無効な場合 |
| MSG_ID_PATH | エラー | File name begins with a dot. | ドットで始まる場合 |
| MSG_ID_PATH | エラー | File already exists. | 同名ファイルが存在する場合 |
| MSG_ID_ROOT | 成功 | Root node valid. | ルートノード名が有効な場合 |
| MSG_ID_ROOT | エラー | Invalid root node name. | ルートノード名が空の場合 |
| MSG_ID_ROOT | 警告 | Invalid root node name characters have been replaced. | 無効な文字が含まれている場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| OKボタンが無効状態でaccept_create()が呼ばれた場合 | 処理をスキップし、ダイアログを閉じない |
| create_scene_root()でnode_type_groupの押下ボタンがnullの場合 | ERR_FAIL_NULL_Vマクロによりnullを返却 |
| create_scene_root()でrootがnullの場合 | ERR_FAIL_NULL_Vマクロによりnullを返却 |
| 3D機能が無効化されており、3Dシーンが選択されている場合 | 2Dシーンに自動切り替え |

## 備考

- ダイアログの最小サイズは400 * EDSCALEピクセルに設定されている
- ルートノード名が空の場合、シーン名から自動導出される際に、プロジェクト設定の「editor/naming/node_name_casing」に従ってケース変換が行われる
- User Interfaceを選択した場合、ルートとなるControlノードは自動的にフルレクト（画面全体に広がる）プリセットが適用される
- 拡張子の選択肢は、PackedSceneリソースがサポートする全ての拡張子が動的に取得される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ダイアログで使用されるデータ構造とUIコンポーネントの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scene_create_dialog.h | `editor/scene/scene_create_dialog.h` | RootType enumの定義（55-60行目）、クラスメンバ変数の定義（63-81行目） |

**読解のコツ**: Godot Engineでは、UIコンポーネントはポインタとして宣言され、コンストラクタで動的に生成される。MSG_ID_*はバリデーションメッセージの識別子。

#### Step 2: エントリーポイントを理解する

ダイアログの初期化とUIレイアウトの構築を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scene_create_dialog.cpp | `editor/scene/scene_create_dialog.cpp` | コンストラクタ（189-316行目）でのUI構築 |

**主要処理フロー**:
1. **190-193行目**: CreateDialogの初期化（カスタムノードタイプ選択用）
2. **195-200行目**: メインVBoxContainerとGridContainerの作成
3. **202-259行目**: ルートタイプ選択UIの構築（CheckBox群）
4. **261-285行目**: シーン名入力UIの構築（LineEdit + OptionButton）
5. **287-297行目**: ルートノード名入力UIの構築
6. **303-313行目**: 検証パネルの初期化とコールバック接続

#### Step 3: 設定と検証処理を理解する

ダイアログの設定と入力値検証の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scene_create_dialog.cpp | `editor/scene/scene_create_dialog.cpp` | config()メソッド（65-77行目）、update_dialog()メソッド（101-154行目） |

**主要処理フロー**:
- **65-77行目（config）**: ダイアログ表示時の初期化処理、EditorFeatureProfileによる3D機能の表示制御
- **101-127行目（update_dialog）**: シーン名の検証（空チェック、ファイル名有効性、重複チェック）
- **136-153行目（update_dialog）**: ルートノード名の検証と自動導出

#### Step 4: シーン作成処理を理解する

ルートノードの作成と返却処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | scene_create_dialog.cpp | `editor/scene/scene_create_dialog.cpp` | create_scene_root()メソッド（160-187行目） |

**主要処理フロー**:
- **161-162行目**: 選択されたルートタイプの取得
- **164-182行目**: タイプに応じたノードインスタンスの生成（Node2D/Node3D/Control/カスタム）
- **185-186行目**: ルートノード名の設定と返却

### プログラム呼び出し階層図

```
SceneCreateDialog (ConfirmationDialog)
    │
    ├─ config(p_dir)                    [ダイアログ初期化]
    │      ├─ EditorFeatureProfileManager::get_current_profile()
    │      └─ validation_panel->update()
    │
    ├─ update_dialog()                  [入力検証]
    │      ├─ scene_name_edit->get_text()
    │      ├─ DirAccess::file_exists()
    │      └─ Node::adjust_name_casing()
    │
    ├─ browse_types()                   [ノードタイプ選択]
    │      └─ select_node_dialog->popup_create()
    │
    ├─ on_type_picked()                 [タイプ選択確定]
    │      └─ select_node_dialog->get_selected_type()
    │
    ├─ accept_create()                  [作成確定]
    │      └─ emit_signal("confirmed")
    │
    └─ create_scene_root()              [ルートノード生成]
           ├─ memnew(Node2D)
           ├─ memnew(Node3D)
           ├─ memnew(Control)
           └─ select_node_dialog->instantiate_selected()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ルートタイプ選択 ───────▶ node_type_group ───────────▶ RootType決定
                              │
シーン名入力 ──────────▶ update_dialog() ────────────▶ 検証結果表示
                              │                              │
                              ├─ 拡張子付加                   │
                              ├─ パス構築                     │
                              └─ 重複チェック                 │
                                                             ▼
ルートノード名入力 ────▶ validate_node_name() ──────▶ 検証結果表示
        │
        ├─ (空の場合) ─▶ シーン名から導出
        │
        └─ Node::adjust_name_casing()

                              │
                              ▼
                      [create_scene_root()]
                              │
                              ▼
                      シーンファイル作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scene_create_dialog.cpp | `editor/scene/scene_create_dialog.cpp` | ソース | ダイアログの実装 |
| scene_create_dialog.h | `editor/scene/scene_create_dialog.h` | ヘッダ | クラス定義とインターフェース |
| create_dialog.h | `editor/gui/create_dialog.h` | ヘッダ | ノードタイプ選択ダイアログ |
| editor_validation_panel.h | `editor/gui/editor_validation_panel.h` | ヘッダ | 入力検証パネル |
| editor_feature_profile.h | `editor/settings/editor_feature_profile.h` | ヘッダ | エディタ機能プロファイル |
| packed_scene.h | `scene/resources/packed_scene.h` | ヘッダ | シーンリソース定義 |
| node_2d.h | `scene/2d/node_2d.h` | ヘッダ | 2Dルートノード |
| node_3d.h | `scene/3d/node_3d.h` | ヘッダ | 3Dルートノード |
| control.h | `scene/gui/control.h` | ヘッダ | UIルートノード |
