# 画面設計書 32-シグナル接続ダイアログ

## 概要

本ドキュメントは、Godot Engineエディタにおけるシグナル接続ダイアログ（ConnectDialog）の画面設計を記述する。このダイアログはノード間のシグナル接続を設定するために使用され、シグナルの発行元から受信先ノードへのコールバックメソッド接続を構成できる。

### 本画面の処理概要

このダイアログ画面では、ノードが発行するシグナルを別のノードのメソッドに接続するための設定を行う。Godotのシグナル・スロットパターンを実現するための中心的なUIコンポーネントである。

**業務上の目的・背景**：ゲーム開発において、オブジェクト間の疎結合な通信はソフトウェア設計の重要な原則である。シグナル接続により、ボタン押下、衝突検出、アニメーション完了などのイベントを他のオブジェクトに通知し、適切な処理を実行できる。このダイアログは、コードを書かずにGUIでシグナル接続を構成することを可能にし、プロトタイピングや非プログラマの作業効率を向上させる。

**画面へのアクセス方法**：ノードドックでシグナルを選択し、「接続」ボタンをクリックするか、シグナルをダブルクリックすることでアクセスする。または、シグナルを右クリックして「接続」を選択する。

**主要な操作・処理内容**：
1. 接続先ノードの選択（シーンツリーから）
2. レシーバーメソッド名の指定（自動生成または手動入力）
3. メソッド選択ポップアップからの既存メソッド選択
4. 追加のバインド引数の設定（高度なオプション）
5. アンバインド引数数の設定
6. 接続フラグの設定（Deferred / One Shot / Append Source）
7. 接続の確定または編集

**画面遷移**：
- 遷移元：シグナルドック（ConnectionsDock）
- 遷移先（確定時）：シグナルドックに戻り、接続が作成/更新される
- 遷移先（キャンセル時）：シグナルドックに戻る

**権限による表示制御**：高度なオプション（Advanced）トグルにより、バインド/アンバインド設定パネルの表示/非表示が制御される。また、スクリプト接続モードとノード接続モードで表示内容が切り替わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F-010 | シグナル管理 | 主機能 | シグナル接続の作成・編集 |
| F-011 | スクリプト編集 | 遷移先機能 | コールバックメソッドの自動生成 |
| F-012 | シーンツリー | 補助機能 | 接続先ノードの選択 |
| F-013 | メソッド選択 | 補助機能 | 既存メソッドの選択 |

## 画面種別

登録・編集（モーダルダイアログ）

## URL/ルーティング

該当なし（デスクトップアプリケーションのモーダルダイアログ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| ソースオブジェクト | 入力 | Object* | 必須 | シグナル発行元ノード |
| シグナル名 | 入力 | StringName | 必須 | 接続するシグナルの名前 |
| シグナル引数 | 入力 | PackedStringArray | - | シグナルの引数リスト |
| 接続先ノード | 入力 | Node* | 必須 | シグナルを受信するノード |
| レシーバーメソッド名 | 入力 | StringName | 必須 | コールバックメソッド名 |
| バインド引数 | 入力 | Vector<Variant> | オプション | 追加で渡すバインド引数 |
| アンバインド数 | 入力 | int | オプション | 無視するシグナル引数数 |
| Deferredフラグ | 入力 | bool | オプション | 遅延呼び出しフラグ |
| One Shotフラグ | 入力 | bool | オプション | 一回限り接続フラグ |
| Append Sourceフラグ | 入力 | bool | オプション | ソース追加フラグ |
| 接続データ | 出力 | ConnectionData | - | 構成された接続情報 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| From Signal | 読み取り専用テキスト | 接続元シグナル名（引数付き） |
| Connect to Script/Node | ラベル | モードに応じたタイトル |
| Filter Nodes | テキスト入力 | ノードフィルター |
| Go to Source | ボタン | ソースノードにフォーカス |
| シーンツリー | ツリービュー | 接続先ノード選択用 |
| Warning Label | ラベル | コールバック生成不可時の警告 |
| Error Label | ラベル | スクリプトなしエラー |
| Receiver Method | テキスト入力 | メソッド名入力 |
| Open Method Tree | ボタン | メソッド選択ポップアップを開く |
| Add Extra Call Argument | ドロップダウン + ボタン | バインド引数追加 |
| Extra Call Arguments | インスペクター | バインド引数一覧 |
| Unbind Signal Arguments | スピンボックス | アンバインド数設定 |
| Deferred | チェックボックス | 遅延呼び出し設定 |
| One Shot | チェックボックス | 一回限り設定 |
| Append Source | チェックボックス | ソースオブジェクト追加設定 |
| Advanced | チェックボタン | 高度なオプション表示切替 |

## イベント仕様

### 1-接続先ノード選択

シーンツリーでノードを選択すると、_tree_node_selected()が呼び出される。選択されたノードへのパスが設定され、編集モードでない場合はメソッド名が自動生成される（generate_method_callback_name）。また、メソッドツリーが更新される。

### 2-メソッド選択ポップアップ

open_method_treeボタンをクリックすると、method_popupがポップアップ表示される。ターゲットノードのスクリプトメソッドとクラスメソッドが階層的に表示される。フィルタリングオプションとして「Script Methods Only」と「Compatible Methods Only」がある。

### 3-メソッド選択

method_treeでメソッドを選択すると、dst_methodフィールドにメソッド名が設定される。ダブルクリックでポップアップが閉じる。

### 4-バインド引数追加

type_listから型を選択し、Addボタンをクリックすると、その型のデフォルト値を持つバインド引数が追加される。bind_editorインスペクターで値を編集できる。

### 5-バインド引数削除

bind_editorで引数を選択し、Removeボタンをクリックすると選択された引数が削除される。

### 6-OKボタン押下

ok_pressed()が呼び出され、以下の検証が行われる：
- メソッド名が空でないこと
- メソッド名が有効な識別子であること
- ターゲットノードが選択されていること
- スクリプトなしの場合、ターゲットにメソッドが存在すること

検証に成功すると「connected」シグナルが発行され、ダイアログが閉じる。

### 7-高度なオプション切替

advancedチェックボタンをトグルすると、vbc_right（バインド/アンバインド設定パネル）の表示/非表示が切り替わる。同時に、スクリプト接続モードとノード接続モードが切り替わる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 接続確定（新規） | シーンファイル | UPDATE | 新規シグナル接続を追加 |
| 接続確定（編集） | シーンファイル | UPDATE | 既存シグナル接続を更新 |
| メソッド自動生成 | スクリプトファイル | UPDATE | コールバックメソッドを追加 |

### テーブル別更新項目詳細

#### シーンファイル（シグナル接続）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | signal | シグナル名 | ConnectionData.signal |
| UPDATE | target | ターゲットノードパス | dst_path |
| UPDATE | method | メソッド名 | dst_method |
| UPDATE | flags | 接続フラグ | CONNECT_DEFERRED等 |
| UPDATE | binds | バインド引数配列 | cdbinds->params |
| UPDATE | unbinds | アンバインド数 | unbind_count値 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | エラー | Method in target node must be specified. | メソッド名が空の場合 |
| - | エラー | Method name must be a valid identifier. | メソッド名が無効な場合 |
| - | エラー | Target method not found. Specify a valid method or attach a script to the target node. | スクリプトなしでメソッドが存在しない場合 |
| - | エラー | Scene does not contain any script. | シーンにスクリプトがない場合 |
| - | 警告 | {Language}: Callback code won't be generated, please add it manually. | 言語がメソッド生成をサポートしない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ターゲットノードが未選択 | OKボタンを無効化、ok_pressed()は処理をスキップ |
| メソッド名が空 | OKボタンを無効化、エラーダイアログ表示 |
| 無効なメソッド名 | エラーダイアログ表示 |
| スクリプトなしでメソッドなし | エラーダイアログ表示 |
| バインド引数インデックス範囲外 | ERR_FAIL_INDEXマクロで処理中断 |

## 備考

- ダイアログの最小サイズは500 * EDSCALEピクセル（高さ）に設定
- メソッド名の自動生成は、プロジェクト設定の「editor/naming/default_signal_callback_name」および「editor/naming/default_signal_callback_to_self_name」に従う
- メソッドフィルタリング設定（Script Methods Only / Compatible Methods Only）はEditorSettingsのプロジェクトメタデータに保存される
- 高度なオプション設定もEditorSettingsに保存され、次回起動時に復元される
- CONNECT_DEFERREDフラグは、シグナル処理をアイドル時に延期する
- CONNECT_ONE_SHOTフラグは、一度呼び出された後に自動的に切断する
- CONNECT_APPEND_SOURCE_OBJECTフラグは、ソースオブジェクトを最初の引数として追加する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シグナル接続のデータ構造とダイアログの構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | connections_dialog.h | `editor/scene/connections_dialog.h` | ConnectionData構造体（54-110行目）、クラスメンバ変数（112-148行目） |

**読解のコツ**: ConnectionDataはシグナル接続の全情報を保持する構造体。CallableCustomBind/CallableCustomUnbindでバインド/アンバインド情報を管理。

#### Step 2: エントリーポイントを理解する

ダイアログの初期化と表示処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | init()メソッド（682-717行目）、popup_dialog()メソッド（719-735行目） |

**主要処理フロー**:
1. **682-687行目（init）**: ソース、シグナル、引数情報の設定
2. **689-695行目（init）**: ターゲットノードとメソッドの設定（編集モード時）
3. **699-705行目（init）**: 接続フラグの復元
4. **707-712行目（init）**: バインド/アンバインド設定の復元
5. **719-735行目（popup_dialog）**: ダイアログ表示とUI初期化

#### Step 3: ノード選択処理を理解する

接続先ノード選択時の処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | _tree_node_selected()（195-216行目）、generate_method_callback_name()（258-296行目） |

**主要処理フロー**:
- **195-205行目**: 選択ノードへのパス計算
- **207-209行目**: 新規接続時のメソッド名自動生成
- **258-296行目**: プロジェクト設定に基づくメソッド名フォーマット

#### Step 4: メソッドツリー更新処理を理解する

メソッド選択ポップアップのツリー構築処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | _update_method_tree()（369-445行目）、_filter_method_list()（306-367行目） |

**主要処理フロー**:
- **369-389行目**: ツリー初期化とシグナル情報取得
- **396-413行目**: スクリプトメソッドの追加
- **420-442行目**: クラス階層に沿ったメソッドの追加
- **306-367行目**: 互換性・検索条件によるメソッドフィルタリング

#### Step 5: 接続確定処理を理解する

OKボタン押下時の検証と接続処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | ok_pressed()（154-182行目） |

**主要処理フロー**:
- **155-161行目**: メソッド名の空チェック
- **163-167行目**: 識別子有効性チェック
- **169-179行目**: ターゲットノードとメソッド存在確認
- **180-181行目**: connectedシグナル発行とダイアログ非表示

### プログラム呼び出し階層図

```
ConnectDialog (ConfirmationDialog)
    │
    ├─ init(ConnectionData, signal_args, edit)  [初期化]
    │      ├─ set_dst_node()
    │      ├─ set_dst_method()
    │      └─ _update_ok_enabled()
    │
    ├─ popup_dialog(p_for_signal)               [表示]
    │      ├─ _advanced_pressed()
    │      └─ popup_centered()
    │
    ├─ _tree_node_selected()                    [ノード選択]
    │      ├─ generate_method_callback_name()
    │      ├─ cdbinds->update_base_node_relative()
    │      ├─ _update_method_tree()
    │      ├─ _update_warning_label()
    │      └─ _update_ok_enabled()
    │
    ├─ _open_method_popup()                     [メソッド選択]
    │      └─ _update_method_tree()
    │              ├─ _filter_method_list()
    │              └─ _create_method_tree_items()
    │
    ├─ _add_bind() / _remove_bind()             [バインド操作]
    │      └─ cdbinds->notify_changed()
    │
    └─ ok_pressed()                             [確定]
           ├─ TS->is_valid_identifier()
           ├─ target->has_method()
           └─ emit_signal("connected")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

シグナル情報 ───────────▶ init() ──────────────────────▶ ダイアログ初期化
ConnectionData                │
                              ▼
ノード選択 ────────────▶ _tree_node_selected() ────────▶ メソッド名生成
                              │                              │
                              └─ generate_method_callback_name()
                                         │
                                         ▼
                              プロジェクト設定参照
                              (default_signal_callback_name)

メソッド選択 ───────────▶ _method_selected() ──────────▶ dst_method設定
      │
      └─ _filter_method_list()
              │
              └─ 互換性チェック / 検索フィルタ

                              │
                              ▼
OKボタン押下 ───────────▶ ok_pressed() ────────────────▶ "connected"シグナル
                              │
                              ├─ 検証処理
                              └─ ConnectionData構築
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| connections_dialog.cpp | `editor/scene/connections_dialog.cpp` | ソース | ダイアログの実装 |
| connections_dialog.h | `editor/scene/connections_dialog.h` | ヘッダ | クラス定義とConnectionData構造体 |
| scene_tree_editor.h | `editor/scene/scene_tree_editor.h` | ヘッダ | 接続先ノード選択ツリー |
| editor_inspector.h | `editor/inspector/editor_inspector.h` | ヘッダ | バインド引数エディタ |
| editor_variant_type_selectors.h | `editor/gui/editor_variant_type_selectors.h` | ヘッダ | バインド型選択 |
| callable_bind.h | `core/variant/callable_bind.h` | ヘッダ | Callableバインド処理 |
| editor_settings.h | `editor/settings/editor_settings.h` | ヘッダ | 設定の保存/復元 |
| project_settings.h | `core/config/project_settings.h` | ヘッダ | メソッド名フォーマット設定 |
