# 画面設計書 33-親変更ダイアログ

## 概要

本ドキュメントは、Godot Engineエディタにおける親変更ダイアログ（ReparentDialog）の画面設計を記述する。このダイアログはノードの親を別のノードに変更するために使用され、シーンツリー内でのノード階層構造を再編成できる。

### 本画面の処理概要

このダイアログ画面では、選択されたノードの親を変更する操作を行う。シーンツリーから新しい親ノードを選択し、オプションでグローバルトランスフォームを維持するかどうかを設定できる。

**業務上の目的・背景**：ゲーム開発において、シーンの構造は開発の進行に伴って変更が必要になることが多い。例えば、複数のオブジェクトをグループ化するための新しい親ノードを作成したり、キャラクターのパーツを別の骨格にアタッチしたりする場合がある。親変更ダイアログは、ノードの階層関係を視覚的に変更しながら、2D/3Dオブジェクトのワールド座標位置を維持するオプションを提供することで、レベルデザインやシーン編集の効率を向上させる。

**画面へのアクセス方法**：シーンドックでノードを選択し、右クリックメニューから「親を変更」を選択するか、キーボードショートカットを使用してアクセスする。

**主要な操作・処理内容**：
1. 新しい親ノードをシーンツリーから選択
2. 「グローバルトランスフォームを維持」オプションの設定
3. 「Reparent」ボタンで親変更を確定

**画面遷移**：
- 遷移元：シーンドック（右クリックメニュー）
- 遷移先（確定時）：シーンドックに戻り、ノード階層が更新される
- 遷移先（キャンセル時）：シーンドックに戻る

**権限による表示制御**：特になし。選択されたノードと同じシーン内の有効なノードのみが親として選択可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F-020 | シーン階層管理 | 主機能 | ノードの親子関係変更 |
| F-021 | トランスフォーム保持 | 補助機能 | グローバル座標の計算・適用 |
| F-022 | シーンツリー | 補助機能 | 親ノード候補の表示・選択 |

## 画面種別

編集（モーダルダイアログ）

## URL/ルーティング

該当なし（デスクトップアプリケーションのモーダルダイアログ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 選択ノード | 入力 | HashSet<Node*> | 必須 | 親を変更するノードの集合 |
| 新しい親ノード | 入力 | Node* | 必須 | 新しい親として選択されたノード |
| グローバルトランスフォーム維持 | 入力 | bool | オプション | デフォルトtrue |
| 新しい親パス | 出力 | NodePath | - | 選択された新しい親のパス |
| トランスフォーム維持フラグ | 出力 | bool | - | keep_global_xform値 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Select new parent | ラベル | シーンツリー選択エリアのタイトル |
| シーンツリー | ツリービュー | 親ノード候補の表示（SceneTreeEditor） |
| Keep Global Transform | チェックボックス | グローバルトランスフォーム維持オプション |
| Reparent | ボタン | 確定ボタン（OKボタン） |
| Cancel | ボタン | キャンセルボタン |

## イベント仕様

### 1-親ノード選択

シーンツリーでノードをクリックして選択する。選択されたノードは新しい親候補として設定される。選択中のノード（reparent対象）はマーク表示され、選択不可となる。

### 2-ダブルクリックで確定

シーンツリーでノードをダブルクリックすると、item_activatedシグナルにより_reparent()が呼び出され、即座に親変更が実行される。

### 3-グローバルトランスフォーム維持設定

keep_transformチェックボックスのオン/オフを切り替える。オンの場合、親変更後もノードのワールド座標位置が維持される。オフの場合、ローカル座標は維持されるがワールド座標は変化する。

### 4-Reparentボタン押下

confirmedシグナルが発行され、_reparent()メソッドが呼び出される。選択されたノードがある場合、「reparent」シグナルが発行され、新しい親のパスとトランスフォーム維持フラグが渡される。

### 5-キャンセルボタン押下

_cancel()メソッドが呼び出され、ダイアログが非表示になる。変更は適用されない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 親変更確定 | シーンファイル | UPDATE | ノードの親子関係を更新 |
| 親変更確定（トランスフォーム維持） | シーンファイル | UPDATE | トランスフォームも更新 |

### テーブル別更新項目詳細

#### シーンファイル（ノード階層）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | parent | 新しい親ノードのパス | reparentシグナルのpath |
| UPDATE | transform（2D/3D） | グローバル座標維持のための再計算値 | keep_global_xformがtrueの場合 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | （本ダイアログには明示的なメッセージ表示なし） | - |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 親ノードが未選択 | _reparent()が早期リターン、シグナルは発行されない |
| 選択ノード自身を親に選択 | マーク機能により選択不可として制御 |
| サブシーンのノードを親に選択 | set_show_enabled_subsceneにより表示制御 |

## 備考

- ダイアログのタイトルは「Reparent Node」に設定
- OKボタンのテキストは「Reparent」にカスタマイズ
- 「Keep Global Transform」はデフォルトでオン（is_pressed() = true）
- 複数ノード選択時、選択されたノードはすべてマークされ、親として選択不可になる
- シーンツリーはset_update_when_invisible(false)により、非表示時の更新を無効化してパフォーマンスを最適化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダイアログの構成要素とシグナル定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | reparent_dialog.h | `editor/scene/reparent_dialog.h` | クラスメンバ変数（41-42行目）、set_currentメソッド宣言（52行目） |

**読解のコツ**: SceneTreeEditorとCheckBoxの2つのUIコンポーネントのみで構成されるシンプルなダイアログ。

#### Step 2: シグナル定義を理解する

ダイアログから発行されるシグナルとその引数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | reparent_dialog.cpp | `editor/scene/reparent_dialog.cpp` | _bind_methods()（65-69行目）でのシグナル登録 |

**主要処理フロー**:
1. **68行目**: reparentシグナルの定義（NodePath path, bool keep_global_xform）

#### Step 3: コンストラクタを理解する

UI構築とイベント接続を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reparent_dialog.cpp | `editor/scene/reparent_dialog.cpp` | コンストラクタ（71-89行目） |

**主要処理フロー**:
- **72行目**: ダイアログタイトル「Reparent Node」設定
- **77-81行目**: SceneTreeEditorの初期化とitem_activatedシグナル接続
- **83-86行目**: Keep Global Transformチェックボックスの初期化（デフォルトtrue）
- **88行目**: OKボタンテキストを「Reparent」に変更

#### Step 4: 親変更処理を理解する

確定時の処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | reparent_dialog.cpp | `editor/scene/reparent_dialog.cpp` | _reparent()（53-58行目）、_notification()（37-47行目） |

**主要処理フロー**:
- **40行目（NOTIFICATION_ENTER_TREE）**: confirmedシグナルと_reparentの接続
- **53-58行目（_reparent）**: 選択ノードがある場合にreparentシグナル発行

### プログラム呼び出し階層図

```
ReparentDialog (ConfirmationDialog)
    │
    ├─ コンストラクタ                    [UI初期化]
    │      ├─ SceneTreeEditor初期化
    │      ├─ CheckBox初期化
    │      └─ item_activated接続
    │
    ├─ set_current(p_selection)         [選択ノード設定]
    │      ├─ tree->set_marked()
    │      └─ tree->set_selected(nullptr)
    │
    ├─ NOTIFICATION_ENTER_TREE          [シグナル接続]
    │      └─ connect("confirmed", _reparent)
    │
    ├─ _reparent()                       [親変更実行]
    │      ├─ tree->get_selected()
    │      ├─ emit_signal("reparent")
    │      └─ hide()
    │
    └─ _cancel()                         [キャンセル]
           └─ hide()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

選択ノード集合 ──────────▶ set_current() ─────────────▶ ツリーマーク設定
HashSet<Node*>                 │
                              ▼
                     tree->set_marked()
                     (選択不可として表示)

ツリー選択 ─────────────▶ tree->get_selected() ────────▶ 新しい親ノード

Keep Global Transform ──▶ keep_transform->is_pressed() ─▶ bool値

                              │
                              ▼
Reparentボタン/         ┌─ _reparent() ─┐
ダブルクリック ─────────▶│               │──────────────▶ "reparent"シグナル
                        │ get_path()    │               (NodePath, bool)
                        │ is_pressed()  │
                        └───────────────┘
                              │
                              ▼
                   シーンドックで親子関係更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| reparent_dialog.cpp | `editor/scene/reparent_dialog.cpp` | ソース | ダイアログの実装 |
| reparent_dialog.h | `editor/scene/reparent_dialog.h` | ヘッダ | クラス定義 |
| scene_tree_editor.h | `editor/scene/scene_tree_editor.h` | ヘッダ | 親ノード選択ツリー |
| scene_tree_dock.cpp | `editor/docks/scene_tree_dock.cpp` | ソース | ダイアログ呼び出し元（推定） |
| dialogs.h | `scene/gui/dialogs.h` | ヘッダ | ConfirmationDialogベースクラス |
| check_box.h | `scene/gui/check_box.h` | ヘッダ | トランスフォーム維持オプション |
