# 画面設計書 34-名前変更ダイアログ

## 概要

本ドキュメントは、Godot Engineエディタにおける名前変更ダイアログ（RenameDialog）の画面設計を記述する。このダイアログは複数のノードを一括で名前変更するための高度な機能を提供し、検索・置換、プレフィックス/サフィックス追加、正規表現、変数置換、後処理など多彩なオプションを持つ。

### 本画面の処理概要

このダイアログ画面では、選択された複数のノードに対してバッチ（一括）名前変更を行う。単純な検索・置換だけでなく、カウンター、ノード名、親名、タイプ名などの変数を使った高度な命名規則を適用できる。

**業務上の目的・背景**：ゲーム開発では、大量のノードを一貫した命名規則で管理することが重要である。例えば、Enemy01, Enemy02...のような連番付きノードの作成、PascalCaseからsnake_caseへの一括変換、特定のプレフィックスの追加などが頻繁に必要になる。このダイアログは、手動での個別名前変更の手間を大幅に削減し、プロジェクト全体の命名規則の統一を支援する。

**画面へのアクセス方法**：シーンドックで複数のノードを選択し、右クリックメニューから「名前を変更」を選択するか、キーボードショートカット（Ctrl+Shift+Rなど）でアクセスする。

**主要な操作・処理内容**：
1. 検索文字列と置換文字列の指定
2. プレフィックス/サフィックスの追加
3. 正規表現の使用（オプション）
4. 変数置換の使用（${NAME}, ${PARENT}, ${TYPE}, ${SCENE}, ${ROOT}, ${COUNTER}）
5. カウンターオプションの設定（開始値、ステップ、パディング、レベルごとカウンター）
6. 後処理オプション（スタイル変換、大文字/小文字変換）
7. リアルタイムプレビュー確認
8. 一括名前変更の実行

**画面遷移**：
- 遷移元：シーンドック（右クリックメニュー）
- 遷移先（確定時）：シーンドックに戻り、選択ノードの名前が更新される
- 遷移先（キャンセル時）：シーンドックに戻る

**権限による表示制御**：「Advanced Options」チェックボタンにより、高度な機能タブ（Substitute/Post-Process）の表示/非表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F-030 | バッチ名前変更 | 主機能 | 複数ノードの一括名前変更 |
| F-031 | 正規表現処理 | 補助機能 | 正規表現による検索・置換 |
| F-032 | 変数置換 | 補助機能 | ${NAME}等の変数展開 |
| F-033 | 後処理 | 補助機能 | スタイル/ケース変換 |
| F-034 | Undo/Redo | 補助機能 | 名前変更の取り消し/やり直し |

## 画面種別

編集（バッチ処理ダイアログ）

## URL/ルーティング

該当なし（デスクトップアプリケーションのモーダルダイアログ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 検索文字列 | 入力 | String | オプション | 検索対象文字列 |
| 置換文字列 | 入力 | String | オプション | 置換後文字列 |
| プレフィックス | 入力 | String | オプション | 先頭に追加する文字列 |
| サフィックス | 入力 | String | オプション | 末尾に追加する文字列 |
| 正規表現使用 | 入力 | bool | オプション | 正規表現モード有効化 |
| 変数置換使用 | 入力 | bool | オプション | 変数展開有効化 |
| 後処理使用 | 入力 | bool | オプション | 後処理有効化 |
| カウンター開始値 | 入力 | int | オプション | デフォルト1 |
| カウンターステップ | 入力 | int | オプション | デフォルト1 |
| カウンターパディング | 入力 | int | オプション | デフォルト1 |
| レベルごとカウンター | 入力 | bool | オプション | 階層ごとにカウンターリセット |
| スタイル変換 | 入力 | int | オプション | Keep/PascalCase to snake_case/snake_case to PascalCase |
| ケース変換 | 入力 | int | オプション | Keep/To Lowercase/To Uppercase |
| 変更後名前一覧 | 出力 | List<NodePath, String> | - | 名前変更対象リスト |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Search | テキスト入力 | 検索文字列入力 |
| Replace | テキスト入力 | 置換文字列入力 |
| Prefix | テキスト入力 | プレフィックス入力 |
| Suffix | テキスト入力 | サフィックス入力 |
| Use Regular Expressions | チェックボタン | 正規表現モード切替 |
| Advanced Options | チェックボタン | 高度オプション表示切替 |
| Substitute タブ | タブコンテナ | 変数置換設定 |
| NAME/PARENT/TYPE/SCENE/ROOT/COUNTER | ボタン群 | 変数挿入ボタン |
| Per-level Counter | チェックボックス | 階層ごとカウンター |
| Start/Step/Padding | スピンボックス | カウンターオプション |
| Post-Process タブ | タブコンテナ | 後処理設定 |
| Style | ドロップダウン | スタイル変換選択 |
| Case | ドロップダウン | ケース変換選択 |
| Preview | ラベル | 変更後名前のプレビュー |
| Rename | ボタン | 確定ボタン |
| Reset | ボタン | 設定リセットボタン |

## イベント仕様

### 1-検索・置換テキスト入力

lne_search/lne_replaceにテキストを入力すると、text_changedシグナルにより_update_preview()が呼び出され、プレビューがリアルタイム更新される。

### 2-変数挿入ボタン押下

NAME/PARENT/TYPE/SCENE/ROOT/COUNTERボタンをクリックすると、_insert_text()により現在フォーカスのあるテキストフィールドに対応する変数（${NAME}等）が挿入される。フォーカスが主要フィールドでない場合はボタンが無効化される。

### 3-正規表現モード切替

cbut_regexをトグルすると、検索・置換処理が正規表現モードに切り替わる。正規表現エラーが発生した場合、プレビューエリアにエラーメッセージが表示される。

### 4-カウンターオプション変更

spn_count_start/step/paddingの値を変更すると、_update_preview_int()経由で_update_preview()が呼び出される。

### 5-後処理オプション変更

opt_style/opt_caseの選択を変更すると、プレビューが更新される。スタイル変換は正規表現を内部使用する。

### 6-Renameボタン押下

ok_pressed()からrename()が呼び出される：
1. EditorSelectionから選択ノード取得
2. _iterate_scene()でシーンツリーを走査し、名前変更対象を収集
3. EditorUndoRedoManagerでUndo/Redo対応のアクションを作成
4. scene_tree_editor->rename_node()で各ノードを名前変更

### 7-Resetボタン押下

reset()メソッドが呼び出され、全フィールドがデフォルト値にリセットされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Rename実行 | シーンファイル | UPDATE | 選択ノードの名前を一括更新 |

### テーブル別更新項目詳細

#### シーンファイル（ノード名）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | node_name | _apply_rename()の結果 | 各選択ノードに適用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | 情報 | Preview: | 正常時のプレビュータイトル |
| - | エラー | Regular Expression Error: | 正規表現エラー時 |
| - | エラー | At character {position} | 正規表現エラー詳細 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 正規表現エラー | _error_handler()でエラーをキャッチし、プレビューにエラーメッセージを表示 |
| 選択ノードが空 | _post_popup()でERR_FAIL_COND |
| ノードパスが見つからない | rename()でスキップしてエラーログ出力 |
| プレビューノードがnull | _update_preview()が早期リターン |

## 備考

- ダイアログの最小サイズは383ピクセル（幅）に設定
- OKボタンのテキストは「Rename」にカスタマイズ
- 「Reset」ボタンで全設定をデフォルト値に戻せる
- 変数置換で使用できる変数：${NAME}（ノード名）、${PARENT}（親ノード名）、${TYPE}（ノードタイプ）、${SCENE}（シーン名）、${ROOT}（ルートノード名）、${COUNTER}（連番）
- カウンターはシーンツリー順で適用される（エディタ選択順ではない）
- Undo/Redoに対応（EditorUndoRedoManager使用）
- 名前変更は逆順で適用される（子ノードから親ノードへ）ことで、パス解決の問題を回避

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダイアログの構成要素と状態管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rename_dialog.h | `editor/scene/rename_dialog.h` | クラスメンバ変数（64-100行目）、主要メソッド宣言（48-62行目） |

**読解のコツ**: LineEdit群（lne_*）が入力フィールド、SpinBox群（spn_*）がカウンターオプション、OptionButton群（opt_*）が後処理オプション。

#### Step 2: UIコンストラクタを理解する

ダイアログのUI構築とイベント接続を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rename_dialog.cpp | `editor/scene/rename_dialog.cpp` | コンストラクタ（49-345行目） |

**主要処理フロー**:
1. **53行目**: ダイアログタイトル「Batch Rename」設定
2. **60-109行目**: Search/Replace/Prefix/Suffixフィールド構築
3. **113-125行目**: RegexとAdvanced Optionsチェックボタン
4. **128-243行目**: Substituteタブ（変数置換ボタン、カウンターオプション）
5. **246-286行目**: Post-Processタブ（Style/Caseオプション）
6. **293-300行目**: プレビューエリア
7. **311-344行目**: イベントコールバック接続

#### Step 3: 名前変更処理を理解する

rename()の処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rename_dialog.cpp | `editor/scene/rename_dialog.cpp` | rename()（582-614行目）、_iterate_scene()（552-580行目）、_apply_rename()（417-444行目） |

**主要処理フロー**:
- **582-594行目（rename）**: 選択ノード取得とシーンツリー走査
- **596-613行目（rename）**: Undoアクション作成と名前変更実行
- **552-580行目（_iterate_scene）**: シーンツリー再帰走査とカウンター管理
- **417-444行目（_apply_rename）**: 検索・置換、変数展開、後処理の適用

#### Step 4: 変数置換と後処理を理解する

_substitute()と_postprocess()の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | rename_dialog.cpp | `editor/scene/rename_dialog.cpp` | _substitute()（446-476行目）、_postprocess()（506-550行目）、_regex()（500-504行目） |

**主要処理フロー**:
- **446-476行目（_substitute）**: ${COUNTER}, ${NAME}, ${TYPE}, ${SCENE}, ${ROOT}, ${PARENT}の展開
- **506-550行目（_postprocess）**: PascalCase/snake_case変換、大文字/小文字変換
- **500-504行目（_regex）**: RegExクラスを使用した正規表現置換

### プログラム呼び出し階層図

```
RenameDialog (ConfirmationDialog)
    │
    ├─ _post_popup()                    [ダイアログ表示時]
    │      ├─ EditorSelection::get_selected_nodes()
    │      ├─ _update_preview()
    │      └─ _update_substitute()
    │
    ├─ _update_preview()                [プレビュー更新]
    │      └─ _apply_rename()
    │             ├─ _substitute()      [変数展開]
    │             ├─ _regex()           [正規表現置換]
    │             └─ _postprocess()     [後処理]
    │
    ├─ _insert_text()                   [変数挿入]
    │      └─ LineEdit::insert_text_at_caret()
    │
    ├─ ok_pressed() / rename()          [名前変更実行]
    │      ├─ _iterate_scene()          [シーン走査]
    │      │      └─ _apply_rename()
    │      ├─ EditorUndoRedoManager::create_action()
    │      ├─ scene_tree_editor->rename_node()
    │      └─ EditorUndoRedoManager::commit_action()
    │
    └─ reset()                          [設定リセット]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Search/Replace ─────────▶ _apply_rename() ─────────────▶ プレビュー表示
Prefix/Suffix                  │
      │                        ├─ 変数展開 (${NAME}等)
      ▼                        ├─ 正規表現置換 (RegEx)
変数挿入ボタン ────────▶ _substitute() ──────────────▶ 展開後文字列
(NAME/PARENT/等)               │
                              ├─ ${COUNTER} → パディング付き連番
                              ├─ ${NAME} → ノード名
                              └─ ${TYPE} → クラス名

後処理オプション ───────▶ _postprocess() ─────────────▶ 変換後文字列
(Style/Case)                   │
                              ├─ to_snake_case()
                              ├─ to_pascal_case()
                              └─ to_lower()/to_upper()

                              │
                              ▼
Renameボタン ───────────▶ rename() ─────────────────▶ シーン更新
                              │                        (Undo/Redo対応)
                              ├─ _iterate_scene()
                              └─ rename_node()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rename_dialog.cpp | `editor/scene/rename_dialog.cpp` | ソース | ダイアログの実装 |
| rename_dialog.h | `editor/scene/rename_dialog.h` | ヘッダ | クラス定義 |
| scene_tree_editor.h | `editor/scene/scene_tree_editor.h` | ヘッダ | ノード名前変更API |
| regex.h | `modules/regex/regex.h` | ヘッダ | 正規表現処理 |
| editor_undo_redo_manager.h | `editor/editor_undo_redo_manager.h` | ヘッダ | Undo/Redo管理 |
| editor_node.h | `editor/editor_node.h` | ヘッダ | エディタ選択取得 |
| spin_box.h | `scene/gui/spin_box.h` | ヘッダ | カウンターオプションUI |
| option_button.h | `scene/gui/option_button.h` | ヘッダ | スタイル/ケース選択UI |
| tab_container.h | `scene/gui/tab_container.h` | ヘッダ | 機能タブUI |
