# 画面設計書 4-3Dエディタ

## 概要

本ドキュメントは、Godot Engineにおける3Dシーン編集用エディタ画面の設計仕様を記載する。

### 本画面の処理概要

3Dエディタは、3Dノード（Node3D派生クラス）を視覚的に配置・編集するためのエディタ画面である。メッシュ、ライト、カメラ、物理オブジェクトなどを3D空間内で操作し、ギズモを使用して変形操作を行える。

**業務上の目的・背景**：3Dゲームやアプリケーションの3Dシーンを直感的に構築できるようにする。ビューポートのナビゲーション、ギズモ操作、環境設定プレビューなど、3D開発に必要な機能を統合的に提供する。

**画面へのアクセス方法**：エディタメイン画面上部の「3D」タブをクリック、またはF2キーを押す。3Dノード（Node3D派生クラス）を選択すると自動的に3Dエディタに切り替わる。

**主要な操作・処理内容**：
1. 3Dビューポートでのノード選択・移動・回転・スケール（ギズモ操作）
2. ビューポートカメラのナビゲーション（オービット、パン、ズーム、フライモード）
3. 複数ビューポート分割表示
4. グリッド表示とスナップ
5. ライティングプレビュー
6. 環境エフェクトのプレビュー
7. コリジョンシェイプのデバッグ表示
8. ギズモプラグインによる拡張表示

**画面遷移**：エディタメイン画面内のタブとして表示。2D/Script/AssetLibタブと相互切り替え可能。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 3Dレンダリング | 主機能 | 3Dモデル・メッシュの描画プレビュー |
| 8 | カメラシステム（2D/3D） | 主機能 | 3Dビューポートのカメラ・ギズモ操作 |
| 9 | ライティング（2D/3D） | 補助機能 | ライトノードの配置・プレビュー |
| 12 | 環境設定 | 補助機能 | 環境エフェクトのプレビュー表示 |
| 15 | 3D物理シミュレーション | 補助機能 | 3D物理ノードのプレビュー・デバッグ表示 |
| 45 | シーンエディタ | 主機能 | 3Dノードの配置・変形・ギズモ操作 |

## 画面種別

編集 / ビューポート

## URL/ルーティング

該当なし（デスクトップアプリケーション内のタブ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 選択ノード | 入力 | Node3D[] | - | 編集対象の3Dノード |
| カメラ位置/向き | 入力 | Transform3D | - | ビューポートカメラ状態 |
| グリッド設定 | 入力 | float | - | グリッドステップ |
| スナップ設定 | 入力 | bool/float | - | スナップの有効/無効と値 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ビューポート | SubViewport | 3Dシーンの描画領域 |
| グリッド | MeshInstance3D | 3Dグリッド表示 |
| ギズモ | EditorNode3DGizmo | 変形操作ハンドル |
| ビュー回転インジケータ | ViewportRotationControl | カメラ向き表示 |
| ナビゲーションコントロール | ViewportNavigationControl | タッチ/モバイル用ナビ |
| ツールバー | HBoxContainer | 編集ツール選択 |

## イベント仕様

### 1-ノード選択

ビューポート上でノードをクリック。レイキャストでオブジェクトを特定し、EditorSelectionに追加。

### 2-ギズモ操作（移動）

移動ギズモの軸矢印をドラッグ。マウス移動をワールド座標に変換し、Node3D::set_position()で更新。

### 3-ギズモ操作（回転）

回転ギズモのリングをドラッグ。ドラッグ方向から角度を計算し、Node3D::set_rotation()で更新。

### 4-ギズモ操作（スケール）

スケールギズモのハンドルをドラッグ。ドラッグ距離からスケール値を計算し、Node3D::set_scale()で更新。

### 5-オービットナビゲーション

中クリック+ドラッグでカメラをターゲット周りで回転。_nav_orbit()が処理。

### 6-パンナビゲーション

Shift+中クリック+ドラッグでカメラを平行移動。_nav_pan()が処理。

### 7-ズームナビゲーション

マウスホイールでカメラをズーム。_nav_zoom()が処理。フリールックモードではカメラ速度に影響。

### 8-フリールックモード

右クリック長押し+WASDでFPS風のカメラ操作。ZOOM_FREELOOK_MINからZOOM_FREELOOK_MAXの範囲で移動。

## データベース更新仕様

本画面は直接ファイルを更新しない（シーン保存時に反映）。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| ノード変形 | EditorData | UPDATE | 編集中シーンのノードプロパティ更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 情報 | View camera orbit/pan modifier | ナビゲーション操作時のガイド |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ロック済みノード選択 | 選択不可、操作を無視 |
| 非表示ノード選択 | 設定により選択可否を制御 |

## 備考

- Node3DEditorクラスがメインの実装
- DISTANCE_DEFAULT = 4（初期カメラ距離）
- GIZMO_ARROW_SIZE = 0.35、GIZMO_CIRCLE_SIZE = 1.1
- フリールックズーム範囲：0.01〜10000（float）または〜1兆（double）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node_3d_editor_plugin.h | `editor/scene/3d/node_3d_editor_plugin.h` | Node3DEditorクラス、ナビゲーションenum |

**読解のコツ**: NavigationMode enum、TransformMode enum、ギズモ定数が重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | node_3d_editor_plugin.cpp | `editor/scene/3d/node_3d_editor_plugin.cpp` | gui_input()、_nav_*()でナビゲーション |

**主要処理フロー**:
1. **行108-131**: 定数定義（DISTANCE_DEFAULT、GIZMO_*）
2. **行135-287**: ViewportNavigationControl（モバイル対応ナビ）
3. **行232-287**: _update_navigation()でナビゲーション更新

#### Step 3: ギズモシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node_3d_editor_gizmos.cpp | `editor/scene/3d/node_3d_editor_gizmos.cpp` | ギズモ描画・操作 |
| 3-2 | gizmos/*.cpp | `editor/scene/3d/gizmos/` | 各種ノード固有ギズモ |

### プログラム呼び出し階層図

```
Node3DEditor
    │
    ├─ Node3DEditorViewport (最大4分割)
    │      ├─ ViewportRotationControl
    │      ├─ ViewportNavigationControl
    │      └─ Camera3D (ビューポートカメラ)
    │
    ├─ EditorNode3DGizmoPlugin (ギズモプラグイン)
    │      └─ 各種GizmoPlugin (Light、Camera、Collision等)
    │
    └─ EditorSelection (選択管理)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

マウス/キー入力 ─────────▶ Node3DEditorViewport ────▶ ビューポート描画
                            │
                            ├──▶ _nav_orbit/pan/zoom() ──▶ カメラ更新
                            │
                            ├──▶ レイキャスト ───────────▶ ノード選択
                            │
                            └──▶ ギズモ操作 ─────────────▶ Transform更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node_3d_editor_plugin.cpp | `editor/scene/3d/node_3d_editor_plugin.cpp` | ソース | 3Dエディタ実装 |
| node_3d_editor_plugin.h | `editor/scene/3d/node_3d_editor_plugin.h` | ヘッダ | クラス定義 |
| node_3d_editor_gizmos.cpp | `editor/scene/3d/node_3d_editor_gizmos.cpp` | ソース | ギズモ基底 |
| gizmos/camera_3d_gizmo_plugin.cpp | `editor/scene/3d/gizmos/` | ソース | カメラギズモ |
| gizmos/light_3d_gizmo_plugin.cpp | `editor/scene/3d/gizmos/` | ソース | ライトギズモ |
