# 画面設計書: グラデーションエディタ

## 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 47 |
| 画面名 | グラデーションエディタ |
| ファイルパス | `editor/scene/gradient_editor_plugin.h`, `editor/scene/gradient_editor_plugin.cpp` |
| 主要クラス | `GradientEdit`, `GradientEditor`, `EditorInspectorPluginGradient`, `GradientEditorPlugin` |
| 基底クラス | `Control`, `VBoxContainer`, `EditorInspectorPlugin`, `EditorPlugin` |

## 概要

グラデーションエディタはGradientリソースを編集するためのインスペクタプラグインです。インスペクタパネル内に直接描画され、カラーストップ（ポイント）の追加・削除・移動、色の変更、グラデーションの反転などを行えます。カラーピッカーポップアップとグリッドスナップ機能を備えています。

### 主な機能

1. **ポイント編集**: グラデーション上のカラーストップを追加・削除・移動
2. **色変更**: カラーピッカーでポイントの色を変更
3. **グラデーション反転**: グラデーション全体を反転
4. **グリッドスナップ**: 設定可能なグリッドへのスナップ
5. **ポイント複製**: Alt+クリックでポイントを複製

## 画面構成

### レイアウト構造

```
+------------------------------------------------------------------+
| GradientEditor (VBoxContainer)                                    |
+------------------------------------------------------------------+
| HFlowContainer (toolbar)                                          |
| +--------+-----+--------+--------------+                          |
| |Reverse |Sep  |SnapBtn |SnapCount     |                          |
| |  [<->] |     |[toggle]|[___10_]      |                          |
| +--------+-----+--------+--------------+                          |
+------------------------------------------------------------------+
| GradientEdit (Control)                                            |
| +--------------------------------------------------+------+       |
| |[Checkerboard + Gradient Preview]                 |[Color]|      |
| |  |    |    |    |                                |Button |      |
| | [V]  [V]  [V]  [V]  (Color Stops)                |       |      |
| +--------------------------------------------------+------+       |
+------------------------------------------------------------------+
```

## 表示項目

### ツールバー

| 項目 | 種類 | 説明 | ソースコード参照 |
|------|------|------|------------------|
| reverse_button | Button | グラデーション反転 | L111, L633-635 |
| snap_button | Button | グリッドスナップ切替 | L112, L639-643 |
| snap_count_edit | EditorSpinSlider | スナップ分割数（2-100） | L113, L645-652 |

### グラデーション編集領域（GradientEdit）

| 項目 | 種類 | 説明 | ソースコード参照 |
|------|------|------|------------------|
| gradient | Ref<Gradient> | 編集対象のグラデーション | L45 |
| preview_texture | Ref<GradientTexture1D> | プレビュー用テクスチャ | L46, L591-592 |
| popup | PopupPanel | カラーピッカーポップアップ | L48, L585-589 |
| picker | ColorPicker | カラーピッカー | L49, L580-583 |
| selected_index | int | 選択中のポイントインデックス | L63 |
| hovered_index | int | ホバー中のポイントインデックス | L64 |

### 描画パラメータ

| パラメータ | 基本値 | 説明 | ソースコード参照 |
|-----------|--------|------|------------------|
| BASE_SPACING | 4 | 基本スペーシング | L67 |
| BASE_HANDLE_WIDTH | 8 | ハンドル幅 | L68 |
| preview_texture width | 1024 | プレビューテクスチャ幅 | L592 |
| minimum_size | (0, 60) * EDSCALE | 最小サイズ | L578 |

## グラブモード

| モード | 説明 | ソースコード参照 |
|--------|------|------------------|
| GRAB_NONE | 何も掴んでいない | L55 |
| GRAB_ADD | 新しいポイントを追加中 | L56 |
| GRAB_MOVE | ポイントを移動中 | L57 |

## イベント仕様

### マウス操作

| 操作 | 処理 | ソースコード参照 |
|------|------|------------------|
| 左クリック（空白） | 新規ポイント追加 | L310-341 |
| 左クリック（ポイント） | ポイント選択 | L301-309 |
| 左クリック（カラーボタン） | カラーピッカー表示 | L288-293 |
| 左ダブルクリック（ポイント） | カラーピッカー表示 | L294-298 |
| 左ドラッグ | ポイント移動 | L379-434 |
| 左ボタン解放 | 編集確定（Undo/Redo登録） | L345-358 |
| Alt+左クリック（ポイント） | ポイント複製 | L330-336 |
| 右クリック（ポイント） | ポイント削除 | L261-281 |
| 中クリック（ポイント） | ポイント削除 | L261-281 |
| 移動中に右クリック | 移動キャンセル（元位置に戻る） | L262-264 |
| マウス移動 | ホバー状態更新 | L367-377 |

### キーボード操作

| キー | 処理 | ソースコード参照 |
|------|------|------------------|
| Delete | 選択ポイント削除 | L242-252 |
| Ctrl/Cmd（押下中） | スナップ有効/無効切替 | L258, L365, L408 |
| Shift（押下中） | 隣接ポイントにスナップ | L383-411 |
| Alt（押下中） | ポイント複製 | L321-327, L330-336 |

### カラーピッカー

| イベント | 処理 | ソースコード参照 |
|----------|------|------------------|
| color_changed | set_color()呼び出し | L99-101, L583 |
| about_to_popup | EditorNode::setup_color_picker | L586 |

## Undo/Redo アクション

| アクション名 | 処理内容 | ソースコード参照 |
|-------------|----------|------------------|
| "Add Gradient Point" | ポイント追加 | L116 |
| "Remove Gradient Point" | ポイント削除 | L144 |
| "Move Gradient Point" | ポイント移動 | L164 |
| "Recolor Gradient Point" | 色変更（MERGE_ENDS） | L182 |
| "Reverse Gradient" | グラデーション反転 | L192 |

## メッセージ仕様

| メッセージ | 表示条件 | ソースコード参照 |
|------------|----------|------------------|
| "Reverse/Mirror Gradient" | 反転ボタンツールチップ | L634 |
| "Toggle Grid Snap" | スナップボタンツールチップ | L640 |

## アイコン設定

| アイコン名 | 用途 | ソースコード参照 |
|------------|------|------------------|
| ReverseGradient | 反転ボタン | L615 |
| SnapGrid | スナップボタン | L616 |
| GuiMiniCheckerboard | 透明部分の市松模様 | L449, L483, L526 |
| overbright_indicator | オーバーブライト色表示 | L531 |

## スナップ設定

| 設定 | デフォルト値 | 範囲 | メタキー |
|------|-------------|------|----------|
| snap_enabled | false | - | _snap_enabled |
| snap_count | 10 | 2-100 | _snap_count |

スナップ設定はグラデーションリソースのメタデータとして保存されます。

## 描画処理

### グラデーション描画

```
1. 市松模様背景描画（透明色対応）
2. preview_textureにグラデーションを設定
3. グラデーションテクスチャ描画
4. スナップライン描画（有効時）
5. ハンドル描画（選択/ホバー状態に応じて）
6. カラーボタン描画（選択色または×マーク）
```

### ハンドル描画詳細

```
各ポイントに対して:
1. 色に応じた境界色決定（明るさ0.455基準で白黒切替）
2. 透明色の場合は市松模様+色付き矩形描画
3. 選択状態: アクセントカラーで枠描画
4. ホバー状態: 半透明枠描画
5. 上部に垂直線描画
```

## ポイント選択ロジック

| 関数 | 処理 | ソースコード参照 |
|------|------|------------------|
| _get_point_at() | X座標からポイントを検索 | L48-67 |
| _predict_insertion_index() | オフセットから挿入位置を予測 | L69-75 |
| _get_gradient_rect_width() | グラデーション描画幅を計算 | L77-79 |

## カラーピッカー表示位置

| 条件 | 表示位置 | ソースコード参照 |
|------|----------|------------------|
| 下に表示可能 | グラデーション下部 | L91-94 |
| 下に収まらない＆下半分にある | グラデーション上部 | L91-92 |

## コードリーディングガイド

### 推奨読解順序

1. **データ構造** (gradient_editor_plugin.h L42-106)
   - GradientEditクラス: 描画とインタラクション
   - GrabMode enum

2. **GradientEditorクラス** (gradient_editor_plugin.h L108-127)
   - ツールバー構成
   - GradientEditとの連携

3. **インスペクタプラグイン** (gradient_editor_plugin.h L129-144)
   - EditorInspectorPluginGradient
   - GradientEditorPlugin

4. **コンストラクタ** (gradient_editor_plugin.cpp L576-661)
   - UI構築
   - シグナル接続

5. **入力処理** (gradient_editor_plugin.cpp L237-435)
   - gui_input()メソッド
   - マウス/キーボードイベント

6. **描画処理** (gradient_editor_plugin.cpp L437-539)
   - _redraw()メソッド
   - グラデーション、ハンドル、カラーボタン描画

7. **Undo/Redo操作** (gradient_editor_plugin.cpp L112-198)
   - add_point(), remove_point()
   - set_offset(), set_color(), reverse_gradient()

### プログラム呼び出し階層図

```
EditorInspectorPluginGradient::parse_begin()
└── GradientEditor::set_gradient()
    └── GradientEdit::set_gradient()
        ├── gradient->connect(changed, queue_redraw)
        └── queue_redraw()

GradientEdit::gui_input() [マウス左クリック]
├── _get_point_at()
├── [空白クリック]
│   ├── gradient->add_point() [一時ポイント]
│   ├── set_selected_index()
│   └── grabbing = GRAB_ADD
├── [ポイント選択]
│   ├── set_selected_index()
│   └── grabbing = GRAB_MOVE
└── [カラーボタンクリック] _show_color_picker()
    └── popup->popup()

GradientEdit::gui_input() [左ボタン解放]
├── [GRAB_MOVE] set_offset()
│   └── EditorUndoRedoManager::create_action("Move Gradient Point")
└── [GRAB_ADD]
    ├── gradient->remove_point() [一時ポイント削除]
    └── add_point()
        └── EditorUndoRedoManager::create_action("Add Gradient Point")

GradientEdit::_notification(NOTIFICATION_DRAW)
└── _redraw()
    ├── draw_texture_rect() [市松模様]
    ├── preview_texture->set_gradient()
    ├── draw_texture_rect() [グラデーション]
    ├── draw_line() [スナップライン]
    ├── draw_rect() [ハンドル]
    └── draw_rect() [カラーボタン]

GradientEdit::reverse_button pressed
└── GradientEdit::reverse_gradient()
    └── EditorUndoRedoManager::create_action("Reverse Gradient")
        ├── gradient->reverse()
        └── commit_action()
```

### データフロー図

```
[Gradientリソース]
    |
    | (set_gradient)
    v
[GradientEdit]
    |
    +----> [preview_texture] ----> [描画]
    |               |
    |               | (set_gradient)
    |               v
    |        [GradientTexture1D]
    |
    +----> [入力処理]
    |        |
    |        v
    +----> [Undo/Redo] --> [EditorUndoRedoManager]
    |        |
    |        v
    +<---- [グラデーション更新] <---- [gradient->add_point/remove_point/set_offset/set_color]

[ColorPicker]
    |
    | (color_changed)
    v
[GradientEdit::set_color()]
    |
    v
[Gradient::set_color()]
```

### 関連ファイル一覧

| ファイル | 役割 |
|----------|------|
| `editor/scene/gradient_editor_plugin.h` | エディタクラス定義 |
| `editor/scene/gradient_editor_plugin.cpp` | エディタ実装 |
| `scene/resources/gradient.h` | Gradientリソース定義 |
| `scene/resources/gradient.cpp` | Gradientリソース実装 |
| `scene/resources/gradient_texture.h` | GradientTexture1D定義 |
| `scene/gui/color_picker.h` | カラーピッカー |
| `scene/gui/popup.h` | PopupPanel |
| `editor/inspector/editor_inspector.h` | インスペクタプラグイン基底 |
| `editor/gui/editor_spin_slider.h` | スピンスライダー |
| `editor/editor_undo_redo_manager.h` | Undo/Redo管理 |
