# 画面設計書: ポリゴン2Dエディタ

## 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 49 |
| 画面名 | ポリゴン2Dエディタ |
| ファイルパス | `editor/scene/2d/polygon_2d_editor_plugin.h`, `editor/scene/2d/polygon_2d_editor_plugin.cpp` |
| 主要クラス | `Polygon2DEditor`, `Polygon2DEditorPlugin` |
| 基底クラス | `AbstractPolygon2DEditor`, `AbstractPolygon2DEditorPlugin` |

## 概要

ポリゴン2Dエディタは、Polygon2Dノードを編集するための専用エディタです。ポリゴン頂点の作成・編集、UV座標の編集、カスタムポリゴンの追加・削除、およびボーンウェイトのペイントをサポートします。EditorDockとして表示され、テクスチャのプレビューとグリッドスナップ機能を備えています。

### 主な機能

1. **ポリゴン編集**: 頂点の作成、移動、回転、スケール
2. **内部頂点管理**: 内部頂点の追加・削除
3. **UV編集**: UVマッピングの編集とPolygonからのコピー
4. **カスタムポリゴン**: ポリゴン分割の追加・削除
5. **ボーンウェイト**: Skeleton2Dとの連携でウェイトペイント
6. **グリッドスナップ**: 設定可能なグリッドへのスナップ

## 画面構成

### レイアウト構造

```
+------------------------------------------------------------------+
| EditorDock "Polygon"                                              |
+------------------------------------------------------------------+
| Toolbar                                                           |
| +------+--------+----+-------+---+---+---+---+---+---+...+------+ |
| |Points|Polygons| UV |Bones  |Actions...            |Edit|Snap  | |
| +------+--------+----+-------+---+---+---+---+---+---+...+------+ |
+------------------------------------------------------------------+
| HSplitContainer                                                   |
| +------------------------------------------+-------------------+  |
| | Canvas (Texture Preview)                 | Bone Scroll       |  |
| | +--------------------------------------+ | +---------------+ |  |
| | | [Texture/Polygon Preview]            | | |[Sync Bones]   | |  |
| | |                                      | | |[Bone List]    | |  |
| | | [Grid Lines]                         | | |  Bone1 [x]    | |  |
| | |                                      | | |  Bone2 [ ]    | |  |
| | | [Polygon Vertices]                   | | |  ...          | |  |
| | +--------------------------------------+ | +---------------+ |  |
| | [ZoomWidget]                             |                   |  |
| | [HScroll][VScroll]                       |                   |  |
| +------------------------------------------+-------------------+  |
+------------------------------------------------------------------+
```

## 表示項目

### モードボタン

| 項目 | 種類 | 説明 | ソースコード参照 |
|------|------|------|------------------|
| MODE_POINTS | Button | ポイント編集モード | L62, L1363 |
| MODE_POLYGONS | Button | ポリゴン編集モード | L63, L1364 |
| MODE_UV | Button | UV編集モード | L64, L1365 |
| MODE_BONES | Button | ボーン編集モード | L65, L1366 |

### アクションボタン

| 項目 | 種類 | アイコン | 説明 | ソースコード参照 |
|------|------|----------|------|------------------|
| ACTION_CREATE | Button | Edit | ポリゴン作成 | L70, L114, L1380 |
| ACTION_CREATE_INTERNAL | Button | EditInternal | 内部頂点作成 | L71, L115, L1381 |
| ACTION_REMOVE_INTERNAL | Button | RemoveInternal | 内部頂点削除 | L72, L116, L1382 |
| ACTION_EDIT_POINT | Button | ToolSelect | ポイント編集 | L73, L117, L1385 |
| ACTION_MOVE | Button | ToolMove | 移動 | L74, L118, L1386 |
| ACTION_ROTATE | Button | ToolRotate | 回転 | L75, L119, L1387 |
| ACTION_SCALE | Button | ToolScale | スケール | L76, L120, L1388 |
| ACTION_ADD_POLYGON | Button | Edit | カスタムポリゴン追加 | L77, L121, L1389 |
| ACTION_REMOVE_POLYGON | Button | Close | カスタムポリゴン削除 | L78, L122, L1390 |
| ACTION_PAINT_WEIGHT | Button | Bucket | ウェイトペイント | L79, L123, L1391 |
| ACTION_CLEAR_WEIGHT | Button | Clear | ウェイトクリア | L80, L124, L1392 |

### ツールバー要素

| 項目 | 種類 | 説明 | ソースコード参照 |
|------|------|------|------------------|
| edit_menu | MenuButton | 編集メニュー | L94, L1448-1459 |
| b_snap_enable | Button | スナップ有効化 | L92, L1463-1471 |
| b_snap_grid | Button | グリッド表示 | L93, L1473-1481 |
| bone_paint_strength | HSlider | ペイント強度 | L114, L1406-1414 |
| bone_paint_radius | SpinBox | ペイント半径 | L115, L1418-1425 |

### キャンバス要素

| 項目 | 種類 | 説明 | ソースコード参照 |
|------|------|------|------------------|
| canvas | Control | 描画領域 | L96, L1440-1442 |
| canvas_background | Panel | 背景パネル | L97, L1431-1435 |
| preview_polygon | Polygon2D | プレビュー用ポリゴン | L98, L1437-1438 |
| zoom_widget | EditorZoomWidget | ズームウィジェット | L99, L1529-1533 |
| hscroll | HScrollBar | 横スクロール | L100, L1539-1542 |
| vscroll | VScrollBar | 縦スクロール | L101, L1535-1538 |

### ボーン編集パネル

| 項目 | 種類 | 説明 | ソースコード参照 |
|------|------|------|------------------|
| bone_scroll_main_vb | VBoxContainer | ボーンパネルコンテナ | L110, L1544-1550 |
| sync_bones | Button | ボーン同期ボタン | L113, L1546-1549 |
| bone_scroll | ScrollContainer | ボーンリストスクロール | L111, L1551-1555 |
| bone_scroll_vb | VBoxContainer | ボーンリストコンテナ | L112, L1556-1557 |

## メニューオプション

| ID | メニュー項目 | 説明 | ソースコード参照 |
|----|-------------|------|------------------|
| MENU_POLYGON_TO_UV | Copy Polygon to UV | ポリゴンをUVにコピー | L55, L1453 |
| MENU_UV_TO_POLYGON | Copy UV to Polygon | UVをポリゴンにコピー | L56, L1454 |
| MENU_UV_CLEAR | Clear UV | UVをクリア | L57, L1456 |
| MENU_GRID_SETTINGS | Grid Settings | グリッド設定ダイアログ | L58, L1458 |

## モード別アクション

### MODE_POINTS（ポイントモード）

| 表示アクション | 説明 | ソースコード参照 |
|---------------|------|------------------|
| ACTION_CREATE | ポリゴン作成 | L264 |
| ACTION_CREATE_INTERNAL | 内部頂点作成 | L265 |
| ACTION_REMOVE_INTERNAL | 内部頂点削除 | L266 |
| ACTION_EDIT_POINT | ポイント編集 | L267 |
| ACTION_MOVE | 全体移動 | L268 |
| ACTION_ROTATE | 全体回転 | L269 |
| ACTION_SCALE | 全体スケール | L270 |

### MODE_POLYGONS（ポリゴンモード）

| 表示アクション | 説明 | ソースコード参照 |
|---------------|------|------------------|
| ACTION_ADD_POLYGON | カスタムポリゴン追加 | L279 |
| ACTION_REMOVE_POLYGON | カスタムポリゴン削除 | L280 |

### MODE_UV（UVモード）

| 表示アクション | 説明 | ソースコード参照 |
|---------------|------|------------------|
| ACTION_EDIT_POINT | UV点編集 | L287 |
| ACTION_MOVE | UV全体移動 | L288 |
| ACTION_ROTATE | UV全体回転 | L289 |
| ACTION_SCALE | UV全体スケール | L290 |

### MODE_BONES（ボーンモード）

| 表示アクション | 説明 | ソースコード参照 |
|---------------|------|------------------|
| ACTION_PAINT_WEIGHT | ウェイトペイント | L294 |
| ACTION_CLEAR_WEIGHT | ウェイトクリア | L295 |

## イベント仕様

### マウス操作

| 操作 | アクション | 処理 | ソースコード参照 |
|------|-----------|------|------------------|
| 左クリック | ACTION_CREATE | ポリゴン頂点追加/閉じる | L474-530 |
| 左クリック | ACTION_CREATE_INTERNAL | 内部頂点追加 | L533-566 |
| 左クリック | ACTION_REMOVE_INTERNAL | 内部頂点削除 | L568-623 |
| 左クリック | ACTION_EDIT_POINT | 頂点選択/ドラッグ開始 | L635-651 |
| 左クリック | ACTION_ADD_POLYGON | ポリゴン頂点選択 | L653-691 |
| 左クリック | ACTION_REMOVE_POLYGON | ポリゴン削除 | L693-723 |
| 左クリック | ACTION_PAINT/CLEAR_WEIGHT | ウェイトペイント開始 | L725-740 |
| 左ボタン解放 | - | ドラッグ確定/Undo登録 | L741-773 |
| 右クリック | - | 編集キャンセル | L775-783 |
| マウス移動 | EDIT_POINT | 頂点移動 | L834-843 |
| マウス移動 | MOVE | 全体移動 | L844-855 |
| マウス移動 | ROTATE | 全体回転 | L856-878 |
| マウス移動 | SCALE | 全体スケール | L879-907 |

### キーボード修飾子

| 修飾子 | アクション | 処理 | ソースコード参照 |
|--------|-----------|------|------------------|
| Shift | ACTION_EDIT_POINT | MOVE切替 | L628-629 |
| Ctrl/Cmd | ACTION_EDIT_POINT | ROTATE切替 | L630-631 |
| Shift+Ctrl/Cmd | ACTION_EDIT_POINT | SCALE切替 | L626-627 |

## Undo/Redo アクション

| アクション名 | 処理内容 | ソースコード参照 |
|-------------|----------|------------------|
| "Create UV Map" | PolygonからUVを作成 | L320 |
| "Create Polygon" | UVからPolygonを作成 | L332 |
| "Create Polygon & UV" | ポリゴン作成完了 | L501 |
| "Create Internal Vertex" | 内部頂点追加 | L548 |
| "Remove Internal Vertex" | 内部頂点削除 | L605 |
| "Transform UV Map" | UV変換 | L744 |
| "Transform Polygon" | ポリゴン変換 | L754 |
| "Add Custom Polygon" | カスタムポリゴン追加 | L679 |
| "Remove Custom Polygon" | カスタムポリゴン削除 | L718 |
| "Paint Bone Weights" | ウェイトペイント | L768 |
| "Sync Bones" | ボーン同期 | L197 |

## グリッド設定ダイアログ

| 項目 | 種類 | 範囲 | デフォルト | ソースコード参照 |
|------|------|------|-----------|------------------|
| Grid Offset X | SpinBox | -256～256 px | 0 | L1489-1497 |
| Grid Offset Y | SpinBox | -256～256 px | 0 | L1499-1507 |
| Grid Step X | SpinBox | -256～256 px | 8 | L1509-1517 |
| Grid Step Y | SpinBox | -256～256 px | 8 | L1519-1527 |

## プロジェクトメタデータ

| キー | 用途 | ソースコード参照 |
|------|------|------------------|
| polygon_2d_uv_editor/snap_enabled | スナップ有効/無効 | L400, L1333 |
| polygon_2d_uv_editor/show_grid | グリッド表示 | L405, L1334 |
| polygon_2d_uv_editor/snap_offset | スナップオフセット | L411, L417, L1330 |
| polygon_2d_uv_editor/snap_step | スナップステップ | L423, L429, L1332 |

## ボーンペイント設定

| パラメータ | 範囲 | デフォルト | ソースコード参照 |
|-----------|------|-----------|------------------|
| bone_paint_strength | 0.0～1.0 | 0.5 | L1410-1413 |
| bone_paint_radius | 1～100 | 32 | L1421-1424 |

## 描画処理

### キャンバス描画 (_canvas_draw)

```
1. ビュー中心化（必要時）
2. テクスチャ背景描画（UVモード/作成時）
   - テクスチャ変換適用
   - draw_texture()
3. プレビューポリゴン表示（ポリゴンモード）
   - preview_polygon設定
4. グリッド描画（有効時）
   - 垂直線/水平線
5. ポリゴン線描画
   - 前の輪郭（ドラッグ中）
   - 現在の輪郭
6. カスタムポリゴン描画
   - ポリゴン線
   - 塗りつぶし
7. 頂点描画
   - ボーンモード: ウェイト色で矩形
   - 通常: EditorPathSharpHandleアイコン
   - 内部頂点: 青色
8. ポリゴン作成中線
9. スケルトン描画（ボーンモード）
   - Bone2D接続線
10. ペイントブラシ円
```

## コードリーディングガイド

### 推奨読解順序

1. **クラス定義** (polygon_2d_editor_plugin.h L51-191)
   - Mode enum、Action enum
   - メンバ変数宣言

2. **基底クラス** (abstract_polygon_2d_editor.h L41-158)
   - AbstractPolygon2DEditor定義
   - Vertex/PosVertex構造体
   - 仮想関数

3. **コンストラクタ** (polygon_2d_editor_plugin.cpp L1329-1569)
   - EditorDock作成
   - ツールバー構築
   - キャンバス設定
   - スクロール設定

4. **モード選択** (polygon_2d_editor_plugin.cpp L252-309)
   - _select_mode()
   - アクションボタン表示切替

5. **入力処理** (polygon_2d_editor_plugin.cpp L445-951)
   - _canvas_input()
   - マウスボタン処理
   - マウス移動処理

6. **描画処理** (polygon_2d_editor_plugin.cpp L1055-1313)
   - _canvas_draw()
   - テクスチャ/グリッド/ポリゴン/頂点描画

7. **ボーン処理** (polygon_2d_editor_plugin.cpp L152-250)
   - _sync_bones()
   - _update_bone_list()

### プログラム呼び出し階層図

```
Polygon2DEditorPlugin::edit()
└── Polygon2DEditor::edit() [継承]
    └── _set_node()
        ├── _update_polygon_editing_state()
        ├── _update_bone_list()
        ├── _update_available_modes()
        └── _center_view_on_draw()

_select_mode(MODE_POINTS)
├── mode_buttons[MODE_POINTS]->set_pressed(true)
├── 他モードのaction_buttonsを非表示
└── 該当モードのaction_buttonsを表示
    └── _set_action(ACTION_EDIT_POINT or ACTION_CREATE)

_canvas_input() [左クリック]
├── panner->gui_input()
├── [ACTION_CREATE]
│   ├── [新規作成] editing_points.push_back()
│   │   └── node->set_polygon() / set_uv()
│   └── [閉じる] undo_redo->create_action("Create Polygon & UV")
├── [ACTION_CREATE_INTERNAL]
│   └── undo_redo->create_action("Create Internal Vertex")
├── [ACTION_REMOVE_INTERNAL]
│   └── undo_redo->create_action("Remove Internal Vertex")
├── [ACTION_EDIT_POINT]
│   └── point_drag_index = 選択頂点
├── [ACTION_ADD_POLYGON]
│   └── polygon_create.push_back()
└── [ACTION_REMOVE_POLYGON]
    └── undo_redo->create_action("Remove Custom Polygon")

_canvas_input() [マウス移動]
├── [ACTION_EDIT_POINT] uv_new.set(point_drag_index, new_pos)
├── [ACTION_MOVE] 全頂点にdragを加算
├── [ACTION_ROTATE] 中心周りに回転
├── [ACTION_SCALE] 中心からスケール
└── [ACTION_PAINT/CLEAR_WEIGHT]
    └── node->set_bone_weights()

_canvas_draw()
├── [UV/CREATE] draw_texture()
├── [else] preview_polygon設定
├── [snap_show_grid] draw_line() グリッド
├── ポリゴン線描画
├── カスタムポリゴン描画
├── [weight_r] ウェイト矩形描画
└── [else] handle描画
    └── draw_texture(EditorPathSharpHandle)
```

### データフロー図

```
[Polygon2Dノード]
    |
    | (_set_node)
    v
[Polygon2DEditor]
    |
    +----> [editing_points] ----> [描画/操作]
    |           |
    |           | (set_polygon / set_uv)
    |           v
    |      [Polygon2D]
    |           - polygon
    |           - uv
    |           - internal_vertex_count
    |           - vertex_colors
    |           - bones
    |           - polygons
    |
    +----> [preview_polygon]
    |           |
    |           | (同期)
    |           v
    |      [Canvas描画]
    |
    +----> [Undo/Redo]
             |
             v
         [EditorUndoRedoManager]

[入力] ---> [_canvas_input()]
              |
              +---> [ドラッグ] ---> [editing_points更新]
              |                         |
              |                         v
              +---> [確定] -----> [Undo/Redo登録]
```

### 関連ファイル一覧

| ファイル | 役割 |
|----------|------|
| `editor/scene/2d/polygon_2d_editor_plugin.h` | エディタクラス定義 |
| `editor/scene/2d/polygon_2d_editor_plugin.cpp` | エディタ実装 |
| `editor/scene/2d/abstract_polygon_2d_editor.h` | 基底クラス定義 |
| `editor/scene/2d/abstract_polygon_2d_editor.cpp` | 基底クラス実装 |
| `scene/2d/polygon_2d.h` | Polygon2Dノード定義 |
| `scene/2d/polygon_2d.cpp` | Polygon2Dノード実装 |
| `scene/2d/skeleton_2d.h` | Skeleton2D定義 |
| `editor/docks/editor_dock.h` | EditorDock基底 |
| `editor/gui/editor_zoom_widget.h` | ズームウィジェット |
| `scene/gui/view_panner.h` | パン操作 |
