# 画面設計書 5-スクリプトエディタ

## 概要

本ドキュメントは、Godot EngineにおけるGDScript/C#等のスクリプト編集画面の設計仕様を記載する。

### 本画面の処理概要

スクリプトエディタは、GDScript、C#、GDExtensionなど各種スクリプト言語のコードを編集するための統合開発環境（IDE）機能を提供する画面である。コード補完、シンタックスハイライト、エラー表示、ブレークポイント設定などの機能を備える。

**業務上の目的・背景**：ゲームロジックの実装において、効率的なコーディング環境を提供する。外部エディタを使用せずに、Godot内で完結したスクリプト開発を可能にし、シーン編集との密接な連携を実現する。

**画面へのアクセス方法**：エディタメイン画面上部の「Script」タブをクリック、またはF3キーを押す。スクリプトファイルをダブルクリック、またはノードにアタッチされたスクリプトを開くことでも遷移する。

**主要な操作・処理内容**：
1. スクリプトファイルの作成・編集・保存
2. シンタックスハイライト（言語固有）
3. コード補完（オートコンプリート）
4. エラー・警告のリアルタイム表示
5. ブレークポイントの設定
6. 検索・置換（ファイル内、プロジェクト全体）
7. 定義へのジャンプ（Go to Definition）
8. ドキュメント参照（ヘルプ統合）
9. 複数スクリプトのタブ管理
10. シグナル接続先のコード参照

**画面遷移**：エディタメイン画面内のタブとして表示。2D/3D/AssetLibタブと相互切り替え可能。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 42 | GDScript | 主機能 | GDScriptコードの編集・構文ハイライト・補完 |
| 43 | C#サポート | 主機能 | C#スクリプトの編集対応 |
| 46 | スクリプトエディタ | 主機能 | コード編集・検索・置換・ジャンプ機能 |
| 5 | 信号システム（シグナル） | 補助機能 | シグナル接続先のコード参照・ジャンプ |

## 画面種別

編集 / コードエディタ

## URL/ルーティング

該当なし（デスクトップアプリケーション内のタブ）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| スクリプトコード | 入出力 | String | - | 編集中のソースコード |
| カーソル位置 | 入力 | Vector2i | - | 行・列位置 |
| 選択範囲 | 入力 | Range | - | テキスト選択範囲 |
| ブレークポイント | 入力 | Array[int] | - | 設定された行番号 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| コードエリア | CodeEdit | ソースコード表示・編集領域 |
| 行番号 | LineNumberArea | 行番号表示 |
| スクリプトタブ | TabBar | 開いているスクリプト一覧 |
| メンバー一覧 | ItemList | クラスのメンバー一覧 |
| 検索バー | HBoxContainer | 検索・置換UI |
| ミニマップ | CodeEdit | コード全体のサムネイル |

## イベント仕様

### 1-コード入力

文字入力時、EditorStandardSyntaxHighlighterがリアルタイムでハイライト処理を実行。予約語、型名、関数名などに色付け。

### 2-コード補完

Ctrl+Spaceまたは自動で補完候補を表示。ScriptLanguage::complete_code()が候補を生成し、ポップアップで表示。

### 3-保存

Ctrl+Sでスクリプトを保存。ResourceSaver::saveでファイルに書き込み、変更フラグをクリア。

### 4-ブレークポイント設定

行番号領域をクリック、またはF9キーでブレークポイントをトグル。デバッガ実行時に該当行で停止。

### 5-定義へジャンプ

シンボル上でCtrl+クリック、またはF12で定義箇所にジャンプ。ScriptLanguage::lookup_code()で定義を検索。

### 6-検索

Ctrl+Fで検索バーを表示。リアルタイムで一致箇所をハイライト。Ctrl+Shift+Fでプロジェクト全体検索（Find in Files）。

### 7-置換

Ctrl+Hで置換モード。単一置換またはすべて置換を選択可能。

### 8-ドキュメント参照

シンボル上でShift+F1でヘルプドキュメントを表示。EditorHelpクラスがドキュメントを検索・表示。

## データベース更新仕様

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スクリプト保存 | *.gd/*.cs | UPDATE/CREATE | スクリプトファイルの保存 |
| ブレークポイント設定 | editor_layout.cfg | UPDATE | ブレークポイント情報の永続化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | エラー | Parse Error: xxx | 構文エラー検出時 |
| MSG002 | 警告 | Warning: xxx | 警告検出時 |
| MSG003 | 情報 | Script '%s' saved. | 保存成功時（トースト） |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 構文エラー | エラー箇所を赤線でマーク、エラーパネルに詳細表示 |
| ファイル書き込み失敗 | エラーダイアログ表示 |
| 外部ファイル変更検出 | リロード確認ダイアログ表示 |

## 備考

- ScriptEditorクラスがメインの実装
- 複数のシンタックスハイライターをサポート（GDScript、JSON、Markdown等）
- CodeEditコントロールを使用
- 外部エディタとの連携もサポート（設定で切り替え可能）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script_editor_plugin.h | `editor/script/script_editor_plugin.h` | ScriptEditorクラス構造 |
| 1-2 | script_text_editor.h | `editor/script/script_text_editor.h` | テキストエディタ実装 |

**読解のコツ**: EditorSyntaxHighlighterの継承関係が重要。

#### Step 2: シンタックスハイライトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script_editor_plugin.cpp | `editor/script/script_editor_plugin.cpp` | ハイライター実装 |

**主要処理フロー**:
1. **行81-113**: EditorSyntaxHighlighter基底クラス
2. **行116-230**: EditorStandardSyntaxHighlighter（キーワード色設定）
3. **行248-265**: EditorJSONSyntaxHighlighter
4. **行269-300**: EditorMarkdownSyntaxHighlighter

### プログラム呼び出し階層図

```
ScriptEditor
    │
    ├─ ScriptTextEditor (各タブ)
    │      ├─ CodeEdit (コード入力)
    │      └─ EditorSyntaxHighlighter
    │             ├─ EditorStandardSyntaxHighlighter
    │             ├─ EditorJSONSyntaxHighlighter
    │             └─ EditorMarkdownSyntaxHighlighter
    │
    ├─ FindInFiles (プロジェクト検索)
    │
    └─ EditorHelp (ドキュメント)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

キー入力 ──────────────▶ CodeEdit ───────────────▶ テキスト更新
                          │
                          ├──▶ SyntaxHighlighter ──▶ 色付け
                          │
                          ├──▶ ScriptLanguage ────▶ 補完候補
                          │
                          └──▶ ResourceSaver ─────▶ *.gd/*.cs 保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script_editor_plugin.cpp | `editor/script/script_editor_plugin.cpp` | ソース | スクリプトエディタ実装 |
| script_text_editor.cpp | `editor/script/script_text_editor.cpp` | ソース | テキストエディタ |
| code_editor.cpp | `editor/gui/code_editor.cpp` | ソース | CodeEdit基盤 |
| find_in_files.cpp | `editor/script/find_in_files.cpp` | ソース | 全体検索 |
| editor_help.cpp | `editor/doc/editor_help.cpp` | ソース | ヘルプドキュメント |
