# 画面設計書 51-パス3Dエディタ

## 概要

本ドキュメントは、Godot Engineエディターにおける「パス3Dエディタ」の画面設計を定義するものである。パス3Dエディタは、Path3Dノードを選択した際に3Dエディター上部に表示される専用ツールバーおよびギズモ操作機能を提供するエディタープラグインである。

### 本画面の処理概要

パス3Dエディタは、3D空間内でベジェ曲線ベースのパスを視覚的に作成・編集するための専門的なツールを提供する。Path3Dノードに関連付けられたCurve3Dリソースの制御点を直接操作し、滑らかな3Dパスを構築することができる。

**業務上の目的・背景**：3Dゲーム開発において、キャラクターやオブジェクトの移動経路、カメラのドリーパス、ローラーコースターのレールなど、滑らかな3D曲線パスが必要となる場面は多い。パス3Dエディタは、これらのパスをコードを書くことなく視覚的に作成・編集できるようにし、開発効率を大幅に向上させる。

**画面へのアクセス方法**：シーンツリードックまたは3Dビューポートにて、Path3Dノードを選択すると、3Dエディターのメニューパネル上部に専用ツールバーが自動的に表示される。

**主要な操作・処理内容**：
1. ポイント選択モード（Select Points）：カーブ上の制御点を選択して移動・操作する
2. コントロールポイント選択モード（Select Control Points）：イン/アウトハンドルを操作してカーブの曲率を調整する
3. チルト選択モード（Select Tilt Handles）：各制御点のチルト（傾き）角度を設定する
4. ポイント追加モード（Add Point）：空間にクリックして新規制御点を追加、または既存セグメントをクリックして分割する
5. ポイント削除モード（Delete Point）：不要な制御点を削除する
6. カーブのクローズ/オープン切り替え：パスを閉じたループにするかどうかを設定する
7. 全ポイントクリア：すべての制御点を一括削除する

**画面遷移**：エディタメイン画面（3Dエディター）上に統合されて表示される。Path3Dノードの選択解除によりツールバーは非表示となる。

**権限による表示制御**：特にロールベースの制御はない。エディター環境での利用が前提であり、すべてのユーザーが同等の機能にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 3Dレンダリング | 主機能 | Path3Dの3Dパス曲線編集 |
| 37 | 3Dナビゲーション | 補助機能 | 3Dパスフォロー設定のプレビュー |

## 画面種別

編集（3Dノード専用エディター）

## URL/ルーティング

デスクトップアプリケーションのため、URLベースのルーティングは存在しない。Path3Dノード選択時に自動的にアクティブ化される。

## 入出力項目

| 項目名 | 型 | 入力/出力 | 説明 |
|--------|------|----------|------|
| Curve3D | Resource | 入出力 | Path3Dに関連付けられた曲線リソース |
| point_position | Vector3 | 入出力 | 各制御点の3D座標 |
| point_in | Vector3 | 入出力 | 各制御点のイン方向ハンドル（相対座標） |
| point_out | Vector3 | 入出力 | 各制御点のアウト方向ハンドル（相対座標） |
| point_tilt | float | 入出力 | 各制御点のチルト角度（ラジアン） |
| closed | bool | 入出力 | カーブが閉じているかどうか |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|------|------|
| パスリボン | 3D表示 | カーブに沿った線状表示（魚骨状の方向表示付き） |
| 制御点ハンドル | 3D表示 | 各制御点の位置を示すハンドル（開始点：緑、終了点：赤、閉ループ時：黄） |
| イン/アウトハンドル | 3D表示 | ベジェ曲線の曲率を制御するハンドル |
| チルトディスク | 3D表示 | 各制御点のチルト角度を示す円形表示 |
| ツールバーボタン | UI | 各編集モード切替ボタン |

## イベント仕様

### 1-ポイント選択モード有効化

curve_editボタンを押下すると、ポイント選択モードがアクティブになる。このモードでは制御点を選択して3Dギズモで移動できる。Shift+クリックで複数選択、Cmd/Ctrl+クリックで新規ポイント追加、右クリックでポイント削除が可能。

### 2-コントロールポイント選択モード有効化

curve_edit_curveボタンを押下すると、イン/アウトハンドルの編集モードになる。Shift+クリックでハンドルをドラッグアウトできる。

### 3-チルト選択モード有効化

curve_edit_tiltボタンを押下すると、各制御点のチルト（傾き）角度を編集するモードになる。チルトディスクとハンドルが表示される。

### 4-ポイント追加モード有効化

curve_createボタンを押下すると、クリック位置に新規制御点を追加するモードになる。既存セグメント上をクリックするとそこで分割される。

### 5-ポイント削除モード有効化

curve_delボタンを押下すると、クリックした制御点を削除するモードになる。

### 6-カーブクローズ切り替え

curve_closedボタンを押下すると、カーブの開閉状態が切り替わる。2点以上の制御点がある場合のみ有効。

### 7-全ポイントクリア

curve_clear_pointsボタンを押下すると、確認ダイアログが表示され、確認後にすべての制御点が削除される。

### 8-ハンドルミラーオプション

Optionsメニューから「Mirror Handle Angles」「Mirror Handle Lengths」のオン/オフを切り替え可能。イン/アウトハンドルの編集時に反対側のハンドルを連動させるかどうかを制御する。

### 9-カーブ作成

Path3DノードにCurve3Dが設定されていない場合、「Create Curve」ボタンが表示される。押下すると新規Curve3Dリソースが作成されて割り当てられる。

## データベース更新仕様

本機能はデータベースを使用しない。編集内容はCurve3Dリソースおよびシーンファイル（.tscn/.scn）に保存される。

### 操作別データ影響一覧

| 操作（イベント） | 対象リソース | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ポイント追加 | Curve3D | UPDATE | add_point()によりポイント配列に新規点を追加 |
| ポイント削除 | Curve3D | UPDATE | remove_point()によりポイント配列から点を削除 |
| ポイント移動 | Curve3D | UPDATE | set_point_position()により座標を更新 |
| ハンドル編集 | Curve3D | UPDATE | set_point_in()/set_point_out()でハンドル位置を更新 |
| チルト編集 | Curve3D | UPDATE | set_point_tilt()でチルト角度を更新 |
| クローズ切替 | Curve3D | UPDATE | set_closed()で開閉状態を変更 |
| 全ポイントクリア | Curve3D | UPDATE | clear_points()で全ポイントを削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG_CLEAR_CONFIRM | 確認 | Remove all curve points? | 全ポイントクリアボタン押下時 |
| ACTION_SPLIT | 成功 | Split Path | パス分割操作完了時（Undo履歴用） |
| ACTION_ADD_POINT | 成功 | Add Point to Curve | ポイント追加完了時（Undo履歴用） |
| ACTION_REMOVE_POINT | 成功 | Remove Path Point | ポイント削除完了時（Undo履歴用） |
| ACTION_SET_POSITION | 成功 | Set Curve Point Position | ポイント移動完了時（Undo履歴用） |
| ACTION_SET_IN | 成功 | Set Curve In Position | インハンドル編集完了時（Undo履歴用） |
| ACTION_SET_OUT | 成功 | Set Curve Out Position | アウトハンドル編集完了時（Undo履歴用） |
| ACTION_SET_TILT | 成功 | Set Curve Point Tilt | チルト編集完了時（Undo履歴用） |
| ACTION_TOGGLE_CLOSED | 成功 | Toggle Open/Closed Curve | 開閉切替完了時（Undo履歴用） |
| ACTION_CLEAR_POINTS | 成功 | Clear Curve Points | 全ポイントクリア完了時（Undo履歴用） |
| ACTION_CREATE_CURVE | 成功 | Create Curve in Path3D | カーブ作成完了時（Undo履歴用） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Curve3Dが未設定 | ツールバー上に「Create Curve」ボタンのみ表示 |
| 制御点が2点未満でクローズ試行 | クローズ操作が無効化される |
| カメラ平面との交差計算失敗 | 操作がスキップされる（AFTER_GUI_INPUT_PASS） |

## 備考

- すべての編集操作はUndo/Redo対応（EditorUndoRedoManager経由）
- スナップ機能対応：Node3DEditorのスナップ設定（移動スナップ、回転スナップ）が有効な場合、それに従う
- Path3Dのdebug_colorプロパティでカスタムカラーを設定可能
- エディター設定の`editors/3d_gizmos/gizmo_settings/path3d_tilt_disk_size`でチルトディスクのサイズを調整可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Path3Dとその曲線データを保持するCurve3Dリソースの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | curve.h | `scene/resources/curve.h` | Curve3Dクラスの定義。ポイント配列、イン/アウトハンドル、チルトの管理方法 |
| 1-2 | path_3d.h | `scene/3d/path_3d.h` | Path3DノードとCurve3Dの関係、debug_colorプロパティ |

**読解のコツ**: Curve3Dは`Vector<Point>`形式でポイントを保持し、各Pointがposition, in, out, tiltを持つ構造を理解する。

#### Step 2: エントリーポイントを理解する

プラグインの登録とエディターへの統合方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | path_3d_editor_plugin.h | `editor/scene/3d/path_3d_editor_plugin.h` | クラス定義、ボタン変数、モード列挙型 |
| 2-2 | path_3d_editor_plugin.cpp | `editor/scene/3d/path_3d_editor_plugin.cpp` | コンストラクタでのUI構築 |

**主要処理フロー**:
1. **896-997行**: Path3DEditorPluginコンストラクタでツールバーUI構築
2. **734-738行**: edit()メソッドでPath3Dノード編集開始
3. **740-742行**: handles()で対象ノード判定
4. **744-751行**: make_visible()でツールバー表示/非表示制御

#### Step 3: ギズモ描画処理を理解する

3Dビューポート上でのパス表示とハンドル描画の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | path_3d_editor_plugin.cpp | `editor/scene/3d/path_3d_editor_plugin.cpp` | Path3DGizmo::redraw()メソッド（299-538行） |

**主要処理フロー**:
- **299-301行**: ギズモのクリアと材質取得
- **333-400行**: パスリボンと骨表示の描画
- **402-537行**: 編集モード時のハンドル描画

#### Step 4: 入力処理を理解する

マウス入力によるポイント追加・削除・編集の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | path_3d_editor_plugin.cpp | `editor/scene/3d/path_3d_editor_plugin.cpp` | forward_3d_gui_input()メソッド（561-732行） |

**主要処理フロー**:
- **594-686行**: 左クリック + 作成モードでのポイント追加/分割処理
- **688-728行**: 左クリック + 削除モードまたは右クリック + 編集モードでのポイント/ハンドル削除

#### Step 5: ハンドル操作を理解する

制御点やイン/アウトハンドルのドラッグ操作処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | path_3d_editor_plugin.cpp | `editor/scene/3d/path_3d_editor_plugin.cpp` | set_handle()メソッド（100-214行） |
| 5-2 | path_3d_editor_plugin.cpp | `editor/scene/3d/path_3d_editor_plugin.cpp` | commit_handle()メソッド（216-297行） |

**主要処理フロー**:
- **100-128行**: プライマリハンドル（制御点位置）の更新
- **130-213行**: セカンダリハンドル（イン/アウト/チルト）の更新
- **216-297行**: Undo/Redo用のアクション登録

### プログラム呼び出し階層図

```
Path3DEditorPlugin (エディタープラグイン)
    │
    ├─ Path3DGizmoPlugin (ギズモプラグイン)
    │      ├─ create_gizmo() → Path3DGizmo生成
    │      ├─ redraw() → ハンドル描画
    │      ├─ subgizmos_intersect_ray() → クリック判定
    │      ├─ get_subgizmo_transform() → 選択位置取得
    │      ├─ set_subgizmo_transform() → 位置更新
    │      └─ commit_subgizmos() → Undo登録
    │
    └─ Path3DGizmo (個別ギズモ)
           ├─ redraw() → パス/ハンドル描画
           ├─ get_handle_name() → ハンドル名取得
           ├─ get_handle_value() → 現在値取得
           ├─ set_handle() → ドラッグ中更新
           └─ commit_handle() → Undo登録
```

### データフロー図

```
[入力]                    [処理]                        [出力]

マウスクリック/ドラッグ
        │
        ▼
forward_3d_gui_input()
        │
        ├─[追加モード]──▶ Curve3D::add_point() ──▶ ポイント追加
        │
        ├─[削除モード]──▶ Curve3D::remove_point() ──▶ ポイント削除
        │
        └─[選択中ドラッグ]
              │
              ▼
        set_handle()
              │
              ├─[位置]──▶ Curve3D::set_point_position()
              ├─[イン]──▶ Curve3D::set_point_in()
              ├─[アウト]──▶ Curve3D::set_point_out()
              └─[チルト]──▶ Curve3D::set_point_tilt()
                    │
                    ▼
              commit_handle()
                    │
                    ▼
              EditorUndoRedoManager (履歴登録)
                    │
                    ▼
              redraw() (表示更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| path_3d_editor_plugin.cpp | `editor/scene/3d/path_3d_editor_plugin.cpp` | ソース | パス3Dエディター本体実装 |
| path_3d_editor_plugin.h | `editor/scene/3d/path_3d_editor_plugin.h` | ヘッダー | クラス定義、列挙型、メンバ変数 |
| path_3d.cpp | `scene/3d/path_3d.cpp` | ソース | Path3Dノード実装 |
| path_3d.h | `scene/3d/path_3d.h` | ヘッダー | Path3Dノード定義 |
| curve.cpp | `scene/resources/curve.cpp` | ソース | Curve3Dリソース実装 |
| curve.h | `scene/resources/curve.h` | ヘッダー | Curve3Dリソース定義 |
| node_3d_editor_plugin.cpp | `editor/scene/3d/node_3d_editor_plugin.cpp` | ソース | 3Dエディター基盤（スナップ等） |
| node_3d_editor_gizmos.cpp | `editor/scene/3d/node_3d_editor_gizmos.cpp` | ソース | ギズモ基底クラス実装 |
| editor_undo_redo_manager.cpp | `editor/editor_undo_redo_manager.cpp` | ソース | Undo/Redo管理 |
