# 画面設計書 54-マテリアルエディタ

## 概要

本ドキュメントは、Godot Engineエディターにおける「マテリアルエディタ」の画面設計を定義するものである。マテリアルエディタは、Materialリソース（StandardMaterial3D、ShaderMaterial、CanvasItemMaterial等）を選択した際にインスペクタードックの上部に表示される高機能なプレビューウィジェットを提供し、マテリアルの見え方を視覚的に確認できるエディタープラグインである。

### 本画面の処理概要

マテリアルエディタは、2Dおよび3Dマテリアルリソースのリアルタイムプレビューを提供する多機能ビューワーである。3Dマテリアル（Shader::MODE_SPATIAL）の場合は球体・ボックス・クワッドの3種類のプレビューメッシュを切り替えて確認でき、2Dマテリアル（Shader::MODE_CANVAS_ITEM）の場合はColorRectでプレビューが表示される。ライトの切り替えや回転操作により、様々な条件下でのマテリアルの見え方を確認可能。

**業務上の目的・背景**：3Dゲーム・アプリケーション開発において、マテリアルはオブジェクトの外観を決定する重要な要素である。マテリアルエディタは、プロパティを変更した際の見え方をリアルタイムで確認できるため、マテリアル調整の効率を大幅に向上させる。特にPBR（物理ベースレンダリング）マテリアルでは、様々な形状や照明条件下での確認が重要であり、複数のプレビューメッシュ切り替え機能がこれを支援する。

**画面へのアクセス方法**：ファイルシステムドックでマテリアルリソースファイル（.material、.res、.tres等）を選択するか、インスペクタードックでMaterialリソースプロパティをクリックしてリソースを展開すると、インスペクター上部にプレビューが自動的に表示される。

**主要な操作・処理内容**：
1. マテリアルのリアルタイムプレビュー表示：選択されたマテリアルを3Dメッシュまたは2D矩形に適用してレンダリング
2. 回転操作：マウスの左ボタンドラッグでプレビューを回転させて確認（3Dマテリアルのみ）
3. プレビューメッシュ切り替え：球体/ボックス/クワッドの3種類から選択（3Dマテリアルのみ）
4. ライト1切り替え：メインのディレクショナルライトのオン/オフを切り替え
5. ライト2切り替え：サブのディレクショナルライトのオン/オフを切り替え
6. ShaderMaterialへの変換：ParticleProcessMaterialやCanvasItemMaterialをShaderMaterialに変換

**画面遷移**：エディタメイン画面のインスペクタードック内に統合されて表示される。Materialリソースの選択解除によりプレビューは非表示となる。この画面から他の画面への遷移は発生しない。

**権限による表示制御**：特にロールベースの制御はない。エディター環境での利用が前提であり、すべてのユーザーが同等の機能にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | シェーダー | 主機能 | マテリアル・シェーダーのプレビュー表示 |
| 7 | 3Dレンダリング | 補助機能 | マテリアル適用3Dプレビュー |

## 画面種別

プレビュー/ビューワー（リソースプレビュー）

## URL/ルーティング

デスクトップアプリケーションのため、URLベースのルーティングは存在しない。Materialリソース選択時に自動的にアクティブ化される。

## 入出力項目

| 項目名 | 型 | 入力/出力 | 説明 |
|--------|------|----------|------|
| material | Ref<Material> | 入力 | プレビュー対象のマテリアルリソース |
| env | Ref<Environment> | 入力 | プレビュー用環境設定（Sky、背景色等） |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|------|------|
| 3Dプレビュー領域 | SubViewportContainer | 3Dマテリアルを表示するビューポート |
| 2Dプレビュー領域 | SubViewportContainer | 2Dマテリアル（CanvasItem）を表示するビューポート |
| エラー表示領域 | VBoxContainer | 未対応シェーダーモード時のエラーメッセージ表示 |
| 球体ボタン | Button | 球体プレビューメッシュ選択ボタン |
| ボックスボタン | Button | ボックスプレビューメッシュ選択ボタン |
| クワッドボタン | Button | クワッド（平面）プレビューメッシュ選択ボタン |
| ライト1ボタン | Button | メインライトの切り替えトグルボタン |
| ライト2ボタン | Button | サブライトの切り替えトグルボタン |
| チェッカーボード背景 | 描画 | 透明度確認用のチェッカーボード模様 |

## イベント仕様

### 1-マテリアルプレビュー表示

Materialリソースが選択されると、edit()メソッドが呼び出され、シェーダーモードに応じて以下の処理が実行される：

**Shader::MODE_SPATIAL（3Dマテリアル）の場合**：
- 3Dプレビューレイアウトが表示される
- 選択中のプレビューメッシュ（球体/ボックス/クワッド）にマテリアルが適用される
- コントロールボタンが表示される

**Shader::MODE_CANVAS_ITEM（2Dマテリアル）の場合**：
- 2DプレビューレイアウトにColorRectが表示される
- ColorRectにマテリアルが設定される
- コントロールボタンは非表示

**その他のモードの場合**：
- エラーメッセージ「Preview is not available for this shader mode.」が表示される

### 2-回転操作（3Dマテリアルのみ）

プレビュー領域上でマウス左ボタンをドラッグすると、gui_input()メソッドにより回転が更新される：
- X軸回転：マウスのY方向移動 × 0.01
- Y軸回転：マウスのX方向移動 × 0.01
- クワッド選択時は回転が±80度にクランプされる（常に見える範囲に制限）
- 回転設定はプロジェクトメタデータに保存され、マテリアル切り替え時に復元される

### 3-球体プレビュー選択

球体ボタンをクリックすると、SphereMeshでマテリアルがプレビューされる。回転は初期値（-15度、30度）にリセットされ、設定が保存される。

### 4-ボックスプレビュー選択

ボックスボタンをクリックすると、BoxMeshでマテリアルがプレビューされる。回転は初期値にリセットされ、設定が保存される。

### 5-クワッドプレビュー選択

クワッドボタンをクリックすると、QuadMesh（平面）でマテリアルがプレビューされる。回転は(0, 0)にリセットされ、設定が保存される。クワッド選択時は回転範囲が制限される。

### 6-ライト1切り替え

ライト1ボタンをトグルすると、メインのDirectionalLight3D（斜め上からの白色光）の表示/非表示が切り替わる。

### 7-ライト2切り替え

ライト2ボタンをトグルすると、サブのDirectionalLight3D（上からの灰色光）の表示/非表示が切り替わる。

### 8-テクスチャ設定時の自動調整

BaseMaterial3Dのroughness_textureまたはmetallic_textureに新規テクスチャを設定した際、対応するroughness/metallicプロパティが自動的に1.0に設定される（便利機能）。

## データベース更新仕様

本機能はデータベースを使用しない。プレビュー操作自体はリソースデータを変更しない読み取り専用の機能である。ただし、テクスチャ設定時の自動調整機能はマテリアルリソースを変更する。

### 操作別データ影響一覧

| 操作（イベント） | 対象リソース | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| マテリアルプレビュー | なし | SELECT（読み取りのみ） | マテリアルデータを読み取ってレンダリング |
| 回転操作 | プロジェクトメタデータ | UPDATE | 回転設定を保存 |
| メッシュ切り替え | プロジェクトメタデータ | UPDATE | 選択メッシュ設定を保存 |
| ライト切り替え | なし | なし | UIステートのみ変更 |
| テクスチャ自動調整 | Material | UPDATE | roughness/metallicプロパティを1.0に設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG_UNSUPPORTED_MODE | 情報 | Preview is not available for this shader mode. | 非対応シェーダーモード時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| マテリアルがnull | プレビューが非表示になる（hide()） |
| シェーダーモードがSPATIAL/CANVAS_ITEM以外 | エラーレイアウトを表示、コントロール非表示 |
| CanvasItemMaterialが未初期化 | ShaderMaterial変換がスキップされる |

## 備考

- プレビュービューポートはMSAA 4X設定かつ透明背景でレンダリングされる
- 物理ライトユニット使用時（プロジェクト設定）は、CameraAttributesPracticalがカメラに設定される
- 最小サイズは 1 × 150 ピクセル（EDSCALE適用後）
- カメラは20度の低FOVで設定され、歪みを最小限に抑えている
- プレビューメッシュと回転設定はプロジェクトメタデータに保存され、セッション間で保持される
- 背景にはチェッカーボードが描画され、透明度のあるマテリアルの確認が容易
- ParticleProcessMaterial、CanvasItemMaterialからShaderMaterialへの変換プラグインが提供される
- Environment設定にはSkyが含まれ、反射プローブなしでも環境反射が機能する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Materialリソースの基本構造とシェーダーモードを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | material.h | `scene/resources/material.h` | Materialクラス、get_shader_mode()、get_shader_rid() |
| 1-2 | shader.h | `scene/resources/shader.h` | Shader::Mode列挙型（MODE_SPATIAL, MODE_CANVAS_ITEM等） |

**読解のコツ**: Materialはシェーダーモードに応じて2D/3D用途が決まり、それに応じたプレビュー方法が選択されることを理解する。

#### Step 2: エントリーポイントを理解する

プラグインの登録とインスペクターへの統合方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | material_editor_plugin.h | `editor/scene/material_editor_plugin.h` | クラス定義、MaterialEditor、EditorInspectorPluginMaterial |
| 2-2 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | can_handle(), parse_begin() |

**主要処理フロー**:
1. **403-410行**: can_handle()でMaterialオブジェクト判定、シェーダーモードチェック
2. **412-422行**: parse_begin()でMaterialEditorをインスペクターに追加

#### Step 3: プレビューUI構築を理解する

2D/3D両対応のプレビューUIの構築を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | MaterialEditor()コンストラクタ（233-399行） |

**主要処理フロー**:
- **238-257行**: 2Dプレビュー用SubViewport/ColorRect構築
- **259-272行**: エラー表示レイアウト構築
- **276-331行**: 3Dプレビュー用Viewport/Camera/Lights/Meshes構築
- **333-395行**: コントロールボタン（メッシュ選択、ライト切り替え）構築

#### Step 4: マテリアル設定処理を理解する

シェーダーモードに応じたプレビュー切り替えを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | edit()メソッド（155-190行） |

**主要処理フロー**:
- **160-161行**: シェーダーモード取得
- **163-170行**: CANVAS_ITEM（2D）モード処理
- **171-178行**: SPATIAL（3D）モード処理
- **179-185行**: その他モード（エラー表示）

#### Step 5: 入力処理を理解する

マウス操作による回転処理と設定保存を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | gui_input()（82-99行） |
| 5-2 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | _store_rotation_metadata()（143-146行） |

**主要処理フロー**:
- **82-98行**: マウスドラッグ検出と回転値更新、クワッド時の制限
- **143-146行**: EditorSettingsへの回転設定保存

#### Step 6: リソース変換プラグインを理解する

マテリアルのShaderMaterial変換機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | make_shader_material()（53-80行） |
| 6-2 | material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | ParticleProcessMaterialConversionPlugin（476-487行） |

**主要処理フロー**:
- **53-80行**: シェーダーコード取得とShaderMaterial生成
- **476-487行**: ParticleProcessMaterial変換プラグイン
- **489-501行**: CanvasItemMaterial変換プラグイン

### プログラム呼び出し階層図

```
MaterialEditorPlugin (エディタープラグイン)
    │
    └─ EditorInspectorPluginMaterial (インスペクタープラグイン)
           ├─ can_handle() → Material判定、シェーダーモードチェック
           │
           ├─ parse_begin()
           │      └─ MaterialEditor (プレビューウィジェット)
           │             ├─ コンストラクタ → UI構築
           │             │      ├─ 2D用SubViewport/ColorRect
           │             │      ├─ 3D用SubViewport/Camera/Lights/Meshes
           │             │      └─ コントロールボタン
           │             │
           │             ├─ edit() → マテリアル設定
           │             │      ├─ シェーダーモード判定
           │             │      ├─ SPATIAL → 3Dプレビュー
           │             │      ├─ CANVAS_ITEM → 2Dプレビュー
           │             │      └─ その他 → エラー表示
           │             │
           │             ├─ gui_input() → 回転操作
           │             │      └─ _update_rotation()
           │             │
           │             ├─ _on_sphere_switch_pressed()
           │             ├─ _on_box_switch_pressed()
           │             ├─ _on_quad_switch_pressed()
           │             ├─ _on_light_1_switch_pressed()
           │             └─ _on_light_2_switch_pressed()
           │
           └─ _undo_redo_inspector_callback() → テクスチャ自動調整

ParticleProcessMaterialConversionPlugin
    └─ convert() → make_shader_material()

CanvasItemMaterialConversionPlugin
    └─ convert() → make_shader_material()
```

### データフロー図

```
[入力]                    [処理]                        [出力]

Materialリソース選択
        │
        ▼
EditorInspectorPluginMaterial::can_handle()
        │
        ├─ get_shader_mode()
        │
        ▼
parse_begin()
        │
        ▼
MaterialEditor::edit()
        │
        ├─[MODE_SPATIAL]
        │      ├─ sphere/box/quad_instance->set_material_override()
        │      └─ layout_3d表示
        │
        ├─[MODE_CANVAS_ITEM]
        │      ├─ rect_instance->set_material()
        │      └─ layout_2d表示
        │
        └─[その他]
               └─ layout_error表示（エラーメッセージ）

マウスドラッグ（3Dモード時）
        │
        ▼
gui_input()
        │
        ├─ rot更新（クワッド時は±80度にクランプ）
        │
        ├─ _update_rotation()
        │      └─ rotation->set_transform()
        │
        └─ _store_rotation_metadata()
               └─ EditorSettings保存

テクスチャ設定（BaseMaterial3D）
        │
        ▼
_undo_redo_inspector_callback()
        │
        └─ roughness/metallic = 1.0 設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| material_editor_plugin.cpp | `editor/scene/material_editor_plugin.cpp` | ソース | マテリアルエディター本体実装 |
| material_editor_plugin.h | `editor/scene/material_editor_plugin.h` | ヘッダー | クラス定義 |
| material.cpp | `scene/resources/material.cpp` | ソース | Materialリソース基底クラス |
| material.h | `scene/resources/material.h` | ヘッダー | Materialリソース定義 |
| base_material_3d.cpp | `scene/resources/3d/base_material_3d.cpp` | ソース | 3Dマテリアル基底実装 |
| shader_material.cpp | `scene/resources/shader_material.cpp` | ソース | ShaderMaterial実装 |
| canvas_item_material.cpp | `scene/resources/canvas_item_material.cpp` | ソース | CanvasItemMaterial実装 |
| particle_process_material.cpp | `scene/resources/particle_process_material.cpp` | ソース | ParticleProcessMaterial実装 |
| primitive_meshes.cpp | `scene/resources/3d/primitive_meshes.cpp` | ソース | SphereMesh/BoxMesh/QuadMesh実装 |
| environment.cpp | `scene/resources/environment.cpp` | ソース | Environment設定 |
| editor_settings.cpp | `editor/settings/editor_settings.cpp` | ソース | プロジェクトメタデータ保存 |
| editor_resource_conversion_plugin.cpp | `editor/plugins/editor_resource_conversion_plugin.cpp` | ソース | リソース変換プラグイン基盤 |
