# 画面設計書 6-アセットライブラリ

## 概要

本ドキュメントは、Godot Engineにおけるオンラインアセットライブラリ閲覧・ダウンロード画面の設計仕様を記載する。

### 本画面の処理概要

アセットライブラリは、Godot Asset Libraryからアセット（テンプレート、プラグイン、スクリプト、素材など）を検索、閲覧、ダウンロード、インストールするためのブラウザ機能を提供する画面である。

**業務上の目的・背景**：コミュニティが作成したアセットを簡単に発見・導入できるようにし、開発の効率化と学習を支援する。外部ブラウザを使用せずにGodot内からアセットを直接プロジェクトにインストールできる。

**画面へのアクセス方法**：エディタメイン画面上部の「AssetLib」タブをクリック。プロジェクトマネージャーからも「Asset Library」ボタンでアクセス可能。

**主要な操作・処理内容**：
1. アセットの検索（キーワード、カテゴリ、サポートバージョン）
2. アセット詳細の閲覧（説明、スクリーンショット、ライセンス）
3. アセットのダウンロード
4. アセットのインストール（ファイル展開、配置先選択）
5. カテゴリブラウジング
6. 作者によるフィルタリング
7. ソート（人気順、最新順、名前順）

**画面遷移**：エディタメイン画面内のタブとして表示。2D/3D/Scriptタブと相互切り替え可能。

**権限による表示制御**：ネットワーク設定（オフラインモード）により機能制限あり。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | リソース管理 | 主機能 | アセットのダウンロード・インストール処理 |
| 38 | HTTPリクエスト | API連携 | Asset LibraryサーバーへのHTTP通信 |

## 画面種別

一覧 / ブラウザ

## URL/ルーティング

API通信先：https://godotengine.org/asset-library/api/

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 検索キーワード | 入力 | String | - | アセット検索用キーワード |
| カテゴリフィルター | 入力 | int | - | カテゴリID |
| サポートバージョン | 入力 | String | - | Godotバージョンフィルター |
| ソート順 | 入力 | Enum | - | 並び替え条件 |
| アセット一覧 | 出力 | Array | - | 検索結果 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| アセットカード | EditorAssetLibraryItem | アセット概要表示 |
| アセット詳細 | EditorAssetLibraryItemDescription | 詳細情報ポップアップ |
| 検索バー | LineEdit | キーワード入力 |
| カテゴリドロップダウン | OptionButton | カテゴリ選択 |
| ソートドロップダウン | OptionButton | ソート選択 |
| ページネーション | HBoxContainer | ページ切り替え |

## イベント仕様

### 1-検索実行

検索ボタン押下またはEnterキーで検索実行。HTTPRequestでAPIにクエリを送信し、JSONレスポンスを解析して一覧を更新。

### 2-アセット選択

アセットカードをクリックすると詳細ダイアログを表示。追加のAPIリクエストで詳細情報、スクリーンショット、ダウンロードURLを取得。

### 3-ダウンロード

「Download」ボタン押下でアセットZIPファイルをダウンロード。進捗バーで状況表示。

### 4-インストール

ダウンロード完了後、EditorAssetInstallerダイアログを表示。インストール先ディレクトリとファイル選択を行い、ZIPを展開。

### 5-カテゴリ変更

カテゴリドロップダウン変更で自動的に検索を再実行。

### 6-ページ切り替え

ページ番号クリックで該当ページの結果を取得。

## データベース更新仕様

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インストール | res://配下 | CREATE | アセットファイルの展開・配置 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | エラー | Request failed, return code: xxx | HTTP通信失敗時 |
| MSG002 | 情報 | Asset downloaded successfully. | ダウンロード成功時 |
| MSG003 | 警告 | Network mode is offline. | オフラインモード時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ネットワークエラー | エラーメッセージ表示、リトライボタン表示 |
| APIレスポンスエラー | エラーメッセージ表示 |
| ダウンロード中断 | 部分ファイル削除 |
| インストール先競合 | 上書き確認ダイアログ表示 |

## 備考

- EditorAssetLibraryクラスがメインの実装
- HTTPRequestはスレッド使用可能（設定依存）
- プロキシ設定に対応
- コミュニティサポート有効/無効の切り替え可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | asset_library_editor_plugin.h | `editor/asset_library/asset_library_editor_plugin.h` | EditorAssetLibraryクラス構造 |

**読解のコツ**: IMAGE_QUEUE_* enumでサムネイル・スクリーンショットのキュー管理を理解。

#### Step 2: UIコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | asset_library_editor_plugin.cpp | `editor/asset_library/asset_library_editor_plugin.cpp` | アセットカード、詳細ダイアログ |

**主要処理フロー**:
1. **行50-57**: setup_http_request()でHTTPリクエスト設定
2. **行59-71**: EditorAssetLibraryItem::configure()でカード設定
3. **行163-245**: EditorAssetLibraryItemコンストラクタ（UI構築）
4. **行249-290**: EditorAssetLibraryItemDescription::set_image()

### プログラム呼び出し階層図

```
EditorAssetLibrary
    │
    ├─ EditorAssetLibraryItem (アセットカード)
    │
    ├─ EditorAssetLibraryItemDescription (詳細ダイアログ)
    │
    ├─ HTTPRequest (API通信)
    │      └─ setup_http_request() (プロキシ設定)
    │
    └─ EditorAssetInstaller (インストーラ)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

検索キーワード ────────▶ HTTPRequest ─────────────▶ API通信
                           │
                           ▼
JSONレスポンス ◀──────── API Server ◀────────────── クエリ
       │
       ▼
EditorAssetLibrary ─────▶ アセット一覧表示
       │
       ▼
ダウンロード ──────────▶ ZIPファイル ───────────▶ インストール
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| asset_library_editor_plugin.cpp | `editor/asset_library/asset_library_editor_plugin.cpp` | ソース | アセットライブラリ実装 |
| editor_asset_installer.cpp | `editor/asset_library/editor_asset_installer.cpp` | ソース | インストーラ |
| http_request.cpp | `scene/main/http_request.cpp` | ソース | HTTP通信 |
