# 画面設計書 7-ファイルシステムドック

## 概要

本ドキュメントは、Godot Engineにおけるプロジェクトファイル一覧表示ドック画面の設計仕様を記載する。

### 本画面の処理概要

ファイルシステムドックは、プロジェクトのres://配下にあるすべてのファイルとディレクトリを階層的またはフラットに表示し、ファイル操作（作成、削除、移動、名前変更）を行うためのドックパネルである。

**業務上の目的・背景**：プロジェクト内のアセット（シーン、スクリプト、テクスチャ、オーディオ等）を視覚的に管理できるようにする。ドラッグ&ドロップでのシーンへの配置、ファイル検索、お気に入り登録などにより、効率的なファイルナビゲーションを実現する。

**画面へのアクセス方法**：エディタメイン画面の左下に常時表示されるドックパネル。「View > FileSystem」メニューで表示/非表示を切り替え可能。

**主要な操作・処理内容**：
1. ディレクトリツリーの展開/折りたたみ
2. ファイル一覧表示（リスト/グリッド切り替え）
3. ファイル検索・フィルタリング
4. ファイルの作成（スクリプト、シーン、シェーダー等）
5. ディレクトリの作成
6. ファイル/ディレクトリの名前変更
7. ファイル/ディレクトリの削除
8. ドラッグ&ドロップでの移動・コピー
9. お気に入り登録
10. ファイルエクスプローラーで表示

**画面遷移**：ドックとして常時表示。ファイル選択によりインポートドックと連携。ファイルダブルクリックで対応エディタに遷移。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | リソース管理 | 主機能 | res://配下のファイル・フォルダ管理 |
| 48 | ファイルシステムドック | 主機能 | プロジェクトファイルのブラウジング・検索 |
| 65 | 画像インポート | 遷移先機能 | 画像ファイル選択時のインポート設定連携 |

## 画面種別

ドック / ファイルブラウザ

## URL/ルーティング

該当なし（ファイルシステムパスはres://で始まる）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 検索キーワード | 入力 | String | - | ファイル名フィルター |
| 選択ファイル | 入出力 | String[] | - | 選択中のファイルパス |
| 表示モード | 入力 | Enum | - | ツリー/リスト/グリッド |
| ソート順 | 入力 | Enum | - | 名前/更新日時/種類 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ディレクトリツリー | Tree | フォルダ階層表示 |
| ファイルリスト | ItemList | ファイル一覧（リスト/グリッド） |
| 検索バー | LineEdit | ファイル検索入力 |
| パンくずリスト | HBoxContainer | 現在パス表示 |
| お気に入り | Tree | お気に入りフォルダ一覧 |

## イベント仕様

### 1-ファイル選択

ファイルをクリックで選択。Ctrl+クリックで複数選択、Shift+クリックで範囲選択。選択変更時にインポートドックを更新。

### 2-ファイルダブルクリック

シーンファイル(.tscn/.scn)はシーンタブで開く。スクリプト(.gd/.cs)はスクリプトエディタで開く。リソースはインスペクターで開く。

### 3-右クリックメニュー

コンテキストメニューを表示。操作項目：新規作成、名前変更、移動、複製、削除、パスコピー、ファイルエクスプローラーで表示。

### 4-ドラッグ&ドロップ

ファイルをドラッグしてディレクトリにドロップで移動。Ctrlキー押下中はコピー。シーンツリードックにドロップでシーンにインスタンス化。

### 5-新規作成

右クリックメニューまたはツールバーから新規スクリプト、シーン、シェーダー、リソースを作成。対応するダイアログを表示。

### 6-検索入力

検索バーに入力するとリアルタイムでファイルをフィルタリング。サブディレクトリ内も検索対象。

### 7-お気に入り登録

ディレクトリを右クリック→「Add to Favorites」でお気に入りセクションに追加。

## データベース更新仕様

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイル作成 | res://配下 | CREATE | 新規ファイル作成 |
| ファイル削除 | res://配下 | DELETE | ファイル削除（ゴミ箱移動） |
| 名前変更 | res://配下 | UPDATE | ファイル名変更 |
| 移動 | res://配下 | UPDATE | ファイルパス変更 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 確認 | Move to Trash? | ファイル削除時 |
| MSG002 | エラー | Cannot rename: xxx | 名前変更失敗時 |
| MSG003 | 確認 | Overwrite file? | 同名ファイル存在時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ファイルアクセス拒否 | エラーダイアログ表示 |
| 無効なファイル名 | 警告表示、操作中止 |
| リンク先不明 | リンクオーバーレイアイコン表示 |

## 備考

- FileSystemDockクラスがメインの実装
- EditorFileSystemと連携してファイルスキャン
- カスタムフォルダカラー設定可能
- シンボリックリンク対応（オーバーレイアイコン表示）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | filesystem_dock.h | `editor/docks/filesystem_dock.h` | FileSystemDockクラス構造、DisplayMode enum |

**読解のコツ**: FILE_SORT_* enumでソートオプション、assigned_folder_colorsでカスタムカラー管理。

#### Step 2: ツリー構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | filesystem_dock.cpp | `editor/docks/filesystem_dock.cpp` | _create_tree()でディレクトリツリー構築 |

**主要処理フロー**:
1. **行71-77**: FileSystemTree::make_custom_tooltip()
2. **行79-85**: FileSystemList::make_custom_tooltip()
3. **行206-221**: _get_tree_item_icon()でアイコン取得
4. **行223-286**: _create_tree()で再帰的にツリー構築

### プログラム呼び出し階層図

```
FileSystemDock (singleton)
    │
    ├─ FileSystemTree (ディレクトリツリー)
    │
    ├─ FileSystemList (ファイル一覧)
    │      └─ popup_editor (名前編集)
    │
    ├─ EditorFileSystem (ファイルスキャン)
    │
    └─ インポートドック連携
           └─ ImportDock
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ファイルシステム ────────▶ EditorFileSystem ────────▶ ファイル情報
                            │
                            ▼
                     FileSystemDock
                            │
                            ├──▶ FileSystemTree ──────▶ ツリー表示
                            │
                            └──▶ FileSystemList ──────▶ 一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| filesystem_dock.cpp | `editor/docks/filesystem_dock.cpp` | ソース | ファイルシステムドック実装 |
| filesystem_dock.h | `editor/docks/filesystem_dock.h` | ヘッダ | クラス定義 |
| editor_file_system.cpp | `editor/file_system/editor_file_system.cpp` | ソース | ファイルスキャン |
| directory_create_dialog.cpp | `editor/gui/directory_create_dialog.cpp` | ソース | ディレクトリ作成ダイアログ |
| scene_create_dialog.cpp | `editor/scene/scene_create_dialog.cpp` | ソース | シーン作成ダイアログ |
