# 画面設計書 8-シーンツリードック

## 概要

本ドキュメントは、Godot Engineにおける現在編集中シーンのノード階層表示ドック画面の設計仕様を記載する。

### 本画面の処理概要

シーンツリードックは、現在編集中のシーンに含まれるすべてのノードを階層構造（ツリー形式）で表示し、ノードの追加・削除・並べ替え・親変更などの構造操作を行うためのドックパネルである。

**業務上の目的・背景**：シーン内のノード構造を視覚的に把握し、効率的に編集できるようにする。ノードの親子関係、スクリプトのアタッチ状態、表示/非表示などをツリービューで一覧表示し、シーン構築作業を支援する。

**画面へのアクセス方法**：エディタメイン画面の左側に常時表示されるドックパネル。「View > Scene」メニューで表示/非表示を切り替え可能。

**主要な操作・処理内容**：
1. ノードの追加（ダイアログから型を選択）
2. ノードの削除
3. ノードの複製
4. ノードのドラッグ&ドロップによる移動・親変更
5. ノードの名前変更
6. ノードの展開/折りたたみ
7. ノードの選択（単一/複数）
8. シーンのインスタンス化
9. スクリプトのアタッチ/デタッチ
10. シグナル接続へのジャンプ

**画面遷移**：ドックとして常時表示。ノード選択でインスペクターと連動。シグナルアイコンクリックでシグナルドックへ遷移。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | シーンツリー管理 | 主機能 | ノード階層の表示・編集・ドラッグ移動 |
| 2 | ノードシステム | 主機能 | ノードの追加・削除・複製・親変更 |
| 5 | 信号システム（シグナル） | 遷移先機能 | シグナルドックへの遷移・シグナル接続 |

## 画面種別

ドック / ツリービュー

## URL/ルーティング

該当なし

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 選択ノード | 入出力 | Node[] | - | 選択中のノード |
| フィルター | 入力 | String | - | ノード名フィルター |
| 編集中シーン | 入力 | PackedScene | - | 表示対象のシーン |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ノードツリー | Tree | ノード階層表示 |
| フィルターバー | LineEdit | ノード検索入力 |
| ツールバー | HBoxContainer | 追加/削除ボタン等 |
| ノードアイコン | Texture2D | ノード型別アイコン |
| 状態アイコン | Texture2D | スクリプト/シグナル/グループ等 |

## イベント仕様

### 1-ノード選択

ツリー上でノードをクリック。EditorSelectionに追加され、インスペクターに反映。Ctrl+クリックで複数選択。

### 2-ノード追加

ツールバーの「+」ボタンまたは右クリックメニューから「Add Child Node」。CreateDialogでノード型を選択し、選択ノードの子として追加。

### 3-ノード削除

選択ノードを右クリック→「Delete」またはDeleteキー。確認なしで削除（Undo可能）。

### 4-ノード移動（ドラッグ&ドロップ）

ノードをドラッグして別ノード上にドロップで親変更。ノード間にドロップで兄弟順序変更。

### 5-名前変更

ノードをダブルクリック、または右クリック→「Rename」。インラインで名前編集。

### 6-シーンインスタンス化

右クリック→「Instantiate Child Scene」でシーンファイルを選択し、子ノードとしてインスタンス化。

### 7-スクリプトアタッチ

右クリック→「Attach Script」でスクリプト作成ダイアログを表示。既存スクリプトを割り当てる場合は「Extend Script」。

### 8-バッチリネーム

複数選択状態で右クリック→「Batch Rename」でRenameDialogを表示。正規表現・連番によるリネーム。

## データベース更新仕様

本画面は編集中シーンのメモリ上データを更新（シーン保存時にファイル反映）。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| ノード追加 | EditorData | UPDATE | シーンにノード追加 |
| ノード削除 | EditorData | UPDATE | シーンからノード削除 |
| ノード移動 | EditorData | UPDATE | 親子関係変更 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | エラー | No parent to instantiate a child at. | 親ノードなしでインスタンス化時 |
| MSG002 | 確認 | This operation can't be undone. | 特定の削除操作時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ルートノード削除 | 操作を拒否 |
| 循環参照（自身を親に） | 操作を拒否 |
| インスタンス内ノード編集 | 制限付き編集（Editable Children設定依存） |

## 備考

- SceneTreeDockクラスがメインの実装
- EditorSelectionと連携して選択を同期
- ホバー時にインスペクターをプレビュー更新可能
- ショートカットキーが豊富に設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scene_tree_dock.h | `editor/docks/scene_tree_dock.h` | SceneTreeDockクラス、TOOL_* enum |

**読解のコツ**: TOOL_*定数でメニュー操作を特定。

#### Step 2: 主要操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scene_tree_dock.cpp | `editor/docks/scene_tree_dock.cpp` | _tool_selected()でツール操作処理 |

**主要処理フロー**:
1. **行73-79**: _quick_open()でシーンをインスタンス化
2. **行93-116**: _inspect_hovered_node()でホバープレビュー
3. **行141-170**: input()でマウス入力処理
4. **行172-251**: shortcut_input()でショートカット処理
5. **行267-295**: instantiate_scenes()でシーンインスタンス化

### プログラム呼び出し階層図

```
SceneTreeDock
    │
    ├─ SceneTreeEditor (ツリーUI)
    │      └─ Tree (ノード表示)
    │
    ├─ CreateDialog (ノード作成)
    │
    ├─ RenameDialog (バッチリネーム)
    │
    ├─ ReparentDialog (親変更)
    │
    └─ EditorSelection (選択管理)
           └─ InspectorDock連携
```

### データフロー図

```
[入力]                      [処理]                           [出力]

編集中シーン ────────────▶ SceneTreeDock ──────────▶ ツリー表示
                            │
操作（追加/削除等） ────▶ _tool_selected() ─────▶ EditorData更新
                            │
ノード選択 ─────────────▶ EditorSelection ──────▶ InspectorDock
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scene_tree_dock.cpp | `editor/docks/scene_tree_dock.cpp` | ソース | シーンツリードック実装 |
| scene_tree_dock.h | `editor/docks/scene_tree_dock.h` | ヘッダ | クラス定義 |
| scene_tree_editor.cpp | `editor/scene_tree_editor.cpp` | ソース | ツリーエディタ |
| create_dialog.cpp | `editor/gui/create_dialog.cpp` | ソース | ノード作成ダイアログ |
| rename_dialog.cpp | `editor/scene/rename_dialog.cpp` | ソース | バッチリネームダイアログ |
| reparent_dialog.cpp | `editor/scene/reparent_dialog.cpp` | ソース | 親変更ダイアログ |
