# 画面設計書 9-インスペクタードック

## 概要

本ドキュメントは、Godot Engineにおける選択中オブジェクトのプロパティ編集ドック画面の設計仕様を記載する。

### 本画面の処理概要

インスペクタードックは、現在選択されているノード、リソース、またはオブジェクトのプロパティを一覧表示し、リアルタイムに編集するためのドックパネルである。

**業務上の目的・背景**：選択したオブジェクトのすべてのプロパティ（位置、回転、スクリプト変数、リソース参照等）を視覚的に確認・編集できるようにする。GUIコントロール（スライダー、カラーピッカー、ファイル選択等）を通じて直感的なプロパティ編集を実現する。

**画面へのアクセス方法**：エディタメイン画面の右側に常時表示されるドックパネル。「View > Inspector」メニューで表示/非表示を切り替え可能。

**主要な操作・処理内容**：
1. プロパティ値の編集（数値、文字列、ベクトル、色等）
2. リソースの参照・作成・編集
3. プロパティの展開/折りたたみ
4. プロパティ値のコピー/貼り付け
5. 変更値のリバート（初期値に戻す）
6. プロパティのピン留め
7. オブジェクト編集履歴の移動
8. プロパティ名スタイル切り替え（Raw/Capitalized/Localized）
9. リソースの保存/名前を付けて保存
10. ヘルプドキュメントの表示

**画面遷移**：ドックとして常時表示。シーンツリーでノード選択時に内容が更新される。リソースクリックでリソースの詳細に遷移。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ノードシステム | 主機能 | ノードプロパティの表示・編集 |
| 3 | リソース管理 | 主機能 | リソースの作成・ロード・保存 |
| 4 | プロパティエディタ | 主機能 | 各種型のプロパティ編集UI |

## 画面種別

ドック / プロパティエディタ

## URL/ルーティング

該当なし

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 編集対象オブジェクト | 入力 | Object | - | 選択中のオブジェクト |
| 検索キーワード | 入力 | String | - | プロパティ名フィルター |
| プロパティ値 | 入出力 | Variant | - | 各プロパティの値 |
| プロパティ名スタイル | 入力 | Enum | - | Raw/Capitalized/Localized |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| オブジェクトセレクター | EditorObjectSelector | 現在のオブジェクトパス表示 |
| プロパティツリー | EditorInspector | プロパティ階層表示 |
| 検索バー | LineEdit | プロパティ検索入力 |
| 履歴ボタン | Button | 前後オブジェクトへの移動 |
| リソースボタン | Button | 新規/ロード/保存ボタン群 |
| オブジェクトメニュー | MenuButton | 展開/折りたたみ等のメニュー |

## イベント仕様

### 1-プロパティ編集

各プロパティ行で値を変更。変更はUndoRedoシステムに登録され、元に戻す/やり直しが可能。

### 2-プロパティコピー/貼り付け

オブジェクトメニュー→「Copy Params」でプロパティをコピー。「Paste Params」で別オブジェクトに貼り付け。

### 3-リソース操作

リソースプロパティの「New」で新規作成、「Load」でファイルから読み込み。右クリックで「Make Unique」（複製）、「Make Built-in」（組み込み化）。

### 4-履歴移動

戻る/進むボタンで編集履歴を移動。履歴メニューから直接オブジェクトを選択可能。

### 5-展開/折りたたみ

オブジェクトメニュー→「Expand All」/「Collapse All」で全プロパティを展開/折りたたみ。「Expand Revertable」で変更のあるプロパティのみ展開。

### 6-プロパティ検索

検索バーに入力するとプロパティ名でフィルタリング。部分一致で検索。

### 7-ヘルプ表示

オブジェクトメニュー→「Open Documentation」でクラスのヘルプを表示。ドキュメントボタンクリックでも同様。

### 8-リソース保存

リソースを選択中に保存ボタンで上書き保存。「Save As」で名前を付けて保存。

## データベース更新仕様

本画面は編集中オブジェクトのプロパティをメモリ上で更新（シーン保存時にファイル反映）。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| プロパティ編集 | Object | UPDATE | プロパティ値変更 |
| リソース作成 | Resource | CREATE | 新規リソース作成 |
| リソース保存 | Resource | UPDATE | リソースファイル保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|------------|
| MSG001 | エラー | Failed to load resource. | リソース読み込み失敗時 |
| MSG002 | 警告 | This object has no resources to duplicate. | 複製するリソースがない時 |
| MSG003 | 確認 | The following resources will be duplicated... | リソース複製確認時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 読み取り専用プロパティ | グレーアウト表示、編集不可 |
| 無効なリソースパス | エラーダイアログ表示 |
| クリップボードが空 | 「Edit Clipboard」無効化 |

## 備考

- InspectorDockクラスがメインの実装
- EditorInspectorがプロパティ表示の実装
- EditorPropertyが各プロパティ行の基底クラス
- シングルトンパターンで他コンポーネントからアクセス可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | inspector_dock.h | `editor/docks/inspector_dock.h` | InspectorDockクラス、MenuOptions enum |

**読解のコツ**: MenuOptions enumでメニュー操作（RESOURCE_*, OBJECT_*, PROPERTY_NAME_STYLE_*）を特定。

#### Step 2: メニュー操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | inspector_dock.cpp | `editor/docks/inspector_dock.cpp` | _menu_option_confirm()でメニュー操作処理 |

**主要処理フロー**:
1. **行48-53**: _prepare_menu()でプロパティ名スタイル設定
2. **行63-228**: _menu_option_confirm()でメニュー操作処理
3. **行69-77**: EXPAND_ALL/COLLAPSE_ALL/EXPAND_REVERTABLEの処理
4. **行79-84**: リソースの保存処理
5. **行108-120**: オブジェクトパラメータのコピー/貼り付け
6. **行230-251**: _new_resource()と_load_resource()
7. **行272-301**: _save_resource(), _copy_resource(), _paste_resource()
8. **行318-366**: _prepare_history()で履歴メニュー構築

### プログラム呼び出し階層図

```
InspectorDock (singleton)
    |
    +-- EditorInspector (プロパティ表示)
    |       |
    |       +-- EditorProperty (各プロパティ行)
    |              +-- EditorPropertyRevert (リバート機能)
    |
    +-- EditorObjectSelector (オブジェクトパス表示)
    |
    +-- CreateDialog (新規リソース作成)
    |
    +-- EditorFileDialog (リソース読み込み)
    |
    +-- EditorSelectionHistory (編集履歴)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

EditorSelection --------> InspectorDock -----------> プロパティ表示
                              |
プロパティ編集 -----------> EditorInspector -------> オブジェクト更新
                              |
                              +---> UndoRedoManager (変更記録)
                              |
履歴選択 -----------------> _select_history() -----> オブジェクト切替
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| inspector_dock.cpp | `editor/docks/inspector_dock.cpp` | ソース | インスペクタードック実装 |
| inspector_dock.h | `editor/docks/inspector_dock.h` | ヘッダ | クラス定義、MenuOptions enum |
| editor_inspector.cpp | `editor/inspector/editor_inspector.cpp` | ソース | プロパティ表示実装 |
| editor_inspector.h | `editor/inspector/editor_inspector.h` | ヘッダ | EditorProperty基底クラス |
| editor_property_name_processor.cpp | `editor/inspector/editor_property_name_processor.cpp` | ソース | プロパティ名変換 |
| create_dialog.cpp | `editor/gui/create_dialog.cpp` | ソース | リソース作成ダイアログ |
| editor_object_selector.cpp | `editor/gui/editor_object_selector.cpp` | ソース | オブジェクトパス表示 |
