---
generated_at: 2026-01-23 10:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：1-プロジェクトマネージャー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **editor_settings-4.tresの永続化仕様**：設定ファイルの実際の構造要確認
  2. **リカバリーモードの詳細動作**：具体的な無効化項目の検証
  3. **タグ保存形式の詳細**：PackedStringArrayの実際の保存形式

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/project_manager/project_manager.cpp` 行1-1300
- E-02: `editor/project_manager/project_manager.h` 行1-291
- E-03: `editor/project_manager/project_list.cpp` 推定
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行2
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` 行67-86
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行2-4

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Godot Engine起動時に表示される最初の画面 | E-04, E-05 | ○ |
| C-02 | プロジェクト一覧・管理画面として機能 | E-01 行480-498 | ○ |
| C-03 | 新規プロジェクト作成機能 | E-01 行753-756 _new_project() | ○ |
| C-04 | プロジェクトインポート機能 | E-01 行748-751 _import_project() | ○ |
| C-05 | プロジェクトスキャン機能 | E-01 行500-502 _scan_projects() | ○ |
| C-06 | プロジェクト編集（エディタ起動） | E-01 行553-602 _open_selected_projects() | ○ |
| C-07 | プロジェクト実行機能 | E-01 行519-551 _run_project_confirm() | ○ |
| C-08 | プロジェクト削除機能 | E-01 行805-833 _erase_project() | ○ |
| C-09 | プロジェクトタグ管理機能 | E-01 行998-1069 タグ関連メソッド群 | ○ |
| C-10 | 検索・フィルタリング機能 | E-01 行973-982 _on_search_term_changed() | ○ |
| C-11 | MainViewTab enumの定義 | E-02 行97-101 | ○ |
| C-12 | プロジェクトダイアログへの遷移 | E-05 行77-82 | ○ |
| C-13 | クイック設定ダイアログへの遷移 | E-01 行465-467 _show_quick_settings() | ○ |
| C-14 | Aboutダイアログへの遷移 | E-01 行382-384 _show_about() | ○ |
| C-15 | Asset Libraryへの遷移 | E-01 行386-396 _open_asset_library_confirmed() | ○ |
| C-16 | ウィンドウ最小サイズ720x450 | E-01 行174 Size2(720, 450) * EDSCALE | ○ |
| C-17 | デフォルトウィンドウサイズ1152x800 | E-02 行276-277 DEFAULT_WINDOW_WIDTH/HEIGHT | ○ |
| C-18 | メインシーン未設定時のエラーメッセージ | E-01 行524-526 | ○ |
| C-19 | アセット未インポート時のエラーメッセージ | E-01 行532-534 | ○ |
| C-20 | project.godot欠落時のエラー処理 | E-01 行562-566 | ○ |
| C-21 | 複数プロジェクト同時実行の確認 | E-01 行511-514 multi_run_ask | ○ |
| C-22 | リカバリーモード対応 | E-01 行873-894 | ○ |
| C-23 | GODOT4_CONFIG_VERSION = 5 | E-01 行78 | ○ |
| C-24 | バージョン変換機能（3.x→4.x） | E-01 行643-656, 1161-1200 | ○ |
| C-25 | ファイルドロップによるインポート | E-01 行1274-1295 _files_dropped() | ○ |
| C-26 | editor_settings-4.tresへの永続化 | **根拠不足** | △ |
| C-27 | タグのproject.godotへの保存形式 | E-01 行1056 application/config/tags | ○ |
| C-28 | リカバリーモードで無効化される項目の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- editor_settings-4.tresの実際のファイル構造とプロジェクトリストの保存形式
  - 候補：`editor/settings/editor_settings.cpp` / EditorSettingsクラスの実装
- リカバリーモードで具体的に無効化される項目の詳細な一覧
  - 候補：`main/main.cpp` / `editor/editor_node.cpp`のリカバリーモード処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構成、ボタン動作、基本的な画面遷移
- 1: 中リスク - バージョン変換処理、タグ管理の詳細動作
- 2: 高リスク - editor_settings永続化の詳細、リカバリーモードの完全性

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクト一覧の表示項目が実際のUIと一致しているか
- [ ] エラーメッセージの文言が実際の表示と一致しているか
- [ ] 画面遷移図との整合性（遷移元・遷移先）
- [ ] バージョン変換処理の動作確認
- [ ] リカバリーモードの無効化項目の網羅性確認
