---
generated_at: 2026-01-23 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：10-シグナルドック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **継承された接続の判定ロジック**：CONNECT_INHERITEDフラグの詳細
  2. **コールバック自動生成の言語サポート**：各スクリプト言語での対応状況

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/docks/signals_dock.cpp` 行1-59
- E-02: `editor/docks/signals_dock.h` 行1-54
- E-03: `editor/scene/connections_dialog.cpp` 行1-1400
- E-04: `editor/scene/connections_dialog.h` 行1-200
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行11
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行36-38

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シグナル接続管理ドック | E-05 | ○ |
| C-02 | SignalsDockがConnectionsDockをラップ | E-01 行44, 51-53 | ○ |
| C-03 | set_object()でオブジェクト設定 | E-01 行40-42 | ○ |
| C-04 | update_tree()でツリー更新 | E-01 行36-38 | ○ |
| C-05 | ConnectionData構造体 | E-04 行54-110 | ○ |
| C-06 | signal, target, method, flags, binds | E-04 行55-61 | ○ |
| C-07 | ConnectDialog接続ダイアログ | E-04 行50-199 | ○ |
| C-08 | generate_method_callback_name() | E-03 行258-296 | ○ |
| C-09 | _make_or_edit_connection()接続作成 | E-03 行974-1080 | ○ |
| C-10 | _connect()でUndo/Redo対応 | E-03 行1085-1104 | ○ |
| C-11 | _disconnect()で接続削除 | E-03 行1109-1124 | ○ |
| C-12 | _disconnect_all()全削除 | E-03 行1130-1157 | ○ |
| C-13 | TreeItemType enum | E-03 行1191-1201 | ○ |
| C-14 | _go_to_method()メソッドジャンプ | E-03 行1261-1283 | ○ |
| C-15 | SIGNAL_MENU_CONNECT/DISCONNECT_ALL/COPY_NAME/OPEN_DOCS | E-03 行1306-1321 | ○ |
| C-16 | SLOT_MENU_EDIT/GO_TO_METHOD/DISCONNECT | E-03 行1350-1362 | ○ |
| C-17 | Deferred/One Shot/Append Sourceオプション | E-03 行921-934 | ○ |
| C-18 | ok_pressed()バリデーション | E-03 行154-182 | ○ |
| C-19 | エラーメッセージ表示 | E-03 行158-178 | ○ |
| C-20 | script_add_function_requestシグナル | E-03 行1069 | ○ |
| C-21 | 継承された接続の判定詳細 | **根拠不足** | △ |
| C-22 | 言語別コールバック生成対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- CONNECT_INHERITEDフラグの設定箇所と判定ロジック
  - 候補：`scene/main/node.cpp`
- can_make_function()の言語別実装
  - 候補：`modules/gdscript/gdscript.cpp`, `modules/mono/csharp_script.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シグナル一覧表示、シグナル名コピー
- 1: 中リスク - 接続作成/編集、メソッドジャンプ
- 2: 高リスク - コールバック自動生成、継承接続判定

## 6) レビュアーチェックリスト（最小）
- [ ] シグナル一覧の表示確認
- [ ] 接続ダイアログからの接続作成確認
- [ ] 接続のUndo/Redo動作確認
- [ ] ダブルクリックでのメソッドジャンプ確認
- [ ] 継承された接続の編集制限確認
