---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート: 11-グループドック

## 概要

本レポートは「画面設計書 11-グループドック」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・処理概要に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | グループドックはEditorDockを継承 | 有 | groups_dock.h | 36-37 | `class GroupsDock : public EditorDock { GDCLASS(GroupsDock, EditorDock);` |
| 2 | ドック名は「Groups」 | 有 | groups_dock.cpp | 41 | `set_name(TTRC("Groups"));` |
| 3 | アイコン名は「Groups」 | 有 | groups_dock.cpp | 42 | `set_icon_name("Groups");` |
| 4 | ショートカットは「docks/open_groups」 | 有 | groups_dock.cpp | 43 | `set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("docks/open_groups", TTRC("Open Groups Dock")));` |
| 5 | デフォルトスロットは右上 | 有 | groups_dock.cpp | 44 | `set_default_slot(EditorDock::DOCK_SLOT_RIGHT_UL);` |
| 6 | GroupsEditorを内包 | 有 | groups_dock.cpp | 46-48 | `groups = memnew(GroupsEditor); ... add_child(groups);` |
| 7 | シーングループとグローバルグループを管理 | 有 | groups_editor.h | 85-86 | `HashMap<StringName, bool> scene_groups;` `HashMap<StringName, String> global_groups;` |
| 8 | 複数ノードの選択に対応 | 有 | groups_editor.h | 55 | `LocalVector<Node *> selection;` |

### 2. アクセス方法・画面遷移に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 9 | シーンツリーからノード選択で更新 | 有 | groups_editor.cpp | 347-367 | `set_selection()`メソッドでノード選択を受け取り、`_update_tree()`を呼び出す |
| 10 | ProjectSettingsと連携 | 有 | groups_editor.cpp | 944 | `ProjectSettingsEditor::get_singleton()->get_group_settings()->connect("group_changed", ...)` |

### 3. UI構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 11 | フィルタ入力欄が存在 | 有 | groups_editor.cpp | 906-912 | `filter = memnew(LineEdit);` `filter->set_placeholder(TTR("Filter Groups"));` |
| 12 | 追加ボタンが存在 | 有 | groups_editor.cpp | 900-904 | `add = memnew(Button);` `add->set_tooltip_text(TTR("Add a new group."));` |
| 13 | Treeコントロールでグループ表示 | 有 | groups_editor.cpp | 919-928 | `tree = memnew(Tree);` `tree->set_hide_root(true);` |
| 14 | 右クリックメニュー対応 | 有 | groups_editor.cpp | 922 | `tree->set_allow_rmb_select(true);` |
| 15 | ノード未選択時のメッセージ表示 | 有 | groups_editor.cpp | 934-942 | `select_a_node->set_text(TTRC("Select one or more nodes to edit their groups."));` |

### 4. イベント処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 16 | チェック状態変更でグループ追加 | 有 | groups_editor.cpp | 378-393 | `if (ti->is_checked(0)) { undo_redo->create_action(TTR("Add to Group"));` |
| 17 | チェック状態変更でグループ削除 | 有 | groups_editor.cpp | 395-411 | `else { undo_redo->create_action(TTR("Remove from Group"));` |
| 18 | 追加ダイアログ表示 | 有 | groups_editor.cpp | 660-726 | `_show_add_group_dialog()`メソッドで`ConfirmationDialog`を生成 |
| 19 | 名前変更ダイアログ表示 | 有 | groups_editor.cpp | 728-783 | `_show_rename_group_dialog()`メソッドで`ConfirmationDialog`を生成 |
| 20 | 削除確認ダイアログ表示 | 有 | groups_editor.cpp | 785-816 | `_show_remove_group_dialog()`メソッドで`ConfirmationDialog`を生成 |
| 21 | グループ種別変換 | 有 | groups_editor.cpp | 454-491 | `case CONVERT_GROUP:`でシーン/グローバル間の変換処理 |
| 22 | グループ名コピー | 有 | groups_editor.cpp | 149-151 | `if (p_id == COPY_GROUP) { DisplayServer::get_singleton()->clipboard_set(ti->get_text(p_column)); }` |
| 23 | フィルタによる絞り込み | 有 | groups_editor.cpp | 254-256 | `if (!filter->get_text().is_subsequence_ofn(E)) { continue; }` |

### 5. Undo/Redo対応に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 24 | EditorUndoRedoManager使用 | 有 | groups_editor.cpp | 377 | `EditorUndoRedoManager *undo_redo = EditorUndoRedoManager::get_singleton();` |
| 25 | グループ追加がUndo対応 | 有 | groups_editor.cpp | 383-384 | `undo_redo->add_do_method(this, "_add_to_group", ...); undo_redo->add_undo_method(this, "_remove_from_group", ...);` |
| 26 | グループ削除がUndo対応 | 有 | groups_editor.cpp | 400-401 | `undo_redo->add_do_method(this, "_remove_from_group", ...); undo_redo->add_undo_method(this, "_add_to_group", ...);` |

### 6. データ管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 27 | シーングループはHashMapで管理 | 有 | groups_editor.h | 85 | `HashMap<StringName, bool> scene_groups;` |
| 28 | グローバルグループはHashMapで管理 | 有 | groups_editor.h | 86 | `HashMap<StringName, String> global_groups;` |
| 29 | グローバルグループはProjectSettingsに保存 | 有 | groups_editor.cpp | 462-466 | `undo_redo->add_do_property(ProjectSettings::get_singleton(), property_name, "");` |
| 30 | グローバルグループのプレフィックス | 有 | groups_editor.h | 48 | `const String GLOBAL_GROUP_PREFIX = "global_group/";` |

### 7. 編集制御に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 31 | 継承グループは編集不可 | 有 | groups_editor.cpp | 47-64 | `can_edit()`関数でSceneStateを確認し、継承グループの編集可否を判定 |
| 32 | ロックアイコン表示 | 有 | groups_editor.cpp | 267 | `item->add_button(0, get_editor_theme_icon(SNAME("Lock")), -1, true, TTR("This group belongs to another scene and can't be edited."));` |
| 33 | 編集可否をチェックボックスに反映 | 有 | groups_editor.cpp | 260 | `item->set_editable(0, _can_edit(E));` |

### 8. バリデーションに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 34 | 空グループ名のバリデーション | 有 | groups_editor.cpp | 834-835 | `if (p_name.is_empty()) { p_validation_panel->set_message(..., TTR("Group can't be empty."), ...);` |
| 35 | 重複グループ名のバリデーション | 有 | groups_editor.cpp | 836-837 | `else if (_has_group(p_name)) { p_validation_panel->set_message(..., TTR("Group already exists."), ...);` |
| 36 | EditorValidationPanelの使用 | 有 | groups_editor.cpp | 706-709 | `add_validation_panel = memnew(EditorValidationPanel);` |

### 9. ショートカットに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 37 | Deleteキーでグループ削除 | 有 | groups_editor.cpp | 888 | `ED_SHORTCUT("groups_editor/delete", TTRC("Delete"), Key::KEY_DELETE);` |
| 38 | F2キーで名前変更 | 有 | groups_editor.cpp | 889 | `ED_SHORTCUT("groups_editor/rename", TTRC("Rename"), Key::F2);` |
| 39 | macOSではEnterキーで名前変更 | 有 | groups_editor.cpp | 890 | `ED_SHORTCUT_OVERRIDE("groups_editor/rename", "macos", Key::ENTER);` |
| 40 | 検索ショートカット対応 | 有 | groups_editor.cpp | 848-850 | `else if (ED_IS_SHORTCUT("editor/open_search", p_event)) { filter->grab_focus(); filter->select_all(); }` |

### 10. 根拠なしの主張

| No | 主張 | 根拠有無 | 説明 |
|----|------|----------|------|
| 41 | メニューからView > Docks > Groupsでアクセス | 無 | エディタ全体のメニュー構成はeditor_node.cppなど別ファイルで定義されており、本分析対象外 |
| 42 | 権限による表示制御の詳細 | 無 | 継承グループの編集制御は確認できるが、ロールベースの権限制御は本コードには存在しない |

## 信頼度スコア計算

```
claims_with_evidence: 40
claims_without_evidence: 2
claims_total: 42
confidence_derived: 40 / 42 = 0.95 (95%)
```

## 結論

本画面設計書の内容は、ソースコード解析により95%の主張について根拠が確認された。根拠のない2件は以下の理由による：

1. **メニューアクセス**: エディタ全体のメニュー構成は別ファイルで管理されており、本分析の対象範囲外
2. **権限制御**: 本画面では継承シーンに基づく編集制御は存在するが、ユーザーロールに基づく権限制御は実装されていない

設計書の記載内容は全体的に正確であり、ソースコードに基づいた信頼性の高い文書である。
