---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: 12-ヒストリードック

## 概要

本レポートは「画面設計書 12-ヒストリードック」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・処理概要に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | HistoryDockはEditorDockを継承 | 有 | history_dock.h | 40-41 | `class HistoryDock : public EditorDock { GDCLASS(HistoryDock, EditorDock);` |
| 2 | ドック名は「History」 | 有 | history_dock.cpp | 239 | `set_name(TTRC("History"));` |
| 3 | アイコン名は「History」 | 有 | history_dock.cpp | 240 | `set_icon_name("History");` |
| 4 | ショートカットは「docks/open_history」 | 有 | history_dock.cpp | 241 | `set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("docks/open_history", TTRC("Open History Dock")));` |
| 5 | デフォルトスロットは左下 | 有 | history_dock.cpp | 242 | `set_default_slot(EditorDock::DOCK_SLOT_LEFT_BR);` |
| 6 | EditorUndoRedoManagerを使用 | 有 | history_dock.cpp | 244 | `ur_manager = EditorUndoRedoManager::get_singleton();` |

### 2. UI構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 7 | シーン履歴チェックボックスが存在 | 有 | history_dock.cpp | 254-261 | `current_scene_checkbox = memnew(CheckBox); ... current_scene_checkbox->set_text(TTRC("Scene"));` |
| 8 | グローバル履歴チェックボックスが存在 | 有 | history_dock.cpp | 263-270 | `global_history_checkbox = memnew(CheckBox); ... global_history_checkbox->set_text(TTRC("Global"));` |
| 9 | ItemListで履歴表示 | 有 | history_dock.cpp | 277 | `action_list = memnew(ItemList);` |
| 10 | 両チェックボックスがデフォルトON | 有 | history_dock.cpp | 260, 269 | `current_scene_checkbox->set_pressed(true);` `global_history_checkbox->set_pressed(true);` |

### 3. シグナル接続に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 11 | history_changedシグナルを監視 | 有 | history_dock.cpp | 245 | `ur_manager->connect("history_changed", callable_mp(this, &HistoryDock::on_history_changed));` |
| 12 | version_changedシグナルを監視 | 有 | history_dock.cpp | 246 | `ur_manager->connect("version_changed", callable_mp(this, &HistoryDock::on_version_changed));` |
| 13 | scene_changedシグナルを監視 | 有 | history_dock.cpp | 227 | `EditorNode::get_singleton()->connect("scene_changed", callable_mp(this, &HistoryDock::on_history_changed));` |
| 14 | item_selectedでジャンプ処理 | 有 | history_dock.cpp | 282 | `action_list->connect(SceneStringName(item_selected), callable_mp(this, &HistoryDock::seek_history));` |

### 4. 履歴表示処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 15 | タイムスタンプ順にソート | 有 | history_dock.cpp | 42-46, 104 | `struct SortActionsByTimestamp { ... return l.timestamp > r.timestamp; }` `full_history.sort_custom<SortActionsByTimestamp>();` |
| 16 | グローバル履歴はアクセントカラー | 有 | history_dock.cpp | 107-109 | `if (E.history_id == EditorUndoRedoManager::GLOBAL_HISTORY) { action_list->set_item_custom_fg_color(-1, get_theme_color(SNAME("accent_color"), ...));` |
| 17 | 「The Beginning」を表示 | 有 | history_dock.cpp | 112-113 | `action_list->add_item(TTRC("The Beginning"));` |
| 18 | 両フィルタOFFで「The Beginning」のみ | 有 | history_dock.cpp | 61-65 | `if (!include_scene && !include_global) { action_list->add_item(TTRC("The Beginning")); ... return; }` |

### 5. 履歴ジャンプ処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 19 | 現在位置<選択位置でundo繰り返し | 有 | history_dock.cpp | 199-209 | `while (current_version < p_index) { ... ur_manager->undo(); ... }` |
| 20 | 現在位置>選択位置でredo繰り返し | 有 | history_dock.cpp | 211-221 | `while (current_version > p_index) { ... ur_manager->redo(); ... }` |
| 21 | フィルタに応じたundo/redo呼び分け | 有 | history_dock.cpp | 200-208 | シーンのみ: `undo_history(current_scene_id)`, グローバルのみ: `undo_history(GLOBAL_HISTORY)`, 両方: `undo()` |

### 6. フィルタ切り替えに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 22 | チェックボックスtoggleでrefresh | 有 | history_dock.cpp | 261 | `current_scene_checkbox->connect(SceneStringName(toggled), callable_mp(this, &HistoryDock::refresh_history).unbind(1));` |
| 23 | グローバルチェックボックスtoggleでrefresh | 有 | history_dock.cpp | 270 | `global_history_checkbox->connect(SceneStringName(toggled), callable_mp(this, &HistoryDock::refresh_history).unbind(1));` |

### 7. レイアウト保存に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 24 | ConfigFileにフィルタ設定保存 | 有 | history_dock.cpp | 179-182 | `p_layout->set_value(p_section, "include_scene", current_scene_checkbox->is_pressed());` `p_layout->set_value(p_section, "include_global", ...);` |
| 25 | ConfigFileからフィルタ設定読み込み | 有 | history_dock.cpp | 184-188 | `current_scene_checkbox->set_pressed_no_signal(p_layout->get_value(p_section, "include_scene", true));` |
| 26 | デフォルト値はtrue | 有 | history_dock.cpp | 185-186 | `get_value(p_section, "include_scene", true)` `get_value(p_section, "include_global", true)` |

### 8. 遅延更新に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 27 | 非表示時はneed_refreshフラグ設定 | 有 | history_dock.cpp | 49-53 | `if (is_visible_in_tree()) { refresh_history(); } else { need_refresh = true; }` |
| 28 | 表示時にneed_refreshで更新 | 有 | history_dock.cpp | 230-234 | `case NOTIFICATION_VISIBILITY_CHANGED: { if (is_visible_in_tree() && need_refresh) { refresh_history(); } }` |

### 9. バージョン管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 29 | current_versionで現在位置管理 | 有 | history_dock.h | 50 | `int current_version = 0;` |
| 30 | refresh_versionで選択位置設定 | 有 | history_dock.cpp | 175-176 | `current_version = idx; action_list->set_current(idx);` |
| 31 | 最新undoタイムスタンプで位置計算 | 有 | history_dock.cpp | 138-149 | `double newest_undo_timestamp = 0;` から計算してスキップ数を決定 |

### 10. 根拠なしの主張

| No | 主張 | 根拠有無 | 説明 |
|----|------|----------|------|
| 32 | メニューからView > Docks > Historyでアクセス | 無 | エディタ全体のメニュー構成はeditor_node.cppなど別ファイルで定義されており、本分析対象外 |

## 信頼度スコア計算

```
claims_with_evidence: 31
claims_without_evidence: 1
claims_total: 32
confidence_derived: 31 / 32 = 0.97 (97%)
```

## 結論

本画面設計書の内容は、ソースコード解析により97%の主張について根拠が確認された。根拠のない1件は以下の理由による：

1. **メニューアクセス**: エディタ全体のメニュー構成は別ファイルで管理されており、本分析の対象範囲外

設計書の記載内容は全体的に正確であり、ソースコードに基づいた信頼性の高い文書である。特にEditorUndoRedoManagerとの連携処理、フィルタ機能、タイムスタンプベースのソート処理などが正確に文書化されている。
