---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 44
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート: 13-インポートドック

## 概要

本レポートは「画面設計書 13-インポートドック」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・処理概要に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | ImportDockはEditorDockを継承 | 有 | import_dock.h | 47-48 | `class ImportDock : public EditorDock { GDCLASS(ImportDock, EditorDock);` |
| 2 | ドック名は「Import」 | 有 | import_dock.cpp | 747 | `set_name(TTRC("Import"));` |
| 3 | アイコン名は「FileAccess」 | 有 | import_dock.cpp | 748 | `set_icon_name("FileAccess");` |
| 4 | ショートカットは「docks/open_import」 | 有 | import_dock.cpp | 749 | `set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("docks/open_import", TTRC("Open Import Dock")));` |
| 5 | デフォルトスロットは左上 | 有 | import_dock.cpp | 750 | `set_default_slot(EditorDock::DOCK_SLOT_LEFT_UR);` |
| 6 | シングルトンパターン | 有 | import_dock.cpp | 99, 746 | `ImportDock *ImportDock::singleton = nullptr;` `singleton = this;` |

### 2. UI構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 7 | ファイル名ラベルが存在 | 有 | import_dock.cpp | 760-764 | `imported = memnew(Label);` |
| 8 | Import Asドロップダウンが存在 | 有 | import_dock.cpp | 767-774 | `import_as = memnew(OptionButton);` |
| 9 | Presetメニューボタンが存在 | 有 | import_dock.cpp | 776-780 | `preset = memnew(MenuButton); preset->set_text(TTRC("Preset"));` |
| 10 | EditorInspectorで設定編集 | 有 | import_dock.cpp | 787-794 | `import_opts = memnew(EditorInspector);` |
| 11 | Reimportボタンが存在 | 有 | import_dock.cpp | 798-801 | `import = memnew(Button); import->set_text(TTRC("Reimport"));` |
| 12 | Advancedボタンが存在 | 有 | import_dock.cpp | 803-812 | `advanced = memnew(Button); advanced->set_text(TTRC("Advanced..."));` |
| 13 | リソース未選択時の案内メッセージ | 有 | import_dock.cpp | 827-835 | `select_a_resource->set_text(TTRC("Select a resource file in the filesystem..."));` |

### 3. データ管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 14 | ImportDockParametersでパラメータ管理 | 有 | import_dock.cpp | 44-97 | `class ImportDockParameters : public Object { ... HashMap<StringName, Variant> values; List<PropertyInfo> properties;` |
| 15 | checkingフラグで複数選択モード | 有 | import_dock.cpp | 53, 189 | `bool checking = false;` `params->checking = params->paths.size() > 1;` |
| 16 | checkedセットで変更項目管理 | 有 | import_dock.cpp | 52, 60-61 | `HashSet<StringName> checked;` `if (checking) { checked.insert(p_name);` |

### 4. ファイル読み込み処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 17 | .importファイルをConfigFileで読み込み | 有 | import_dock.cpp | 102-108 | `config.instantiate(); Error err = config->load(p_path + ".import");` |
| 18 | インポーター名を取得 | 有 | import_dock.cpp | 110 | `String importer_name = config->get_value("remap", "importer");` |
| 19 | keep/skip判定 | 有 | import_dock.cpp | 111-120 | `if (importer_name == "keep") { ... } else if (importer_name == "skip") { ... }` |
| 20 | 利用可能インポーター取得 | 有 | import_dock.cpp | 128-134 | `ResourceFormatImporter::get_singleton()->get_importers_for_file(p_path, &importers);` |

### 5. 複数ファイル処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 21 | 複数ファイル表示 | 有 | import_dock.cpp | 348 | `imported->set_text(vformat(TTR("%d Files"), p_paths.size()));` |
| 22 | 最頻値を使用 | 有 | import_dock.cpp | 229, 297-306 | `// Use the value that is repeated the most.` 以下の頻度計算ロジック |
| 23 | チェックボックス付きプロパティ | 有 | import_dock.cpp | 84-88 | `pi.usage |= PROPERTY_USAGE_CHECKABLE; if (checked.has(E.name)) { pi.usage |= PROPERTY_USAGE_CHECKED; }` |

### 6. 再インポート処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 24 | 設定をConfigFileに保存 | 有 | import_dock.cpp | 647-658 | `config->set_value("params", E.name, params->values[E.name]);` |
| 25 | reimport_filesで再インポート | 有 | import_dock.cpp | 688 | `EditorFileSystem::get_singleton()->reimport_files(params->paths);` |
| 26 | filesystem_changedシグナル発行 | 有 | import_dock.cpp | 689 | `EditorFileSystem::get_singleton()->emit_signal(SNAME("filesystem_changed"));` |
| 27 | インポーター変更時の警告 | 有 | import_dock.cpp | 571-576 | `if (!need_cleanup.is_empty() || used_in_resources) { cleanup_warning->set_visible(...); reimport_confirm->popup_centered(); }` |

### 7. プリセット管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 28 | Set as Default | 有 | import_dock.cpp | 435-452 | `case ITEM_SET_AS_DEFAULT: { ... ProjectSettings::get_singleton()->set(setting_name, import_settings);` |
| 29 | Load Default | 有 | import_dock.cpp | 453-468 | `case ITEM_LOAD_DEFAULT: { ... Dictionary import_settings = GLOBAL_GET(setting_name);` |
| 30 | Clear Default | 有 | import_dock.cpp | 469-473 | `case ITEM_CLEAR_DEFAULT: { ProjectSettings::get_singleton()->set(setting_name, Variant());` |
| 31 | プリセットメニュー更新 | 有 | import_dock.cpp | 374-399 | `_update_preset_menu()`メソッド全体 |
| 32 | importer_defaults/設定名 | 有 | import_dock.cpp | 432, 394 | `String setting_name = "importer_defaults/" + params->importer->get_importer_name();` |

### 8. 高度なオプションに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 33 | has_advanced_optionsで表示判定 | 有 | import_dock.cpp | 217, 350 | `if (... params->importer->has_advanced_options()) { advanced->show();` |
| 34 | show_advanced_options呼び出し | 有 | import_dock.cpp | 627-631 | `void ImportDock::_advanced_options() { ... params->importer->show_advanced_options(params->paths[0]);` |
| 35 | 単一ファイル時のみ表示 | 有 | import_dock.cpp | 217, 350 | `params->paths.size() == 1 && params->importer->has_advanced_options()` |

### 9. ダーティ状態管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 36 | プロパティ編集でダーティ設定 | 有 | import_dock.cpp | 709-711 | `void ImportDock::_property_edited(...) { _set_dirty(true); }` |
| 37 | (*)マーカー追加 | 有 | import_dock.cpp | 716 | `import->set_text(TTR("Reimport") + " (*)");` |
| 38 | 警告カラー適用 | 有 | import_dock.cpp | 717 | `import->add_theme_color_override(SceneStringName(font_color), get_theme_color(SNAME("warning_color"), ...));` |
| 39 | ツールチップ設定 | 有 | import_dock.cpp | 718 | `import->set_tooltip_text(TTRC("You have pending changes..."));` |

### 10. Keep/Skipオプションに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 40 | Keep Fileオプション | 有 | import_dock.cpp | 162 | `import_as->add_item(TTRC("Keep File (exported as is)"));` |
| 41 | Skip Fileオプション | 有 | import_dock.cpp | 164 | `import_as->add_item(TTRC("Skip File (not exported)"));` |
| 42 | keepメタデータ | 有 | import_dock.cpp | 163 | `import_as->set_item_metadata(-1, "keep");` |
| 43 | skipメタデータ | 有 | import_dock.cpp | 165 | `import_as->set_item_metadata(-1, "skip");` |

### 11. EditorInspector連携に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 44 | use_doc_hints有効化 | 有 | import_dock.cpp | 794 | `import_opts->set_use_doc_hints(true);` |

### 12. 根拠なしの主張

| No | 主張 | 根拠有無 | 説明 |
|----|------|----------|------|
| 45 | メニューからView > Docks > Importでアクセス | 無 | エディタ全体のメニュー構成はeditor_node.cppなど別ファイルで定義されており、本分析対象外 |

## 信頼度スコア計算

```
claims_with_evidence: 44
claims_without_evidence: 1
claims_total: 45
confidence_derived: 44 / 45 = 0.98 (98%)
```

## 結論

本画面設計書の内容は、ソースコード解析により98%の主張について根拠が確認された。根拠のない1件は以下の理由による：

1. **メニューアクセス**: エディタ全体のメニュー構成は別ファイルで管理されており、本分析の対象範囲外

設計書の記載内容は非常に正確であり、特にImportDockParametersによるパラメータ管理、複数ファイル編集時の頻度計算、プリセット管理、ダーティ状態管理などが詳細に文書化されている。ソースコードに基づいた信頼性の高い文書である。
