---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 14-出力パネル

## 概要

本レポートは「画面設計書 14-出力パネル」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・処理概要に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | EditorLogはEditorDockを継承 | 有 | editor_log.h | 42-43 | `class EditorLog : public EditorDock { GDCLASS(EditorLog, EditorDock);` |
| 2 | ドック名は「Output」 | 有 | editor_log.cpp | 490 | `set_name(TTRC("Output"));` |
| 3 | アイコン名は「Output」 | 有 | editor_log.cpp | 491 | `set_icon_name("Output");` |
| 4 | ショートカットはAlt+O | 有 | editor_log.cpp | 492 | `set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("bottom_panels/toggle_output_bottom_panel", TTRC("Toggle Output Dock"), KeyModifierMask::ALT | Key::O));` |
| 5 | デフォルトスロットは下部 | 有 | editor_log.cpp | 493 | `set_default_slot(EditorDock::DOCK_SLOT_BOTTOM);` |
| 6 | 水平/フローティングレイアウト対応 | 有 | editor_log.cpp | 494 | `set_available_layouts(EditorDock::DOCK_LAYOUT_HORIZONTAL | EditorDock::DOCK_LAYOUT_FLOATING);` |

### 2. メッセージタイプに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 7 | MSG_TYPE_STD定義 | 有 | editor_log.h | 47 | `MSG_TYPE_STD,` |
| 8 | MSG_TYPE_ERROR定義 | 有 | editor_log.h | 48 | `MSG_TYPE_ERROR,` |
| 9 | MSG_TYPE_WARNING定義 | 有 | editor_log.h | 50 | `MSG_TYPE_WARNING,` |
| 10 | MSG_TYPE_EDITOR定義 | 有 | editor_log.h | 51 | `MSG_TYPE_EDITOR,` |
| 11 | MSG_TYPE_STD_RICH定義 | 有 | editor_log.h | 49 | `MSG_TYPE_STD_RICH,` |

### 3. UI構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 12 | RichTextLabelでログ表示 | 有 | editor_log.cpp | 515-526 | `log = memnew(RichTextLabel); log->set_use_bbcode(true);` |
| 13 | 検索ボックスが存在 | 有 | editor_log.cpp | 529-536 | `search_box = memnew(LineEdit); search_box->set_placeholder(TTR("Filter Messages"));` |
| 14 | Clearボタンが存在 | 有 | editor_log.cpp | 547-553 | `clear_button = memnew(Button); ... clear_button->connect(..., &EditorLog::_clear_request);` |
| 15 | Copyボタンが存在 | 有 | editor_log.cpp | 556-563 | `copy_button = memnew(Button); ... copy_button->connect(..., &EditorLog::_copy_request);` |
| 16 | Collapseボタンが存在 | 有 | editor_log.cpp | 574-581 | `collapse_button = memnew(Button); collapse_button->set_toggle_mode(true);` |
| 17 | Show Searchボタンが存在 | 有 | editor_log.cpp | 584-593 | `show_search_button = memnew(Button); show_search_button->set_toggle_mode(true);` |

### 4. フィルタボタンに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 18 | 標準メッセージフィルタ | 有 | editor_log.cpp | 598-602 | `LogFilter *std_filter = memnew(LogFilter(MSG_TYPE_STD)); std_filter->initialize_button(TTRC("Standard Messages"), ...);` |
| 19 | エラーフィルタ | 有 | editor_log.cpp | 604-607 | `LogFilter *error_filter = memnew(LogFilter(MSG_TYPE_ERROR)); error_filter->initialize_button(TTRC("Errors"), ...);` |
| 20 | 警告フィルタ | 有 | editor_log.cpp | 609-612 | `LogFilter *warning_filter = memnew(LogFilter(MSG_TYPE_WARNING)); warning_filter->initialize_button(TTRC("Warnings"), ...);` |
| 21 | エディタメッセージフィルタ | 有 | editor_log.cpp | 614-617 | `LogFilter *editor_filter = memnew(LogFilter(MSG_TYPE_EDITOR)); editor_filter->initialize_button(TTRC("Editor Messages"), ...);` |

### 5. エラーハンドラに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 22 | エラーハンドラ登録 | 有 | editor_log.cpp | 621-623 | `eh.errfunc = _error_handler; eh.userdata = this; add_error_handler(&eh);` |
| 23 | URL形式でエラー情報表示 | 有 | editor_log.cpp | 58 | `err_str = vformat("[url]%s:%d[/url] - %s", ...)` |
| 24 | 非メインスレッドはMessageQueue経由 | 有 | editor_log.cpp | 63-67 | `if (!Thread::is_main_thread()) { MessageQueue::get_main_singleton()->push_callable(...); }` |

### 6. メッセージ処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 25 | 改行で分割 | 有 | editor_log.cpp | 282 | `Vector<String> lines = p_msg.split("\n", true);` |
| 26 | 重複メッセージはカウント増加 | 有 | editor_log.cpp | 259-265 | `if (... messages[...].text == p_msg ...) { previous.count++; }` |
| 27 | エラー色で表示 | 有 | editor_log.cpp | 411-418 | `case MSG_TYPE_ERROR: { log->push_color(theme_cache.error_color); ... log->add_text(" ERROR: ");` |
| 28 | 警告色で表示 | 有 | editor_log.cpp | 420-427 | `case MSG_TYPE_WARNING: { log->push_color(theme_cache.warning_color); ... log->add_text(" WARNING: ");` |
| 29 | 折りたたみ時の回数表示 | 有 | editor_log.cpp | 436-440 | `if (collapse && p_message.count > 1) { log->push_bold(); log->add_text(vformat("(%s) ", itos(p_message.count)));` |

### 7. フィルタ・検索処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 30 | フィルタ切り替えでログ再構築 | 有 | editor_log.cpp | 465-469 | `void EditorLog::_set_filter_active(...) { ... _rebuild_log(); }` |
| 31 | 検索でログ再構築 | 有 | editor_log.cpp | 479-481 | `void EditorLog::_search_changed(...) { _rebuild_log(); }` |
| 32 | BBCode解析後テキストでも検索 | 有 | editor_log.cpp | 366-378 | `if (!search_match && p_message.text.contains_char('[')) { ... bbcode_parser->parse_bbcode(...); search_match = parsed_text.containsn(search_text); }` |

### 8. クリア・コピー処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 33 | クリア処理 | 有 | editor_log.cpp | 235-240 | `log->clear(); messages.clear(); _reset_message_counts();` |
| 34 | 選択テキストコピー | 有 | editor_log.cpp | 243-251 | `String text = log->get_selected_text(); if (text.is_empty()) { text = log->get_parsed_text(); } ... clipboard_set(text);` |

### 9. メタクリック処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 35 | res://パスはScriptEditorで開く | 有 | editor_log.cpp | 213-218 | `if (path.begins_with("res://")) { ... ScriptEditor::get_singleton()->edit(res, line, 0);` |
| 36 | .cpp/.hは外部エディタで開く | 有 | editor_log.cpp | 219-229 | `else if (path.has_extension("cpp") || ...) { ... ScriptEditorPlugin::open_in_external_editor(path, line, -1, true);` |

### 10. 状態永続化に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 37 | 状態保存タイマー | 有 | editor_log.cpp | 496-500 | `save_state_timer = memnew(Timer); save_state_timer->set_wait_time(2); save_state_timer->connect("timeout", ...&EditorLog::_save_state);` |
| 38 | フィルタ状態保存 | 有 | editor_log.cpp | 173-175 | `for (...) { config->set_value(section, "log_filter_" + itos(E.key), E.value->is_active()); }` |
| 39 | 折りたたみ状態保存 | 有 | editor_log.cpp | 177 | `config->set_value(section, "collapse", collapse);` |
| 40 | 検索表示状態保存 | 有 | editor_log.cpp | 178 | `config->set_value(section, "show_search", search_box->is_visible());` |
| 41 | editor_layout.cfgに保存 | 有 | editor_log.cpp | 170, 180 | `config->load(...path_join("editor_layout.cfg")); ... config->save(...path_join("editor_layout.cfg"));` |

### 11. 行数制限に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 42 | デフォルト行数制限 | 有 | editor_log.h | 126 | `int line_limit = 10000;` |
| 43 | EditorSettingsから行数取得 | 有 | editor_log.cpp | 133, 502 | `int new_line_limit = int(EDITOR_GET("run/output/max_lines"));` |
| 44 | 行数超過時に古い行を削除 | 有 | editor_log.cpp | 460-462 | `while (log->get_paragraph_count() > line_limit + 1) { log->remove_paragraph(0, true); }` |

### 12. テーマ・アイコンに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 45 | フィルタボタンアイコン設定 | 有 | editor_log.cpp | 109-112 | `type_filter_map[MSG_TYPE_STD]->toggle_button->set_button_icon(get_editor_theme_icon(SNAME("Popup")));` 等 |
| 46 | エラー/警告時にドックアイコン設定 | 有 | editor_log.cpp | 418, 427 | `_set_dock_tab_icon(icon);` |
| 47 | エラー/警告アイコンをキャッシュ | 有 | editor_log.cpp | 125-128 | `theme_cache.error_color = ...; theme_cache.error_icon = ...; theme_cache.warning_color = ...; theme_cache.warning_icon = ...;` |

### 13. 起動メッセージに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 48 | バージョン情報表示 | 有 | editor_log.cpp | 619 | `add_message(GODOT_VERSION_FULL_NAME " (c) 2007-present Juan Linietsky, Ariel Manzur & Godot Contributors.");` |

## 信頼度スコア計算

```
claims_with_evidence: 48
claims_without_evidence: 0
claims_total: 48
confidence_derived: 48 / 48 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

設計書の記載内容は非常に正確であり、特にメッセージ処理フロー、フィルタリング機能、状態永続化、エラー箇所へのジャンプ機能などが詳細に文書化されている。ソースコードに完全に基づいた信頼性の高い文書である。
