---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 52
  claims_with_evidence: 52
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 15-デバッガ

## 概要

本レポートは「画面設計書 15-デバッガ」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・クラス構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | ScriptEditorDebuggerはMarginContainerを継承 | 有 | script_editor_debugger.h | 59-60 | `class ScriptEditorDebugger : public MarginContainer { GDCLASS(ScriptEditorDebugger, MarginContainer);` |
| 2 | EditorDebuggerNodeがfriendクラス | 有 | script_editor_debugger.h | 62 | `friend class EditorDebuggerNode;` |
| 3 | DebugAdapterProtocolがfriendクラス | 有 | script_editor_debugger.h | 63 | `friend class DebugAdapterProtocol;` |
| 4 | DebugAdapterParserがfriendクラス | 有 | script_editor_debugger.h | 64 | `friend class DebugAdapterParser;` |

### 2. タブ構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 5 | TabContainerでタブ管理 | 有 | script_editor_debugger.cpp | 2056-2058 | `tabs = memnew(TabContainer); add_child(tabs); tabs->connect("tab_changed", ...);` |
| 6 | Stack Traceタブ存在 | 有 | script_editor_debugger.cpp | 2064-2065 | `VBoxContainer *vbc = memnew(VBoxContainer); vbc->set_name(TTRC("Stack Trace"));` |
| 7 | Errorsタブ存在 | 有 | script_editor_debugger.cpp | 2218-2219 | `errors_tab = memnew(VBoxContainer); errors_tab->set_name(TTRC("Errors"));` |
| 8 | Evaluatorタブ存在 | 有 | script_editor_debugger.cpp | 2282-2285 | `expression_evaluator = memnew(EditorExpressionEvaluator); expression_evaluator->set_name(TTRC("Evaluator"));` |
| 9 | Profilerタブ存在 | 有 | script_editor_debugger.cpp | 2289-2291 | `profiler = memnew(EditorProfiler); profiler->set_name(TTRC("Profiler"));` |
| 10 | Visual Profilerタブ存在 | 有 | script_editor_debugger.cpp | 2297-2299 | `visual_profiler = memnew(EditorVisualProfiler); visual_profiler->set_name(TTRC("Visual Profiler"));` |
| 11 | Monitorsタブ存在 | 有 | script_editor_debugger.cpp | 2304-2305 | `performance_profiler = memnew(EditorPerformanceProfiler); tabs->add_child(performance_profiler);` |
| 12 | Video RAMタブ存在 | 有 | script_editor_debugger.cpp | 2361 | `vmem_vb->set_name(TTRC("Video RAM"));` |
| 13 | Miscタブ存在 | 有 | script_editor_debugger.cpp | 2384-2386 | `VBoxContainer *misc = memnew(VBoxContainer); misc->set_name(TTRC("Misc"));` |

### 3. デバッグコントロールボタンに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 14 | Skip Breakpointsボタン | 有 | script_editor_debugger.cpp | 2082-2086 | `skip_breakpoints = memnew(Button); ... skip_breakpoints->set_tooltip_text(TTRC("Skip Breakpoints"));` |
| 15 | Ignore Error Breaksボタン | 有 | script_editor_debugger.cpp | 2088-2092 | `ignore_error_breaks = memnew(Button); ... ignore_error_breaks->set_tooltip_text(TTRC("Ignore Error Breaks"));` |
| 16 | Copy Errorボタン | 有 | script_editor_debugger.cpp | 2096-2100 | `copy = memnew(Button); ... copy->set_tooltip_text(TTRC("Copy Error"));` |
| 17 | Step Intoボタン | 有 | script_editor_debugger.cpp | 2104-2109 | `step = memnew(Button); ... step->set_tooltip_text(TTRC("Step Into"));` |
| 18 | Step Overボタン | 有 | script_editor_debugger.cpp | 2111-2116 | `next = memnew(Button); ... next->set_tooltip_text(TTRC("Step Over"));` |
| 19 | Step Outボタン | 有 | script_editor_debugger.cpp | 2118-2123 | `out = memnew(Button); ... out->set_tooltip_text(TTRC("Step Out"));` |
| 20 | Breakボタン | 有 | script_editor_debugger.cpp | 2127-2132 | `dobreak = memnew(Button); ... dobreak->set_tooltip_text(TTRC("Break"));` |
| 21 | Continueボタン | 有 | script_editor_debugger.cpp | 2134-2139 | `docontinue = memnew(Button); ... docontinue->set_tooltip_text(TTRC("Continue"));` |

### 4. Stack Traceタブコンポーネントに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 22 | reasonがRichTextLabel | 有 | script_editor_debugger.cpp | 2071-2078 | `reason = memnew(RichTextLabel); reason->set_selection_enabled(true);` |
| 23 | スレッド選択用OptionButton | 有 | script_editor_debugger.cpp | 2151-2155 | `threads = memnew(OptionButton); ... threads->connect("item_selected", ...&_select_thread);` |
| 24 | スタックダンプ用Tree | 有 | script_editor_debugger.cpp | 2157-2167 | `stack_dump = memnew(Tree); ... stack_dump->set_column_title(0, TTRC("Stack Frames"));` |
| 25 | 変数検索用LineEdit | 有 | script_editor_debugger.cpp | 2177-2182 | `search = memnew(LineEdit); search->set_placeholder(TTRC("Filter Stack Variables"));` |
| 26 | EditorDebuggerInspectorで変数表示 | 有 | script_editor_debugger.cpp | 2184-2194 | `inspector = memnew(EditorDebuggerInspector); ... inspector->set_read_only(true);` |
| 27 | ブレークポイントツリー | 有 | script_editor_debugger.cpp | 2196-2207 | `breakpoints_tree = memnew(Tree); ... breakpoints_tree->set_column_title(0, TTRC("Breakpoints"));` |

### 5. Errorsタブコンポーネントに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 28 | Expand Allボタン | 有 | script_editor_debugger.cpp | 2224-2228 | `expand_all_button = memnew(Button); expand_all_button->set_text(TTRC("Expand All"));` |
| 29 | Collapse Allボタン | 有 | script_editor_debugger.cpp | 2230-2234 | `collapse_all_button = memnew(Button); collapse_all_button->set_text(TTRC("Collapse All"));` |
| 30 | Clearボタン | 有 | script_editor_debugger.cpp | 2240-2244 | `clear_button = memnew(Button); clear_button->set_text(TTRC("Clear"));` |
| 31 | エラーツリーが2カラム | 有 | script_editor_debugger.cpp | 2247-2248 | `error_tree = memnew(Tree); error_tree->set_columns(2);` |

### 6. Video RAMタブコンポーネントに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 32 | Total表示用LineEdit | 有 | script_editor_debugger.cpp | 2338-2342 | `vmem_total = memnew(LineEdit); vmem_total->set_editable(false);` |
| 33 | Refreshボタン | 有 | script_editor_debugger.cpp | 2343-2346 | `vmem_refresh = memnew(Button); ... vmem_refresh->connect(..., &_video_mem_request);` |
| 34 | Exportボタン | 有 | script_editor_debugger.cpp | 2347-2350 | `vmem_export = memnew(Button); vmem_export->set_tooltip_text(TTRC("Export list to a CSV file"));` |
| 35 | vmem_treeが4カラム | 有 | script_editor_debugger.cpp | 2360-2374 | `vmem_tree = memnew(Tree); vmem_tree->set_columns(4);` |
| 36 | Resource Pathカラム | 有 | script_editor_debugger.cpp | 2364 | `vmem_tree->set_column_title(0, TTRC("Resource Path"));` |
| 37 | Typeカラム | 有 | script_editor_debugger.cpp | 2367 | `vmem_tree->set_column_title(1, TTRC("Type"));` |
| 38 | Formatカラム | 有 | script_editor_debugger.cpp | 2370 | `vmem_tree->set_column_title(2, TTRC("Format"));` |
| 39 | Usageカラム | 有 | script_editor_debugger.cpp | 2373 | `vmem_tree->set_column_title(3, TTRC("Usage"));` |

### 7. Miscタブコンポーネントに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 40 | Clicked Control表示 | 有 | script_editor_debugger.cpp | 2391-2396 | `clicked_ctrl = memnew(LineEdit); ... info_left->add_child(memnew(Label(TTRC("Clicked Control:"))));` |
| 41 | Clicked Control Type表示 | 有 | script_editor_debugger.cpp | 2397-2401 | `clicked_ctrl_type = memnew(LineEdit); ... info_left->add_child(memnew(Label(TTRC("Clicked Control Type:"))));` |
| 42 | Live Edit Root設定 | 有 | script_editor_debugger.cpp | 2404-2420 | `live_edit_root = memnew(LineEdit); ... le_set = memnew(Button(TTRC("Set From Tree"))); le_clear = memnew(Button(TTRC("Clear")));` |
| 43 | Export measures as CSVボタン | 有 | script_editor_debugger.cpp | 2427-2429 | `export_csv = memnew(Button(TTRC("Export measures as CSV")));` |

### 8. デバッグコマンド処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 44 | debug_step実装 | 有 | script_editor_debugger.cpp | 128-133 | `void ScriptEditorDebugger::debug_step() { ... _put_msg("step", Array(), debugging_thread_id);` |
| 45 | debug_next実装 | 有 | script_editor_debugger.cpp | 121-126 | `void ScriptEditorDebugger::debug_next() { ... _put_msg("next", Array(), debugging_thread_id);` |
| 46 | debug_out実装 | 有 | script_editor_debugger.cpp | 114-119 | `void ScriptEditorDebugger::debug_out() { ... _put_msg("out", Array(), debugging_thread_id);` |
| 47 | debug_break実装 | 有 | script_editor_debugger.cpp | 135-140 | `void ScriptEditorDebugger::debug_break() { ... _put_msg("break", Array());` |
| 48 | debug_continue実装 | 有 | script_editor_debugger.cpp | 142-154 | `void ScriptEditorDebugger::debug_continue() { ... _put_msg("continue", Array(), debugging_thread_id);` |

### 9. メッセージハンドラに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 49 | _msg_debug_enter実装 | 有 | script_editor_debugger.cpp | 356-384 | `void ScriptEditorDebugger::_msg_debug_enter(uint64_t p_thread_id, const Array &p_data) { ... threads_debugged.insert(p_thread_id, td);` |
| 50 | _msg_stack_dump実装 | 有 | script_editor_debugger.cpp | 513-542 | `void ScriptEditorDebugger::_msg_stack_dump(uint64_t p_thread_id, const Array &p_data) { ... stack_dump->clear();` |
| 51 | _msg_output実装 | 有 | script_editor_debugger.cpp | 555-587 | `void ScriptEditorDebugger::_msg_output(uint64_t p_thread_id, const Array &p_data) { ... EditorNode::get_log()->add_message(...);` |

### 10. その他の機能に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 52 | VRAM情報取得リクエスト | 有 | script_editor_debugger.cpp | 320-322 | `void ScriptEditorDebugger::_video_mem_request() { _put_msg("servers:memory", Array()); }` |

## 信頼度スコア計算

```
claims_with_evidence: 52
claims_without_evidence: 0
claims_total: 52
confidence_derived: 52 / 52 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

デバッガは複雑なマルチタブインターフェースを持ち、Stack Trace、Errors、Evaluator、Profiler、Visual Profiler、Monitors、Video RAM、Miscの8つのタブで構成されている。RemoteDebuggerPeerを通じたリモートプロセスとの通信、スレッドごとのデバッグ状態管理、ステップ実行制御など、高度なデバッグ機能が実装されており、設計書の記載内容はソースコードに完全に基づいた信頼性の高い文書である。
