---
generated_at: 2026-01-23 11:45:00
metrics:
  claims_total: 55
  claims_with_evidence: 55
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 16-オーディオバス

## 概要

本レポートは「画面設計書 16-オーディオバス」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・クラス構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | EditorAudioBusesはEditorDockを継承 | 有 | editor_audio_buses.h | 151-152 | `class EditorAudioBuses : public EditorDock { GDCLASS(EditorAudioBuses, EditorDock);` |
| 2 | ドック名は「Audio」 | 有 | editor_audio_buses.cpp | 1373 | `set_name(TTRC("Audio"));` |
| 3 | アイコン名は「AudioStreamPlayer」 | 有 | editor_audio_buses.cpp | 1374 | `set_icon_name("AudioStreamPlayer");` |
| 4 | ショートカットはAlt+A | 有 | editor_audio_buses.cpp | 1375 | `set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("bottom_panels/toggle_audio_bottom_panel", TTRC("Toggle Audio Dock"), KeyModifierMask::ALT | Key::A));` |
| 5 | デフォルトスロットは下部 | 有 | editor_audio_buses.cpp | 1376 | `set_default_slot(EditorDock::DOCK_SLOT_BOTTOM);` |
| 6 | 水平/フローティングレイアウト対応 | 有 | editor_audio_buses.cpp | 1377 | `set_available_layouts(EditorDock::DOCK_LAYOUT_HORIZONTAL | EditorDock::DOCK_LAYOUT_FLOATING);` |

### 2. EditorAudioBus構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 7 | EditorAudioBusはPanelContainerを継承 | 有 | editor_audio_buses.h | 52-53 | `class EditorAudioBus : public PanelContainer { GDCLASS(EditorAudioBus, PanelContainer);` |
| 8 | track_name LineEdit存在 | 有 | editor_audio_buses.cpp | 838-842 | `track_name = memnew(LineEdit); ... track_name->connect(SceneStringName(text_submitted), ...);` |
| 9 | slider VSlider存在 | 有 | editor_audio_buses.cpp | 906-910 | `slider = memnew(VSlider); slider->set_min(0.0); slider->set_max(1.0);` |
| 10 | soloボタン存在 | 有 | editor_audio_buses.cpp | 846-852 | `solo = memnew(Button); solo->set_toggle_mode(true); solo->set_tooltip_text(TTR("Solo"));` |
| 11 | muteボタン存在 | 有 | editor_audio_buses.cpp | 853-858 | `mute = memnew(Button); mute->set_toggle_mode(true); mute->set_tooltip_text(TTR("Mute"));` |
| 12 | bypassボタン存在 | 有 | editor_audio_buses.cpp | 860-866 | `bypass = memnew(Button); bypass->set_toggle_mode(true); bypass->set_tooltip_text(TTR("Bypass"));` |
| 13 | sendオプションボタン存在 | 有 | editor_audio_buses.cpp | 992-997 | `send = memnew(OptionButton); ... send->connect("item_selected", ...&_send_selected);` |
| 14 | effectsツリー存在 | 有 | editor_audio_buses.cpp | 972-989 | `effects = memnew(Tree); effects->set_hide_root(true);` |

### 3. VUメーターに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 15 | CHANNELS_MAX定義 | 有 | editor_audio_buses.h | 61 | `static const int CHANNELS_MAX = 4;` |
| 16 | チャンネル構造体定義 | 有 | editor_audio_buses.h | 63-71 | `struct { bool prev_active = false; float peak_l = 0; float peak_r = 0; TextureProgressBar *vu_l; TextureProgressBar *vu_r; } channel[CHANNELS_MAX];` |
| 17 | VU最小値-80dB | 有 | editor_audio_buses.cpp | 946 | `channel[i].vu_l->set_min(-80);` |
| 18 | VU最大値24dB | 有 | editor_audio_buses.cpp | 947 | `channel[i].vu_l->set_max(24);` |
| 19 | TextureProgressBar使用 | 有 | editor_audio_buses.cpp | 943-957 | `channel[i].vu_l = memnew(TextureProgressBar); channel[i].vu_l->set_fill_mode(TextureProgressBar::FILL_BOTTOM_TO_TOP);` |

### 4. ボリューム変換に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 20 | 正規化→dB変換式 | 有 | editor_audio_buses.cpp | 377-394 | `float EditorAudioBus::_normalized_volume_to_scaled_db(float normalized) { if (normalized > 0.6f) { return 22.22f * normalized - 16.2f; } ...` |
| 21 | dB→正規化変換式 | 有 | editor_audio_buses.cpp | 396-416 | `float EditorAudioBus::_scaled_db_to_normalized_volume(float db) { if (db > -2.88) { return (db + 16.2f) / 22.22f; } ...` |

### 5. ツールバーボタンに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 22 | Add Busボタン | 有 | editor_audio_buses.cpp | 1397-1401 | `add = memnew(Button); ... add->set_text(TTR("Add Bus"));` |
| 23 | Loadボタン | 有 | editor_audio_buses.cpp | 1406-1410 | `load = memnew(Button); load->set_text(TTR("Load"));` |
| 24 | Save Asボタン | 有 | editor_audio_buses.cpp | 1412-1416 | `save_as = memnew(Button); save_as->set_text(TTR("Save As"));` |
| 25 | Load Defaultボタン | 有 | editor_audio_buses.cpp | 1418-1422 | `_default = memnew(Button); _default->set_text(TTR("Load Default"));` |
| 26 | Createボタン | 有 | editor_audio_buses.cpp | 1424-1428 | `_new = memnew(Button); _new->set_text(TTR("Create"));` |

### 6. バス操作処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 27 | バス追加処理 | 有 | editor_audio_buses.cpp | 1176-1183 | `void EditorAudioBuses::_add_bus() { ... ur->add_do_method(AudioServer::get_singleton(), "set_bus_count", ...+1);` |
| 28 | バス削除処理 | 有 | editor_audio_buses.cpp | 1199-1223 | `void EditorAudioBuses::_delete_bus(Object *p_which) { ... ur->add_do_method(AudioServer::get_singleton(), "remove_bus", index);` |
| 29 | バス複製処理 | 有 | editor_audio_buses.cpp | 1225-1243 | `void EditorAudioBuses::_duplicate_bus(int p_which) { ... ur->add_do_method(AudioServer::get_singleton(), "add_bus", add_at_pos);` |
| 30 | ボリュームリセット | 有 | editor_audio_buses.cpp | 1245-1256 | `void EditorAudioBuses::_reset_bus_volume(Object *p_which) { ... ur->add_do_method(AudioServer::get_singleton(), "set_bus_volume_db", index, 0.f);` |

### 7. VUメーター更新処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 31 | NOTIFICATION_PROCESSで更新 | 有 | editor_audio_buses.cpp | 160-203 | `case NOTIFICATION_PROCESS: { ... for (int i = 0; i < cc; i++) { ...` |
| 32 | AudioServer::get_bus_peak_volume使用 | 有 | editor_audio_buses.cpp | 172-173 | `real_peak[0] = MAX(real_peak[0], AudioServer::get_singleton()->get_bus_peak_volume_left_db(get_index(), i));` |
| 33 | 減衰速度60dB/秒 | 有 | editor_audio_buses.cpp | 179, 185 | `channel[i].peak_l -= get_process_delta_time() * 60.0;` |
| 34 | disabled_vuテクスチャ使用 | 有 | editor_audio_buses.cpp | 90, 196-197 | `disabled_vu = get_editor_theme_icon(SNAME("BusVuFrozen"));` `channel[i].vu_l->set_over_texture(disabled_vu);` |

### 8. ソロ/ミュート/バイパス処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 35 | solo処理 | 有 | editor_audio_buses.cpp | 457-469 | `void EditorAudioBus::_solo_toggled() { ... ur->add_do_method(AudioServer::get_singleton(), "set_bus_solo", ...);` |
| 36 | mute処理 | 有 | editor_audio_buses.cpp | 471-483 | `void EditorAudioBus::_mute_toggled() { ... ur->add_do_method(AudioServer::get_singleton(), "set_bus_mute", ...);` |
| 37 | bypass処理 | 有 | editor_audio_buses.cpp | 485-497 | `void EditorAudioBus::_bypass_toggled() { ... ur->add_do_method(AudioServer::get_singleton(), "set_bus_bypass_effects", ...);` |

### 9. エフェクト管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 38 | エフェクトオプションポップアップ | 有 | editor_audio_buses.cpp | 1001-1016 | `effect_options = memnew(PopupMenu); ... effect_options->add_item(name); effect_options->set_item_metadata(-1, E);` |
| 39 | エフェクト削除ポップアップ | 有 | editor_audio_buses.cpp | 1032-1035 | `delete_effect_popup = memnew(PopupMenu); delete_effect_popup->add_item(TTR("Delete Effect"));` |
| 40 | エフェクト削除処理 | 有 | editor_audio_buses.cpp | 774-794 | `void EditorAudioBus::_delete_effect_pressed(int p_option) { ... ur->add_do_method(AudioServer::get_singleton(), "remove_bus_effect", ...);` |

### 10. レイアウト保存/読込に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 41 | 自動保存タイマー | 有 | editor_audio_buses.cpp | 1444-1448 | `save_timer = memnew(Timer); save_timer->set_wait_time(0.8); save_timer->set_one_shot(true); ... save_timer->connect("timeout", ...&_server_save);` |
| 42 | サーバー保存処理 | 有 | editor_audio_buses.cpp | 1280-1294 | `void EditorAudioBuses::_server_save() { Ref<AudioBusLayout> state = AudioServer::get_singleton()->generate_bus_layout(); ... ResourceSaver::save(state, ...);` |
| 43 | レイアウト読込処理 | 有 | editor_audio_buses.cpp | 1467-1489 | `void EditorAudioBuses::open_layout(const String &p_path) { ... AudioServer::get_singleton()->set_bus_layout(state);` |
| 44 | 新規レイアウト処理 | 有 | editor_audio_buses.cpp | 1314-1320 | `void EditorAudioBuses::_new_layout() { file_dialog->set_file_mode(EditorFileDialog::FILE_MODE_SAVE_FILE); file_dialog->set_title(TTR("Location for New Layout..."));` |

### 11. ドラッグ&ドロップに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 45 | バス移動ドラッグデータ | 有 | editor_audio_buses.cpp | 1067-1070 | `bool EditorAudioBusDrop::can_drop_data(...) { ... return (d.has("type") && String(d["type"]) == "move_audio_bus");` |
| 46 | エフェクト移動ドラッグデータ | 有 | editor_audio_buses.cpp | 700-703 | `if (!d.has("type") || String(d["type"]) != "audio_bus_effect") { return false; }` |
| 47 | ドロップ位置移動 | 有 | editor_audio_buses.cpp | 1268-1278 | `void EditorAudioBuses::_drop_at_index(int p_bus, int p_index) { ... ur->add_do_method(AudioServer::get_singleton(), "move_bus", p_bus, p_index);` |
| 48 | EditorAudioBusDropクラス | 有 | editor_audio_buses.h | 138-149 | `class EditorAudioBusDrop : public Control { GDCLASS(EditorAudioBusDrop, Control);` |

### 12. バスオプションメニューに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 49 | bus_optionsメニューボタン | 有 | editor_audio_buses.cpp | 1018-1023 | `bus_options = memnew(MenuButton); ... bus_options->set_tooltip_text(TTR("Bus Options"));` |
| 50 | 複製ショートカット | 有 | editor_audio_buses.cpp | 1026 | `bus_popup->add_shortcut(ED_SHORTCUT("audio_bus_editor/duplicate_selected_bus", TTRC("Duplicate Bus"), KeyModifierMask::CMD_OR_CTRL | Key::D));` |
| 51 | 削除ショートカット | 有 | editor_audio_buses.cpp | 1027 | `bus_popup->add_shortcut(ED_SHORTCUT("audio_bus_editor/delete_selected_bus", TTRC("Delete Bus"), Key::KEY_DELETE));` |
| 52 | Reset Volumeメニュー | 有 | editor_audio_buses.cpp | 1029 | `bus_popup->add_item(TTR("Reset Volume"));` |

### 13. EditorAudioMeterNotchesに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 53 | EditorAudioMeterNotchesクラス定義 | 有 | editor_audio_buses.h | 218-272 | `class EditorAudioMeterNotches : public Control { GDCLASS(EditorAudioMeterNotches, Control);` |
| 54 | 目盛り追加処理 | 有 | editor_audio_buses.cpp | 963-970 | `EditorAudioMeterNotches *scale = memnew(EditorAudioMeterNotches); for (float db = 6.0f; db >= -80.0f; db -= 6.0f) { bool renderNotch = (db >= -6.0f || db == -24.0f || db == -72.0f); scale->add_notch(...);` |
| 55 | AudioNotch構造体 | 有 | editor_audio_buses.h | 222-246 | `struct AudioNotch { float relative_position = 0; float db_value = 0; bool render_db_value = false; ...` |

## 信頼度スコア計算

```
claims_with_evidence: 55
claims_without_evidence: 0
claims_total: 55
confidence_derived: 55 / 55 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

オーディオバスエディタは複雑なオーディオミキサーインターフェースを提供しており、EditorAudioBuses（全体管理）、EditorAudioBus（個別バス）、EditorAudioBusDrop（ドラッグ&ドロップ）、EditorAudioMeterNotches（VUメーター目盛り）の4つのクラスで構成されている。VUメーター更新、ボリューム変換（対数スケール）、エフェクト管理、レイアウト保存/読込など、多岐にわたる機能が実装されており、設計書の記載内容はソースコードに完全に基づいた信頼性の高い文書である。
