---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 17-アニメーションエディタ

## 概要

本レポートは「画面設計書 17-アニメーションエディタ」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・クラス構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | AnimationPlayerEditorはEditorDockを継承 | 有 | animation_player_editor_plugin.h | 47-48 | `class AnimationPlayerEditor : public EditorDock { GDCLASS(AnimationPlayerEditor, EditorDock);` |
| 2 | ドック名は「Animation」 | 有 | animation_player_editor_plugin.cpp | 2056 | `set_name(TTRC("Animation"));` |
| 3 | アイコン名は「Animation」 | 有 | animation_player_editor_plugin.cpp | 2057 | `set_icon_name("Animation");` |
| 4 | ショートカットはAlt+N | 有 | animation_player_editor_plugin.cpp | 2058 | `set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("bottom_panels/toggle_animation_bottom_panel", TTRC("Toggle Animation Dock"), KeyModifierMask::ALT | Key::N));` |
| 5 | デフォルトスロットは下部 | 有 | animation_player_editor_plugin.cpp | 2059 | `set_default_slot(EditorDock::DOCK_SLOT_BOTTOM);` |
| 6 | 水平/フローティングレイアウト対応 | 有 | animation_player_editor_plugin.cpp | 2060 | `set_available_layouts(EditorDock::DOCK_LAYOUT_HORIZONTAL | EditorDock::DOCK_LAYOUT_FLOATING);` |
| 7 | シングルトンパターン | 有 | animation_player_editor_plugin.h | 140 | `static AnimationPlayerEditor *singleton;` |

### 2. 再生コントロールに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 8 | play_bw_fromボタン | 有 | animation_player_editor_plugin.cpp | 2074-2076 | `play_bw_from = memnew(Button); play_bw_from->set_theme_type_variation(SceneStringName(FlatButton));` |
| 9 | play_bwボタン | 有 | animation_player_editor_plugin.cpp | 2078-2080 | `play_bw = memnew(Button); play_bw->set_theme_type_variation(SceneStringName(FlatButton));` |
| 10 | stopボタン | 有 | animation_player_editor_plugin.cpp | 2082-2084 | `stop = memnew(Button); stop->set_theme_type_variation(SceneStringName(FlatButton));` |
| 11 | playボタン | 有 | animation_player_editor_plugin.cpp | 2086-2088 | `play = memnew(Button); play->set_theme_type_variation(SceneStringName(FlatButton));` |
| 12 | play_fromボタン | 有 | animation_player_editor_plugin.cpp | 2090-2092 | `play_from = memnew(Button); play_from->set_theme_type_variation(SceneStringName(FlatButton));` |
| 13 | frameスピンボックス | 有 | animation_player_editor_plugin.cpp | 2094-2099 | `frame = memnew(SpinBox); ... frame->set_tooltip_text(TTR("Animation position (in seconds)."));` |

### 3. アニメーション管理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 14 | tool_animメニューボタン | 有 | animation_player_editor_plugin.cpp | 2114-2132 | `tool_anim = memnew(MenuButton); tool_anim->set_text(TTR("Animation"));` |
| 15 | animationオプションボタン | 有 | animation_player_editor_plugin.cpp | 2134-2140 | `animation = memnew(OptionButton); animation->set_tooltip_text(TTR("Display list of animations in player."));` |
| 16 | autoplayボタン | 有 | animation_player_editor_plugin.cpp | 2142-2145 | `autoplay = memnew(Button); autoplay->set_tooltip_text(TTR("Autoplay on Load"));` |
| 17 | pinボタン | 有 | animation_player_editor_plugin.cpp | 2186-2191 | `pin = memnew(Button); pin->set_toggle_mode(true); pin->set_tooltip_text(TTR("Pin AnimationPlayer"));` |

### 4. オニオンスキニングに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 18 | onion_toggleボタン | 有 | animation_player_editor_plugin.cpp | 2154-2159 | `onion_toggle = memnew(Button); onion_toggle->set_toggle_mode(true); onion_toggle->set_tooltip_text(TTR("Enable Onion Skinning"));` |
| 19 | onion_skinningメニュー | 有 | animation_player_editor_plugin.cpp | 2161-2182 | `onion_skinning = memnew(MenuButton); onion_skinning->set_tooltip_text(TTR("Onion Skinning Options"));` |
| 20 | Pastオプション | 有 | animation_player_editor_plugin.cpp | 2168-2169 | `onion_skinning->get_popup()->add_check_item(TTR("Past"), ONION_SKINNING_PAST);` |
| 21 | Futureオプション | 有 | animation_player_editor_plugin.cpp | 2171 | `onion_skinning->get_popup()->add_check_item(TTR("Future"), ONION_SKINNING_FUTURE);` |
| 22 | 1/2/3ステップオプション | 有 | animation_player_editor_plugin.cpp | 2173-2176 | `onion_skinning->get_popup()->add_radio_check_item(TTR("1 step"), ONION_SKINNING_1_STEP);` |
| 23 | Differences Onlyオプション | 有 | animation_player_editor_plugin.cpp | 2178 | `onion_skinning->get_popup()->add_check_item(TTR("Differences Only"), ONION_SKINNING_DIFFERENCES_ONLY);` |
| 24 | Force White Modulateオプション | 有 | animation_player_editor_plugin.cpp | 2179 | `onion_skinning->get_popup()->add_check_item(TTR("Force White Modulate"), ONION_SKINNING_FORCE_WHITE_MODULATE);` |
| 25 | Include Gizmos (3D)オプション | 有 | animation_player_editor_plugin.cpp | 2180 | `onion_skinning->get_popup()->add_check_item(TTR("Include Gizmos (3D)"), ONION_SKINNING_INCLUDE_GIZMOS);` |

### 5. ツールメニュー項目に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 26 | New...メニュー項目 | 有 | animation_player_editor_plugin.cpp | 2119 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/new_animation", TTRC("New...")), TOOL_NEW_ANIM);` |
| 27 | Manage Animations...メニュー項目 | 有 | animation_player_editor_plugin.cpp | 2121 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/animation_libraries", TTRC("Manage Animations...")), TOOL_ANIM_LIBRARY);` |
| 28 | Duplicate...メニュー項目 | 有 | animation_player_editor_plugin.cpp | 2123 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/duplicate_animation", TTRC("Duplicate...")), TOOL_DUPLICATE_ANIM);` |
| 29 | Rename...メニュー項目 | 有 | animation_player_editor_plugin.cpp | 2125 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/rename_animation", TTRC("Rename...")), TOOL_RENAME_ANIM);` |
| 30 | Edit Transitions...メニュー項目 | 有 | animation_player_editor_plugin.cpp | 2126 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/edit_transitions", TTRC("Edit Transitions...")), TOOL_EDIT_TRANSITIONS);` |
| 31 | Open in Inspectorメニュー項目 | 有 | animation_player_editor_plugin.cpp | 2127 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/open_animation_in_inspector", TTRC("Open in Inspector")), TOOL_EDIT_RESOURCE);` |
| 32 | Removeメニュー項目 | 有 | animation_player_editor_plugin.cpp | 2129 | `tool_anim->get_popup()->add_shortcut(ED_SHORTCUT("animation_player_editor/remove_animation", TTRC("Remove")), TOOL_REMOVE_ANIM);` |

### 6. 再生処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 33 | _play_pressed実装 | 有 | animation_player_editor_plugin.cpp | 315-335 | `void AnimationPlayerEditor::_play_pressed() { ... player->play(current); ... stop->set_button_icon(pause_icon);` |
| 34 | _play_from_pressed実装 | 有 | animation_player_editor_plugin.cpp | 337-359 | `void AnimationPlayerEditor::_play_from_pressed() { ... player->seek_internal(time, ...); player->play(current);` |
| 35 | _play_bw_pressed実装 | 有 | animation_player_editor_plugin.cpp | 368-387 | `void AnimationPlayerEditor::_play_bw_pressed() { ... player->play_backwards(current);` |
| 36 | _stop_pressed実装 | 有 | animation_player_editor_plugin.cpp | 413-428 | `void AnimationPlayerEditor::_stop_pressed() { ... player->pause(); ... player->stop();` |

### 7. ダイアログに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 37 | name_dialog | 有 | animation_player_editor_plugin.cpp | 2196-2221 | `name_dialog = memnew(ConfirmationDialog); name_dialog->set_title(TTR("Create New Animation"));` |
| 38 | name入力欄 | 有 | animation_player_editor_plugin.cpp | 2207-2209 | `name = memnew(LineEdit); name_hb->add_child(name);` |
| 39 | library選択ドロップダウン | 有 | animation_player_editor_plugin.cpp | 2210-2212 | `library = memnew(OptionButton); name_hb->add_child(library);` |
| 40 | blend_editor.dialog | 有 | animation_player_editor_plugin.cpp | 2223-2246 | `blend_editor.dialog = memnew(AcceptDialog); blend_editor.dialog->set_title(TTR("Cross-Animation Blend Times"));` |
| 41 | blend_editor.tree | 有 | animation_player_editor_plugin.cpp | 2232-2241 | `blend_editor.tree = memnew(Tree); blend_editor.tree->set_columns(2);` |
| 42 | blend_editor.next | 有 | animation_player_editor_plugin.cpp | 2243-2246 | `blend_editor.next = memnew(OptionButton); ... blend_vb->add_margin_child(TTR("Next (Auto Queue):"), blend_editor.next);` |

### 8. トラックエディタに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 43 | track_editor生成 | 有 | animation_player_editor_plugin.cpp | 2149-2150 | `track_editor = memnew(AnimationTrackEditor); hb->add_child(track_editor->get_edit_menu());` |
| 44 | track_editor接続 | 有 | animation_player_editor_plugin.cpp | 2261-2264 | `main_vbox_container->add_child(track_editor); track_editor->connect("timeline_changed", ...); track_editor->connect("animation_len_changed", ...);` |

### 9. オニオンスキニング処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 45 | _start_onion_skinning | 有 | animation_player_editor_plugin.cpp | 1938-1947 | `void AnimationPlayerEditor::_start_onion_skinning() { ... get_tree()->connect("process_frame", ...&_prepare_onion_layers_1);` |
| 46 | forward_force_draw_over_viewport | 有 | animation_player_editor_plugin.cpp | 1306-1354 | `void AnimationPlayerEditor::forward_force_draw_over_viewport(Control *p_overlay) { ... RS::get_singleton()->canvas_item_add_texture_rect_region(...);` |
| 47 | onionシェーダー | 有 | animation_player_editor_plugin.cpp | 2283-2299 | `onion.capture.shader->set_code(R"(shader_type canvas_item; uniform vec4 bkg_color; ...` |

### 10. シグナル・イベントに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 48 | animation_selectedシグナル | 有 | animation_player_editor_plugin.cpp | 2039 | `ADD_SIGNAL(MethodInfo("animation_selected", PropertyInfo(Variant::STRING, "name")));` |
| 49 | animation_list_changed接続 | 有 | animation_player_editor_plugin.cpp | 1273-1274 | `player->connect("animation_list_changed", callable_mp(this, &AnimationPlayerEditor::_animation_libraries_updated), CONNECT_DEFERRED);` |
| 50 | current_animation_changed接続 | 有 | animation_player_editor_plugin.cpp | 1279-1280 | `player->connect("current_animation_changed", callable_mp(this, &AnimationPlayerEditor::_current_animation_changed));` |

## 信頼度スコア計算

```
claims_with_evidence: 50
claims_without_evidence: 0
claims_total: 50
confidence_derived: 50 / 50 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

アニメーションエディタはEditorDockを継承した複合的なUIコンポーネントであり、再生コントロール、アニメーション選択、ツールメニュー、オニオンスキニング、トラック編集など多岐にわたる機能を統合している。特にオニオンスキニング機能はRenderingServerを直接使用したビューポートキャプチャとシェーダー処理を含む高度な実装となっている。設計書の記載内容はソースコードに完全に基づいた信頼性の高い文書である。
