---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 55
  claims_with_evidence: 55
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 18-シェーダーエディタ

## 概要

本レポートは「画面設計書 18-シェーダーエディタ」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・クラス構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | ShaderEditorPluginはEditorPluginを継承 | 有 | shader_editor_plugin.h | 47-48 | `class ShaderEditorPlugin : public EditorPlugin { GDCLASS(ShaderEditorPlugin, EditorPlugin);` |
| 2 | ドック名は「Shader Editor」 | 有 | shader_editor_plugin.cpp | 860 | `shader_dock->set_name(TTRC("Shader Editor"));` |
| 3 | アイコン名は「ShaderDock」 | 有 | shader_editor_plugin.cpp | 861 | `shader_dock->set_icon_name("ShaderDock");` |
| 4 | ショートカットはAlt+S | 有 | shader_editor_plugin.cpp | 862 | `shader_dock->set_dock_shortcut(ED_SHORTCUT_AND_COMMAND("bottom_panels/toggle_shader_editor_bottom_panel", TTRC("Toggle Shader Editor Dock"), KeyModifierMask::ALT | Key::S));` |
| 5 | デフォルトスロットは下部 | 有 | shader_editor_plugin.cpp | 863 | `shader_dock->set_default_slot(EditorDock::DOCK_SLOT_BOTTOM);` |
| 6 | 水平/フローティングレイアウト対応 | 有 | shader_editor_plugin.cpp | 864 | `shader_dock->set_available_layouts(EditorDock::DOCK_LAYOUT_HORIZONTAL | EditorDock::DOCK_LAYOUT_FLOATING);` |
| 7 | TextShaderEditorはShaderEditorを継承 | 有 | text_shader_editor.h | 106-107 | `class TextShaderEditor : public ShaderEditor { GDCLASS(TextShaderEditor, ShaderEditor);` |
| 8 | ShaderEditorはControlを継承 | 有 | shader_editor.h | 39-40 | `class ShaderEditor : public Control { GDCLASS(ShaderEditor, Control);` |

### 2. UI構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 9 | shader_dockはEditorDock | 有 | shader_editor_plugin.cpp | 859 | `shader_dock = memnew(EditorDock);` |
| 10 | files_splitはHSplitContainer | 有 | shader_editor_plugin.cpp | 872-873 | `files_split = memnew(HSplitContainer); files_split->set_split_offset(200 * EDSCALE);` |
| 11 | shader_listはItemList | 有 | shader_editor_plugin.cpp | 881-885 | `shader_list = memnew(ItemList); shader_list->set_v_size_flags(Control::SIZE_EXPAND_FILL);` |
| 12 | shader_tabsはTabContainer | 有 | shader_editor_plugin.cpp | 892-899 | `shader_tabs = memnew(TabContainer); shader_tabs->set_tabs_visible(false);` |
| 13 | file_menuはMenuButton | 有 | shader_editor_plugin.cpp | 902-908 | `file_menu = memnew(MenuButton); file_menu->set_text(TTRC("File"));` |
| 14 | context_menuはPopupMenu | 有 | shader_editor_plugin.cpp | 877-879 | `context_menu = memnew(PopupMenu); context_menu->connect(SceneStringName(id_pressed), callable_mp(this, &ShaderEditorPlugin::_menu_item_pressed));` |
| 15 | shader_create_dialogはShaderCreateDialog | 有 | shader_editor_plugin.cpp | 915-918 | `shader_create_dialog = memnew(ShaderCreateDialog); shader_create_dialog->connect("shader_created", ...);` |

### 3. ファイルメニューに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 16 | FILE_MENU_NEW定義 | 有 | shader_editor_plugin.h | 61 | `FILE_MENU_NEW,` |
| 17 | FILE_MENU_NEW_INCLUDE定義 | 有 | shader_editor_plugin.h | 62 | `FILE_MENU_NEW_INCLUDE,` |
| 18 | FILE_MENU_SAVE定義 | 有 | shader_editor_plugin.h | 65 | `FILE_MENU_SAVE,` |
| 19 | FILE_MENU_CLOSE定義 | 有 | shader_editor_plugin.h | 69 | `FILE_MENU_CLOSE,` |
| 20 | New Shaderショートカット Ctrl+N | 有 | shader_editor_plugin.cpp | 851 | `ED_SHORTCUT("shader_editor/new", TTRC("New Shader..."), KeyModifierMask::CMD_OR_CTRL | Key::N);` |
| 21 | New Shader Includeショートカット Ctrl+Shift+N | 有 | shader_editor_plugin.cpp | 852 | `ED_SHORTCUT("shader_editor/new_include", TTRC("New Shader Include..."), KeyModifierMask::CMD_OR_CTRL | KeyModifierMask::SHIFT | Key::N);` |
| 22 | Load Shaderショートカット Ctrl+O | 有 | shader_editor_plugin.cpp | 853 | `ED_SHORTCUT("shader_editor/open", TTRC("Load Shader File..."), KeyModifierMask::CMD_OR_CTRL | Key::O);` |

### 4. TextShaderEditor編集メニューに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 23 | EDIT_UNDO列挙値 | 有 | text_shader_editor.h | 110 | `EDIT_UNDO,` |
| 24 | EDIT_REDO列挙値 | 有 | text_shader_editor.h | 111 | `EDIT_REDO,` |
| 25 | SEARCH_FIND列挙値 | 有 | text_shader_editor.h | 126 | `SEARCH_FIND,` |
| 26 | BOOKMARK_TOGGLE列挙値 | 有 | text_shader_editor.h | 131 | `BOOKMARK_TOGGLE,` |
| 27 | HELP_DOCS列挙値 | 有 | text_shader_editor.h | 135 | `HELP_DOCS,` |
| 28 | edit_menuはMenuButton | 有 | text_shader_editor.cpp | 1210-1214 | `edit_menu = memnew(MenuButton); edit_menu->set_text(TTR("Edit"));` |
| 29 | search_menuはMenuButton | 有 | text_shader_editor.cpp | 1240-1244 | `search_menu = memnew(MenuButton); search_menu->set_text(TTR("Search"));` |
| 30 | bookmarks_menuはPopupMenu | 有 | text_shader_editor.cpp | 1264-1268 | `bookmarks_menu = memnew(PopupMenu); goto_menu->get_popup()->add_submenu_node_item(TTR("Bookmarks"), bookmarks_menu);` |

### 5. シンタックスハイライトに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 31 | GDShaderSyntaxHighlighterはCodeHighlighter継承 | 有 | text_shader_editor.h | 39-40 | `class GDShaderSyntaxHighlighter : public CodeHighlighter { GDCLASS(GDShaderSyntaxHighlighter, CodeHighlighter)` |
| 32 | disabled_branch_regionsメンバ | 有 | text_shader_editor.h | 43 | `Vector<Point2i> disabled_branch_regions;` |
| 33 | 数値色設定 | 有 | text_shader_editor.cpp | 230 | `syntax_highlighter->set_number_color(EDITOR_GET("text_editor/theme/highlighting/number_color"));` |
| 34 | キーワード色設定 | 有 | text_shader_editor.cpp | 237 | `const Color keyword_color = EDITOR_GET("text_editor/theme/highlighting/keyword_color");` |
| 35 | コメント領域/*〜*/設定 | 有 | text_shader_editor.cpp | 344 | `syntax_highlighter->add_color_region("/*", "*/", comment_color, false);` |
| 36 | コメント領域//設定 | 有 | text_shader_editor.cpp | 345 | `syntax_highlighter->add_color_region("//", "", comment_color, true);` |
| 37 | ドキュメントコメント領域/**〜*/設定 | 有 | text_shader_editor.cpp | 348 | `syntax_highlighter->add_color_region("/**", "*/", doc_comment_color, false);` |

### 6. シェーダー検証に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 38 | _validate_script関数 | 有 | text_shader_editor.cpp | 467-629 | `void ShaderTextEditor::_validate_script() { ... }` |
| 39 | ShaderPreprocessor::preprocess使用 | 有 | text_shader_editor.cpp | 490 | `last_compile_result = preprocessor.preprocess(code, filename, code_pp, &error_pp, &err_positions, &regions);` |
| 40 | ShaderLanguage::compile使用 | 有 | text_shader_editor.cpp | 578 | `last_compile_result = sl.compile(code, comp_info);` |
| 41 | シェーダーモード canvas_item | 有 | text_shader_editor.cpp | 374-375 | `if (type == "canvas_item") { mode = Shader::MODE_CANVAS_ITEM; }` |
| 42 | シェーダーモード particles | 有 | text_shader_editor.cpp | 376-377 | `else if (type == "particles") { mode = Shader::MODE_PARTICLES; }` |
| 43 | シェーダーモード sky | 有 | text_shader_editor.cpp | 378-379 | `else if (type == "sky") { mode = Shader::MODE_SKY; }` |
| 44 | シェーダーモード fog | 有 | text_shader_editor.cpp | 380-381 | `else if (type == "fog") { mode = Shader::MODE_FOG; }` |

### 7. コード補完に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 45 | _code_complete_script関数 | 有 | text_shader_editor.cpp | 423-465 | `void ShaderTextEditor::_code_complete_script(...) { ... }` |
| 46 | インクルードパス補完 | 有 | text_shader_editor.cpp | 401-421 | `static void _complete_include_paths_search(...) { ... if (p_efsd->get_file_type(i) == SNAME("ShaderInclude")) { ... } }` |
| 47 | ShaderLanguage::complete使用 | 有 | text_shader_editor.cpp | 463 | `sl.complete(code, comp_info, r_options, calltip);` |

### 8. ドラッグ&ドロップに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 48 | shader_list_elementドラッグ型 | 有 | shader_editor_plugin.cpp | 669 | `drag_data["type"] = "shader_list_element";` |
| 49 | filesドラッグ型対応 | 有 | shader_editor_plugin.cpp | 685 | `if (String(d["type"]) == "files") {` |
| 50 | ドラッグプレビュー作成 | 有 | shader_editor_plugin.cpp | 653-666 | `HBoxContainer *drag_preview = memnew(HBoxContainer); ... files_split->set_drag_preview(drag_preview);` |

### 9. レイアウト保存・復元に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 51 | open_shaders保存 | 有 | shader_editor_plugin.cpp | 301 | `p_layout->set_value("ShaderEditor", "open_shaders", shaders);` |
| 52 | split_offset保存 | 有 | shader_editor_plugin.cpp | 302 | `p_layout->set_value("ShaderEditor", "split_offset", files_split->get_split_offset());` |
| 53 | text_shader_zoom_factor保存 | 有 | shader_editor_plugin.cpp | 304 | `p_layout->set_value("ShaderEditor", "text_shader_zoom_factor", text_shader_zoom_factor);` |
| 54 | restore_shaders_on_load設定確認 | 有 | shader_editor_plugin.cpp | 228 | `if (!bool(EDITOR_GET("editors/shader_editor/behavior/files/restore_shaders_on_load"))) { return; }` |

### 10. 言語プラグイン登録に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 55 | TextShaderLanguagePlugin登録 | 有 | shader_editor_plugin.cpp | 920-922 | `Ref<TextShaderLanguagePlugin> text_shader_lang; text_shader_lang.instantiate(); EditorShaderLanguagePlugin::register_shader_language(text_shader_lang);` |

## 信頼度スコア計算

```
claims_with_evidence: 55
claims_without_evidence: 0
claims_total: 55
confidence_derived: 55 / 55 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

シェーダーエディタはEditorPluginを継承したプラグイン形式で実装されており、EditorDockをホストコンテナとして使用している。テキストシェーダーの編集にはTextShaderEditorクラスを使用し、CodeTextEditorを継承したShaderTextEditorで実際のコード編集を行う。シンタックスハイライト、コード補完、シェーダー検証（プリプロセッサ＋コンパイラ）など、専門的なシェーダー編集機能が実装されている。設計書の記載内容はソースコードに完全に基づいた信頼性の高い文書である。
