---
generated_at: 2026-01-23 12:45:00
metrics:
  claims_total: 55
  claims_with_evidence: 55
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 19-プロジェクトダイアログ

## 概要

本レポートは「画面設計書 19-プロジェクトダイアログ」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・クラス構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | ProjectDialogはConfirmationDialog継承 | 有 | project_dialog.h | 43-44 | `class ProjectDialog : public ConfirmationDialog { GDCLASS(ProjectDialog, ConfirmationDialog);` |
| 2 | 表示サイズ500 x auto | 有 | project_dialog.cpp | 982 | `popup_centered(Size2(500, 0) * EDSCALE);` |

### 2. モード列挙型に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 3 | MODE_NEW定義 | 有 | project_dialog.h | 48 | `MODE_NEW,` |
| 4 | MODE_IMPORT定義 | 有 | project_dialog.h | 49 | `MODE_IMPORT,` |
| 5 | MODE_INSTALL定義 | 有 | project_dialog.h | 50 | `MODE_INSTALL,` |
| 6 | MODE_RENAME定義 | 有 | project_dialog.h | 51 | `MODE_RENAME,` |
| 7 | MODE_DUPLICATE定義 | 有 | project_dialog.h | 52 | `MODE_DUPLICATE,` |

### 3. モード別タイトル・ボタンに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 8 | MODE_NEW タイトル"Create New Project" | 有 | project_dialog.cpp | 916 | `set_title(TTRC("Create New Project"));` |
| 9 | MODE_NEW ボタン"Create" | 有 | project_dialog.cpp | 917 | `set_ok_button_text(TTRC("Create"));` |
| 10 | MODE_IMPORT タイトル"Import Existing Project" | 有 | project_dialog.cpp | 906 | `set_title(TTRC("Import Existing Project"));` |
| 11 | MODE_IMPORT ボタン"Import" | 有 | project_dialog.cpp | 907 | `set_ok_button_text(TTRC("Import"));` |
| 12 | MODE_RENAME タイトル"Rename Project" | 有 | project_dialog.cpp | 859 | `set_title(TTRC("Rename Project"));` |
| 13 | MODE_RENAME ボタン"Rename" | 有 | project_dialog.cpp | 860 | `set_ok_button_text(TTRC("Rename"));` |
| 14 | MODE_DUPLICATE タイトル"Duplicate Project" | 有 | project_dialog.cpp | 956 | `set_title(TTRC("Duplicate Project"));` |
| 15 | MODE_DUPLICATE ボタン"Duplicate" | 有 | project_dialog.cpp | 957 | `set_ok_button_text(TTRC("Duplicate"));` |

### 4. UI構成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 16 | name_containerはVBoxContainer | 有 | project_dialog.cpp | 1019 | `name_container = memnew(VBoxContainer);` |
| 17 | project_nameはLineEdit | 有 | project_dialog.cpp | 1026 | `project_name = memnew(LineEdit);` |
| 18 | project_path_containerはVBoxContainer | 有 | project_dialog.cpp | 1032 | `project_path_container = memnew(VBoxContainer);` |
| 19 | project_pathはLineEdit | 有 | project_dialog.cpp | 1052 | `project_path = memnew(LineEdit);` |
| 20 | create_dirはCheckButton | 有 | project_dialog.cpp | 1043 | `create_dir = memnew(CheckButton);` |
| 21 | create_dirテキスト"Create Folder" | 有 | project_dialog.cpp | 1044 | `create_dir->set_text(TTRC("Create Folder"));` |
| 22 | project_browseはButton | 有 | project_dialog.cpp | 1079 | `project_browse = memnew(Button);` |
| 23 | project_status_rectはTextureRect | 有 | project_dialog.cpp | 1075 | `project_status_rect = memnew(TextureRect);` |
| 24 | install_path_containerはVBoxContainer | 有 | project_dialog.cpp | 1058 | `install_path_container = memnew(VBoxContainer);` |
| 25 | install_pathはLineEdit | 有 | project_dialog.cpp | 1068 | `install_path = memnew(LineEdit);` |
| 26 | msgはLabel | 有 | project_dialog.cpp | 1094 | `msg = memnew(Label);` |
| 27 | renderer_containerはVBoxContainer | 有 | project_dialog.cpp | 1103 | `renderer_container = memnew(VBoxContainer);` |
| 28 | vcs_metadata_selectionはOptionButton | 有 | project_dialog.cpp | 1203 | `vcs_metadata_selection = memnew(OptionButton);` |
| 29 | edit_check_boxはCheckBox | 有 | project_dialog.cpp | 1221 | `edit_check_box = memnew(CheckBox);` |
| 30 | edit_check_boxテキスト"Edit Now" | 有 | project_dialog.cpp | 1222 | `edit_check_box->set_text(TTRC("Edit Now"));` |

### 5. メッセージタイプに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 31 | MESSAGE_ERROR定義 | 有 | project_dialog.h | 57 | `MESSAGE_ERROR,` |
| 32 | MESSAGE_WARNING定義 | 有 | project_dialog.h | 58 | `MESSAGE_WARNING,` |
| 33 | MESSAGE_SUCCESS定義 | 有 | project_dialog.h | 59 | `MESSAGE_SUCCESS,` |
| 34 | MESSAGE_ERRORでerror_color使用 | 有 | project_dialog.cpp | 64 | `msg->add_theme_color_override(SceneStringName(font_color), get_theme_color(SNAME("error_color"), EditorStringName(Editor)));` |
| 35 | MESSAGE_WARNINGでwarning_color使用 | 有 | project_dialog.cpp | 68 | `msg->add_theme_color_override(SceneStringName(font_color), get_theme_color(SNAME("warning_color"), EditorStringName(Editor)));` |
| 36 | MESSAGE_SUCCESSでsuccess_color使用 | 有 | project_dialog.cpp | 72 | `msg->add_theme_color_override(SceneStringName(font_color), get_theme_color(SNAME("success_color"), EditorStringName(Editor)));` |

### 6. レンダラー選択に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 37 | Forward+オプション | 有 | project_dialog.cpp | 1123 | `rs_button->set_text(TTRC("Forward+"));` |
| 38 | Forward+のrendering_method | 有 | project_dialog.cpp | 1128 | `rs_button->set_meta(SNAME("rendering_method"), "forward_plus");` |
| 39 | Mobileオプション | 有 | project_dialog.cpp | 1136 | `rs_button->set_text(TTRC("Mobile"));` |
| 40 | Mobileのrendering_method | 有 | project_dialog.cpp | 1141 | `rs_button->set_meta(SNAME("rendering_method"), "mobile");` |
| 41 | Compatibilityオプション | 有 | project_dialog.cpp | 1149 | `rs_button->set_text(TTRC("Compatibility"));` |
| 42 | Compatibilityのrendering_method | 有 | project_dialog.cpp | 1154 | `rs_button->set_meta(SNAME("rendering_method"), "gl_compatibility");` |
| 43 | More informationリンク | 有 | project_dialog.cpp | 1157-1159 | `LinkButton *ri_link = memnew(LinkButton); ri_link->set_text(TTRC("More information")); ri_link->set_uri(GODOT_VERSION_DOCS_URL "/tutorials/rendering/renderers.html");` |

### 7. ディレクトリ命名規則に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 44 | directory_naming_convention設定取得 | 有 | project_dialog.cpp | 317 | `int naming_convention = (int)EDITOR_GET("project_manager/directory_naming_convention");` |
| 45 | kebab-case変換 | 有 | project_dialog.cpp | 322 | `new_auto_dir = new_auto_dir.to_kebab_case();` |
| 46 | snake_case変換 | 有 | project_dialog.cpp | 325 | `new_auto_dir = new_auto_dir.to_snake_case();` |
| 47 | camelCase変換 | 有 | project_dialog.cpp | 328 | `new_auto_dir = new_auto_dir.to_camel_case();` |
| 48 | PascalCase変換 | 有 | project_dialog.cpp | 331 | `new_auto_dir = new_auto_dir.to_pascal_case();` |
| 49 | Title Case変換 | 有 | project_dialog.cpp | 334 | `new_auto_dir = new_auto_dir.capitalize();` |

### 8. プロジェクト作成に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 50 | application/config/name設定 | 有 | project_dialog.cpp | 592 | `initial_settings["application/config/name"] = project_name->get_text().strip_edges();` |
| 51 | application/config/icon設定 | 有 | project_dialog.cpp | 593 | `initial_settings["application/config/icon"] = "res://icon.svg";` |
| 52 | rendering/renderer/rendering_method設定 | 有 | project_dialog.cpp | 573 | `initial_settings["rendering/renderer/rendering_method"] = renderer_type;` |
| 53 | VCSメタデータ作成 | 有 | project_dialog.cpp | 614 | `EditorVCSInterface::create_vcs_metadata_files(EditorVCSInterface::VCSMetadata(vcs_metadata_selection->get_selected()), path);` |
| 54 | .editorconfig作成 | 有 | project_dialog.cpp | 617-628 | `const String editor_config_path = path.path_join(".editorconfig"); ... f->store_line("charset = utf-8");` |

### 9. シグナルに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 55 | project_createdシグナル | 有 | project_dialog.cpp | 1010 | `ADD_SIGNAL(MethodInfo("project_created"));` |

## 信頼度スコア計算

```
claims_with_evidence: 55
claims_without_evidence: 0
claims_total: 55
confidence_derived: 55 / 55 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

プロジェクトダイアログはConfirmationDialogを継承した多目的ダイアログであり、5つのモード（新規作成、インポート、インストール、名前変更、複製）をサポートしている。モードに応じてUI要素の表示/非表示が動的に切り替わり、プロジェクト名、パス、レンダラー選択、VCSメタデータなどの設定を行える。パス検証は複数のルールに基づいて行われ、ZIPファイルのインポートにも対応している。設計書の記載内容はソースコードに完全に基づいた信頼性の高い文書である。
