---
generated_at: 2026-01-23 10:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：2-エディタメイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **ショートカットキーの正確性**：F1-F4キーの割り当て確認
  2. **editor_layout.cfgの構造詳細**：ドック配置の保存形式
  3. **プラグインクラッシュ時の動作**：実際の例外処理フロー

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/editor_node.cpp` 行1-500
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行3
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` 行41-62
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行5-9

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト編集時のメイン画面 | E-02 | ○ |
| C-02 | 2D/3D/Script/AssetLibの切り替えが可能 | E-03 行44-47 | ○ |
| C-03 | 各種ドックとの連携 | E-03 行49-55 | ○ |
| C-04 | ボトムパネルとの連携 | E-03 行57-61 | ○ |
| C-05 | EditorNodeがシングルトン | E-01 行205 singleton変数 | ○ |
| C-06 | F1キーで2Dエディタ | E-01 行410-411 editor_main_screen->select() | ○ |
| C-07 | F2キーで3Dエディタ | E-01 行412-413 | ○ |
| C-08 | F3キーでスクリプトエディタ | E-01 行414-415 | ○ |
| C-09 | Ctrl+Pでクイックオープン | E-03 行124 | ○ |
| C-10 | シーン保存でResourceSaver使用 | E-04 リソース管理 | ○ |
| C-11 | EditorDockManagerでドック管理 | E-01 行86 include | ○ |
| C-12 | EditorMainScreenで画面切り替え | E-01 行97 include | ○ |
| C-13 | タイトルバーに未保存マーク表示 | E-01 行369-372 | ○ |
| C-14 | プロジェクト名をタイトルに表示 | E-01 行362-368 | ○ |
| C-15 | shortcut_input()でショートカット処理 | E-01 行402-438 | ○ |
| C-16 | editor_layout.cfgにレイアウト保存 | **根拠不足** | △ |
| C-17 | 最大4ビューポート分割対応 | **根拠不足** | △ |
| C-18 | EditorUndoRedoManagerでUndo管理 | E-01 行98 include | ○ |
| C-19 | シーンツリー管理が主機能 | E-04 行5 | ○ |
| C-20 | ノードシステムが主機能 | E-04 行6 | ○ |
| C-21 | リソース管理が主機能 | E-04 行7 | ○ |
| C-22 | プロジェクト設定がAPI連携 | E-04 行8 | ○ |
| C-23 | シーンエディタが主機能 | E-04 行9 | ○ |
| C-24 | プラグインクラッシュ時の例外処理 | **根拠不足** | △ |
| C-25 | F5キーでゲーム実行 | E-01 ショートカット | ○ |

## 4) 不足情報（Unknown / Missing）
- editor_layout.cfgの詳細なフォーマット仕様
  - 候補：`editor/docks/editor_dock_manager.cpp` / レイアウト保存・復元処理
- 3Dエディタの4ビューポート分割の具体的実装
  - 候補：`editor/scene/3d/node_3d_editor_plugin.cpp`
- プラグイン例外処理の詳細フロー
  - 候補：`editor/plugins/editor_plugin.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構成、メニュー項目
- 1: 中リスク - ショートカットキーの割り当て、ドック配置
- 2: 高リスク - プラグイン例外処理、レイアウト保存の互換性

## 6) レビュアーチェックリスト（最小）
- [ ] ショートカットキー（F1-F4、Ctrl+P等）の動作確認
- [ ] タイトルバーの表示形式確認
- [ ] 画面遷移図との整合性（遷移元・遷移先）
- [ ] ドック配置の保存・復元動作確認
- [ ] Undo/Redo履歴の動作確認
