---
generated_at: 2026-01-23 13:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 20-クイック設定ダイアログ

## 概要

本レポートは「画面設計書 20-クイック設定ダイアログ」に記載された各主張（claim）について、ソースコードからの根拠を示すものである。

## 根拠一覧

### 1. 画面概要・クラス構造に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 1 | QuickSettingsDialogはAcceptDialog継承 | 有 | quick_settings_dialog.h | 43-44 | `class QuickSettingsDialog : public AcceptDialog { GDCLASS(QuickSettingsDialog, AcceptDialog);` |
| 2 | ダイアログタイトル"Quick Settings" | 有 | quick_settings_dialog.cpp | 303 | `set_title(TTRC("Quick Settings"));` |
| 3 | OKボタンテキスト"Close" | 有 | quick_settings_dialog.cpp | 304 | `set_ok_button_text(TTRC("Close"));` |

### 2. メンバ変数に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 4 | editor_languages Vector | 有 | quick_settings_dialog.h | 47-48 | `Vector<String> editor_languages;` (ANDROID_ENABLED以外) |
| 5 | editor_styles Vector | 有 | quick_settings_dialog.h | 49 | `Vector<String> editor_styles;` |
| 6 | editor_themes Vector | 有 | quick_settings_dialog.h | 50 | `Vector<String> editor_themes;` |
| 7 | editor_scales Vector | 有 | quick_settings_dialog.h | 51 | `Vector<String> editor_scales;` |
| 8 | editor_network_modes Vector | 有 | quick_settings_dialog.h | 52 | `Vector<String> editor_network_modes;` |
| 9 | editor_check_for_updates Vector | 有 | quick_settings_dialog.h | 53 | `Vector<String> editor_check_for_updates;` |
| 10 | editor_directory_naming_conventions Vector | 有 | quick_settings_dialog.h | 54 | `Vector<String> editor_directory_naming_conventions;` |

### 3. UIコンポーネントに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 11 | settings_list_panelはPanelContainer | 有 | quick_settings_dialog.cpp | 314 | `settings_list_panel = memnew(PanelContainer);` |
| 12 | settings_listはVBoxContainer | 有 | quick_settings_dialog.cpp | 317 | `settings_list = memnew(VBoxContainer);` |
| 13 | language_option_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 323 | `language_option_button = memnew(OptionButton);` |
| 14 | style_option_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 340 | `style_option_button = memnew(OptionButton);` |
| 15 | theme_option_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 354 | `theme_option_button = memnew(OptionButton);` |
| 16 | scale_option_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 377 | `scale_option_button = memnew(OptionButton);` |
| 17 | network_mode_option_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 391 | `network_mode_option_button = memnew(OptionButton);` |
| 18 | check_for_update_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 405 | `check_for_update_button = memnew(OptionButton);` |
| 19 | directory_naming_convention_buttonはOptionButton | 有 | quick_settings_dialog.cpp | 419 | `directory_naming_convention_button = memnew(OptionButton);` |

### 4. 設定項目ラベルに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 20 | Languageラベル | 有 | quick_settings_dialog.cpp | 335 | `_add_setting_control(TTRC("Language"), language_option_button);` |
| 21 | Styleラベル | 有 | quick_settings_dialog.cpp | 349 | `_add_setting_control(TTRC("Style"), style_option_button);` |
| 22 | Color Presetラベル | 有 | quick_settings_dialog.cpp | 363 | `_add_setting_control(TTRC("Color Preset"), theme_option_button);` |
| 23 | Display Scaleラベル | 有 | quick_settings_dialog.cpp | 386 | `_add_setting_control(TTRC("Display Scale"), scale_option_button);` |
| 24 | Network Modeラベル | 有 | quick_settings_dialog.cpp | 400 | `_add_setting_control(TTRC("Network Mode"), network_mode_option_button);` |
| 25 | Check for Updatesラベル | 有 | quick_settings_dialog.cpp | 414 | `_add_setting_control(TTRC("Check for Updates"), check_for_update_button);` |
| 26 | Directory Naming Conventionラベル | 有 | quick_settings_dialog.cpp | 428 | `_add_setting_control(TTRC("Directory Naming Convention"), directory_naming_convention_button);` |

### 5. 設定値取得に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 27 | interface/editor/editor_language取得 | 有 | quick_settings_dialog.cpp | 62-64 | `if (pi.name == "interface/editor/editor_language") { editor_languages = pi.hint_string.split(";", false); }` |
| 28 | interface/theme/style取得 | 有 | quick_settings_dialog.cpp | 66-67 | `else if (pi.name == "interface/theme/style") { editor_styles = pi.hint_string.split(","); }` |
| 29 | interface/theme/color_preset取得 | 有 | quick_settings_dialog.cpp | 68-69 | `else if (pi.name == "interface/theme/color_preset") { editor_themes = pi.hint_string.split(","); }` |
| 30 | interface/editor/display_scale取得 | 有 | quick_settings_dialog.cpp | 70-71 | `else if (pi.name == "interface/editor/display_scale") { editor_scales = pi.hint_string.split(","); }` |
| 31 | network/connection/network_mode取得 | 有 | quick_settings_dialog.cpp | 72-73 | `else if (pi.name == "network/connection/network_mode") { editor_network_modes = pi.hint_string.split(","); }` |

### 6. 設定変更処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 32 | _language_selected実装 | 有 | quick_settings_dialog.cpp | 196-199 | `void QuickSettingsDialog::_language_selected(int p_id) { ... _set_setting_value("interface/editor/editor_language", selected_language); }` |
| 33 | _style_selected実装 | 有 | quick_settings_dialog.cpp | 202-205 | `void QuickSettingsDialog::_style_selected(int p_id) { ... _set_setting_value("interface/theme/style", selected_style); }` |
| 34 | _theme_selected実装 | 有 | quick_settings_dialog.cpp | 207-212 | `void QuickSettingsDialog::_theme_selected(int p_id) { ... custom_theme_label->set_visible(selected_theme == "Custom"); }` |
| 35 | _scale_selected p_restart_required=true | 有 | quick_settings_dialog.cpp | 214-216 | `void QuickSettingsDialog::_scale_selected(int p_id) { _set_setting_value("interface/editor/display_scale", p_id, true); }` |
| 36 | _network_mode_selected オフラインで更新確認無効化 | 有 | quick_settings_dialog.cpp | 218-223 | `void QuickSettingsDialog::_network_mode_selected(int p_id) { ... check_for_update_button->set_disabled(!p_id); }` |

### 7. 設定保存処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 37 | EditorSettings::set呼び出し | 有 | quick_settings_dialog.cpp | 234 | `EditorSettings::get_singleton()->set(p_setting, p_value);` |
| 38 | EditorSettings::notify_changes呼び出し | 有 | quick_settings_dialog.cpp | 235 | `EditorSettings::get_singleton()->notify_changes();` |
| 39 | EditorSettings::save呼び出し | 有 | quick_settings_dialog.cpp | 236 | `EditorSettings::get_singleton()->save();` |
| 40 | 再起動ボタン"Restart Now"テキスト | 有 | quick_settings_dialog.cpp | 246 | `restart_required_button = add_button(TTRC("Restart Now"), ed_swap_cancel_ok != 2);` |

### 8. 完全設定ダイアログに関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 41 | EditorSettingsDialog遅延生成 | 有 | quick_settings_dialog.cpp | 252-266 | `void QuickSettingsDialog::_show_full_settings() { if (!editor_settings_dialog) { ... editor_settings_dialog = memnew(EditorSettingsDialog); } }` |
| 42 | EditorHelp::generate_doc呼び出し | 有 | quick_settings_dialog.cpp | 254 | `EditorHelp::generate_doc();` |
| 43 | "Edit All Settings"ボタン | 有 | quick_settings_dialog.cpp | 436-437 | `Button *open_full_settings = memnew(Button); open_full_settings->set_text(TTRC("Edit All Settings"));` |

### 9. 再起動関連に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 44 | restart_required_labelテキスト | 有 | quick_settings_dialog.cpp | 445 | `restart_required_label = memnew(Label(TTRC("Settings changed! The project manager must be restarted for changes to take effect.")));` |
| 45 | restart_required最小サイズ560 | 有 | quick_settings_dialog.cpp | 446 | `restart_required_label->set_custom_minimum_size(Size2(560, 0) * EDSCALE);` |
| 46 | restart_requiredシグナル定義 | 有 | quick_settings_dialog.cpp | 299 | `ADD_SIGNAL(MethodInfo("restart_required"));` |
| 47 | _request_restart実装 | 有 | quick_settings_dialog.cpp | 271-273 | `void QuickSettingsDialog::_request_restart() { emit_signal("restart_required"); }` |

### 10. テーマ・通知処理に関する主張

| No | 主張 | 根拠有無 | 根拠ファイル | 該当行 | 根拠コード・説明 |
|----|------|----------|-------------|--------|-----------------|
| 48 | quick_settings_panelスタイル適用 | 有 | quick_settings_dialog.cpp | 284 | `settings_list_panel->add_theme_style_override(SceneStringName(panel), get_theme_stylebox(SNAME("quick_settings_panel"), SNAME("ProjectManager")));` |
| 49 | restart_required_labelにwarning_color | 有 | quick_settings_dialog.cpp | 286 | `restart_required_label->add_theme_color_override(SceneStringName(font_color), get_theme_color(SNAME("warning_color"), EditorStringName(Editor)));` |
| 50 | custom_theme_labelにfont_placeholder_color | 有 | quick_settings_dialog.cpp | 287 | `custom_theme_label->add_theme_color_override(SceneStringName(font_color), get_theme_color(SNAME("font_placeholder_color"), EditorStringName(Editor)));` |

## 信頼度スコア計算

```
claims_with_evidence: 50
claims_without_evidence: 0
claims_total: 50
confidence_derived: 50 / 50 = 1.00 (100%)
```

## 結論

本画面設計書の内容は、ソースコード解析により100%の主張について根拠が確認された。

クイック設定ダイアログはAcceptDialogを継承したシンプルなダイアログで、プロジェクトマネージャーから主要なエディタ設定を素早く変更できるUIを提供する。言語（Android以外）、スタイル、カラープリセット、表示スケール、ネットワークモード、更新確認、ディレクトリ命名規則の7種類の設定項目を持ち、各設定はEditorSettingsを通じて即座に保存される。表示スケール変更時は再起動が必要となり、動的に"Restart Now"ボタンが追加される。"Edit All Settings"ボタンで完全なEditorSettingsDialogにアクセスすることも可能である。設計書の記載内容はソースコードに完全に基づいた信頼性の高い文書である。
