---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：21-プロジェクト設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **ショートカットキーでのアクセス**：具体的なキーバインドの根拠不足
  2. **EditorFeatureProfileによる機能制限**：具体的な制限内容の詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/settings/project_settings_editor.cpp` 行51-75 popup_project_settings()関数
- E-02: `editor/settings/project_settings_editor.cpp` 行87-101 queue_save()/_save()関数
- E-03: `editor/settings/project_settings_editor.cpp` 行120-127 _setting_edited()関数
- E-04: `editor/settings/project_settings_editor.cpp` 行164-185 _add_setting()関数
- E-05: `editor/settings/project_settings_editor.cpp` 行187-208 _delete_setting()関数
- E-06: `editor/settings/project_settings_editor.cpp` 行442-462 _action_added()関数
- E-07: `editor/settings/project_settings_editor.cpp` 行489-506 _action_removed()関数
- E-08: `editor/settings/project_settings_editor.cpp` 行685-861 コンストラクタ（UI構築）
- E-09: `editor/settings/project_settings_editor.h` 行50-157 クラス定義
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` 行22 画面定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行60-62 機能マッピング
- E-12: `docs/code-to-docs/画面一覧/画面遷移図.md` 行118-119 遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト設定ダイアログはproject.godotファイルに保存される設定を編集する | E-02 | ○ |
| C-02 | メインメニューの「Project > Project Settings」から起動 | E-12 | ○ |
| C-03 | ショートカットキーでのアクセスも可能 | **根拠なし** | △ |
| C-04 | 一般設定タブでプロジェクト全般の設定を編集 | E-08 行700-704 | ○ |
| C-05 | Input Mapタブで入力アクションとキーバインドを設定 | E-08 行801-808 | ○ |
| C-06 | Localizationタブで多言語対応の設定を管理 | E-08 行810-813 | ○ |
| C-07 | Autoloadでシングルトンスクリプトを設定 | E-08 行820-823 | ○ |
| C-08 | Shader Globalsタブでシェーダーグローバル変数を定義 | E-08 行825-828 | ○ |
| C-09 | Groupsタブでノードグループを管理 | E-08 行830-833 | ○ |
| C-10 | Pluginsタブでプラグインの有効/無効切り替え | E-08 行835-837 | ○ |
| C-11 | Import Defaultsタブでインポート設定管理 | E-08 行856-858 | ○ |
| C-12 | カスタムプロパティの追加・削除機能 | E-04, E-05 | ○ |
| C-13 | 設定変更時にqueue_save()が呼び出される | E-03 | ○ |
| C-14 | 1.5秒後に自動保存される | E-08 行839-843 Timer設定 | ○ |
| C-15 | 入力アクションは「input/」プレフィックス付きで保存 | E-06 行443 | ○ |
| C-16 | UndoRedoManagerによる操作履歴管理 | E-04 行172-181, E-06 行452-461 | ○ |
| C-17 | 「global/」プレフィックス自動付与 | E-01 行320-326 _get_setting_name() | ○ |
| C-18 | 再起動バナーが表示される | E-08 行773-799 restart_container | ○ |
| C-19 | EditorFeatureProfileによる機能制限 | **根拠なし** | △ |
| C-20 | ダイアログ位置・サイズはメタデータに保存 | E-01 行53-58, 行659 | ○ |
| C-21 | Feature Overrideでプラットフォーム別設定 | E-01 行328-386 _add_feature_overrides() | ○ |
| C-22 | タブコンテナでUI構成 | E-08 行694-698 | ○ |
| C-23 | 検索ボックスでフィルタリング | E-08 行709-715 | ○ |
| C-24 | Advanced Settings トグル | E-08 行717-719 | ○ |
| C-25 | 重複アクション名でエラー | E-06 行445-446 ERR_FAIL_COND_MSG | ○ |

## 4) 不足情報（Unknown / Missing）
- ショートカットキーの具体的なバインド
  - 候補：EditorSettings / input_map.cpp / editor_node.cpp のショートカット定義
- EditorFeatureProfileによる具体的な制限項目
  - 候補：editor_feature_profile.cpp / 関連ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードから確認可能
- 1: 中リスク - ショートカットキーに関する主張は実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ショートカットキーアクセスの有無を実機で確認
- [ ] EditorFeatureProfileによる制限の具体的な挙動を確認
- [ ] 各タブの機能がソースコードと一致することを確認
- [ ] 自動保存タイマー（1.5秒）の動作を確認
