---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-エディター設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Project Managerからの限定的アクセス**：is_in_project_managerフラグの具体的な挙動

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/settings/editor_settings_dialog.cpp` 行74-89 popup_edit_settings()
- E-02: `editor/settings/editor_settings_dialog.cpp` 行156-189 _update_shortcuts()
- E-03: `editor/settings/editor_settings_dialog.cpp` 行246-300 _shortcut_button_pressed()
- E-04: `editor/settings/editor_settings_dialog.cpp` 行302-350 _event_config_confirmed()
- E-05: `editor/settings/editor_settings_dialog.cpp` 行97-99 get_drag_data_fw()
- E-06: `editor/settings/editor_settings_dialog.h` 行47-136 クラス定義
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` 行23 画面定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 機能マッピング
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md` 遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エディター設定はユーザーごとに保存されすべてのプロジェクトで共有 | E-06 editor_settings-4.cfg | ○ |
| C-02 | メインメニューの「Editor > Editor Settings」から起動 | E-09 | ○ |
| C-03 | 一般タブでエディター全般の設定を編集 | E-06 tab_general | ○ |
| C-04 | ショートカットタブでキーボードショートカットを設定 | E-06 tab_shortcuts | ○ |
| C-05 | Advanced Settingsの表示切り替え | E-06 advanced_switch | ○ |
| C-06 | ショートカットの追加/編集/削除/リセット | E-03 ShortcutButton enum | ○ |
| C-07 | ドラッグ&ドロップによるショートカットの並び替え | E-05 get_drag_data_fw() | ○ |
| C-08 | Project Managerからも限定的にアクセス可能 | E-06 _is_in_project_manager() | △ |
| C-09 | ショートカット編集時にInputEventConfigurationDialog | E-06 shortcut_editor | ○ |
| C-10 | 設定変更で即座にEditorSettings::save() | E-01 行83-86 | ○ |
| C-11 | 再起動バナー表示機能 | E-06 restart_container, restart_label | ○ |
| C-12 | SectionedInspectorを使用 | E-06 inspector | ○ |
| C-13 | Treeでショートカット表示 | E-06 shortcuts Tree* | ○ |
| C-14 | EditorSettingsPropertyWrapperを使用 | E-06 行138-167 | ○ |
| C-15 | _settings_changed()で変更検知 | E-06 行81 | ○ |
| C-16 | _update_shortcuts()でツリー構築 | E-02 | ○ |
| C-17 | SHORTCUT_ADD/EDIT/ERASE/REVERT定数 | E-06 ShortcutButton enum | ○ |
| C-18 | _create_shortcut_treeitem()でTreeItem作成 | E-06 行92 | ○ |
| C-19 | UndoRedoコールバック対応 | E-06 _undo_redo_callback() | ○ |
| C-20 | _tabs_tab_changed()でタブ切り替え処理 | E-06 行101 | ○ |

## 4) 不足情報（Unknown / Missing）
- Project Managerモードでの具体的な制限内容
  - 候補：project_manager.cpp / editor_node.cpp の初期化処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Project Managerからのアクセス時の動作を実機で確認
- [ ] ショートカットのドラッグ&ドロップ動作を確認
- [ ] 再起動が必要な設定項目を特定
