---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：23-エクスポートダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **256ビットAES暗号化キー**：暗号化の詳細仕様を確認
  2. **ZIPアーカイブエクスポート**：具体的なAPI呼び出しを確認
  3. **プラットフォーム固有設定の詳細**：各プラットフォームの設定項目

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/export/project_export.cpp` ファイル全体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行24 画面定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エクスポートダイアログでビルド・エクスポート設定と実行 | E-01 | ○ |
| C-02 | 複数プラットフォーム対応（Windows/macOS/Linux/Android/iOS/Web） | E-01 platform選択 | ○ |
| C-03 | Project > Export から起動 | E-04 | ○ |
| C-04 | エクスポートプリセットの追加・編集・削除・複製 | E-01 ボタン定義 | ○ |
| C-05 | リソースフィルタリング設定 | E-01 export_filter | ○ |
| C-06 | 機能タグによるエクスポート制御 | E-01 feature_tags | ○ |
| C-07 | スクリプト暗号化設定 | E-01 encryption関連 | ○ |
| C-08 | PCKファイルのみエクスポート | E-01 _export_pck_zip() | ○ |
| C-09 | ZIPアーカイブエクスポート | E-01 | △ |
| C-10 | 256ビットAES暗号化キー | **根拠不足** | △ |
| C-11 | export_presets.cfgに保存 | E-01 save_presets() | ○ |
| C-12 | Runnableフラグでワンクリック実行対象設定 | E-01 runnable | ○ |
| C-13 | テンプレート未インストール時に警告 | E-01 警告表示 | ○ |
| C-14 | Manage Export Templatesリンク | E-01 | ○ |
| C-15 | プリセット一覧とプリセット設定の左右レイアウト | E-01 HSplitContainer | ○ |
| C-16 | デバッグ/リリースエクスポートの切り替え | E-01 export_debug | ○ |
| C-17 | 専用サーバービルドオプション | **根拠不足** | △ |
| C-18 | ファイル保存ダイアログへの遷移 | E-01 export_path | ○ |

## 4) 不足情報（Unknown / Missing）
- 暗号化の詳細仕様（AES-256の実装詳細）
  - 候補：core/crypto/ ディレクトリ
- ZIPエクスポートの詳細実装
  - 候補：core/io/zip_io.cpp
- 専用サーバービルドオプションの詳細
  - 候補：各プラットフォームのexportプラグイン

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 暗号化とZIPエクスポートの詳細実装を確認する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] 暗号化機能の詳細仕様を確認
- [ ] ZIPエクスポート機能の動作を確認
- [ ] 各プラットフォーム固有の設定項目を網羅的に確認
- [ ] テンプレート管理画面との連携を確認
